/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultFuture;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultFutureImpl;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangResultImpl<T>
implements ClangResult<T> {
    @NonNls
    @NotNull
    private final String myName;
    @NotNull
    private final CompletableFuture<T> myFuture;
    @Nullable
    private Runnable myDoneRunnable;

    public ClangResultImpl(@NonNls @NotNull String name, @NotNull CompletableFuture<T> future) {
        if (name == null) {
            ClangResultImpl.$$$reportNull$$$0(0);
        }
        if (future == null) {
            ClangResultImpl.$$$reportNull$$$0(1);
        }
        this(name, future, () -> {});
    }

    public ClangResultImpl(@NonNls @NotNull String name, @NotNull CompletableFuture<T> future, @NotNull Runnable doneRunnable) {
        if (name == null) {
            ClangResultImpl.$$$reportNull$$$0(2);
        }
        if (future == null) {
            ClangResultImpl.$$$reportNull$$$0(3);
        }
        if (doneRunnable == null) {
            ClangResultImpl.$$$reportNull$$$0(4);
        }
        this.myName = name;
        this.myFuture = future;
        this.myDoneRunnable = doneRunnable;
    }

    @Override
    @Nullable
    public T waitForResult() throws ExecutionException {
        assert (this.myDoneRunnable != null) : "Already has been converted to the result future or released!";
        return (T)CidrConcurrentUtilsKt.waitCancelAware(this.myFuture, (String)this.myName);
    }

    @Override
    @Nullable
    public T waitForResult(long timeoutMs) throws ExecutionException, TimeoutException {
        assert (this.myDoneRunnable != null) : "Already has been converted to the result future or released!";
        return (T)CidrConcurrentUtilsKt.waitCancelAware(this.myFuture, (long)timeoutMs, (String)this.myName);
    }

    @Override
    @NotNull
    public ClangResultFuture<T> iWillNotForgetToCancelTheFuture() {
        assert (this.myDoneRunnable != null) : "Already has been converted to the result future or released!";
        ClangResultFutureImpl<T> asResultFuture = new ClangResultFutureImpl<T>(this.myFuture, this.myDoneRunnable);
        this.myDoneRunnable = null;
        ClangResultFutureImpl<T> clangResultFutureImpl = asResultFuture;
        if (clangResultFutureImpl == null) {
            ClangResultImpl.$$$reportNull$$$0(5);
        }
        return clangResultFutureImpl;
    }

    public void release() {
        if (this.myDoneRunnable != null) {
            this.myDoneRunnable.run();
            this.myDoneRunnable = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doneRunnable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangResultImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangResultImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "iWillNotForgetToCancelTheFuture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

