/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

public enum CLionCompletionFlags {
    None(0),
    Deprecated(1),
    NotAvailable(2),
    NotAccessible(4),
    Const(8),
    SC_Extern(16),
    SC_Static(32),
    SC_PrivateExtern(64),
    SC_Auto(128),
    SC_Register(256),
    Directive(512),
    Macro(1024),
    SnippetFunction(2048),
    Class(4096),
    Struct(8192),
    Union(16384),
    Framework(32768),
    TypeKeyword(65536),
    ImportantKeyword(131072),
    AngleBrackets(262144),
    SimpleTypeAliasInsertion(524288),
    NamespaceUsage(0x100000),
    Method(0x200000),
    Kernel(0x400000),
    MethodWithTrailingReturnType(0x800000),
    AS_public(0x1000000),
    AS_protected(0x2000000),
    AS_private(0x4000000),
    Local(0x8000000),
    VirtualMethod(0x10000000),
    KeywordRequiresSpaceAfter(0x20000000),
    OverrideCall(0x40000000);

    private final int value;

    private CLionCompletionFlags(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static boolean isPublic(int value) {
        return (value & AS_public.getValue()) != 0;
    }

    public static boolean isProtected(int value) {
        return (value & AS_protected.getValue()) != 0;
    }

    public static boolean isPrivate(int value) {
        return (value & AS_private.getValue()) != 0;
    }

    public static boolean isExtern(int value) {
        return (value & SC_Extern.getValue()) != 0;
    }

    public static boolean isStatic(int value) {
        return (value & SC_Static.getValue()) != 0;
    }

    public static boolean isPrivateExtern(int value) {
        return (value & SC_PrivateExtern.getValue()) != 0;
    }

    public static boolean isNotAvailable(int value) {
        return (value & NotAvailable.getValue()) != 0;
    }

    public static boolean isNotAccessible(int value) {
        return (value & NotAccessible.getValue()) != 0;
    }

    public static boolean isConstant(int value) {
        return (value & Const.getValue()) != 0;
    }

    public static boolean isVirtualMethod(int value) {
        return (value & VirtualMethod.getValue()) != 0;
    }

    public static boolean isDirective(int value) {
        return (value & Directive.getValue()) != 0;
    }

    public static boolean isMacro(int value) {
        return (value & Macro.getValue()) != 0;
    }

    public static boolean isClass(int value) {
        return (value & Class.getValue()) != 0;
    }

    public static boolean isStruct(int value) {
        return (value & Struct.getValue()) != 0;
    }

    public static boolean isUnion(int value) {
        return (value & Union.getValue()) != 0;
    }

    public static boolean isDeprecated(int value) {
        return (value & Deprecated.getValue()) != 0;
    }

    public static boolean isLocal(int value) {
        return (value & Local.getValue()) != 0;
    }

    public static boolean isFramework(int value) {
        return (value & Framework.getValue()) != 0;
    }

    public static boolean isOverrideCall(int value) {
        return (value & OverrideCall.getValue()) != 0;
    }

    public static boolean isSnippetFunction(int value) {
        return (value & SnippetFunction.getValue()) != 0;
    }
}

