/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class TargetedCommandLine {
    @NotNull
    private final TargetValue<String> myExePath;
    @NotNull
    private final TargetValue<String> myWorkingDirectory;
    @NotNull
    private final TargetValue<String> myInputFilePath;
    @NotNull
    private final Charset myCharset;
    @NotNull
    private final List<? extends TargetValue<String>> myParameters;
    @NotNull
    private final Map<String, TargetValue<String>> myEnvironment;

    public TargetedCommandLine(@NotNull TargetValue<String> exePath, @NotNull TargetValue<String> workingDirectory, @NotNull TargetValue<String> inputFilePath, @NotNull Charset charset, @NotNull List<? extends TargetValue<String>> parameters, @NotNull Map<String, TargetValue<String>> environment) {
        if (exePath == null) {
            TargetedCommandLine.$$$reportNull$$$0(0);
        }
        if (workingDirectory == null) {
            TargetedCommandLine.$$$reportNull$$$0(1);
        }
        if (inputFilePath == null) {
            TargetedCommandLine.$$$reportNull$$$0(2);
        }
        if (charset == null) {
            TargetedCommandLine.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            TargetedCommandLine.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            TargetedCommandLine.$$$reportNull$$$0(5);
        }
        this.myExePath = exePath;
        this.myWorkingDirectory = workingDirectory;
        this.myInputFilePath = inputFilePath;
        this.myCharset = charset;
        this.myParameters = parameters;
        this.myEnvironment = environment;
    }

    public String getCommandPresentation(@NotNull TargetEnvironment target) throws ExecutionException {
        String exePath;
        if (target == null) {
            TargetedCommandLine.$$$reportNull$$$0(6);
        }
        if ((exePath = TargetedCommandLine.resolvePromise(this.myExePath.getTargetValue(), "exe path")) == null) {
            throw new ExecutionException(LangBundle.message("targeted.command.line.exe.path.not.set", new Object[0]));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        for (TargetValue<String> targetValue : this.myParameters) {
            parameters.add(TargetedCommandLine.resolvePromise(targetValue.getTargetValue(), "parameter"));
        }
        return StringUtil.join((Collection)CommandLineUtil.toCommandLine((String)ParametersListUtil.escape((CharSequence)exePath), parameters, (Platform)target.getTargetPlatform().getPlatform()), (String)" ");
    }

    public List<String> collectCommandsSynchronously() throws ExecutionException {
        try {
            return this.collectCommands().blockingGet(0);
        }
        catch (java.util.concurrent.ExecutionException | TimeoutException e) {
            throw new ExecutionException(LangBundle.message("targeted.command.line.collector.failed", new Object[0]), (Throwable)e);
        }
    }

    @NotNull
    public @NotNull Promise<@NotNull List<@NotNull String>> collectCommands() {
        ArrayList<Promise<Object>> promises = new ArrayList<Promise<Object>>(this.myParameters.size() + 1);
        promises.add(this.myExePath.getTargetValue().then(command -> {
            if (command == null) {
                throw new IllegalStateException("Resolved value for exe path is null");
            }
            return command;
        }));
        for (TargetValue<String> targetValue : this.myParameters) {
            promises.add(targetValue.getTargetValue());
        }
        Promise<List<String>> promise = Promises.collectResults(promises);
        if (promise == null) {
            TargetedCommandLine.$$$reportNull$$$0(7);
        }
        return promise;
    }

    @Nullable
    public String getWorkingDirectory() throws ExecutionException {
        return TargetedCommandLine.resolvePromise(this.myWorkingDirectory.getTargetValue(), "working directory");
    }

    @Nullable
    public String getInputFilePath() throws ExecutionException {
        return TargetedCommandLine.resolvePromise(this.myInputFilePath.getTargetValue(), "input file path");
    }

    @NotNull
    public Map<String, String> getEnvironmentVariables() throws ExecutionException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, TargetValue<String>> e : this.myEnvironment.entrySet()) {
            result.put(e.getKey(), TargetedCommandLine.resolvePromise(e.getValue().getTargetValue(), "environment variable " + e.getKey()));
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            TargetedCommandLine.$$$reportNull$$$0(8);
        }
        return linkedHashMap;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            TargetedCommandLine.$$$reportNull$$$0(9);
        }
        return charset;
    }

    @Nullable
    private static String resolvePromise(@NotNull Promise<String> promise, @NotNull String debugName) throws ExecutionException {
        if (promise == null) {
            TargetedCommandLine.$$$reportNull$$$0(10);
        }
        if (debugName == null) {
            TargetedCommandLine.$$$reportNull$$$0(11);
        }
        try {
            return promise.blockingGet(0);
        }
        catch (java.util.concurrent.ExecutionException | TimeoutException e) {
            throw new ExecutionException(LangBundle.message("targeted.command.line.resolver.failed.for", debugName), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFilePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/target/TargetedCommandLine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/target/TargetedCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommands";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentVariables";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommandPresentation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolvePromise";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

