/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WritingAccessProvider {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static final ExtensionPointName<WritingAccessProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.writingAccessProvider");
    public static final ProjectExtensionPointName<WritingAccessProvider> EP = new ProjectExtensionPointName("com.intellij.writingAccessProvider");

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            WritingAccessProvider.$$$reportNull$$$0(0);
        }
        Collection<VirtualFile> collection = this.requestWriting(files.toArray(VirtualFile.EMPTY_ARRAY));
        if (collection == null) {
            WritingAccessProvider.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getReadOnlyMessage() {
        String string = CoreBundle.message("editing.read.only.file.hint", new Object[0]);
        if (string == null) {
            WritingAccessProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Deprecated
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        if (files == null) {
            WritingAccessProvider.$$$reportNull$$$0(3);
        }
        throw new AbstractMethodError("requestWriting(List<VirtualFile>) not implemented");
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file) {
        if (file == null) {
            WritingAccessProvider.$$$reportNull$$$0(4);
        }
        return true;
    }

    public static boolean isPotentiallyWritable(@NotNull VirtualFile file, @Nullable Project project) {
        if (file == null) {
            WritingAccessProvider.$$$reportNull$$$0(5);
        }
        return project == null || project.isDefault() || EP.findFirstSafe((AreaInstance)project, provider -> !provider.isPotentiallyWritable(file)) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/WritingAccessProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/WritingAccessProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWriting";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlyMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPotentiallyWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

