/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GlobalSearchScopes {
    private GlobalSearchScopes() {
    }

    @NotNull
    public static GlobalSearchScope openFilesScope(@NotNull Project project) {
        FileEditorManager fileEditorManager;
        if (project == null) {
            GlobalSearchScopes.$$$reportNull$$$0(0);
        }
        VirtualFile[] files = (fileEditorManager = FileEditorManager.getInstance(project)) != null ? fileEditorManager.getOpenFiles() : VirtualFile.EMPTY_ARRAY;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope(project, Arrays.asList(files), IdeBundle.message("scope.open.files", new Object[0]));
        if (globalSearchScope == null) {
            GlobalSearchScopes.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope executionScope(@NotNull Project project, @Nullable RunProfile runProfile) {
        GlobalSearchScope scope;
        if (project == null) {
            GlobalSearchScopes.$$$reportNull$$$0(2);
        }
        if (runProfile instanceof SearchScopeProvidingRunProfile && (scope = ((SearchScopeProvidingRunProfile)runProfile).getSearchScope()) != null) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                GlobalSearchScopes.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScopes.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @Nullable
    public static GlobalSearchScope executionScope(@NotNull Collection<? extends Module> modules) {
        if (modules == null) {
            GlobalSearchScopes.$$$reportNull$$$0(5);
        }
        if (modules.isEmpty()) {
            return null;
        }
        return GlobalSearchScope.union(ContainerUtil.map2List(modules, module -> GlobalSearchScope.moduleRuntimeScope(module, true)));
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        if (directory == null) {
            GlobalSearchScopes.$$$reportNull$$$0(6);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope(directory, withSubdirectories);
        if (globalSearchScope == null) {
            GlobalSearchScopes.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
        if (project == null) {
            GlobalSearchScopes.$$$reportNull$$$0(8);
        }
        if (directory == null) {
            GlobalSearchScopes.$$$reportNull$$$0(9);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope(project, directory, withSubdirectories);
        if (globalSearchScope == null) {
            GlobalSearchScopes.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope filterScope(@NotNull Project project, @NotNull NamedScope set) {
        if (project == null) {
            GlobalSearchScopes.$$$reportNull$$$0(11);
        }
        if (set == null) {
            GlobalSearchScopes.$$$reportNull$$$0(12);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.filterScope(project, set);
        if (globalSearchScope == null) {
            GlobalSearchScopes.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope projectTestScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScopes.$$$reportNull$$$0(14);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.projectTestScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScopes.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope directoriesScope(@NotNull Project project, boolean withSubdirectories, VirtualFile ... directories) {
        if (project == null) {
            GlobalSearchScopes.$$$reportNull$$$0(16);
        }
        if (directories == null) {
            GlobalSearchScopes.$$$reportNull$$$0(17);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope(project, withSubdirectories, directories);
        if (globalSearchScope == null) {
            GlobalSearchScopes.$$$reportNull$$$0(18);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope projectProductionScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScopes.$$$reportNull$$$0(19);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.projectProductionScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScopes.$$$reportNull$$$0(20);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "openFilesScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "executionScope";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "directoryScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterScope";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "projectTestScope";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "directoriesScope";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "projectProductionScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openFilesScope";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executionScope";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "directoryScope";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "projectTestScope";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "directoriesScope";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "projectProductionScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

