/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.ui.components.panels.RowGridLayout;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J$\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f0\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ui/components/panels/RowGridLayout;", "Ljava/awt/LayoutManager;", "columns", "", "rows", "gap", "alignment", "(IIII)V", "addLayoutComponent", "", "name", "", "comp", "Ljava/awt/Component;", "getCellSize", "Ljava/awt/Dimension;", "sizes", "", "getGrid", "count", "size", "getGridSize", "getSize", "parent", "Ljava/awt/Container;", "function", "Lkotlin/Function1;", "layoutContainer", "minimumLayoutSize", "preferredLayoutSize", "removeLayoutComponent", "intellij.platform.ide"})
public class RowGridLayout
implements LayoutManager {
    private final int columns;
    private final int rows;
    private final int gap;
    private final int alignment;

    @Override
    public void addLayoutComponent(@NotNull String name, @NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
    }

    @Override
    public void removeLayoutComponent(@NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void layoutContainer(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parent.treeLock");
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object2) {
            boolean bl3 = false;
            Rectangle bounds = new Rectangle(parent.getWidth(), parent.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)parent.getInsets());
            int count = parent.getComponentCount();
            Dimension grid = this.getGridSize(count);
            if (grid.width > 0 && grid.height > 0) {
                int gap = this.gap <= 0 ? 0 : JBUI.scale((int)this.gap);
                int width = RangesKt.coerceAtLeast((int)((bounds.width + gap) / grid.width - gap), (int)0);
                int height = RangesKt.coerceAtLeast((int)((bounds.height + gap) / grid.height - gap), (int)0);
                int x = bounds.x - width - gap;
                int y = bounds.y - height - gap;
                int n = 0;
                int n2 = count;
                while (n < n2) {
                    void i;
                    if (i % grid.width != false) {
                        x += width + gap;
                    } else {
                        void space;
                        y += height + gap;
                        x = bounds.x;
                        if (this.alignment != 2 && (space = i + grid.width - count) > 0) {
                            space *= width + gap;
                            if (this.alignment != 4) {
                                space /= 2;
                            }
                            x += space;
                        }
                    }
                    parent.getComponent((int)i).setBounds(x, y, width, height);
                    ++i;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.getSize(parent, (Function1<? super Component, ? extends Dimension>)((Function1)preferredLayoutSize.1.INSTANCE));
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.getSize(parent, (Function1<? super Component, ? extends Dimension>)((Function1)minimumLayoutSize.1.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Dimension getSize(Container parent, Function1<? super Component, ? extends Dimension> function) {
        Dimension dimension = new Dimension();
        boolean bl = false;
        boolean bl2 = false;
        Dimension size = dimension;
        boolean bl3 = false;
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parent.treeLock");
        Object object2 = object;
        boolean bl4 = false;
        boolean bl5 = false;
        synchronized (object2) {
            boolean bl6 = false;
            JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
            Component[] components = parent.getComponents();
            Dimension grid = this.getGridSize(components.length);
            if (grid.width > 0 && grid.height > 0) {
                Collection<Dimension> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullExpressionValue((Object)components, (String)"components");
                Component[] componentArray = components;
                RowGridLayout rowGridLayout = this;
                boolean $i$f$map = false;
                void var17_20 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var20_23 = $this$mapTo$iv$iv;
                int n = ((void)var20_23).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var24_27 = item$iv$iv = var20_23[i];
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    Dimension dimension2 = (Dimension)function.invoke((Object)v1);
                    collection.add(dimension2);
                }
                collection = (List)destination$iv$iv;
                Dimension cell = rowGridLayout.getCellSize((List<? extends Dimension>)collection);
                if (cell.width > 0 && cell.height > 0) {
                    int gap = this.gap <= 0 ? 0 : JBUI.scale((int)this.gap);
                    size.width += (gap + cell.width) * grid.width - gap;
                    size.height += (gap + cell.height) * grid.height - gap;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        return dimension;
    }

    private final int getGrid(int count, int size) {
        return count <= 0 || size <= 0 ? 0 : (count % size == 0 ? count / size : 1 + count / size);
    }

    private final Dimension getGridSize(int count) {
        Dimension dimension;
        if (this.columns <= 0) {
            int n = RangesKt.coerceAtMost((int)this.rows, (int)count);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            dimension = new Dimension(this.getGrid(count, it), it);
        } else if (this.rows <= 0) {
            int n = RangesKt.coerceAtMost((int)this.columns, (int)count);
            boolean bl = false;
            boolean bl4 = false;
            int it = n;
            boolean bl5 = false;
            dimension = new Dimension(it, this.getGrid(count, it));
        } else {
            dimension = this.columns * this.rows < count ? new Dimension(this.columns, this.getGrid(count, this.columns)) : new Dimension(this.columns, this.rows);
        }
        return dimension;
    }

    @NotNull
    protected Dimension getCellSize(@NotNull List<? extends Dimension> sizes) {
        Intrinsics.checkNotNullParameter(sizes, (String)"sizes");
        Dimension dimension = new Dimension();
        boolean bl = false;
        boolean bl2 = false;
        Dimension size = dimension;
        boolean bl3 = false;
        Iterable iterable = sizes;
        boolean bl4 = false;
        if (!iterable.isEmpty()) {
            int n;
            iterable = sizes;
            Dimension dimension2 = size;
            bl4 = false;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw (Throwable)new NoSuchElementException();
            }
            Dimension it22 = (Dimension)iterator.next();
            boolean bl5 = false;
            int it22 = it22.width;
            while (iterator.hasNext()) {
                Dimension it32 = (Dimension)iterator.next();
                $i$a$-maxOf-RowGridLayout$getCellSize$1$1 = false;
                int it32 = it32.width;
                if (it22 >= it32) continue;
                it22 = it32;
            }
            dimension2.width = n = it22;
            iterable = sizes;
            dimension2 = size;
            bl4 = false;
            iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw (Throwable)new NoSuchElementException();
            }
            Dimension it = (Dimension)iterator.next();
            boolean bl6 = false;
            int n2 = it.height;
            while (iterator.hasNext()) {
                Dimension it3 = (Dimension)iterator.next();
                $i$a$-maxOf-RowGridLayout$getCellSize$1$2 = false;
                int n3 = it3.height;
                if (n2 >= n3) continue;
                n2 = n3;
            }
            dimension2.height = n = n2;
        }
        return dimension;
    }

    public RowGridLayout(int columns, int rows, int gap, int alignment) {
        this.columns = columns;
        this.rows = rows;
        this.gap = gap;
        this.alignment = alignment;
        boolean bl = this.columns > 0 || this.rows > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "unsupported columns and rows: " + this.columns + " x " + this.rows;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.alignment == 2 || this.alignment == 4 || this.alignment == 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "unsupported alignment: " + this.alignment;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RowGridLayout(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, n4);
    }
}

