/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface XDebugSession
extends AbstractDebuggerSession {
    public static final DataKey<XDebugSession> DATA_KEY = DataKey.create((String)"XDebugSessionTab.XDebugSession");

    @NotNull
    public Project getProject();

    @NotNull
    public XDebugProcess getDebugProcess();

    public boolean isSuspended();

    @Nullable
    public XStackFrame getCurrentStackFrame();

    public XSuspendContext getSuspendContext();

    @Nullable
    public XSourcePosition getCurrentPosition();

    @Nullable
    public XSourcePosition getTopFramePosition();

    public void stepOver(boolean var1);

    public void stepInto();

    public void stepOut();

    public void forceStepInto();

    public void runToPosition(@NotNull XSourcePosition var1, boolean var2);

    public void pause();

    public void resume();

    public void showExecutionPoint();

    public void setCurrentStackFrame(@NotNull XExecutionStack var1, @NotNull XStackFrame var2, boolean var3);

    default public void setCurrentStackFrame(@NotNull XExecutionStack executionStack, @NotNull XStackFrame frame) {
        if (executionStack == null) {
            XDebugSession.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            XDebugSession.$$$reportNull$$$0(1);
        }
        this.setCurrentStackFrame(executionStack, frame, frame.equals(executionStack.getTopFrame()));
    }

    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> var1, @Nullable Icon var2, @Nullable String var3);

    public void setBreakpointVerified(@NotNull XLineBreakpoint<?> var1);

    public void setBreakpointInvalid(@NotNull XLineBreakpoint<?> var1, @Nullable String var2);

    public boolean breakpointReached(@NotNull XBreakpoint<?> var1, @Nullable String var2, @NotNull XSuspendContext var3);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean breakpointReached(@NotNull XBreakpoint<?> var1, @NotNull XSuspendContext var2);

    public void positionReached(@NotNull XSuspendContext var1);

    public void sessionResumed();

    public void stop();

    public void setBreakpointMuted(boolean var1);

    public boolean areBreakpointsMuted();

    public void addSessionListener(@NotNull XDebugSessionListener var1, @NotNull Disposable var2);

    public void addSessionListener(@NotNull XDebugSessionListener var1);

    public void removeSessionListener(@NotNull XDebugSessionListener var1);

    public void reportError(@NotNull @NlsContexts.NotificationContent String var1);

    public void reportMessage(@NotNull @NlsContexts.NotificationContent String var1, @NotNull MessageType var2);

    public void reportMessage(@NotNull @NlsContexts.NotificationContent String var1, @NotNull MessageType var2, @Nullable HyperlinkListener var3);

    @NotNull
    @NlsContexts.TabTitle
    public String getSessionName();

    @NotNull
    public RunContentDescriptor getRunContentDescriptor();

    @Nullable
    public RunProfile getRunProfile();

    public void setPauseActionSupported(boolean var1);

    public void rebuildViews();

    public <V extends XSmartStepIntoVariant> void smartStepInto(XSmartStepIntoHandler<V> var1, V var2);

    public void updateExecutionPosition();

    public void initBreakpoints();

    public ConsoleView getConsoleView();

    public RunnerLayoutUi getUI();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "executionStack";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "frame";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/XDebugSession";
        objectArray[2] = "setCurrentStackFrame";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

