/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.breakpoints;

import com.intellij.javascript.debugger.JavaScriptLineBreakpointManager;
import com.intellij.javascript.debugger.breakpoints.JSLineBreakpointHandlerBase;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Url;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/debugger/breakpoints/JSSourceMapOnlyBreakpointHandler;", "Lcom/intellij/javascript/debugger/breakpoints/JSLineBreakpointHandlerBase;", "breakpointTypeClass", "Ljava/lang/Class;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "manager", "Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "(Ljava/lang/Class;Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;)V", "doRegisterBreakpoint", "", "vm", "Lorg/jetbrains/debugger/Vm;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "intellij.javascript.debugger"})
public final class JSSourceMapOnlyBreakpointHandler
extends JSLineBreakpointHandlerBase {
    @Override
    protected void doRegisterBreakpoint(@NotNull Vm vm, @NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Ref hasSourceMappedLocation = new Ref((Object)false);
        JavaScriptLineBreakpointManager javaScriptLineBreakpointManager = this.getManager();
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        Object object = xSourcePosition != null ? xSourcePosition.getFile() : null;
        if (!(object instanceof VmScriptFile)) {
            object = null;
        }
        VmScriptFile vmScriptFile = (VmScriptFile)((Object)object);
        Object object2 = vmScriptFile != null ? vmScriptFile.getScript() : null;
        boolean bl = false;
        Url url = null;
        Ref ref = hasSourceMappedLocation;
        List locations = JavaScriptLineBreakpointManager.getActualLocations$default(javaScriptLineBreakpointManager, breakpoint, vm, null, (Script)object2, url, ref, bl, 20, null);
        object2 = locations;
        bl = false;
        if (!object2.isEmpty()) {
            Object object3 = hasSourceMappedLocation.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"hasSourceMappedLocation.get()");
            if (((Boolean)object3).booleanValue()) {
                this.getManager().setBreakpoint(vm, breakpoint);
            }
        }
    }

    public JSSourceMapOnlyBreakpointHandler(@NotNull Class<? extends XLineBreakpointType<?>> breakpointTypeClass, @NotNull JavaScriptLineBreakpointManager manager) {
        Intrinsics.checkNotNullParameter(breakpointTypeClass, (String)"breakpointTypeClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(breakpointTypeClass, manager);
    }
}

