/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipEmptySerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import gnu.trove.THashMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggableProcessRunConfigurationBase
extends LocatableConfigurationBase
implements DebuggableProcessRunConfiguration,
RefactoringListenerProvider {
    private static final SerializationFilter SERIALIZATION_FILTER = new SkipEmptySerializationFilter(){

        protected ThreeState accepts(@NotNull String name, @NotNull Object beanValue) {
            if (name == null) {
                1.$$$reportNull$$$0(0);
            }
            if (beanValue == null) {
                1.$$$reportNull$$$0(1);
            }
            return name.equals("passParentEnvs") ? ThreeState.fromBoolean((boolean)Boolean.FALSE.equals(beanValue)) : ThreeState.UNSURE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "beanValue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/debugger/execution/DebuggableProcessRunConfigurationBase$1";
            objectArray[2] = "accepts";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private String inputPath;
    private String programParameters;
    private String workingDirectory;
    private String exePath;
    private Map<String, String> environments = new HashMap<String, String>();
    private boolean passParentEnvs = true;

    protected DebuggableProcessRunConfigurationBase(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Override
    @Attribute
    public String getExePath() {
        return this.exePath;
    }

    public void setExePath(@Nullable String value) {
        this.exePath = PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value));
    }

    @Override
    @Attribute
    @Nullable
    @NlsSafe
    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(@Nullable @NlsSafe String value) {
        this.inputPath = PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value));
    }

    @Attribute
    @Nullable
    public String getProgramParameters() {
        return this.programParameters;
    }

    public void setProgramParameters(@Nullable String value) {
        this.programParameters = StringUtil.nullize((String)value);
    }

    @Attribute
    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.workingDirectory = PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value));
    }

    @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false, surroundWithTag=false)
    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map2 = this.environments;
        if (map2 == null) {
            DebuggableProcessRunConfigurationBase.$$$reportNull$$$0(0);
        }
        return map2;
    }

    public void setEnvs(@NotNull Map<String, String> value) {
        if (value == null) {
            DebuggableProcessRunConfigurationBase.$$$reportNull$$$0(1);
        }
        this.environments = value;
    }

    @Attribute
    public boolean isPassParentEnvs() {
        return this.passParentEnvs;
    }

    public void setPassParentEnvs(boolean value) {
        this.passParentEnvs = value;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            DebuggableProcessRunConfigurationBase.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this, (Element)element, (SerializationFilter)SERIALIZATION_FILTER);
    }

    protected final void _writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            DebuggableProcessRunConfigurationBase.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        Project project = this.getProject();
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)project);
        this.inputPath = pathMacroManager.collapsePath(this.inputPath);
        this.exePath = pathMacroManager.collapsePath(this.exePath);
        this.workingDirectory = pathMacroManager.collapsePath(this.workingDirectory);
        this.programParameters = pathMacroManager.collapsePath(this.programParameters);
    }

    protected final void _readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
    }

    public RunConfiguration clone() {
        DebuggableProcessRunConfigurationBase clone = (DebuggableProcessRunConfigurationBase)super.clone();
        clone.environments = new THashMap(this.environments);
        return super.clone();
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (Comparing.equal((Object)PsiUtilBase.asVirtualFile((PsiElement)element), (Object)DebuggableProcessRunConfigurationBase.findInputVirtualFile(this))) {
            return new FilePathRefactoringElementListener(this, true);
        }
        return null;
    }

    @Override
    @Nullable
    public String getEffectiveWorkingDirectory() {
        String workingDir = this.getWorkingDirectory();
        if (workingDir == null) {
            return this.getProject().getBasePath();
        }
        return FileUtilRt.toSystemDependentName((String)PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPath(workingDir));
    }

    @Override
    @Nullable
    public final String getEffectiveExePath() {
        String path = this.getExePath();
        if (path != null) {
            return PathUtil.toSystemDependentName((String)PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPath(path));
        }
        return this.computeDefaultExePath();
    }

    @Nullable
    protected abstract String computeDefaultExePath();

    public void checkConfiguration() throws RuntimeConfigurationException {
        File workingDir;
        String workingDirectoryPath = this.getEffectiveWorkingDirectory();
        File file2 = workingDir = workingDirectoryPath == null ? null : new File(workingDirectoryPath);
        if (workingDir == null || !workingDir.isAbsolute() || !workingDir.isDirectory()) {
            throw new RuntimeConfigurationError(JSDebuggerBundle.message("dialog.message.please.specify.working.directory.correctly", new Object[0]));
        }
        VirtualFile file3 = DebuggableProcessRunConfigurationBase.findInputVirtualFile(this);
        if (file3 == null || !file3.isValid()) {
            throw new RuntimeConfigurationError(JSDebuggerBundle.message("dialog.message.please.specify.path.to.correctly", this.getInputFileTitle()));
        }
    }

    @NotNull
    protected abstract String getInputFileTitle();

    protected final void checkExePath(@NotNull String appName) throws RuntimeConfigurationError {
        if (appName == null) {
            DebuggableProcessRunConfigurationBase.$$$reportNull$$$0(4);
        }
        String exePath = this.getEffectiveExePath();
        String exePathProblem = null;
        if (StringUtil.isEmpty((String)exePath)) {
            exePathProblem = JSDebuggerBundle.message("dialog.message.path.to.executable.empty", appName);
        } else {
            File file2 = new File(this.correctExePath(exePath));
            if (!file2.isFile()) {
                exePathProblem = JSDebuggerBundle.message("dialog.message.path.to.correct", appName);
            }
        }
        if (exePathProblem != null) {
            throw new RuntimeConfigurationError(exePathProblem);
        }
    }

    @Override
    @NotNull
    public String correctExePath(@NotNull String exePath) {
        if (exePath == null) {
            DebuggableProcessRunConfigurationBase.$$$reportNull$$$0(5);
        }
        String string = exePath;
        if (string == null) {
            DebuggableProcessRunConfigurationBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static VirtualFile findInputVirtualFile(@NotNull DebuggableProcessRunConfiguration configuration) {
        String inputPath;
        if (configuration == null) {
            DebuggableProcessRunConfigurationBase.$$$reportNull$$$0(7);
        }
        if ((inputPath = configuration.getInputPath()) == null) {
            return null;
        }
        VirtualFile result2 = LocalFileSystem.getInstance().findFileByPath(PathMacroManager.getInstance((ComponentManager)configuration.getProject()).expandPath(inputPath));
        if (result2 == null) {
            VirtualFile workingDir;
            VirtualFile virtualFile = workingDir = configuration.getWorkingDirectory() == null ? null : LocalFileSystem.getInstance().findFileByPath(configuration.getWorkingDirectory());
            if (workingDir != null) {
                result2 = workingDir.findFileByRelativePath(inputPath);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/execution/DebuggableProcessRunConfigurationBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/execution/DebuggableProcessRunConfigurationBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "correctExePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkExePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "correctExePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findInputVirtualFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FilePathRefactoringElementListener
    extends UndoRefactoringElementAdapter {
        private final DebuggableProcessRunConfigurationBase configuration;
        private final boolean isInputPath;

        public FilePathRefactoringElementListener(@NotNull DebuggableProcessRunConfigurationBase configuration, boolean isInputPath) {
            if (configuration == null) {
                FilePathRefactoringElementListener.$$$reportNull$$$0(0);
            }
            this.configuration = configuration;
            this.isInputPath = isInputPath;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            VirtualFile newFile;
            if (element == null) {
                FilePathRefactoringElementListener.$$$reportNull$$$0(1);
            }
            if ((newFile = PsiUtilBase.asVirtualFile((PsiElement)element)) != null && this.isInputPath) {
                String newInputPath;
                VirtualFile workingDir;
                String workingDirectoryPath = this.configuration.getEffectiveWorkingDirectory();
                VirtualFile virtualFile = workingDir = workingDirectoryPath == null ? null : LocalFileSystem.getInstance().findFileByPath(workingDirectoryPath);
                if (workingDir != null && workingDir.isDirectory() && (newInputPath = VfsUtilCore.getRelativePath((VirtualFile)workingDir, (VirtualFile)newFile, (char)'/')) != null) {
                    this.configuration.setInputPath(newInputPath);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/debugger/execution/DebuggableProcessRunConfigurationBase$FilePathRefactoringElementListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refactored";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

