/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.scripts.ConsumerOnEdt;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.ScriptTreeActionBase;
import com.intellij.javascript.debugger.scripts.SourcesTreeComponent;
import com.intellij.javascript.debugger.scripts.VisualizeScriptSourcemap;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceFileFinder;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapActionKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import java.util.List;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0014J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/debugger/scripts/VisualizeScriptSourcemap;", "Lcom/intellij/javascript/debugger/scripts/ScriptTreeActionBase;", "treeComponent", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "(Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;)V", "invisibleIfDisabled", "", "getInvisibleIfDisabled", "()Z", "chooseScript", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/Script;", "items", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isApplicable", "info", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "perform", "", "node", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "context", "visualize", "script", "sourceUrl", "Lcom/intellij/util/Url;", "intellij.javascript.debugger"})
public final class VisualizeScriptSourcemap
extends ScriptTreeActionBase {
    private final boolean invisibleIfDisabled;

    @Override
    protected boolean getInvisibleIfDisabled() {
        return this.invisibleIfDisabled;
    }

    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        for (Script script : info.getScripts$intellij_javascript_debugger()) {
            if (script.getSourceMap() == null) continue;
            return true;
        }
        return false;
    }

    private final Promise<Script> chooseScript(List<? extends Script> items, DataContext dataContext) {
        if (items.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first(items));
        }
        AsyncPromise result2 = new AsyncPromise();
        JBPopupFactory.getInstance().createPopupChooserBuilder(items).setTitle(JSDebuggerBundle.message("js.scripts.visualize.popup.choose", new Object[0])).setItemChosenCallback(new Consumer(result2){
            final /* synthetic */ AsyncPromise $result;

            public final void consume(Script value) {
                this.$result.setResult((Object)value);
            }
            {
                this.$result = asyncPromise;
            }
        }).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((SimpleListCellRenderer.Customizer)chooseScript.2.INSTANCE)).createPopup().showInBestPositionFor(dataContext);
        return (Promise)result2;
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Url sourceUrl = node.getFileInfo().getUrl();
        this.chooseScript(node.getFileInfo().getScripts$intellij_javascript_debugger(), context).onSuccess(new java.util.function.Consumer(this, sourceUrl){
            final /* synthetic */ VisualizeScriptSourcemap this$0;
            final /* synthetic */ Url $sourceUrl;

            public final void accept(Script script) {
                Script script2 = script;
                Intrinsics.checkNotNullExpressionValue((Object)script2, (String)"script");
                VisualizeScriptSourcemap.access$visualize(this.this$0, script2, this.$sourceUrl);
            }
            {
                this.this$0 = visualizeScriptSourcemap;
                this.$sourceUrl = url;
            }
        });
    }

    private final void visualize(Script script, Url sourceUrl) {
        SourceMap sourceMap = script.getSourceMap();
        if (sourceMap == null) {
            return;
        }
        SourceMap map2 = sourceMap;
        this.getTreeComponent().getDebugProcess().getDebuggerViewSupport().getFileByUrlOrVmSource(script, true).onSuccess((java.util.function.Consumer)new ConsumerOnEdt<VirtualFile>(this, map2, sourceUrl, script, this.getProject()){
            final /* synthetic */ VisualizeScriptSourcemap this$0;
            final /* synthetic */ SourceMap $map;
            final /* synthetic */ Url $sourceUrl;
            final /* synthetic */ Script $script;

            public void consume(@NotNull Project project, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                VisualizeSourceMapActionKt.visualizeMap(this.$map, file2, this.$sourceUrl, project, new SourceFileFinder(this){
                    final /* synthetic */ visualize.1 this$0;

                    @Nullable
                    public VirtualFile find(@NotNull Url source) {
                        VirtualFile virtualFile;
                        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                        VirtualFile virtualFile2 = SourceMapInspectorKt.createSourceFromProvidedContent(this.this$0.$map, source, (UserDataHolder)this.this$0.$script);
                        if (virtualFile2 == null) {
                            virtualFile2 = virtualFile = SourceMapInspectorKt.getSourceFile(source);
                        }
                        if (virtualFile2 == null) {
                            virtualFile = this.this$0.this$0.getTreeComponent().getDebugProcess().findFileOrAny(source);
                        }
                        return virtualFile;
                    }
                    {
                        this.this$0 = this$0;
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$map = $captured_local_variable$1;
                this.$sourceUrl = $captured_local_variable$2;
                this.$script = $captured_local_variable$3;
                super($super_call_param$4);
            }
        });
    }

    public VisualizeScriptSourcemap(@NotNull SourcesTreeComponent treeComponent) {
        Intrinsics.checkNotNullParameter((Object)treeComponent, (String)"treeComponent");
        super(treeComponent, JSDebuggerBundle.message("js.scripts.visualize.action", new Object[0]));
    }

    public static final /* synthetic */ void access$visualize(VisualizeScriptSourcemap $this, Script script, Url sourceUrl) {
        $this.visualize(script, sourceUrl);
    }
}

