/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.HashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointBase;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointManagerBase;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.SuspendContext;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ?\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH$\u00a2\u0006\u0002\u0010 J\u0019\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010$J/\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0\"2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010#\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010)J\u0014\u0010*\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0\"2\u0006\u0010#\u001a\u00020&H\u0016J\u0014\u0010,\u001a\u00020\u001f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0016J\u0015\u0010/\u001a\u00020\u00132\u0006\u0010#\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u00100J\u0012\u00101\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020&J\n\u00102\u001a\u0006\u0012\u0002\b\u00030\"J\b\u00103\u001a\u00020\u0013H\u0016J<\u00104\u001a\u0002052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00066"}, d2={"Lorg/jetbrains/debugger/BreakpointManagerBase;", "T", "Lorg/jetbrains/debugger/BreakpointBase;", "Lorg/jetbrains/debugger/BreakpointManager;", "()V", "breakpointDuplicationByTarget", "Ljava/util/concurrent/ConcurrentMap;", "getBreakpointDuplicationByTarget", "()Ljava/util/concurrent/ConcurrentMap;", "breakpoints", "", "getBreakpoints", "()Ljava/util/Set;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/debugger/BreakpointListener;", "getDispatcher", "()Lcom/intellij/util/EventDispatcher;", "addBreakpointListener", "", "listener", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "ignoreCount", "enabled", "", "(Lorg/jetbrains/debugger/BreakpointTarget;IILjava/lang/String;IZ)Lorg/jetbrains/debugger/BreakpointBase;", "doClearBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "breakpoint", "(Lorg/jetbrains/debugger/BreakpointBase;)Lorg/jetbrains/concurrency/Promise;", "doSetBreakpoint", "Lorg/jetbrains/debugger/Breakpoint;", "url", "Lcom/intellij/util/Url;", "(Lorg/jetbrains/debugger/BreakpointTarget;Lcom/intellij/util/Url;Lorg/jetbrains/debugger/BreakpointBase;)Lorg/jetbrains/concurrency/Promise;", "enableBreakpoints", "flush", "isBreakOnFirstStatement", "context", "Lorg/jetbrains/debugger/SuspendContext;", "notifyBreakpointResolvedListener", "(Lorg/jetbrains/debugger/BreakpointBase;)V", "remove", "removeAll", "setBreakOnFirstStatement", "setBreakpoint", "Lorg/jetbrains/debugger/BreakpointManager$SetBreakpointResult;", "intellij.javascript.debugger.backend"})
public abstract class BreakpointManagerBase<T extends BreakpointBase<?>>
implements BreakpointManager {
    @NotNull
    private final Set<T> breakpoints;
    @NotNull
    private final ConcurrentMap<T, T> breakpointDuplicationByTarget;
    @NotNull
    private final EventDispatcher<BreakpointListener> dispatcher;

    @NotNull
    public Set<T> getBreakpoints() {
        return this.breakpoints;
    }

    @NotNull
    protected final ConcurrentMap<T, T> getBreakpointDuplicationByTarget() {
        return this.breakpointDuplicationByTarget;
    }

    @NotNull
    protected final EventDispatcher<BreakpointListener> getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    protected abstract T createBreakpoint(@NotNull BreakpointTarget var1, int var2, int var3, @Nullable String var4, int var5, boolean var6);

    @NotNull
    protected abstract Promise<? extends Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget var1, @Nullable Url var2, @NotNull T var3);

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public BreakpointManager.SetBreakpointResult setBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable Url url, @Nullable String condition, int ignoreCount) {
        Promise promise2;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        T breakpoint = this.createBreakpoint(target, line, column, condition, ignoreCount, true);
        BreakpointBase existingBreakpoint = (BreakpointBase)this.breakpointDuplicationByTarget.putIfAbsent(breakpoint, breakpoint);
        if (existingBreakpoint != null && !existingBreakpoint.getPendingRemove()) {
            return (BreakpointManager.SetBreakpointResult)new BreakpointManager.BreakpointExist((Breakpoint)existingBreakpoint);
        }
        this.getBreakpoints().add(breakpoint);
        Function0 set2 = (Function0)new Function0<Promise<Breakpoint>>(this, target, url, breakpoint){
            final /* synthetic */ BreakpointManagerBase this$0;
            final /* synthetic */ BreakpointTarget $target;
            final /* synthetic */ Url $url;
            final /* synthetic */ BreakpointBase $breakpoint;

            @NotNull
            public final Promise<Breakpoint> invoke() {
                Promise promise2 = this.this$0.doSetBreakpoint(this.$target, this.$url, this.$breakpoint).onError(new Consumer(this){
                    final /* synthetic */ setBreakpoint.set.1 this$0;

                    public final void accept(Throwable it) {
                        BreakpointListener breakpointListener = (BreakpointListener)this.this$0.this$0.getDispatcher().getMulticaster();
                        Breakpoint breakpoint = this.this$0.$breakpoint;
                        String string = it.getMessage();
                        if (string == null) {
                            string = it.toString();
                        }
                        breakpointListener.errorOccurred(breakpoint, string);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (promise2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<org.jetbrains.debugger.Breakpoint>");
                }
                return promise2;
            }
            {
                this.this$0 = breakpointManagerBase;
                this.$target = breakpointTarget;
                this.$url = url;
                this.$breakpoint = breakpointBase;
                super(0);
            }
        };
        BreakpointBase breakpointBase = existingBreakpoint;
        if (breakpointBase != null && breakpointBase.getPendingRemove()) {
            Promise promise3 = existingBreakpoint.vmRegistered().thenAsync(new Function(set2){
                final /* synthetic */ Function0 $set;

                public final Promise<Breakpoint> fun(Object it) {
                    return (Promise)this.$set.invoke();
                }
                {
                    this.$set = function0;
                }
            });
            promise2 = promise3;
            Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"existingBreakpoint.vmReg\u2026red().thenAsync { set() }");
        } else {
            promise2 = (Promise)set2.invoke();
        }
        Promise promise4 = promise2;
        return (BreakpointManager.SetBreakpointResult)new BreakpointManager.BreakpointCreated((Breakpoint)breakpoint, promise4);
    }

    @NotNull
    public final Promise<?> remove(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        BreakpointBase b = (BreakpointBase)breakpoint;
        b.setPendingRemove(true);
        Promise promise2 = b.vmRegistered().then(new Function(this, b){
            final /* synthetic */ BreakpointManagerBase this$0;
            final /* synthetic */ BreakpointBase $b;

            public final Promise<T> fun(Object it) {
                this.this$0.doClearBreakpoint(this.$b);
                this.this$0.getBreakpoints().remove(this.$b);
                return Promises.resolvedPromise(this.this$0.getBreakpointDuplicationByTarget().remove(this.$b));
            }
            {
                this.this$0 = breakpointManagerBase;
                this.$b = breakpointBase;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"b.vmRegistered().then {\n\u2026ByTarget.remove(b))\n    }");
        return promise2;
    }

    @NotNull
    public final Promise<?> removeAll() {
        List list = CollectionsKt.toList((Iterable)this.getBreakpoints());
        this.getBreakpoints().clear();
        this.breakpointDuplicationByTarget.clear();
        SmartList promises = new SmartList();
        for (BreakpointBase b : list) {
            promises.add(this.remove(b));
        }
        return Promises.all((Collection)((Collection)promises));
    }

    @NotNull
    protected abstract Promise<?> doClearBreakpoint(@NotNull T var1);

    public final void addBreakpointListener(@NotNull BreakpointListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2);
    }

    protected final void notifyBreakpointResolvedListener(@NotNull T breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (((BreakpointBase)breakpoint).isResolved()) {
            ((BreakpointListener)this.dispatcher.getMulticaster()).resolved((Breakpoint)breakpoint);
        }
    }

    @NotNull
    public Promise<? extends Breakpoint> flush(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        return ((BreakpointBase)breakpoint).flush(this);
    }

    @NotNull
    public Promise<?> enableBreakpoints(boolean enabled) {
        return Promises.rejectedPromise((String)"Unsupported");
    }

    public void setBreakOnFirstStatement() {
    }

    public boolean isBreakOnFirstStatement(@NotNull SuspendContext<?> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        return false;
    }

    public BreakpointManagerBase() {
        Set set2 = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"Collections.newSetFromMap(ConcurrentHashMap())");
        this.breakpoints = set2;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap((HashingStrategy)new HashingStrategy<T>(){

            public int hashCode(@Nullable T b) {
                if (b == null) {
                    return 0;
                }
                int result2 = ((BreakpointBase)b).getLine();
                result2 *= 31 + ((BreakpointBase)b).getColumn();
                if (((BreakpointBase)b).getCondition() != null) {
                    String string = ((BreakpointBase)b).getCondition();
                    Intrinsics.checkNotNull((Object)string);
                    result2 *= 31 + string.hashCode();
                }
                return result2 *= 31 + ((BreakpointBase)b).getTarget().hashCode();
            }

            public boolean equals(@Nullable T b1, @Nullable T b2) {
                if (b1 == b2) {
                    return true;
                }
                return b1 != null && b2 != null && Intrinsics.areEqual(((BreakpointBase)b1).getTarget().getClass(), ((BreakpointBase)b2).getTarget().getClass()) && Intrinsics.areEqual((Object)((BreakpointBase)b1).getTarget(), (Object)((BreakpointBase)b2).getTarget()) && ((BreakpointBase)b1).getLine() == ((BreakpointBase)b2).getLine() && ((BreakpointBase)b1).getColumn() == ((BreakpointBase)b2).getColumn() && Intrinsics.areEqual((Object)((BreakpointBase)b1).getCondition(), (Object)((BreakpointBase)b2).getCondition());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentCollectionFact\u2026= b2.condition\n    }\n  })");
        this.breakpointDuplicationByTarget = concurrentMap;
        EventDispatcher eventDispatcher = EventDispatcher.create(BreakpointListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(B\u2026ointListener::class.java)");
        this.dispatcher = eventDispatcher;
    }

    @Nullable
    public Function1<String, BreakpointTarget> getFunctionSupport() {
        return BreakpointManager.DefaultImpls.getFunctionSupport((BreakpointManager)this);
    }

    public boolean getRegExpBreakpointSupported() {
        return BreakpointManager.DefaultImpls.getRegExpBreakpointSupported((BreakpointManager)this);
    }

    @NotNull
    public BreakpointManager.MUTE_MODE getMuteMode() {
        return BreakpointManager.DefaultImpls.getMuteMode((BreakpointManager)this);
    }
}

