/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialogUI;
import com.intellij.analysis.ModelScopeItemView;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.analysis.dialog.ModelScopeItemPresenter;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.find.FindSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseAnalysisActionDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(BaseAnalysisActionDialog.class);
    @NotNull
    private final AnalysisUIOptions myOptions;
    private final boolean myRememberScope;
    private final boolean myShowInspectTestSource;
    private final @NlsContexts.Separator String myScopeTitle;
    private final Project myProject;
    private final ButtonGroup myGroup;
    private final JCheckBox myInspectTestSource;
    private final JCheckBox myAnalyzeInjectedCode;
    private final List<ModelScopeItemView> myViewItems;

    @Deprecated
    public BaseAnalysisActionDialog(@NlsContexts.DialogTitle @NotNull String title2, @NotNull @NlsContexts.Separator String scopeTitle, @NotNull Project project, @NotNull AnalysisScope scope2, String moduleName, boolean rememberScope, @NotNull AnalysisUIOptions analysisUIOptions, @Nullable PsiElement context2) {
        if (title2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(0);
        }
        if (scopeTitle == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(1);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(2);
        }
        if (scope2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(3);
        }
        if (analysisUIOptions == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(4);
        }
        this(title2, scopeTitle, project, BaseAnalysisActionDialog.standardItems(project, scope2, moduleName != null ? ModuleManager.getInstance((Project)project).findModuleByName(moduleName) : null, context2), analysisUIOptions, rememberScope);
    }

    @NotNull
    public static List<ModelScopeItem> standardItems(@NotNull Project project, @NotNull AnalysisScope scope2, @Nullable Module module, @Nullable PsiElement context2) {
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(6);
        }
        List list2 = ContainerUtil.mapNotNull((Collection)ModelScopeItemPresenter.EP_NAME.getExtensionList(), presenter -> presenter.tryCreate(project, scope2, module, context2));
        if (list2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public BaseAnalysisActionDialog(@NlsContexts.DialogTitle @NotNull String title2, @NotNull @NlsContexts.Separator String scopeTitle, @NotNull Project project, @NotNull List<? extends ModelScopeItem> items, @NotNull AnalysisUIOptions options2, boolean rememberScope) {
        if (title2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(8);
        }
        if (scopeTitle == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(9);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(10);
        }
        if (items == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(11);
        }
        if (options2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(12);
        }
        this(title2, scopeTitle, project, items, options2, rememberScope, ModuleUtil.hasTestSourceRoots((Project)project));
    }

    public BaseAnalysisActionDialog(@NlsContexts.DialogTitle @NotNull String title2, @NotNull @NlsContexts.Separator String scopeTitle, @NotNull Project project, @NotNull List<? extends ModelScopeItem> items, @NotNull AnalysisUIOptions options2, boolean rememberScope, boolean showInspectTestSource) {
        if (title2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(13);
        }
        if (scopeTitle == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(14);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(15);
        }
        if (items == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(16);
        }
        if (options2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(17);
        }
        super(true);
        this.myGroup = new ButtonGroup();
        this.myInspectTestSource = new JCheckBox();
        this.myAnalyzeInjectedCode = new JCheckBox();
        this.myScopeTitle = scopeTitle;
        this.myProject = project;
        this.myViewItems = ModelScopeItemPresenter.createOrderedViews(items, this.getDisposable());
        this.myOptions = options2;
        this.myRememberScope = rememberScope;
        this.myShowInspectTestSource = showInspectTestSource;
        this.init();
        this.setTitle(title2);
    }

    protected JComponent createCenterPanel() {
        this.myInspectTestSource.setText(CodeInsightBundle.message((String)"scope.option.include.test.sources", (Object[])new Object[0]));
        this.myInspectTestSource.setSelected(this.myOptions.ANALYZE_TEST_SOURCES);
        this.myInspectTestSource.setVisible(this.myShowInspectTestSource);
        this.myAnalyzeInjectedCode.setText(CodeInsightBundle.message((String)"scope.option.analyze.injected.code", (Object[])new Object[0]));
        this.myAnalyzeInjectedCode.setSelected(this.myOptions.ANALYZE_INJECTED_CODE);
        this.myAnalyzeInjectedCode.setVisible(false);
        ArrayList<JRadioButton> buttons = new ArrayList<JRadioButton>();
        JPanel panel2 = new BaseAnalysisActionDialogUI().panel(this.myScopeTitle, this.myViewItems, this.myInspectTestSource, this.myAnalyzeInjectedCode, buttons, this.myDisposable);
        buttons.forEach(b -> this.myGroup.add((AbstractButton)b));
        this.preselectButton();
        BorderLayoutPanel wholePanel = new BorderLayoutPanel();
        wholePanel.addToTop((Component)panel2);
        JComponent additionalPanel = this.getAdditionalActionSettings(this.myProject);
        if (additionalPanel != null) {
            wholePanel.addToCenter((Component)additionalPanel);
        }
        new RadioUpDownListener(buttons.toArray(new JRadioButton[0]));
        return wholePanel;
    }

    public void setShowInspectInjectedCode(boolean showInspectInjectedCode) {
        if (Registry.is((String)"idea.batch.inspections.injected.psi.option") && SystemProperties.getBooleanProperty((String)"idea.batch.inspections.inspect.injected.psi", (boolean)true)) {
            this.myAnalyzeInjectedCode.setVisible(showInspectInjectedCode);
        }
    }

    private void preselectButton() {
        int type;
        List preselectedScopes;
        if (this.myRememberScope && (preselectedScopes = ContainerUtil.filter(this.myViewItems, arg_0 -> BaseAnalysisActionDialog.lambda$preselectButton$2(type = this.myOptions.SCOPE_TYPE, arg_0))).size() >= 1) {
            LOG.assertTrue(preselectedScopes.size() == 1, (Object)"preselectedScopes.size() == 1");
            ((ModelScopeItemView)preselectedScopes.get((int)0)).button.setSelected(true);
            return;
        }
        ArrayList<ModelScopeItemView> candidates = new ArrayList<ModelScopeItemView>();
        for (ModelScopeItemView view : this.myViewItems) {
            candidates.add(view);
            if (view.scopeId != 3) continue;
            break;
        }
        Collections.reverse(candidates);
        for (ModelScopeItemView x : candidates) {
            int scopeType2 = x.scopeId;
            if (scopeType2 == 8 || scopeType2 == 10) continue;
            x.button.setSelected(true);
            break;
        }
    }

    public JComponent getPreferredFocusedComponent() {
        Enumeration<AbstractButton> enumeration = this.myGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton button4 = enumeration.nextElement();
            if (!button4.isSelected()) continue;
            return button4;
        }
        return super.getPreferredFocusedComponent();
    }

    @Deprecated
    public AnalysisScope getScope(@NotNull AnalysisUIOptions uiOptions, @NotNull AnalysisScope defaultScope, @NotNull Project project, Module module) {
        if (uiOptions == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(18);
        }
        if (defaultScope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(19);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(20);
        }
        return this.getScope(defaultScope);
    }

    public boolean isProjectScopeSelected() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 1).findFirst().map(x -> x.button.isSelected()).orElse(false);
    }

    public boolean isModuleScopeSelected() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 4).findFirst().map(x -> x.button.isSelected()).orElse(false);
    }

    public boolean isUncommittedFilesSelected() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 10).findFirst().map(x -> x.button.isSelected()).orElse(false);
    }

    @Nullable
    public SearchScope getCustomScope() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 8 && x.button.isSelected()).findFirst().map(x -> x.model.getScope().toSearchScope()).orElse(null);
    }

    public boolean isInspectTestSources() {
        return this.myInspectTestSource.isSelected();
    }

    public boolean isAnalyzeInjectedCode() {
        return !this.myAnalyzeInjectedCode.isVisible() || this.myAnalyzeInjectedCode.isSelected();
    }

    public AnalysisScope getScope(@NotNull AnalysisScope defaultScope) {
        if (defaultScope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(21);
        }
        AnalysisScope scope2 = null;
        for (ModelScopeItemView x : this.myViewItems) {
            if (!x.button.isSelected()) continue;
            int type = x.scopeId;
            scope2 = x.model.getScope();
            if (!this.myRememberScope) continue;
            this.myOptions.SCOPE_TYPE = type;
            if (type != 8) continue;
            this.myOptions.CUSTOM_SCOPE_NAME = scope2.toSearchScope().getDisplayName();
        }
        if (scope2 == null) {
            scope2 = defaultScope;
            if (this.myRememberScope) {
                this.myOptions.SCOPE_TYPE = scope2.getScopeType();
            }
        }
        if (this.myInspectTestSource.isVisible()) {
            if (this.myRememberScope) {
                this.myOptions.ANALYZE_TEST_SOURCES = this.isInspectTestSources();
            }
            scope2.setIncludeTestSource(this.isInspectTestSources());
        }
        if (this.myAnalyzeInjectedCode.isVisible()) {
            if (this.myRememberScope) {
                this.myOptions.ANALYZE_INJECTED_CODE = this.isAnalyzeInjectedCode();
            }
            scope2.setAnalyzeInjectedCode(this.isAnalyzeInjectedCode());
        }
        FindSettings.getInstance().setDefaultScopeName(scope2.getDisplayName());
        return scope2;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project) {
        return null;
    }

    private static /* synthetic */ boolean lambda$preselectButton$2(int type, ModelScopeItemView x) {
        return x.scopeId == type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeTitle";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisUIOptions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/BaseAnalysisActionDialog";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiOptions";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/BaseAnalysisActionDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "standardItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "standardItems";
                break;
            }
            case 7: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

