/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.XmlCodeStyleMainPanel;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.MagicIntegerConstAccessor;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.xml.XmlBundle;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        if (modelSettings == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return new CodeStyleAbstractConfigurable(baseSettings, modelSettings, XmlLanguageCodeStyleSettingsProvider.getConfigurableDisplayNameText()){

            @Override
            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings2) {
                return new XmlCodeStyleMainPanel(this.getCurrentSettings(), settings2);
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.IDE.globalcodestyle.xml";
            }
        };
    }

    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings2) {
        return new XmlCodeStyleSettings(settings2);
    }

    @NotNull
    public Language getLanguage() {
        XMLLanguage xMLLanguage = XMLLanguage.INSTANCE;
        if (xMLLanguage == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        return xMLLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            return CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), "preview.xml.template");
        }
        return "";
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (settingsType == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        XmlLanguageCodeStyleSettingsProvider.customizeXml(consumer, settingsType);
    }

    static void customizeXml(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING"});
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_AT_FIRST_COLUMN.name(), CodeStyleSettingsCustomizable.CommenterOption.BLOCK_COMMENT_AT_FIRST_COLUMN.name()});
        }
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        if (indentOptions == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        commonSettings.setForceArrangeMenuAvailable(true);
        if (PlatformUtils.isRubyMine()) {
            indentOptions.INDENT_SIZE = 2;
        }
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        if (field == null) {
            XmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        if (codeStyleObject instanceof XmlCodeStyleSettings && "XML_WHITE_SPACE_AROUND_CDATA".equals(field.getName())) {
            return new MagicIntegerConstAccessor(codeStyleObject, field, new int[]{0, 1, 2}, new String[]{"preserve", "none", "new_lines"});
        }
        return super.getAccessor(codeStyleObject, field);
    }

    @NlsContexts.ConfigurableName
    public static String getConfigurableDisplayNameText() {
        return XmlBundle.message((String)"title.xml", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/XmlLanguageCodeStyleSettingsProvider";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/XmlLanguageCodeStyleSettingsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "customizeXml";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

