/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CustomizableLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.SpeedSearchHelper;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionTableWithPreviewPanel
extends CustomizableLanguageCodeStylePanel {
    private static final Logger LOG = Logger.getInstance(OptionTableWithPreviewPanel.class);
    private static final KeyStroke ENTER_KEY_STROKE = KeyStroke.getKeyStroke(10, 0, false);
    protected TreeTable myTreeTable;
    private final JPanel myPanel = new JPanel();
    private final List<Option> myOptions = new ArrayList<Option>();
    private final List<Option> myCustomOptions = new ArrayList<Option>();
    private final Set<String> myAllowedOptions = new HashSet<String>();
    private final Map<String, @NlsContexts.Label String> myRenamedFields = new HashMap<String, String>();
    private boolean myShowAllStandardOptions;
    protected boolean isFirstUpdate = true;
    private SpeedSearchHelper mySearchHelper;
    public final ColumnInfo TITLE = new ColumnInfo("TITLE"){

        public Object valueOf(Object o) {
            if (o instanceof MyTreeNode) {
                MyTreeNode node2 = (MyTreeNode)o;
                return node2.getText();
            }
            return o.toString();
        }

        public Class getColumnClass() {
            return TreeTableModel.class;
        }
    };
    public final ColumnInfo VALUE = new ColumnInfo("VALUE"){
        private final TableCellEditor myEditor;
        private final TableCellRenderer myRenderer;
        {
            this.myEditor = new MyValueEditor();
            this.myRenderer = new MyValueRenderer();
        }

        public Object valueOf(Object o) {
            if (o instanceof MyTreeNode) {
                MyTreeNode node2 = (MyTreeNode)o;
                return node2.getValue();
            }
            return null;
        }

        public TableCellRenderer getRenderer(Object o) {
            return this.myRenderer;
        }

        public TableCellEditor getEditor(Object item) {
            return this.myEditor;
        }

        public boolean isCellEditable(Object o) {
            return o instanceof MyTreeNode && ((MyTreeNode)o).isEnabled();
        }

        public void setValue(Object o, Object o1) {
            MyTreeNode node2 = (MyTreeNode)o;
            node2.setValue(o1);
        }
    };
    public final ColumnInfo[] COLUMNS = new ColumnInfo[]{this.TITLE, this.VALUE};

    public OptionTableWithPreviewPanel(CodeStyleSettings settings2) {
        super(settings2);
    }

    @Override
    protected void init() {
        super.init();
        this.myPanel.setLayout(new GridBagLayout());
        this.initTables();
        this.myTreeTable = this.createOptionsTree(this.getSettings());
        this.myTreeTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myTreeTable){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        this.myPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel previewPanel = OptionTableWithPreviewPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
        this.isFirstUpdate = false;
        this.customizeSettings();
    }

    @Override
    protected void resetDefaultNames() {
        this.myRenamedFields.clear();
    }

    public void showAllStandardOptions() {
        this.myShowAllStandardOptions = true;
        for (Option each : this.myOptions) {
            each.setEnabled(true);
        }
        for (Option each : this.myCustomOptions) {
            each.setEnabled(false);
        }
    }

    public void showStandardOptions(String ... optionNames) {
        Collections.addAll(this.myAllowedOptions, optionNames);
        for (Option each : this.myOptions) {
            each.setEnabled(false);
            for (String optionName : optionNames) {
                if (!each.getOptionName().equals(optionName)) continue;
                each.setEnabled(true);
            }
        }
        for (Option each : this.myCustomOptions) {
            each.setEnabled(false);
        }
    }

    public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title2, @Nls @Nullable String groupName, Object ... options2) {
        if (settingsClass == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(0);
        }
        if (fieldName == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(1);
        }
        if (title2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(2);
        }
        this.showCustomOption(settingsClass, fieldName, title2, groupName, null, null, options2);
    }

    public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title2, @Nls @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @NonNls @Nullable String anchorFieldName, Object ... options2) {
        if (settingsClass == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(3);
        }
        if (fieldName == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(4);
        }
        if (title2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(5);
        }
        if (this.isFirstUpdate) {
            FieldOption option2 = options2.length == 2 ? new SelectionOption(settingsClass, fieldName, title2, groupName, anchor2, anchorFieldName, (String[])options2[0], (int[])options2[1]) : new BooleanOption(settingsClass, fieldName, title2, groupName, anchor2, anchorFieldName);
            this.myCustomOptions.add(option2);
            option2.setEnabled(true);
        } else {
            for (Option each : this.myCustomOptions) {
                if (!(each instanceof FieldOption) || ((FieldOption)each).clazz != settingsClass || !each.getOptionName().equals(fieldName)) continue;
                each.setEnabled(true);
            }
        }
    }

    public void renameStandardOption(@NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String newTitle) {
        if (fieldName == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(6);
        }
        if (newTitle == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(7);
        }
        this.myRenamedFields.put(fieldName, newTitle);
    }

    public void showOption(@NotNull String optionName) {
        if (optionName == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(8);
        }
        this.myAllowedOptions.add(optionName);
    }

    protected TreeTable createOptionsTree(CodeStyleSettings settings2) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        HashMap<String, DefaultMutableTreeNode> groupsMap = new HashMap<String, DefaultMutableTreeNode>();
        List sorted = this.sortOptions(ContainerUtil.concat(this.myOptions, this.myCustomOptions));
        for (Option each : sorted) {
            String groupName;
            if (!this.myCustomOptions.contains(each) && !this.myAllowedOptions.contains(each.getOptionName()) && !this.myShowAllStandardOptions) continue;
            String group2 = each.groupName;
            MyTreeNode newNode = new MyTreeNode(each, each.title, settings2);
            DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)groupsMap.get(group2);
            if (groupNode != null) {
                groupNode.add(newNode);
                continue;
            }
            if (group2 == null) {
                groupName = each.title;
                groupNode = newNode;
            } else {
                groupName = group2;
                groupNode = new DefaultMutableTreeNode(groupName);
                groupNode.add(newNode);
            }
            groupsMap.put(groupName, groupNode);
            rootNode.add(groupNode);
        }
        ListTreeTableModel model2 = new ListTreeTableModel((TreeNode)rootNode, this.COLUMNS);
        TreeTable treeTable = new TreeTable((TreeTableModel)model2){

            public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
                TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
                tableRenderer.setRootVisible(false);
                tableRenderer.setShowsRootHandles(true);
                return tableRenderer;
            }

            public TableCellRenderer getCellRenderer(int row2, int column2) {
                TreePath treePath = this.getTree().getPathForRow(row2);
                if (treePath == null) {
                    return super.getCellRenderer(row2, column2);
                }
                Object node2 = treePath.getLastPathComponent();
                TableCellRenderer renderer2 = OptionTableWithPreviewPanel.this.COLUMNS[column2].getRenderer(node2);
                return renderer2 == null ? super.getCellRenderer(row2, column2) : renderer2;
            }

            public TableCellEditor getCellEditor(int row2, int column2) {
                TreePath treePath = this.getTree().getPathForRow(row2);
                if (treePath == null) {
                    return super.getCellEditor(row2, column2);
                }
                Object node2 = treePath.getLastPathComponent();
                TableCellEditor editor = OptionTableWithPreviewPanel.this.COLUMNS[column2].getEditor(node2);
                return editor == null ? super.getCellEditor(row2, column2) : editor;
            }
        };
        TreeTableSpeedSearch speedSearch2 = new TreeTableSpeedSearch(treeTable);
        speedSearch2.setComparator(new SpeedSearchComparator(false));
        this.mySearchHelper = new SpeedSearchHelper(speedSearch2);
        treeTable.setRootVisible(false);
        TreeTableTree tree = treeTable.getTree();
        MyTitleRenderer titleRenderer = new MyTitleRenderer(this.mySearchHelper);
        tree.setCellRenderer((TreeCellRenderer)((Object)titleRenderer));
        tree.setShowsRootHandles(true);
        treeTable.setSelectionMode(0);
        treeTable.setTableHeader(null);
        TreeUtil.expandAll((JTree)tree);
        treeTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(1);
        treeTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(1);
        int maxWidth = tree.getPreferredScrollableViewportSize().width + 10;
        TableColumn titleColumn = treeTable.getColumnModel().getColumn(0);
        titleColumn.setPreferredWidth(maxWidth);
        titleColumn.setMinWidth(maxWidth);
        titleColumn.setMaxWidth(maxWidth);
        titleColumn.setResizable(false);
        Dimension valueSize = new JLabel(ApplicationBundle.message((String)"option.table.sizing.text", (Object[])new Object[0])).getPreferredSize();
        treeTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)(maxWidth + valueSize.width + 10), (int)20));
        return treeTable;
    }

    private String getRenamedTitle(String fieldOrGroupName, String defaultName) {
        String result2 = this.myRenamedFields.get(fieldOrGroupName);
        return result2 == null ? defaultName : result2;
    }

    protected abstract void initTables();

    private static void resetNode(TreeNode node2, CodeStyleSettings settings2) {
        if (node2 instanceof MyTreeNode) {
            ((MyTreeNode)node2).reset(settings2);
        }
        for (int j = 0; j < node2.getChildCount(); ++j) {
            TreeNode child2 = node2.getChildAt(j);
            OptionTableWithPreviewPanel.resetNode(child2, settings2);
        }
    }

    private static void applyNode(TreeNode node2, CodeStyleSettings settings2) {
        if (node2 instanceof MyTreeNode) {
            ((MyTreeNode)node2).apply(settings2);
        }
        for (int j = 0; j < node2.getChildCount(); ++j) {
            TreeNode child2 = node2.getChildAt(j);
            OptionTableWithPreviewPanel.applyNode(child2, settings2);
        }
    }

    private static boolean isModified(TreeNode node2, CodeStyleSettings settings2) {
        if (node2 instanceof MyTreeNode && ((MyTreeNode)node2).isModified(settings2)) {
            return true;
        }
        for (int j = 0; j < node2.getChildCount(); ++j) {
            TreeNode child2 = node2.getChildAt(j);
            if (!OptionTableWithPreviewPanel.isModified(child2, settings2)) continue;
            return true;
        }
        return false;
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title2) {
        if (fieldName == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(9);
        }
        if (title2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(10);
        }
        this.addOption(fieldName, title2, null);
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title2, String @NotNull [] options2, int @NotNull [] values2) {
        if (fieldName == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(11);
        }
        if (title2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(12);
        }
        if (options2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(13);
        }
        if (values2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(14);
        }
        this.addOption(fieldName, title2, null, options2, values2);
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title2, @Nullable String groupName, int minValue, int maxValue, int defaultValue, @Nullable Function<? super Integer, String> defaultValueRenderer) {
        if (fieldName == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(15);
        }
        if (title2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(16);
        }
        this.myOptions.add(new IntOption(null, fieldName, title2, groupName, null, null, minValue, maxValue, defaultValue, defaultValueRenderer));
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title2, @Nullable String groupName) {
        if (fieldName == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(17);
        }
        if (title2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(18);
        }
        this.myOptions.add(new BooleanOption(null, fieldName, title2, groupName, null, null));
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title2, @Nullable String groupName, String @NotNull [] options2, int @NotNull [] values2) {
        if (fieldName == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(19);
        }
        if (title2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(20);
        }
        if (options2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(21);
        }
        if (values2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(22);
        }
        this.myOptions.add(new SelectionOption(null, fieldName, title2, groupName, null, null, options2, values2));
    }

    protected void addCustomOption(@NotNull Option option2) {
        if (option2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(23);
        }
        this.myOptions.add(option2);
    }

    @Nullable
    protected JComponent getCustomValueRenderer(@NotNull String optionName, @NotNull Object value2) {
        if (optionName == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(24);
        }
        if (value2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(25);
        }
        return null;
    }

    @Nullable
    protected JComponent getCustomNodeEditor(@NotNull MyTreeNode node2) {
        if (node2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(26);
        }
        return null;
    }

    @Nullable
    protected Object getCustomNodeEditorValue(@NotNull JComponent customEditor) {
        if (customEditor == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(27);
        }
        return null;
    }

    @Override
    public void apply(CodeStyleSettings settings2) throws ConfigurationException {
        TableCellEditor editor = this.myTreeTable.getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            throw new ConfigurationException(LangBundle.message((String)"dialog.message.editing.cannot.be.stopped", (Object[])new Object[0]));
        }
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        OptionTableWithPreviewPanel.applyNode(root, settings2);
    }

    @Override
    public boolean isModified(CodeStyleSettings settings2) {
        TableCellEditor editor = this.myTreeTable.getCellEditor();
        if (editor != null) {
            return true;
        }
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        return OptionTableWithPreviewPanel.isModified(root, settings2);
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings2) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        OptionTableWithPreviewPanel.resetNode(root, settings2);
        ((DefaultTreeModel)treeModel).nodeChanged(root);
    }

    @Override
    @NotNull
    public Set<String> processListOptions() {
        HashSet<String> options2 = new HashSet<String>();
        OptionTableWithPreviewPanel.collectOptions(options2, this.myOptions);
        OptionTableWithPreviewPanel.collectOptions(options2, this.myCustomOptions);
        HashSet<String> hashSet = options2;
        if (hashSet == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    private static void collectOptions(Set<? super String> optionNames, List<? extends Option> optionList) {
        for (Option option2 : optionList) {
            if (option2.groupName != null) {
                optionNames.add(option2.groupName);
            }
            optionNames.add(option2.title);
        }
    }

    @Override
    public void highlightOptions(@NotNull String searchString) {
        if (searchString == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(29);
        }
        this.mySearchHelper.find(searchString);
    }

    private static void updateColors(@NotNull JComponent component2, @NotNull JTable table, boolean isSelected) {
        if (component2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(30);
        }
        if (table == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(31);
        }
        component2.setOpaque(isSelected);
        component2.setBackground(RenderingUtil.getBackground((JTable)table, (boolean)isSelected));
        if (!(component2 instanceof ColoredLabel) || isSelected) {
            component2.setForeground(RenderingUtil.getForeground((JTable)table, (boolean)isSelected));
        }
    }

    @NotNull
    private static String arrayToString(int @NotNull [] array2) {
        int n;
        if (array2 == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(32);
        }
        if ((n = array2.length) == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder(array2.length * 4);
        b.append(array2[0]);
        for (int i2 = 1; i2 < n; ++i2) {
            b.append(',').append(' ').append(array2[i2]);
        }
        String string = b.toString();
        if (string == null) {
            OptionTableWithPreviewPanel.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 28: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 28: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTitle";
                break;
            }
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customEditor";
                break;
            }
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "processListOptions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showCustomOption";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renameStandardOption";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showOption";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addOption";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addCustomOption";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCustomValueRenderer";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCustomNodeEditor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCustomNodeEditorValue";
                break;
            }
            case 28: 
            case 33: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "highlightOptions";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "arrayToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 28: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ColoredLabel
    extends JLabel {
        public ColoredLabel(@Nls String text2, Color foreground) {
            super(text2);
            this.setForeground(foreground);
        }
    }

    private final class MyTitleRenderer
    extends ColoredTreeCellRenderer {
        private final SpeedSearchHelper mySearchHelper;

        private MyTitleRenderer(SpeedSearchHelper helper) {
            this.mySearchHelper = helper;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            String text2;
            if (tree == null) {
                MyTitleRenderer.$$$reportNull$$$0(0);
            }
            SimpleTextAttributes attributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (value2 instanceof MyTreeNode) {
                MyTreeNode node2 = (MyTreeNode)value2;
                if (node2.getKey().groupName == null) {
                    attributes2 = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                }
                text2 = OptionTableWithPreviewPanel.this.getRenamedTitle(node2.getKey().getOptionName(), node2.getText());
                this.setEnabled(node2.isEnabled());
            } else {
                attributes2 = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                text2 = OptionTableWithPreviewPanel.this.getRenamedTitle(value2.toString(), value2.toString());
                this.setEnabled(true);
            }
            this.mySearchHelper.setLabelText((SimpleColoredComponent)this, text2, attributes2.getStyle(), attributes2.getFgColor(), attributes2.getBgColor());
            this.setBackground(RenderingUtil.getBackground((JTree)tree, (boolean)selected2));
            this.setForeground(RenderingUtil.getForeground((JTree)tree, (boolean)selected2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyTitleRenderer", "customizeCellRenderer"));
        }
    }

    private class MyValueEditor
    extends AbstractTableCellEditor {
        public static final String STOP_CELL_EDIT_ACTION_KEY = "stopEdit";
        private final JCheckBox myBooleanEditor = new JBCheckBox();
        private final JBComboBoxTableCellEditorComponent myOptionsEditor = new JBComboBoxTableCellEditorComponent();
        private final IntegerField myIntOptionsEditor = new IntegerField();
        private JComponent myCurrentEditor = null;
        private MyTreeNode myCurrentNode = null;
        private final AbstractAction STOP_CELL_EDIT_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyValueEditor.this.stopCellEditing();
            }
        };

        MyValueEditor() {
            ActionListener itemChoosen = new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (MyValueEditor.this.myCurrentNode != null) {
                        MyValueEditor.this.myCurrentNode.setValue(MyValueEditor.this.getCellEditorValue());
                        OptionTableWithPreviewPanel.this.somethingChanged();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueEditor$2", "actionPerformed"));
                }
            };
            this.myBooleanEditor.addActionListener(itemChoosen);
            this.myOptionsEditor.addActionListener(itemChoosen);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myBooleanEditor);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myOptionsEditor);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myIntOptionsEditor);
        }

        public Object getCellEditorValue() {
            if (this.myCurrentEditor == this.myOptionsEditor) {
                return this.myOptionsEditor.getEditorValue();
            }
            if (this.myCurrentEditor == this.myBooleanEditor) {
                return this.myBooleanEditor.isSelected();
            }
            if (this.myCurrentEditor == this.myIntOptionsEditor) {
                return this.myIntOptionsEditor.getValue();
            }
            Object value2 = OptionTableWithPreviewPanel.this.getCustomNodeEditorValue(this.myCurrentEditor);
            if (value2 != null) {
                return value2;
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row2, int column2) {
            DefaultMutableTreeNode defaultNode = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row2).getLastPathComponent();
            this.myCurrentEditor = null;
            this.myCurrentNode = null;
            if (defaultNode instanceof MyTreeNode) {
                MyTreeNode node2;
                this.myCurrentNode = node2 = (MyTreeNode)defaultNode;
                if (node2.getKey() instanceof BooleanOption) {
                    this.myCurrentEditor = this.myBooleanEditor;
                    this.myBooleanEditor.setSelected(node2.getValue() == Boolean.TRUE);
                    this.myBooleanEditor.setEnabled(node2.isEnabled());
                } else if (node2.getKey() instanceof IntOption) {
                    IntOption intOption = (IntOption)node2.getKey();
                    this.myCurrentEditor = this.myIntOptionsEditor;
                    this.myIntOptionsEditor.setCanBeEmpty(true);
                    this.myIntOptionsEditor.setMinValue(intOption.getMinValue());
                    this.myIntOptionsEditor.setMaxValue(intOption.getMaxValue());
                    this.myIntOptionsEditor.setDefaultValue(Integer.valueOf(intOption.getDefaultValue()));
                    this.myIntOptionsEditor.setValue((Integer)node2.getValue());
                } else if (node2.getKey() instanceof SelectionOption) {
                    this.myCurrentEditor = this.myOptionsEditor;
                    this.myOptionsEditor.setCell(table, row2, column2);
                    this.myOptionsEditor.setText(String.valueOf(node2.getValue()));
                    this.myOptionsEditor.setOptions((Object[])((SelectionOption)node2.getKey()).options);
                    this.myOptionsEditor.setDefaultValue(node2.getValue());
                } else {
                    this.myCurrentEditor = OptionTableWithPreviewPanel.this.getCustomNodeEditor(node2);
                }
            }
            if (this.myCurrentEditor != null) {
                this.myCurrentEditor.setBackground(table.getBackground());
                if (this.myCurrentEditor instanceof JTextField) {
                    this.myCurrentEditor.getInputMap().put(ENTER_KEY_STROKE, STOP_CELL_EDIT_ACTION_KEY);
                    this.myCurrentEditor.getActionMap().put(STOP_CELL_EDIT_ACTION_KEY, this.STOP_CELL_EDIT_ACTION);
                }
            }
            return this.myCurrentEditor;
        }
    }

    private class MyValueRenderer
    implements TableCellRenderer {
        private JTable myTable;
        private int myRow;
        private int myColumn;
        private final OptionsLabel myComboBox = new OptionsLabel();
        private final JCheckBox myCheckBox = new JBCheckBox();
        private final JPanel myEmptyLabel = new JPanel();
        private final JLabel myIntLabel = new JLabel();

        MyValueRenderer() {
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myComboBox);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myCheckBox);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myIntLabel);
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            JComponent customRenderer;
            if (table == null) {
                MyValueRenderer.$$$reportNull$$$0(0);
            }
            this.myTable = table;
            this.myRow = row2;
            this.myColumn = column2;
            boolean isEnabled = true;
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row2).getLastPathComponent();
            Option key = null;
            if (node2 instanceof MyTreeNode) {
                isEnabled = ((MyTreeNode)node2).isEnabled();
                key = ((MyTreeNode)node2).getKey();
            }
            if (!table.isEnabled()) {
                isEnabled = false;
            }
            if (key != null && value2 != null && (customRenderer = OptionTableWithPreviewPanel.this.getCustomValueRenderer(key.getOptionName(), value2)) != null) {
                OptionTableWithPreviewPanel.updateColors(customRenderer, table, isSelected);
                JComponent jComponent = customRenderer;
                if (jComponent == null) {
                    MyValueRenderer.$$$reportNull$$$0(1);
                }
                return jComponent;
            }
            if (value2 instanceof Boolean) {
                this.myCheckBox.setSelected((Boolean)value2);
                this.myCheckBox.setEnabled(isEnabled);
                OptionTableWithPreviewPanel.updateColors(this.myCheckBox, table, isSelected);
                JCheckBox jCheckBox = this.myCheckBox;
                if (jCheckBox == null) {
                    MyValueRenderer.$$$reportNull$$$0(2);
                }
                return jCheckBox;
            }
            if (value2 instanceof String) {
                this.myComboBox.setText((String)value2);
                this.myComboBox.setEnabled(isEnabled);
                OptionTableWithPreviewPanel.updateColors(this.myComboBox, table, isSelected);
                OptionsLabel optionsLabel = this.myComboBox;
                if (optionsLabel == null) {
                    MyValueRenderer.$$$reportNull$$$0(3);
                }
                return optionsLabel;
            }
            if (value2 instanceof Integer) {
                if (key instanceof IntOption && ((IntOption)key).isDefaultValue(value2)) {
                    this.myIntLabel.setText(((IntOption)key).getDefaultValueText());
                } else {
                    @NlsSafe String text2 = value2.toString();
                    this.myIntLabel.setText(text2);
                }
                OptionTableWithPreviewPanel.updateColors(this.myIntLabel, table, isSelected);
                JLabel jLabel = this.myIntLabel;
                if (jLabel == null) {
                    MyValueRenderer.$$$reportNull$$$0(4);
                }
                return jLabel;
            }
            OptionTableWithPreviewPanel.updateColors(this.myEmptyLabel, table, isSelected);
            JPanel jPanel2 = this.myEmptyLabel;
            if (jPanel2 == null) {
                MyValueRenderer.$$$reportNull$$$0(5);
            }
            return jPanel2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableCellRendererComponent";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        protected class OptionsLabel
        extends JLabel {
            protected OptionsLabel() {
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleOptionsLabel();
                }
                return this.accessibleContext;
            }

            protected class AccessibleOptionsLabel
            extends JLabel.AccessibleJLabel
            implements AccessibleAction {
                protected AccessibleOptionsLabel() {
                    super(OptionsLabel.this);
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PUSH_BUTTON;
                }

                @Override
                public AccessibleAction getAccessibleAction() {
                    return this;
                }

                @Override
                public int getAccessibleActionCount() {
                    return 1;
                }

                @Override
                public String getAccessibleActionDescription(int i2) {
                    if (i2 == 0) {
                        return UIManager.getString("AbstractButton.clickText");
                    }
                    return null;
                }

                @Override
                public boolean doAccessibleAction(int i2) {
                    if (i2 == 0) {
                        MyValueRenderer.this.myTable.editCellAt(MyValueRenderer.this.myRow, MyValueRenderer.this.myColumn);
                        return true;
                    }
                    return false;
                }
            }
        }
    }

    protected static class MyTreeNode
    extends DefaultMutableTreeNode {
        private final Option myKey;
        private final String myText;
        private Object myValue;

        public MyTreeNode(Option key, String text2, CodeStyleSettings settings2) {
            this.myKey = key;
            this.myText = text2;
            this.myValue = key.getValue(settings2);
            this.setUserObject(this.myText);
        }

        public Option getKey() {
            return this.myKey;
        }

        public String getText() {
            return this.myText;
        }

        public Object getValue() {
            return this.myValue;
        }

        public void setValue(Object value2) {
            this.myValue = value2;
        }

        public void reset(CodeStyleSettings settings2) {
            this.setValue(this.myKey.getValue(settings2));
        }

        public boolean isModified(CodeStyleSettings settings2) {
            return this.myValue != null && !this.myValue.equals(this.myKey.getValue(settings2));
        }

        public void apply(CodeStyleSettings settings2) {
            this.myKey.setValue(this.myValue, settings2);
        }

        public boolean isEnabled() {
            return this.myKey.isEnabled();
        }
    }

    private class IntOption
    extends FieldOption {
        private final int myMinValue;
        private final int myMaxValue;
        private final int myDefaultValue;
        private final @Nullable Function<? super Integer, @Nls String> myDefaultValueRenderer;

        IntOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title2, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, String anchorFiledName, int minValue, int maxValue, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nls @Nullable int defaultValue, Function<? super Integer, String> defaultValueRenderer) {
            if (fieldName == null) {
                IntOption.$$$reportNull$$$0(0);
            }
            if (title2 == null) {
                IntOption.$$$reportNull$$$0(1);
            }
            super(clazz, fieldName, title2, groupName, anchor2, anchorFiledName);
            this.myMinValue = minValue;
            this.myMaxValue = maxValue;
            this.myDefaultValue = defaultValue;
            this.myDefaultValueRenderer = defaultValueRenderer;
        }

        @Override
        public Object getValue(CodeStyleSettings settings2) {
            try {
                return this.field.getInt(this.getSettings(settings2));
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        @Override
        public void setValue(Object value2, CodeStyleSettings settings2) {
            try {
                if (value2 instanceof Integer) {
                    this.field.setInt(this.getSettings(settings2), (Integer)value2);
                } else {
                    this.field.setInt(this.getSettings(settings2), this.myDefaultValue);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public int getMinValue() {
            return this.myMinValue;
        }

        public int getMaxValue() {
            return this.myMaxValue;
        }

        public int getDefaultValue() {
            return this.myDefaultValue;
        }

        public boolean isDefaultValue(Object value2) {
            return value2 instanceof Integer && (Integer)value2 == this.myDefaultValue;
        }

        @Nullable
        @Nls
        public String getDefaultValueText() {
            return this.myDefaultValueRenderer != null ? this.myDefaultValueRenderer.apply((Integer)this.myDefaultValue) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fieldName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$IntOption";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SelectionOption
    extends FieldOption {
        final String @NotNull [] options;
        final int @NotNull [] values;

        SelectionOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title2, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @NotNull String anchorFiledName, String @NotNull [] options2, int[] values2) {
            if (fieldName == null) {
                SelectionOption.$$$reportNull$$$0(0);
            }
            if (title2 == null) {
                SelectionOption.$$$reportNull$$$0(1);
            }
            if (options2 == null) {
                SelectionOption.$$$reportNull$$$0(2);
            }
            if (values2 == null) {
                SelectionOption.$$$reportNull$$$0(3);
            }
            super(clazz, fieldName, title2, groupName, anchor2, anchorFiledName);
            this.options = options2;
            this.values = values2;
        }

        @Override
        public Object getValue(CodeStyleSettings settings2) {
            try {
                int value2 = this.field.getInt(this.getSettings(settings2));
                for (int i2 = 0; i2 < this.values.length; ++i2) {
                    if (this.values[i2] != value2) continue;
                    return this.options[i2];
                }
                String possibleValues = OptionTableWithPreviewPanel.arrayToString(this.values);
                LOG.error("Invalid option value " + value2 + " for " + this.field.getName() + " (possible values: " + possibleValues + ")");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void setValue(Object value2, CodeStyleSettings settings2) {
            try {
                for (int i2 = 0; i2 < this.values.length; ++i2) {
                    if (!this.options[i2].equals(value2)) continue;
                    this.field.setInt(this.getSettings(settings2), this.values[i2]);
                    return;
                }
                LOG.error("Invalid option value " + value2 + " for " + this.field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fieldName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "values";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$SelectionOption";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class BooleanOption
    extends FieldOption {
        private BooleanOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title2, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, String anchorFiledName) {
            if (fieldName == null) {
                BooleanOption.$$$reportNull$$$0(0);
            }
            if (title2 == null) {
                BooleanOption.$$$reportNull$$$0(1);
            }
            super(clazz, fieldName, title2, groupName, anchor2, anchorFiledName);
        }

        @Override
        public Object getValue(CodeStyleSettings settings2) {
            try {
                return this.field.getBoolean(this.getSettings(settings2));
            }
            catch (IllegalAccessException ignore) {
                return null;
            }
        }

        @Override
        public void setValue(Object value2, CodeStyleSettings settings2) {
            try {
                this.field.setBoolean(this.getSettings(settings2), (Boolean)value2);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fieldName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$BooleanOption";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected abstract class FieldOption
    extends Option {
        @Nullable
        final Class<? extends CustomCodeStyleSettings> clazz;
        @NotNull
        final Field field;

        FieldOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title2, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, String anchorFiledName) {
            if (fieldName == null) {
                FieldOption.$$$reportNull$$$0(0);
            }
            if (title2 == null) {
                FieldOption.$$$reportNull$$$0(1);
            }
            super(fieldName, title2, groupName, anchor2, anchorFiledName);
            this.clazz = clazz;
            try {
                Class styleSettingsClass = clazz == null ? CommonCodeStyleSettings.class : clazz;
                this.field = styleSettingsClass.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        protected Object getSettings(CodeStyleSettings settings2) {
            if (this.clazz != null) {
                return settings2.getCustomSettings(this.clazz);
            }
            return settings2.getCommonSettings(OptionTableWithPreviewPanel.this.getDefaultLanguage());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fieldName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$FieldOption";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class Option
    extends CustomizableLanguageCodeStylePanel.OrderedOption {
        @NotNull
        final String title;
        @Nullable
        final String groupName;
        private boolean myEnabled;

        protected Option(@NotNull String optionName, @NotNull String title2, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorOptionName) {
            if (optionName == null) {
                Option.$$$reportNull$$$0(0);
            }
            if (title2 == null) {
                Option.$$$reportNull$$$0(1);
            }
            super(optionName, anchor2, anchorOptionName);
            this.myEnabled = false;
            this.title = title2;
            this.groupName = groupName;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public abstract Object getValue(CodeStyleSettings var1);

        public abstract void setValue(Object var1, CodeStyleSettings var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "optionName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$Option";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

