/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.editorActions.XmlTagNameSynchronizer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlTagRuleProvider;
import com.intellij.xml.actions.GenerateXmlTagAction;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagInsertHandler
implements InsertHandler<LookupElement> {
    public static final XmlTagInsertHandler INSTANCE = new XmlTagInsertHandler();

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        if (context2 == null) {
            XmlTagInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            XmlTagInsertHandler.$$$reportNull$$$0(1);
        }
        Project project = context2.getProject();
        Editor editor = context2.getEditor();
        int startOffset = context2.getStartOffset();
        Document document = InjectedLanguageUtil.getTopLevelEditor(editor).getDocument();
        Ref currentElementRef = Ref.create();
        XmlTagNameSynchronizer.runWithoutCancellingSyncTagsEditing(document, () -> {
            int offset = editor.getCaretModel().getOffset();
            editor.getDocument().insertString(offset, (CharSequence)" ");
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            currentElementRef.set((Object)context2.getFile().findElementAt(startOffset));
            editor.getDocument().deleteString(offset, offset + 1);
        });
        XmlTag tag2 = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)((PsiElement)currentElementRef.get()), XmlTag.class, (boolean)true);
        if (tag2 == null) {
            return;
        }
        if (context2.getCompletionChar() != '\r') {
            context2.setAddCompletionChar(false);
        }
        if (XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_TAG_END) == null && XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_EMPTY_ELEMENT_END) == null) {
            XmlTagInsertHandler.insertIncompleteTag(context2.getCompletionChar(), editor, tag2);
        } else if (context2.getCompletionChar() == '\t') {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            int caretOffset = editor.getCaretModel().getOffset();
            XmlTag otherTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context2.getFile().findElementAt(caretOffset), XmlTag.class);
            XmlToken endTagStart = XmlUtil.getTokenOfType((PsiElement)otherTag, XmlTokenType.XML_END_TAG_START);
            if (endTagStart != null) {
                PsiElement sibling = endTagStart.getNextSibling();
                assert (sibling != null);
                ASTNode node2 = sibling.getNode();
                assert (node2 != null);
                if (node2.getElementType() == XmlTokenType.XML_NAME) {
                    int sOffset = sibling.getTextRange().getStartOffset();
                    int eOffset = sibling.getTextRange().getEndOffset();
                    editor.getDocument().deleteString(sOffset, eOffset);
                    editor.getDocument().insertString(sOffset, (CharSequence)otherTag.getName());
                }
            }
            editor.getCaretModel().moveToOffset(caretOffset + 1);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
        }
        if (context2.getCompletionChar() == ' ' && TemplateManager.getInstance(project).getActiveTemplate(editor) != null) {
            return;
        }
        TailType tailType = LookupItem.handleCompletionChar(editor, item, context2.getCompletionChar());
        tailType.processTail(editor, editor.getCaretModel().getOffset());
    }

    public static void insertIncompleteTag(char completionChar, final Editor editor, XmlTag tag2) {
        XmlElementDescriptor descriptor2;
        XmlTag originalElement = CompletionUtil.getOriginalElement(tag2);
        XmlElementDescriptor xmlElementDescriptor = descriptor2 = originalElement != null ? originalElement.getDescriptor() : tag2.getDescriptor();
        if (descriptor2 == null) {
            return;
        }
        final Project project = editor.getProject();
        TemplateManager templateManager = TemplateManager.getInstance(project);
        Template template = templateManager.createTemplate("", "");
        template.setToIndent(true);
        PsiFile containingFile = tag2.getContainingFile();
        boolean htmlCode = HtmlUtil.hasHtml(containingFile) || HtmlUtil.supportsXmlTypedHandlers(containingFile);
        template.setToReformat(!htmlCode);
        StringBuilder indirectRequiredAttrs = XmlTagInsertHandler.addRequiredAttributes(descriptor2, tag2, template, containingFile);
        final boolean chooseAttributeName = XmlTagInsertHandler.addTail(completionChar, descriptor2, htmlCode, tag2, template, indirectRequiredAttrs);
        templateManager.startTemplate(editor, template, new TemplateEditingAdapter(){
            private RangeMarker myAttrValueMarker;

            @Override
            public void waitingForInput(Template template) {
                int offset = editor.getCaretModel().getOffset();
                this.myAttrValueMarker = editor.getDocument().createRangeMarker(offset + 1, offset + 4);
            }

            @Override
            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                char c;
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                int offset = editor.getCaretModel().getOffset();
                if (chooseAttributeName && offset > 0 && ((c = editor.getDocument().getCharsSequence().charAt(offset - 1)) == '/' || c == ' ' && brokenOff)) {
                    WriteCommandAction.writeCommandAction((Project)project).run(() -> editor.getDocument().replaceString(offset, offset + 3, (CharSequence)">"));
                }
            }

            @Override
            public void templateCancelled(Template template) {
                if (this.myAttrValueMarker == null) {
                    return;
                }
                if (UndoManager.getInstance((Project)project).isUndoOrRedoInProgress()) {
                    return;
                }
                if (chooseAttributeName && this.myAttrValueMarker.isValid()) {
                    int startOffset = this.myAttrValueMarker.getStartOffset();
                    int endOffset = this.myAttrValueMarker.getEndOffset();
                    WriteCommandAction.writeCommandAction((Project)project).run(() -> editor.getDocument().replaceString(startOffset, endOffset, (CharSequence)">"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/completion/XmlTagInsertHandler$1", "templateFinished"));
            }
        });
    }

    @Nullable
    private static StringBuilder addRequiredAttributes(XmlElementDescriptor descriptor2, @Nullable XmlTag tag2, Template template, PsiFile containingFile) {
        InspectionProfileImpl profile;
        XmlEntitiesInspection inspection;
        Set notRequiredAttributes = Collections.emptySet();
        if (tag2 instanceof HtmlTag && (inspection = (XmlEntitiesInspection)(profile = InspectionProjectProfileManager.getInstance(tag2.getProject()).getCurrentProfile()).getUnwrappedTool("RequiredAttributes", (PsiElement)tag2)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(inspection.getAdditionalEntries());
            notRequiredAttributes = new HashSet();
            while (tokenizer.hasMoreElements()) {
                notRequiredAttributes.add(tokenizer.nextToken());
            }
        }
        XmlAttributeDescriptor[] attributes2 = descriptor2.getAttributesDescriptors(tag2);
        StringBuilder indirectRequiredAttrs = null;
        if (WebEditorOptions.getInstance().isAutomaticallyInsertRequiredAttributes()) {
            XmlExtension extension2 = XmlExtension.getExtension(containingFile);
            for (XmlAttributeDescriptor attributeDecl : attributes2) {
                boolean htmlCode;
                String attributeName = attributeDecl.getName((PsiElement)tag2);
                boolean shouldBeInserted = extension2.shouldBeInserted(attributeDecl);
                if (!shouldBeInserted) continue;
                XmlExtension.AttributeValuePresentation presenter = extension2.getAttributeValuePresentation(tag2, attributeName, XmlEditUtil.getAttributeQuote(containingFile));
                boolean bl = htmlCode = HtmlUtil.hasHtml(containingFile) || HtmlUtil.supportsXmlTypedHandlers(containingFile);
                if (tag2 == null || tag2.getAttributeValue(attributeName) == null) {
                    if (notRequiredAttributes.contains(attributeName)) continue;
                    if (!extension2.isIndirectSyntax(attributeDecl)) {
                        template.addTextSegment(" " + attributeName + "=" + presenter.getPrefix());
                        template.addVariable(presenter.showAutoPopup() ? new MacroCallNode(new CompleteMacro()) : new EmptyExpression(), true);
                        template.addTextSegment(presenter.getPostfix());
                        continue;
                    }
                    if (indirectRequiredAttrs == null) {
                        indirectRequiredAttrs = new StringBuilder();
                    }
                    indirectRequiredAttrs.append("\n<jsp:attribute name=\"").append(attributeName).append("\"></jsp:attribute>\n");
                    continue;
                }
                if (!attributeDecl.isFixed() || attributeDecl.getDefaultValue() == null || htmlCode) continue;
                template.addTextSegment(" " + attributeName + "=" + presenter.getPrefix() + attributeDecl.getDefaultValue() + presenter.getPostfix());
            }
        }
        return indirectRequiredAttrs;
    }

    protected static boolean addTail(char completionChar, XmlElementDescriptor descriptor2, boolean isHtmlCode, XmlTag tag2, Template template, StringBuilder indirectRequiredAttrs) {
        if (completionChar == '>' || completionChar == '/' && indirectRequiredAttrs != null) {
            String name;
            template.addTextSegment(">");
            if (indirectRequiredAttrs != null) {
                template.addTextSegment(indirectRequiredAttrs.toString());
            }
            template.addEndVariable();
            if (!(tag2 instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag2, true) || tag2.getAttributes().length != 0 || !WebEditorOptions.getInstance().isAutomaticallyInsertClosingTag() || (name = descriptor2.getName((PsiElement)tag2)) == null)) {
                template.addTextSegment("</");
                template.addTextSegment(name);
                template.addTextSegment(">");
            }
        } else if (completionChar == '/') {
            template.addTextSegment(XmlTagInsertHandler.closeTag(tag2));
        } else if (completionChar == ' ' && template.getSegmentsCount() == 0) {
            if (WebEditorOptions.getInstance().isAutomaticallyStartAttribute() && (descriptor2.getAttributesDescriptors(tag2).length > 0 || XmlTagInsertHandler.isTagFromHtml(tag2) && !HtmlUtil.isTagWithoutAttributes(tag2.getName()))) {
                XmlTagInsertHandler.completeAttribute(tag2.getContainingFile(), template);
                return true;
            }
        } else if (completionChar == '\u0000' || completionChar == '\n' || completionChar == '\t') {
            if (WebEditorOptions.getInstance().isAutomaticallyInsertClosingTag() && isHtmlCode && HtmlUtil.isSingleHtmlTag(tag2, true)) {
                if (XmlTagInsertHandler.hasOwnAttributes(descriptor2, tag2)) {
                    template.addEndVariable();
                }
                template.addTextSegment(HtmlUtil.isHtmlTag(tag2) ? ">" : XmlTagInsertHandler.closeTag(tag2));
            } else {
                if (XmlTagInsertHandler.needAtLeastOneAttribute(tag2) && WebEditorOptions.getInstance().isAutomaticallyStartAttribute() && tag2.getAttributes().length == 0 && template.getSegmentsCount() == 0) {
                    XmlTagInsertHandler.completeAttribute(tag2.getContainingFile(), template);
                    return true;
                }
                XmlTagInsertHandler.completeTagTail(template, descriptor2, tag2.getContainingFile(), tag2, true);
            }
        }
        return false;
    }

    @NotNull
    private static String closeTag(XmlTag tag2) {
        CodeStyleSettings settings2 = CodeStyle.getSettings((PsiFile)tag2.getContainingFile());
        boolean html = HtmlUtil.isHtmlTag(tag2);
        boolean needsSpace = html && ((HtmlCodeStyleSettings)settings2.getCustomSettings(HtmlCodeStyleSettings.class)).HTML_SPACE_INSIDE_EMPTY_TAG || !html && ((XmlCodeStyleSettings)settings2.getCustomSettings(XmlCodeStyleSettings.class)).XML_SPACE_INSIDE_EMPTY_TAG;
        return needsSpace ? " />" : "/>";
    }

    private static void completeAttribute(PsiFile file2, Template template) {
        template.addTextSegment(" ");
        template.addVariable(new MacroCallNode(new CompleteMacro()), true);
        template.addTextSegment("=" + XmlEditUtil.getAttributeQuote(file2));
        template.addEndVariable();
        template.addTextSegment(XmlEditUtil.getAttributeQuote(file2));
    }

    private static boolean needAtLeastOneAttribute(XmlTag tag2) {
        for (XmlTagRuleProvider ruleProvider : XmlTagRuleProvider.EP_NAME.getExtensionList()) {
            for (XmlTagRuleProvider.Rule rule : ruleProvider.getTagRule(tag2)) {
                if (!rule.needAtLeastOneAttribute(tag2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean addRequiredSubTags(Template template, XmlElementDescriptor descriptor2, PsiFile file2, XmlTag context2) {
        if (!WebEditorOptions.getInstance().isAutomaticallyInsertRequiredSubTags()) {
            return false;
        }
        List<XmlElementDescriptor> requiredSubTags = GenerateXmlTagAction.getRequiredSubTags(descriptor2);
        if (!requiredSubTags.isEmpty()) {
            template.addTextSegment(">");
            template.setToReformat(true);
        }
        for (XmlElementDescriptor subTag : requiredSubTags) {
            String prefixByNamespace;
            if (subTag == null) {
                template.addTextSegment("<");
                template.addVariable(new MacroCallNode(new CompleteSmartMacro()), true);
                continue;
            }
            Object qname = subTag.getName();
            if (subTag instanceof XmlElementDescriptorImpl && StringUtil.isNotEmpty((String)(prefixByNamespace = context2.getPrefixByNamespace(((XmlElementDescriptorImpl)subTag).getNamespace())))) {
                qname = prefixByNamespace + ":" + subTag.getName();
            }
            template.addTextSegment("<" + (String)qname);
            XmlTagInsertHandler.addRequiredAttributes(subTag, null, template, file2);
            XmlTagInsertHandler.completeTagTail(template, subTag, file2, context2, false);
        }
        if (!requiredSubTags.isEmpty()) {
            XmlTagInsertHandler.addTagEnd(template, descriptor2, context2);
        }
        return !requiredSubTags.isEmpty();
    }

    private static void completeTagTail(Template template, XmlElementDescriptor descriptor2, PsiFile file2, XmlTag context2, boolean firstLevel) {
        boolean completeIt = !(firstLevel && XmlTagInsertHandler.canHaveAttributes(descriptor2, context2) || file2 != null && !XmlExtension.getExtension(file2).shouldCompleteTag(context2));
        switch (descriptor2.getContentType()) {
            case -1: {
                return;
            }
            case 0: {
                if (!completeIt) break;
                template.addTextSegment(XmlTagInsertHandler.closeTag(context2));
                break;
            }
            case 3: {
                if (!completeIt) break;
                template.addTextSegment(">");
                if (firstLevel) {
                    template.addEndVariable();
                } else {
                    template.addVariable(new MacroCallNode(new CompleteMacro()), true);
                }
                XmlTagInsertHandler.addTagEnd(template, descriptor2, context2);
                break;
            }
            default: {
                if (XmlTagInsertHandler.addRequiredSubTags(template, descriptor2, file2, context2) || !completeIt) break;
                template.addTextSegment(">");
                template.addEndVariable();
                XmlTagInsertHandler.addTagEnd(template, descriptor2, context2);
            }
        }
    }

    private static boolean hasOwnAttributes(XmlElementDescriptor descriptor2, XmlTag tag2) {
        return ContainerUtil.find((Object[])descriptor2.getAttributesDescriptors(tag2), attr -> attr instanceof HtmlAttributeDescriptorImpl && HtmlUtil.isOwnHtmlAttribute(attr)) != null;
    }

    private static boolean canHaveAttributes(XmlElementDescriptor descriptor2, XmlTag context2) {
        Object[] attributes2 = descriptor2.getAttributesDescriptors(context2);
        int required = WebEditorOptions.getInstance().isAutomaticallyInsertRequiredAttributes() ? ArraysKt.count((Object[])attributes2, attribute -> attribute.isRequired() && context2.getAttribute(attribute.getName()) == null) : 0;
        return attributes2.length - required > 0;
    }

    private static void addTagEnd(Template template, XmlElementDescriptor descriptor2, XmlTag context2) {
        template.addTextSegment("</" + descriptor2.getName((PsiElement)context2) + ">");
    }

    private static boolean isTagFromHtml(XmlTag tag2) {
        String ns = tag2.getNamespace();
        return "http://www.w3.org/1999/xhtml".equals(ns) || "http://www.w3.org/1999/html".equals(ns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/XmlTagInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

