/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTracker
implements Disposable {
    private static final Logger LOG = Logger.getInstance(EditorTracker.class);
    private final Project myProject;
    private final Map<Window, List<Editor>> myWindowToEditorsMap;
    private final Map<Window, WindowAdapter> myWindowToWindowFocusListenerMap;
    private final Map<Editor, Window> myEditorToWindowMap;
    private List<? extends Editor> myActiveEditors;
    private Window myActiveWindow;
    private final Map<Editor, Runnable> myExecuteOnEditorRelease;

    public EditorTracker(@NotNull Project project) {
        if (project == null) {
            EditorTracker.$$$reportNull$$$0(0);
        }
        this.myWindowToEditorsMap = new HashMap<Window, List<Editor>>();
        this.myWindowToWindowFocusListenerMap = new HashMap<Window, WindowAdapter>();
        this.myEditorToWindowMap = new HashMap<Editor, Window>();
        this.myActiveEditors = Collections.emptyList();
        this.myExecuteOnEditorRelease = new HashMap<Editor, Runnable>();
        this.myProject = project;
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                JFrame frame;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((frame = WindowManager.getInstance().getFrame(EditorTracker.this.myProject)) == null || frame.getFocusOwner() == null) {
                    return;
                }
                EditorTracker.this.setActiveWindow(frame);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/EditorTracker$1", "selectionChanged"));
            }
        });
    }

    public static EditorTracker getInstance(@NotNull Project project) {
        if (project == null) {
            EditorTracker.$$$reportNull$$$0(1);
        }
        return (EditorTracker)project.getService(EditorTracker.class);
    }

    private void registerEditor(@NotNull Editor editor) {
        if (editor == null) {
            EditorTracker.$$$reportNull$$$0(2);
        }
        this.unregisterEditor(editor);
        final Window window = this.windowByEditor(editor);
        if (window == null) {
            return;
        }
        this.myEditorToWindowMap.put(editor, window);
        List<Editor> list2 = this.myWindowToEditorsMap.get(window);
        if (list2 == null) {
            list2 = new ArrayList<Editor>();
            this.myWindowToEditorsMap.put(window, list2);
            if (!(window instanceof IdeFrameImpl)) {
                WindowAdapter listener2 = new WindowAdapter(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowGainedFocus:" + window);
                        }
                        EditorTracker.this.setActiveWindow(window);
                    }

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowLostFocus:" + window);
                        }
                        EditorTracker.this.setActiveWindow(null);
                    }

                    @Override
                    public void windowClosed(WindowEvent event) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowClosed:" + window);
                        }
                        EditorTracker.this.setActiveWindow(null);
                    }
                };
                this.myWindowToWindowFocusListenerMap.put(window, listener2);
                window.addWindowFocusListener(listener2);
                window.addWindowListener(listener2);
                if (window.isFocused()) {
                    this.setActiveWindow(window);
                }
            }
        }
        list2.add(editor);
        if (this.myActiveWindow == window) {
            this.setActiveWindow(window);
        }
    }

    private void unregisterEditor(@NotNull Editor editor) {
        Window oldWindow;
        if (editor == null) {
            EditorTracker.$$$reportNull$$$0(3);
        }
        if ((oldWindow = this.myEditorToWindowMap.get(editor)) != null) {
            this.myEditorToWindowMap.remove(editor);
            List<Editor> editorsList = this.myWindowToEditorsMap.get(oldWindow);
            boolean removed = editorsList.remove(editor);
            LOG.assertTrue(removed);
            if (oldWindow == this.myActiveWindow) {
                this.updateActiveEditors(this.myActiveWindow);
            }
            if (editorsList.isEmpty()) {
                this.myWindowToEditorsMap.remove(oldWindow);
                WindowAdapter listener2 = this.myWindowToWindowFocusListenerMap.remove(oldWindow);
                if (listener2 != null) {
                    oldWindow.removeWindowFocusListener(listener2);
                    oldWindow.removeWindowListener(listener2);
                }
            }
        }
    }

    @Nullable
    private Window windowByEditor(@NotNull Editor editor) {
        Window window;
        ProjectFrameHelper frameHelper;
        if (editor == null) {
            EditorTracker.$$$reportNull$$$0(4);
        }
        return (frameHelper = ProjectFrameHelper.getFrameHelper(window = SwingUtilities.windowForComponent(editor.getComponent()))) != null && frameHelper.getProject() != this.myProject ? null : window;
    }

    @NotNull
    public List<? extends Editor> getActiveEditors() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<? extends Editor> list2 = this.myActiveEditors;
        if (list2 == null) {
            EditorTracker.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private void setActiveWindow(@Nullable Window window) {
        this.myActiveWindow = window;
        this.updateActiveEditors(window);
    }

    private void updateActiveEditors(@Nullable Window window) {
        List<Editor> list2;
        List<Editor> list3 = list2 = window == null ? null : this.myWindowToEditorsMap.get(window);
        if (list2 == null) {
            this.setActiveEditors(Collections.emptyList());
        } else {
            SmartList editors2 = new SmartList();
            for (Editor editor : list2) {
                if (!editor.getContentComponent().isShowing() || editor.isDisposed()) continue;
                editors2.add(editor);
            }
            this.setActiveEditors((List<? extends Editor>)editors2);
        }
    }

    public void setActiveEditors(@NotNull List<? extends Editor> editors2) {
        if (editors2 == null) {
            EditorTracker.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (editors2.equals(this.myActiveEditors)) {
            return;
        }
        this.myActiveEditors = editors2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("active editors changed:");
            for (Editor editor : editors2) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                LOG.debug("    " + psiFile);
            }
        }
        ((EditorTrackerListener)this.myProject.getMessageBus().syncPublisher(EditorTrackerListener.TOPIC)).activeEditorsChanged(editors2);
    }

    private void editorCreated(@NotNull EditorFactoryEvent event) {
        Editor editor;
        if (event == null) {
            EditorTracker.$$$reportNull$$$0(7);
        }
        if ((editor = event.getEditor()).getProject() != null && editor.getProject() != this.myProject || this.myProject.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        this.createEditorImpl(editor);
    }

    protected void createEditorImpl(final @NotNull Editor editor) {
        if (editor == null) {
            EditorTracker.$$$reportNull$$$0(8);
        }
        JComponent component2 = editor.getComponent();
        JComponent contentComponent = editor.getContentComponent();
        PropertyChangeListener propertyChangeListener2 = evt -> {
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                this.registerEditor(editor);
            }
        };
        component2.addPropertyChangeListener("ancestor", propertyChangeListener2);
        FocusListener focusListener2 = new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                Window window = EditorTracker.this.myEditorToWindowMap.get(editor);
                if (window == null) {
                    return;
                }
                List<Editor> list2 = EditorTracker.this.myWindowToEditorsMap.get(window);
                int index2 = list2.indexOf(editor);
                LOG.assertTrue(index2 >= 0);
                if (list2.isEmpty()) {
                    return;
                }
                for (int i2 = index2 - 1; i2 >= 0; --i2) {
                    list2.set(i2 + 1, list2.get(i2));
                }
                list2.set(0, editor);
                EditorTracker.this.setActiveWindow(window);
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/EditorTracker$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        contentComponent.addFocusListener(focusListener2);
        this.myExecuteOnEditorRelease.put(editor, () -> {
            component2.removePropertyChangeListener("ancestor", propertyChangeListener2);
            contentComponent.removeFocusListener(focusListener2);
        });
    }

    private void editorReleased(@NotNull EditorFactoryEvent event) {
        Editor editor;
        if (event == null) {
            EditorTracker.$$$reportNull$$$0(9);
        }
        if ((editor = event.getEditor()).getProject() != null && editor.getProject() != this.myProject) {
            return;
        }
        this.editorReleasedImpl(editor);
    }

    protected void editorReleasedImpl(@NotNull Editor editor) {
        if (editor == null) {
            EditorTracker.$$$reportNull$$$0(10);
        }
        this.unregisterEditor(editor);
        this.executeOnRelease(editor);
    }

    public void dispose() {
        this.executeOnRelease(null);
    }

    private void executeOnRelease(@Nullable Editor editor) {
        if (editor == null) {
            for (Runnable r : this.myExecuteOnEditorRelease.values()) {
                r.run();
            }
            this.myExecuteOnEditorRelease.clear();
        } else {
            Runnable runnable2 = this.myExecuteOnEditorRelease.get(editor);
            if (runnable2 != null) {
                runnable2.run();
                this.myExecuteOnEditorRelease.remove(editor);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/EditorTracker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/EditorTracker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "windowByEditor";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setActiveEditors";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "editorCreated";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "editorReleased";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "editorReleasedImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyAppLevelEditorFactoryListener
    implements EditorFactoryListener {
        MyAppLevelEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Project project;
            if (event == null) {
                MyAppLevelEditorFactoryListener.$$$reportNull$$$0(0);
            }
            if ((project = event.getEditor().getProject()) != null && !project.isDisposed()) {
                EditorTracker.getInstance(project).editorCreated(event);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Project project;
            if (event == null) {
                MyAppLevelEditorFactoryListener.$$$reportNull$$$0(1);
            }
            if ((project = event.getEditor().getProject()) != null && !project.isDisposed()) {
                EditorTracker.getInstance(project).editorReleased(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/EditorTracker$MyAppLevelEditorFactoryListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

