/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderSelectionManager;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

class DocRenderMouseEventBridge
implements EditorMouseListener,
EditorMouseMotionListener {
    private final DocRenderSelectionManager mySelectionManager;
    private DocRenderer.EditorPane myMouseOverPane;
    private DocRenderer.EditorPane myDragPane;

    DocRenderMouseEventBridge(DocRenderSelectionManager selectionManager) {
        this.mySelectionManager = selectionManager;
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(0);
        }
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        DocRenderer.EditorPane currentPane = DocRenderMouseEventBridge.redispatchEvent(event, 503, null);
        if (currentPane == null) {
            this.restoreCursor();
        } else {
            ((EditorEx)event.getEditor()).setCustomCursor(DocRenderMouseEventBridge.class, currentPane.getCursor());
            if (currentPane != this.myMouseOverPane) {
                if (this.myMouseOverPane != null) {
                    DocRenderMouseEventBridge.dispatchMouseExitEvent(this.myMouseOverPane);
                }
                this.myMouseOverPane = currentPane;
            }
        }
    }

    public void mouseDragged(@NotNull EditorMouseEvent e) {
        if (e == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(1);
        }
        if (e.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.checkPaneSelection(DocRenderMouseEventBridge.redispatchEvent(e, 506, this.myDragPane));
        if (this.myDragPane != null && !DocRenderItem.useOldBackend(e.getEditor())) {
            e.consume();
        }
    }

    public void mouseExited(@NotNull EditorMouseEvent event) {
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(2);
        }
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.restoreCursor();
    }

    public void mousePressed(@NotNull EditorMouseEvent event) {
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(3);
        }
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.myDragPane = DocRenderMouseEventBridge.redispatchEvent(event, 501, null);
        this.checkPaneSelection(this.myDragPane);
    }

    public void mouseReleased(@NotNull EditorMouseEvent event) {
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(4);
        }
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.checkPaneSelection(DocRenderMouseEventBridge.redispatchEvent(event, 502, null));
        this.myDragPane = null;
    }

    public void mouseClicked(@NotNull EditorMouseEvent event) {
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(5);
        }
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.checkPaneSelection(DocRenderMouseEventBridge.redispatchEvent(event, 500, null));
    }

    private void restoreCursor() {
        if (this.myMouseOverPane != null) {
            DocRenderMouseEventBridge.dispatchMouseExitEvent(this.myMouseOverPane);
            ((EditorEx)this.myMouseOverPane.getEditor()).setCustomCursor(DocRenderMouseEventBridge.class, null);
            this.myMouseOverPane = null;
        }
    }

    private void checkPaneSelection(@Nullable DocRenderer.EditorPane pane2) {
        if (pane2 != null && pane2.hasSelection()) {
            this.mySelectionManager.setPaneWithSelection(pane2);
        }
    }

    @Nullable
    private static DocRenderer.EditorPane redispatchEvent(@NotNull EditorMouseEvent event, int eventId, @Nullable DocRenderer.EditorPane targetPane) {
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(6);
        }
        MouseEvent mouseEvent = event.getMouseEvent();
        Point mousePoint = mouseEvent.getPoint();
        Editor editor = event.getEditor();
        if (DocRenderItem.useOldBackend(editor)) {
            EditorCustomElementRenderer renderer2;
            Inlay inlay = event.getInlay();
            if (inlay != null && (renderer2 = inlay.getRenderer()) instanceof DocRenderer) {
                DocRenderer dr = (DocRenderer)renderer2;
                Rectangle relativeBounds = dr.getEditorPaneBoundsWithinRenderer(inlay.getWidthInPixels(), inlay.getHeightInPixels());
                Rectangle inlayBounds = inlay.getBounds();
                assert (inlayBounds != null);
                int x = mousePoint.x - inlayBounds.x - relativeBounds.x;
                int y = mousePoint.y - inlayBounds.y - relativeBounds.y;
                if (x >= 0 && x < relativeBounds.width && y >= 0 && y < relativeBounds.height) {
                    DocRenderer.EditorPane editorPane = dr.getRendererComponent(editor, relativeBounds.width);
                    if (eventId != 506 || targetPane == editorPane) {
                        int button4 = mouseEvent.getButton();
                        DocRenderMouseEventBridge.dispatchEvent(editorPane, new MouseEvent(editorPane, eventId, 0L, mouseEvent.getModifiersEx(), x, y, mouseEvent.getClickCount(), false, button4 == 2 ? 1 : button4));
                        return editorPane;
                    }
                }
            }
        } else {
            CustomFoldRegion cfr;
            CustomFoldRegionRenderer r;
            FoldRegion foldRegion = event.getCollapsedFoldRegion();
            if (foldRegion instanceof CustomFoldRegion && (r = (cfr = (CustomFoldRegion)foldRegion).getRenderer()) instanceof DocRenderer) {
                DocRenderer renderer3 = (DocRenderer)r;
                Rectangle relativeBounds = renderer3.getEditorPaneBoundsWithinRenderer(cfr.getWidthInPixels(), cfr.getHeightInPixels());
                Point location = cfr.getLocation();
                assert (location != null);
                int x = mousePoint.x - location.x - relativeBounds.x;
                int y = mousePoint.y - location.y - relativeBounds.y;
                if (x >= 0 && x < relativeBounds.width && y >= 0 && y < relativeBounds.height) {
                    DocRenderer.EditorPane editorPane = renderer3.getRendererComponent(editor, relativeBounds.width);
                    if (eventId != 506 || targetPane == editorPane) {
                        int button5 = mouseEvent.getButton();
                        DocRenderMouseEventBridge.dispatchEvent(editorPane, new MouseEvent(editorPane, eventId, 0L, mouseEvent.getModifiersEx(), x, y, mouseEvent.getClickCount(), false, button5 == 2 ? 1 : button5));
                        return editorPane;
                    }
                }
            }
        }
        return null;
    }

    private static void dispatchEvent(@NotNull DocRenderer.EditorPane editorPane, @NotNull MouseEvent event) {
        if (editorPane == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(7);
        }
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(8);
        }
        editorPane.doWithRepaintTracking(() -> AWTAccessor.getComponentAccessor().processEvent(editorPane, event));
    }

    private static void dispatchMouseExitEvent(@NotNull DocRenderer.EditorPane editorPane) {
        if (editorPane == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(9);
        }
        DocRenderMouseEventBridge.dispatchEvent(editorPane, new MouseEvent(editorPane, 505, 0L, 0, 0, 0, 0, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderMouseEventBridge";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDragged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseExited";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "mousePressed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseReleased";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseClicked";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "redispatchEvent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "dispatchEvent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "dispatchMouseExitEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

