/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.MoverWrapper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMoveHandler
extends EditorWriteActionHandler.ForEachCaret {
    protected final boolean isDown;

    public BaseMoveHandler(boolean down) {
        this.isDown = down;
    }

    public void executeWriteAction(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            BaseMoveHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            BaseMoveHandler.$$$reportNull$$$0(1);
        }
        Project project = editor.getProject();
        assert (project != null);
        Document document = editor.getDocument();
        PsiFile file2 = this.getPsiFile(project, editor);
        MoverWrapper mover = this.getSuitableMover(editor, file2);
        if (mover != null && mover.getInfo().toMove2 != null) {
            LineRange range2 = mover.getInfo().toMove;
            if (!(range2.startLine <= 0 && !this.isDown || range2.endLine >= document.getLineCount() && this.isDown)) {
                mover.move(editor, file2);
            }
        }
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            BaseMoveHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            BaseMoveHandler.$$$reportNull$$$0(3);
        }
        if (editor.isViewer() || editor.isOneLineMode()) {
            return false;
        }
        Project project = editor.getProject();
        return project != null && !project.isDisposed();
    }

    @Nullable
    protected abstract PsiFile getPsiFile(@NotNull Project var1, @NotNull Editor var2);

    @Nullable
    protected abstract MoverWrapper getSuitableMover(@NotNull Editor var1, @Nullable PsiFile var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/moveUpDown/BaseMoveHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWriteAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

