/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J0\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007H\u0007J\u001a\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/lookup/LookupUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCaseCorrectedLookupString", "", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "prefix", "getInjectedDocument", "Lcom/intellij/injected/editor/DocumentWindow;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "insertLookupInDocument", "caretOffset", "document", "Lcom/intellij/openapi/editor/Document;", "lookupString", "insertLookupInDocumentWindowIfNeeded", "performGuardedChange", "", "action", "Ljava/lang/Runnable;", "intellij.platform.analysis.impl"})
@ApiStatus.Internal
public final class LookupUtil {
    private static final Logger LOG;
    @NotNull
    public static final LookupUtil INSTANCE;

    @JvmStatic
    public static final int insertLookupInDocumentWindowIfNeeded(@NotNull Project project, @NotNull Editor editor, int caretOffset, int prefix2, @NotNull String lookupString) {
        int n;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
        DocumentWindow document = INSTANCE.getInjectedDocument(project, editor, caretOffset);
        if (document == null) {
            Document document2 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
            return INSTANCE.insertLookupInDocument(caretOffset, document2, prefix2, lookupString);
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)document);
        int offset = document.hostToInjected(caretOffset);
        int n2 = offset - prefix2;
        int n3 = 0;
        boolean bl = false;
        n2 = Math.max(n2, n3);
        n3 = 0;
        int lookupStart = Math.min(offset, n2);
        int diff = -1;
        if (file2 != null) {
            List list2 = InjectedLanguageManager.getInstance((Project)project).intersectWithAllEditableFragments(file2, TextRange.create((int)lookupStart, (int)offset));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"InjectedLanguageManager.\u2026ate(lookupStart, offset))");
            List ranges = list2;
            Collection collection = ranges;
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                Object e = ranges.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"ranges[0]");
                diff = ((TextRange)e).getStartOffset() - lookupStart;
                if (ranges.size() == 1 && diff == 0) {
                    diff = -1;
                }
            }
        }
        if (diff == -1) {
            Document document3 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"editor.document");
            n = INSTANCE.insertLookupInDocument(caretOffset, document3, prefix2, lookupString);
        } else {
            String string;
            Document document4 = (Document)document;
            if (diff == 0) {
                string = lookupString;
            } else {
                String string2 = lookupString;
                bl = false;
                String string3 = string2.substring(diff);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            }
            n = document.injectedToHost(INSTANCE.insertLookupInDocument(offset, document4, prefix2 - diff, string));
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @NotNull
    public static final String getCaseCorrectedLookupString(@NotNull LookupElement item, @NotNull PrefixMatcher prefixMatcher, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        v0 = item.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"item.lookupString");
        lookupString = v0;
        if (item.isCaseSensitive()) {
            return lookupString;
        }
        length = prefix.length();
        if (length == 0 || !prefixMatcher.prefixMatches(prefix)) {
            return lookupString;
        }
        isAllLower = true;
        isAllUpper = true;
        sameCase = true;
        i = 0;
        while (i < length && (isAllLower || isAllUpper || sameCase)) {
            var11_11 = c = prefix.charAt(i);
            var12_12 = '\u0000';
            isLower = Character.isLowerCase(var11_11);
            var12_12 = c;
            var13_13 = false;
            isUpper = Character.isUpperCase(var12_12);
            if (!isLower && !isUpper) {
                ++i;
                continue;
            }
            isAllLower = isAllLower != false && isLower != false;
            v1 = isAllUpper = isAllUpper != false && isUpper != false;
            if (!sameCase || i >= lookupString.length()) ** GOTO lbl-1000
            var12_12 = lookupString.charAt(i);
            var13_13 = false;
            if (isLower == Character.isLowerCase(var12_12)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            sameCase = v2;
            ++i;
        }
        if (sameCase) {
            return lookupString;
        }
        if (isAllLower) {
            v3 = StringUtil.toLowerCase((String)lookupString);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"StringUtil.toLowerCase(lookupString)");
            return v3;
        }
        if (isAllUpper) {
            v4 = StringUtil.toUpperCase((String)lookupString);
            v5 = v4;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"StringUtil.toUpperCase(lookupString)");
        } else {
            v5 = lookupString;
        }
        return v5;
    }

    private final DocumentWindow getInjectedDocument(Project project, Editor editor, int offset) {
        PsiFile hostFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (hostFile != null) {
            List list2 = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(hostFile, TextRange.create((int)offset, (int)offset));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"InjectedLanguageManager.\u2026e.create(offset, offset))");
            List injected = list2;
            Iterator iterator2 = injected.iterator();
            while (iterator2.hasNext()) {
                DocumentWindow documentWindow;
                DocumentWindow documentWindow2 = documentWindow = (DocumentWindow)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)documentWindow2, (String)"documentWindow");
                if (!documentWindow2.isValid() || !documentWindow.containsRange(offset, offset)) continue;
                return documentWindow;
            }
        }
        return null;
    }

    private final int insertLookupInDocument(int caretOffset, Document document, int prefix2, String lookupString) {
        int len;
        int n = caretOffset - prefix2;
        int n2 = 0;
        boolean bl = false;
        n = Math.max(n, n2);
        n2 = 0;
        int lookupStart = Math.min(caretOffset, n);
        n2 = lookupStart;
        LOG.assertTrue(0 <= n2 && (len = document.getTextLength()) >= n2, (Object)("ls: " + lookupStart + " caret: " + caretOffset + " prefix:" + prefix2 + " doc: " + len));
        n2 = caretOffset;
        LOG.assertTrue(0 <= n2 && len >= n2, (Object)("co: " + caretOffset + " doc: " + len));
        document.replaceString(lookupStart, caretOffset, (CharSequence)lookupString);
        return lookupStart + lookupString.length();
    }

    @JvmStatic
    public static final void performGuardedChange(@Nullable Editor editor, @NotNull Runnable action2) {
        LookupEx lookup2;
        LookupEx lookupEx;
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Editor editor2 = editor;
        if (editor2 != null) {
            Editor editor3 = editor2;
            boolean bl = false;
            boolean bl2 = false;
            Editor p1 = editor3;
            boolean bl3 = false;
            lookupEx = LookupManager.getActiveLookup(p1);
        } else {
            lookupEx = lookup2 = null;
        }
        if (lookup2 == null) {
            action2.run();
        } else {
            lookup2.performGuardedChange(action2);
        }
    }

    private LookupUtil() {
    }

    static {
        LookupUtil lookupUtil;
        INSTANCE = lookupUtil = new LookupUtil();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LookupUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

