/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.impl;

import com.intellij.codeInsight.navigation.BaseCtrlMouseInfo;
import com.intellij.codeInsight.navigation.CtrlMouseInfo;
import com.intellij.codeInsight.navigation.MultipleTargetElementsInfo;
import com.intellij.codeInsight.navigation.impl.DeclarationCtrlMouseInfo;
import com.intellij.codeInsight.navigation.impl.SingleSymbolCtrlMouseInfo;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.impl.SymbolWithProvider;
import com.intellij.model.psi.impl.TargetData;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u0002H\u0000\u001a\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"ctrlMouseInfo", "Lcom/intellij/codeInsight/navigation/CtrlMouseInfo;", "Lcom/intellij/model/psi/impl/TargetData;", "elementAtOffset", "Lcom/intellij/psi/PsiElement;", "highlightRanges", "", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/model/psi/impl/TargetData$Referenced;", "intellij.platform.lang.impl"})
public final class CtrlMouseKt {
    @Nullable
    public static final CtrlMouseInfo ctrlMouseInfo(@NotNull TargetData $this$ctrlMouseInfo) {
        CtrlMouseInfo ctrlMouseInfo2;
        Intrinsics.checkNotNullParameter((Object)$this$ctrlMouseInfo, (String)"$this$ctrlMouseInfo");
        TargetData targetData = $this$ctrlMouseInfo;
        if (targetData instanceof TargetData.Declared) {
            ctrlMouseInfo2 = new DeclarationCtrlMouseInfo(((TargetData.Declared)$this$ctrlMouseInfo).getDeclaration());
        } else if (targetData instanceof TargetData.Referenced) {
            List<SymbolWithProvider> targets2 = $this$ctrlMouseInfo.getTargets();
            if (targets2.isEmpty()) {
                return null;
            }
            List<TextRange> ranges = CtrlMouseKt.highlightRanges((TargetData.Referenced)$this$ctrlMouseInfo);
            SymbolWithProvider singleTarget = (SymbolWithProvider)CollectionsKt.singleOrNull(targets2);
            ctrlMouseInfo2 = singleTarget != null ? (BaseCtrlMouseInfo)new SingleSymbolCtrlMouseInfo(singleTarget.getSymbol(), CtrlMouseKt.elementAtOffset($this$ctrlMouseInfo), ranges) : (BaseCtrlMouseInfo)new MultipleTargetElementsInfo(ranges);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ctrlMouseInfo2;
    }

    @NotNull
    public static final PsiElement elementAtOffset(@NotNull TargetData $this$elementAtOffset) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$elementAtOffset, (String)"$this$elementAtOffset");
        TargetData targetData = $this$elementAtOffset;
        if (targetData instanceof TargetData.Declared) {
            PsiElement psiElement2 = ((TargetData.Declared)$this$elementAtOffset).getDeclaration().getDeclaringElement();
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"declaration.declaringElement");
        } else if (targetData instanceof TargetData.Referenced) {
            PsiElement psiElement3 = ((PsiSymbolReference)CollectionsKt.last(((TargetData.Referenced)$this$elementAtOffset).getReferences())).getElement();
            psiElement = psiElement3;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"references.last().element");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return psiElement;
    }

    @NotNull
    public static final List<TextRange> highlightRanges(@NotNull TargetData $this$highlightRanges) {
        List<TextRange> list2;
        Intrinsics.checkNotNullParameter((Object)$this$highlightRanges, (String)"$this$highlightRanges");
        TargetData targetData = $this$highlightRanges;
        if (targetData instanceof TargetData.Declared) {
            list2 = CollectionsKt.listOf((Object)((TargetData.Declared)$this$highlightRanges).getDeclaration().getAbsoluteRange());
        } else if (targetData instanceof TargetData.Referenced) {
            list2 = CtrlMouseKt.highlightRanges((TargetData.Referenced)$this$highlightRanges);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TextRange> highlightRanges(TargetData.Referenced $this$highlightRanges) {
        void $this$mapTo$iv;
        PsiSymbolReference singleReference = (PsiSymbolReference)CollectionsKt.singleOrNull($this$highlightRanges.getReferences());
        if (singleReference != null) {
            return TargetsKt.referenceRanges(singleReference);
        }
        Iterable iterable = $this$highlightRanges.getReferences();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p1;
            PsiSymbolReference psiSymbolReference = (PsiSymbolReference)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            List<TextRange> list2 = TargetsKt.referenceRanges((PsiSymbolReference)p1);
            collection.add(list2);
        }
        HashSet rangeLists = (HashSet)destination$iv;
        List singleRangeList = (List)CollectionsKt.singleOrNull((Iterable)rangeLists);
        if (singleRangeList != null) {
            return singleRangeList;
        }
        TextRange textRange = ((PsiSymbolReference)CollectionsKt.first($this$highlightRanges.getReferences())).getAbsoluteRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"references.first().absoluteRange");
        return CollectionsKt.listOf((Object)textRange);
    }
}

