/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.DynamicBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesModel;
import com.intellij.profile.codeInspection.ui.header.InspectionToolsConfigurable;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CodeInspectionAction
extends BaseAnalysisAction {
    private static final Logger LOG = Logger.getInstance(CodeInspectionAction.class);
    private static final String LAST_SELECTED_PROFILE_PROP = "run.code.analysis.last.selected.profile";
    private int myRunId = 0;
    private GlobalInspectionContextImpl myGlobalInspectionContext;
    protected InspectionProfileImpl myExternalProfile;

    public CodeInspectionAction() {
        super(InspectionsBundle.messagePointer((String)"inspection.action.title", (Object[])new Object[0]), InspectionsBundle.messagePointer((String)"inspection.action.noun", (Object[])new Object[0]));
    }

    public CodeInspectionAction(@NlsContexts.DialogTitle String title2, @Nls String analysisNoon) {
        super(title2, analysisNoon);
    }

    @Override
    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope2) {
        if (project == null) {
            CodeInspectionAction.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            CodeInspectionAction.$$$reportNull$$$0(1);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassist.inspect.batch");
        try {
            this.runInspections(project, scope2);
        }
        finally {
            this.myGlobalInspectionContext = null;
            this.myExternalProfile = null;
        }
    }

    protected void runInspections(@NotNull Project project, @NotNull AnalysisScope scope2) {
        if (project == null) {
            CodeInspectionAction.$$$reportNull$$$0(2);
        }
        if (scope2 == null) {
            CodeInspectionAction.$$$reportNull$$$0(3);
        }
        int runId = ++this.myRunId;
        scope2.setSearchInLibraries(false);
        FileDocumentManager.getInstance().saveAllDocuments();
        InspectionProfileImpl externalProfile = this.myExternalProfile;
        GlobalInspectionContextImpl inspectionContext = this.getGlobalInspectionContext(project);
        inspectionContext.setRerunAction(() -> DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            if (runId != this.myRunId) {
                return;
            }
            if (project.isDisposed()) {
                return;
            }
            if (!scope2.isValid()) {
                return;
            }
            this.myExternalProfile = externalProfile;
            this.myGlobalInspectionContext = inspectionContext;
            FileDocumentManager.getInstance().saveAllDocuments();
            this.analyze(project, scope2);
        }));
        inspectionContext.setExternalProfile(externalProfile);
        inspectionContext.setCurrentScope(scope2);
        inspectionContext.doInspections(scope2);
    }

    private GlobalInspectionContextImpl getGlobalInspectionContext(Project project) {
        if (this.myGlobalInspectionContext == null) {
            this.myGlobalInspectionContext = ((InspectionManagerEx)InspectionManager.getInstance((Project)project)).createNewGlobalContext();
        }
        return this.myGlobalInspectionContext;
    }

    @Override
    @NonNls
    protected String getHelpTopic() {
        return "reference.dialogs.inspection.scope";
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.myGlobalInspectionContext = null;
    }

    @Override
    protected JComponent getAdditionalActionSettings(final @NotNull Project project, final BaseAnalysisActionDialog dialog2) {
        if (project == null) {
            CodeInspectionAction.$$$reportNull$$$0(4);
        }
        dialog2.setShowInspectInjectedCode(true);
        AdditionalPanel panel2 = new AdditionalPanel();
        final InspectionManagerEx manager2 = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        final SchemesCombo profiles = (SchemesCombo)((Object)panel2.myBrowseProfilesCombo.getComboBox());
        final InspectionProfileManager profileManager = InspectionProfileManager.getInstance();
        final ProjectInspectionProfileManager projectProfileManager = ProjectInspectionProfileManager.getInstance(project);
        panel2.myBrowseProfilesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalProfilesComboboxAwareInspectionToolsConfigurable errorConfigurable = CodeInspectionAction.this.createConfigurable(projectProfileManager, profiles);
                MySingleConfigurableEditor editor = new MySingleConfigurableEditor(project, errorConfigurable, manager2);
                if (editor.showAndGet()) {
                    CodeInspectionAction.this.reloadProfiles(profiles, profileManager, projectProfileManager, project);
                    if (errorConfigurable.mySelectedName != null) {
                        InspectionProfileImpl profile = (errorConfigurable.mySelectedIsProjectProfile ? projectProfileManager : profileManager).getProfile(errorConfigurable.mySelectedName);
                        profiles.selectScheme(profile);
                    }
                } else {
                    InspectionProfile profile = (InspectionProfile)profiles.getSelectedScheme();
                    boolean canExecute = profile != null && profile.isExecutable(project);
                    dialog2.setOKActionEnabled(canExecute);
                }
            }
        });
        profiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeInspectionAction.this.myExternalProfile = (InspectionProfileImpl)profiles.getSelectedScheme();
                boolean canExecute = CodeInspectionAction.this.myExternalProfile != null && CodeInspectionAction.this.myExternalProfile.isExecutable(project);
                dialog2.setOKActionEnabled(canExecute);
                if (canExecute) {
                    PropertiesComponent.getInstance((Project)project).setValue(CodeInspectionAction.LAST_SELECTED_PROFILE_PROP, (CodeInspectionAction.this.myExternalProfile.isProjectLevel() ? (char)'p' : 'a') + CodeInspectionAction.this.myExternalProfile.getName());
                    manager2.setProfile(CodeInspectionAction.this.myExternalProfile.getName());
                }
            }
        });
        this.reloadProfiles(profiles, profileManager, projectProfileManager, project);
        return panel2.myAdditionalPanel;
    }

    protected ExternalProfilesComboboxAwareInspectionToolsConfigurable createConfigurable(ProjectInspectionProfileManager projectProfileManager, SchemesCombo<InspectionProfileImpl> profilesCombo) {
        return new ExternalProfilesComboboxAwareInspectionToolsConfigurable(projectProfileManager, profilesCombo);
    }

    private void reloadProfiles(SchemesCombo<InspectionProfileImpl> profilesCombo, InspectionProfileManager appProfileManager, InspectionProjectProfileManager projectProfileManager, Project project) {
        profilesCombo.resetSchemes(InspectionProfileSchemesModel.getSortedProfiles(appProfileManager, projectProfileManager));
        InspectionProfileImpl selectedProfile = this.getProfileToUse(project, appProfileManager, projectProfileManager);
        profilesCombo.selectScheme(selectedProfile);
    }

    @NotNull
    private InspectionProfileImpl getProfileToUse(@NotNull Project project, @NotNull InspectionProfileManager appProfileManager, @NotNull InspectionProjectProfileManager projectProfileManager) {
        String lastSelectedProfile;
        if (project == null) {
            CodeInspectionAction.$$$reportNull$$$0(5);
        }
        if (appProfileManager == null) {
            CodeInspectionAction.$$$reportNull$$$0(6);
        }
        if (projectProfileManager == null) {
            CodeInspectionAction.$$$reportNull$$$0(7);
        }
        if ((lastSelectedProfile = PropertiesComponent.getInstance((Project)project).getValue(LAST_SELECTED_PROFILE_PROP)) != null) {
            char type = lastSelectedProfile.charAt(0);
            String lastSelectedProfileName = lastSelectedProfile.substring(1);
            if (type == 'a') {
                InspectionProfileImpl profile = appProfileManager.getProfile(lastSelectedProfileName, false);
                if (profile != null) {
                    InspectionProfileImpl inspectionProfileImpl = profile;
                    if (inspectionProfileImpl == null) {
                        CodeInspectionAction.$$$reportNull$$$0(8);
                    }
                    return inspectionProfileImpl;
                }
            } else {
                LOG.assertTrue(type == 'p', (Object)("Unexpected last selected profile: '" + lastSelectedProfile + "'"));
                InspectionProfileImpl profile = projectProfileManager.getProfile(lastSelectedProfileName, false);
                if (profile != null && profile.isProjectLevel()) {
                    InspectionProfileImpl inspectionProfileImpl = profile;
                    if (inspectionProfileImpl == null) {
                        CodeInspectionAction.$$$reportNull$$$0(9);
                    }
                    return inspectionProfileImpl;
                }
            }
        }
        InspectionProfileImpl inspectionProfileImpl = this.getGlobalInspectionContext(project).getCurrentProfile();
        if (inspectionProfileImpl == null) {
            CodeInspectionAction.$$$reportNull$$$0(10);
        }
        return inspectionProfileImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appProfileManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/CodeInspectionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/CodeInspectionAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfileToUse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runInspections";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalActionSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProfileToUse";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySingleConfigurableEditor
    extends SingleConfigurableEditor {
        private final InspectionManagerEx myManager;

        MySingleConfigurableEditor(Project project, ErrorsConfigurable configurable2, InspectionManagerEx manager2) {
            super(project, (Configurable)configurable2, MySingleConfigurableEditor.createDimensionKey(configurable2));
            this.myManager = manager2;
        }

        @Override
        protected void doOKAction() {
            Object o = ((ErrorsConfigurable)this.getConfigurable()).getSelectedObject();
            if (o instanceof InspectionProfile) {
                this.myManager.setProfile(((InspectionProfile)o).getName());
            }
            super.doOKAction();
        }
    }

    private static class AdditionalPanel {
        public ComboboxWithBrowseButton myBrowseProfilesCombo;
        public JPanel myAdditionalPanel;

        private AdditionalPanel() {
            this.$$$setupUI$$$();
        }

        private void createUIComponents() {
            this.myBrowseProfilesCombo = new ComboboxWithBrowseButton((JComboBox)((Object)new SchemesCombo<InspectionProfileImpl>(){

                @Override
                protected boolean supportsProjectSchemes() {
                    return true;
                }

                @Override
                protected boolean isProjectScheme(@NotNull InspectionProfileImpl profile) {
                    if (profile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return profile.isProjectLevel();
                }

                @Override
                @NotNull
                protected SimpleTextAttributes getSchemeAttributes(InspectionProfileImpl profile) {
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    if (simpleTextAttributes == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return simpleTextAttributes;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "profile";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInspection/actions/CodeInspectionAction$AdditionalPanel$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInspection/actions/CodeInspectionAction$AdditionalPanel$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getSchemeAttributes";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "isProjectScheme";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel2;
            this.createUIComponents();
            this.myAdditionalPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
            jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/InspectionsBundle", AdditionalPanel.class).getString("inspection.action.profile.label"), (int)0, (int)0, null, null));
            ComboboxWithBrowseButton comboboxWithBrowseButton = this.myBrowseProfilesCombo;
            jPanel3.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
            ButtonGroup buttonGroup2 = new ButtonGroup();
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myAdditionalPanel;
        }
    }

    protected static class ExternalProfilesComboboxAwareInspectionToolsConfigurable
    extends InspectionToolsConfigurable {
        private final SchemesCombo<InspectionProfileImpl> myProfilesCombo;
        private String mySelectedName;
        private boolean mySelectedIsProjectProfile;

        public ExternalProfilesComboboxAwareInspectionToolsConfigurable(@NotNull ProjectInspectionProfileManager projectProfileManager, SchemesCombo<InspectionProfileImpl> profilesCombo) {
            if (projectProfileManager == null) {
                ExternalProfilesComboboxAwareInspectionToolsConfigurable.$$$reportNull$$$0(0);
            }
            super(projectProfileManager);
            this.myProfilesCombo = profilesCombo;
        }

        @Override
        protected InspectionProfileImpl getCurrentProfile() {
            return this.myProfilesCombo.getSelectedScheme();
        }

        @Override
        protected void applyRootProfile(@NotNull String name, boolean isProjectLevel) {
            if (name == null) {
                ExternalProfilesComboboxAwareInspectionToolsConfigurable.$$$reportNull$$$0(1);
            }
            this.mySelectedName = name;
            this.mySelectedIsProjectProfile = isProjectLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectProfileManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/actions/CodeInspectionAction$ExternalProfilesComboboxAwareInspectionToolsConfigurable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyRootProfile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

