/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.StdJobDescriptors;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextBase
extends UserDataHolderBase
implements GlobalInspectionContext {
    private static final Logger LOG = Logger.getInstance(GlobalInspectionContextBase.class);
    private static final Hash.Strategy<Tools> TOOLS_HASHING_STRATEGY = new Hash.Strategy<Tools>(){

        public int hashCode(@Nullable Tools object) {
            return object == null ? 0 : object.getShortName().hashCode();
        }

        public boolean equals(@Nullable Tools o1, @Nullable Tools o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.getShortName().equals(o2.getShortName());
        }
    };
    private RefManager myRefManager;
    private AnalysisScope myCurrentScope;
    @NotNull
    private final Project myProject;
    private final List<JobDescriptor> myJobDescriptors;
    private final StdJobDescriptors myStdJobDescriptors;
    protected ProgressIndicator myProgressIndicator;
    private InspectionProfileImpl myExternalProfile;
    private Runnable myRerunAction;
    protected final Map<Key<?>, GlobalInspectionContextExtension<?>> myExtensions;
    final Map<String, Tools> myTools;
    @NonNls
    public static final String PROBLEMS_TAG_NAME = "problems";
    @NonNls
    public static final String LOCAL_TOOL_ATTRIBUTE = "is_local_tool";

    public GlobalInspectionContextBase(@NotNull Project project) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(0);
        }
        this.myJobDescriptors = new ArrayList<JobDescriptor>();
        this.myStdJobDescriptors = new StdJobDescriptors();
        this.myProgressIndicator = new EmptyProgressIndicator();
        this.myRerunAction = () -> {};
        this.myExtensions = new HashMap();
        this.myTools = new HashMap<String, Tools>();
        this.myProject = project;
        for (InspectionExtensionsFactory factory2 : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            GlobalInspectionContextExtension extension2 = factory2.createGlobalInspectionContextExtension();
            this.myExtensions.put(extension2.getID(), extension2);
        }
    }

    public AnalysisScope getCurrentScope() {
        return this.myCurrentScope;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(1);
        }
        return project;
    }

    public <T> T getExtension(@NotNull Key<T> key) {
        if (key == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(2);
        }
        return (T)this.myExtensions.get(key);
    }

    @NotNull
    public InspectionProfileImpl getCurrentProfile() {
        if (this.myExternalProfile != null) {
            InspectionProfileImpl inspectionProfileImpl = this.myExternalProfile;
            if (inspectionProfileImpl == null) {
                GlobalInspectionContextBase.$$$reportNull$$$0(3);
            }
            return inspectionProfileImpl;
        }
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)this.myProject)).getCurrentProfile();
        InspectionProfileImpl profile = ProjectInspectionProfileManager.getInstance(this.myProject).getProfile(currentProfile, false);
        InspectionProfileImpl inspectionProfileImpl = profile == null ? InspectionProfileManager.getInstance().getProfile(currentProfile) : profile;
        if (inspectionProfileImpl == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(4);
        }
        return inspectionProfileImpl;
    }

    public boolean shouldCheck(@NotNull RefEntity entity, @NotNull GlobalInspectionTool tool) {
        if (entity == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(5);
        }
        if (tool == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(6);
        }
        return !(entity instanceof RefElementImpl) || this.isToCheckMember((RefElementImpl)entity, (InspectionProfileEntry)tool);
    }

    public boolean isSuppressed(@NotNull PsiElement element2, @NotNull String id2) {
        RefManagerImpl refManager;
        if (element2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(7);
        }
        if (id2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(8);
        }
        if ((refManager = (RefManagerImpl)this.getRefManager()).isDeclarationsFound()) {
            RefElement refElement = refManager.getReference(element2);
            return refElement instanceof RefElementImpl && ((RefElementImpl)refElement).isSuppressed(id2);
        }
        return SuppressionUtil.isSuppressed(element2, id2);
    }

    void cleanupTools() {
        EntryPointsManager entryPointsManager;
        this.myProgressIndicator.cancel();
        for (GlobalInspectionContextExtension<?> extension2 : this.myExtensions.values()) {
            extension2.cleanup();
        }
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                toolWrapper.cleanup(this.myProject);
            }
        }
        this.myTools.clear();
        EntryPointsManager entryPointsManager2 = entryPointsManager = this.getProject().isDisposed() ? null : EntryPointsManager.getInstance((Project)this.getProject());
        if (entryPointsManager != null) {
            entryPointsManager.cleanup();
        }
        if (this.myRefManager != null) {
            ((RefManagerImpl)this.myRefManager).cleanup();
            this.myRefManager = null;
            if (this.myCurrentScope != null) {
                this.myCurrentScope.invalidate();
                this.myCurrentScope = null;
            }
        }
        this.myJobDescriptors.clear();
    }

    public void setCurrentScope(@NotNull AnalysisScope currentScope) {
        if (currentScope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(9);
        }
        this.myCurrentScope = currentScope;
    }

    public void setRerunAction(@NotNull Runnable action2) {
        if (action2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(10);
        }
        this.myRerunAction = action2;
    }

    public void doInspections(@NotNull AnalysisScope scope2) {
        if (scope2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(11);
        }
        if (!GlobalInspectionContextUtil.canRunInspections(this.myProject, true, this.myRerunAction)) {
            return;
        }
        this.cleanup();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myCurrentScope = scope2;
            this.launchInspections(scope2);
        }, this.myProject.getDisposed());
    }

    @NotNull
    public RefManager getRefManager() {
        RefManager refManager = this.myRefManager;
        if (refManager == null) {
            this.myRefManager = refManager = (RefManager)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> new RefManagerImpl(this.myProject, this.myCurrentScope, this));
        }
        RefManager refManager2 = refManager;
        if (refManager2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(12);
        }
        return refManager2;
    }

    public boolean isToCheckMember(@NotNull RefElement owner, @NotNull InspectionProfileEntry tool) {
        if (owner == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(13);
        }
        if (tool == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(14);
        }
        return this.isToCheckFile(((RefElementImpl)owner).getContainingFile(), tool) && !((RefElementImpl)owner).isSuppressed(tool.getShortName(), tool.getAlternativeID());
    }

    public boolean isToCheckFile(PsiFile file2, @NotNull InspectionProfileEntry tool) {
        Tools tools;
        if (tool == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(15);
        }
        if ((tools = this.myTools.get(tool.getShortName())) != null && file2 != null) {
            for (ScopeToolState state : tools.getTools()) {
                NamedScope namedScope = state.getScope(file2.getProject());
                if (namedScope != null && !namedScope.getValue().contains(file2, this.getCurrentProfile().getProfileManager().getScopesManager())) continue;
                return state.isEnabled() && state.getTool().getTool() == tool;
            }
        }
        return false;
    }

    protected void launchInspections(final @NotNull AnalysisScope scope2) {
        if (scope2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        LOG.info("Code inspection started");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getProject(), AnalysisBundle.message((String)"inspection.progress.title", (Object[])new Object[0]), true, this.createOption()){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                GlobalInspectionContextBase.this.performInspectionsWithProgress(scope2, false, false);
            }

            public void onSuccess() {
                GlobalInspectionContextBase.this.notifyInspectionsFinished(scope2);
            }

            public void onCancel() {
                GlobalInspectionContextBase.this.cleanup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextBase$2", "run"));
            }
        });
    }

    @NotNull
    protected PerformInBackgroundOption createOption() {
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.ALWAYS_BACKGROUND;
        if (performInBackgroundOption == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(17);
        }
        return performInBackgroundOption;
    }

    protected void notifyInspectionsFinished(@NotNull AnalysisScope scope2) {
        if (scope2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(18);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInspectionsWithProgress(@NotNull AnalysisScope scope2, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        if (scope2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(19);
        }
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (!(this.myProgressIndicator instanceof ProgressIndicatorEx)) {
            throw new IllegalStateException("Inspections must be run under ProgressIndicatorEx but got: " + this.myProgressIndicator);
        }
        this.myProgressIndicator.setIndeterminate(false);
        ((ProgressIndicatorEx)this.myProgressIndicator).addStateDelegate(new AbstractProgressIndicatorExBase(){

            @Override
            public void cancel() {
                super.cancel();
                GlobalInspectionContextBase.this.canceled();
            }
        });
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        try {
            psiManager.startBatchFilesProcessingMode();
            refManager.inspectionReadActionStarted();
            this.getStdJobDescriptors().BUILD_GRAPH.setTotalAmount(scope2.getFileCount());
            this.getStdJobDescriptors().LOCAL_ANALYSIS.setTotalAmount(scope2.getFileCount());
            this.getStdJobDescriptors().FIND_EXTERNAL_USAGES.setTotalAmount(0);
            ProgressManager.getInstance().executeProcessUnderProgress(() -> this.runTools(scope2, runGlobalToolsOnly, isOfflineInspections), (ProgressIndicator)new SensitiveProgressWrapper(this.myProgressIndicator));
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        finally {
            refManager.inspectionReadActionFinished();
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    protected void canceled() {
    }

    protected void runTools(@NotNull AnalysisScope scope2, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        if (scope2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(20);
        }
    }

    public void initializeTools(@NotNull List<Tools> outGlobalTools, @NotNull List<Tools> outLocalTools, @NotNull List<? super Tools> outGlobalSimpleTools) {
        if (outGlobalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(21);
        }
        if (outLocalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(22);
        }
        if (outGlobalSimpleTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(23);
        }
        List<Tools> usedTools = this.getUsedTools();
        for (Tools tools : usedTools) {
            JobDescriptor[] jobDescriptors;
            String shortName = tools.getShortName();
            this.myTools.put(shortName, tools);
            InspectionToolWrapper toolWrapper = tools.getTool();
            GlobalInspectionContextBase.classifyTool(outGlobalTools, outLocalTools, outGlobalSimpleTools, tools, toolWrapper);
            for (ScopeToolState state : tools.getTools()) {
                state.getTool().initialize((GlobalInspectionContext)this);
            }
            for (JobDescriptor jobDescriptor : jobDescriptors = toolWrapper.getJobDescriptors((GlobalInspectionContext)this)) {
                this.appendJobDescriptor(jobDescriptor);
            }
        }
        for (GlobalInspectionContextExtension globalInspectionContextExtension : this.myExtensions.values()) {
            globalInspectionContextExtension.performPreRunActivities(outGlobalTools, outLocalTools, (GlobalInspectionContext)this);
        }
    }

    @NotNull
    public List<Tools> getUsedTools() {
        InspectionProfileImpl profile = this.getCurrentProfile();
        List<Tools> tools = profile.getAllEnabledInspectionTools(this.myProject);
        LinkedHashSet dependentTools = new LinkedHashSet();
        for (Tools tool : tools) {
            profile.collectDependentInspections(tool.getTool(), dependentTools, this.getProject());
        }
        if (dependentTools.isEmpty()) {
            List<Tools> list2 = tools;
            if (list2 == null) {
                GlobalInspectionContextBase.$$$reportNull$$$0(24);
            }
            return list2;
        }
        ObjectOpenCustomHashSet set2 = new ObjectOpenCustomHashSet(tools, TOOLS_HASHING_STRATEGY);
        set2.addAll(ContainerUtil.map(dependentTools, toolWrapper -> new ToolsImpl((InspectionToolWrapper)toolWrapper, toolWrapper.getDefaultLevel(), true, true)));
        return new ArrayList<Tools>((Collection<Tools>)set2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void classifyTool(@NotNull List<? super Tools> outGlobalTools, @NotNull List<? super Tools> outLocalTools, @NotNull List<? super Tools> outGlobalSimpleTools, @NotNull Tools currentTools, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (outGlobalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(25);
        }
        if (outLocalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(26);
        }
        if (outGlobalSimpleTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(27);
        }
        if (currentTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(28);
        }
        if (toolWrapper == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(29);
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            outLocalTools.add((Tools)currentTools);
            return;
        } else {
            if (!(toolWrapper instanceof GlobalInspectionToolWrapper)) throw new RuntimeException("unknown tool " + toolWrapper);
            if (toolWrapper.getTool() instanceof GlobalSimpleInspectionTool) {
                outGlobalSimpleTools.add((Tools)currentTools);
                return;
            } else {
                if (!(toolWrapper.getTool() instanceof GlobalInspectionTool)) throw new RuntimeException("unknown global tool " + toolWrapper);
                outGlobalTools.add((Tools)currentTools);
            }
        }
    }

    @NotNull
    public Map<String, Tools> getTools() {
        Map<String, Tools> map2 = this.myTools;
        if (map2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(30);
        }
        return map2;
    }

    private void appendJobDescriptor(@NotNull JobDescriptor job2) {
        if (job2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(31);
        }
        if (!this.myJobDescriptors.contains(job2)) {
            this.myJobDescriptors.add(job2);
            job2.setDoneAmount(0);
        }
    }

    public void codeCleanup(@NotNull AnalysisScope scope2, @NotNull InspectionProfile profile, @Nullable String commandName2, @Nullable Runnable postRunnable, boolean modal, @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
        if (scope2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(32);
        }
        if (profile == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(33);
        }
        if (shouldApplyFix == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(34);
        }
    }

    public void codeCleanup(@NotNull AnalysisScope scope2, @NotNull InspectionProfile profile, @Nullable String commandName2, @Nullable Runnable postRunnable, boolean modal) {
        if (scope2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(35);
        }
        if (profile == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(36);
        }
        this.codeCleanup(scope2, profile, commandName2, postRunnable, modal, __ -> true);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, PsiElement ... scope2) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(37);
        }
        if (scope2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(38);
        }
        GlobalInspectionContextBase.cleanupElements(project, runnable2, (? super ProblemDescriptor descriptor2) -> true, scope2);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, Predicate<? super ProblemDescriptor> shouldApplyFix, PsiElement ... scope2) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(39);
        }
        if (scope2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(40);
        }
        ArrayList<SmartPsiElementPointer> elements = new ArrayList<SmartPsiElementPointer>();
        SmartPointerManager manager2 = SmartPointerManager.getInstance((Project)project);
        for (PsiElement element2 : scope2) {
            elements.add(manager2.createSmartPsiElementPointer(element2));
        }
        GlobalInspectionContextBase.cleanupElements(project, runnable2, elements, shouldApplyFix);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, List<? extends SmartPsiElementPointer<PsiElement>> elements) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(41);
        }
        GlobalInspectionContextBase.cleanupElements(project, runnable2, elements, (? super ProblemDescriptor descriptor2) -> true);
    }

    private static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, List<? extends SmartPsiElementPointer<PsiElement>> elements, @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(42);
        }
        if (shouldApplyFix == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(43);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
            for (SmartPsiElementPointer element2 : elements) {
                PsiElement psiElement = element2.getElement();
                if (psiElement == null || !psiElement.isPhysical()) continue;
                psiElements.add(psiElement);
            }
            if (psiElements.isEmpty()) {
                return;
            }
            GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)InspectionManager.getInstance((Project)project).createNewGlobalContext();
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
            AnalysisScope analysisScope = new AnalysisScope((SearchScope)new LocalSearchScope(psiElements.toArray(PsiElement.EMPTY_ARRAY)), project);
            globalContext.codeCleanup(analysisScope, profile, null, runnable2, true, shouldApplyFix);
        });
    }

    public void close(boolean noSuspiciousCodeFound) {
        this.cleanup();
    }

    public void cleanup() {
        this.cleanupTools();
    }

    public void incrementJobDoneAmount(@NotNull JobDescriptor job2, @NotNull @NlsContexts.ProgressText String message2) {
        if (job2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(44);
        }
        if (message2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(45);
        }
        if (this.myProgressIndicator == null) {
            return;
        }
        ProgressManager.checkCanceled();
        int old = job2.getDoneAmount();
        job2.setDoneAmount(old + 1);
        float totalProgress = this.getTotalProgress();
        this.myProgressIndicator.setFraction((double)totalProgress);
        this.myProgressIndicator.setText(job2.getDisplayName() + " " + message2);
    }

    private float getTotalProgress() {
        int totalDone = 0;
        int totalTotal = 0;
        for (JobDescriptor jobDescriptor : this.myJobDescriptors) {
            totalDone += jobDescriptor.getDoneAmount();
            totalTotal += jobDescriptor.getTotalAmount();
        }
        return totalTotal == 0 ? 1.0f : 1.0f * (float)totalDone / (float)totalTotal;
    }

    public void setExternalProfile(InspectionProfileImpl profile) {
        this.myExternalProfile = profile;
    }

    @NotNull
    public StdJobDescriptors getStdJobDescriptors() {
        StdJobDescriptors stdJobDescriptors = this.myStdJobDescriptors;
        if (stdJobDescriptors == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(46);
        }
        return stdJobDescriptors;
    }

    public static void assertUnderDaemonProgress() {
        ProgressIndicator original;
        ProgressIndicator indicator2 = ProgressManager.getGlobalProgressIndicator();
        ProgressIndicator progressIndicator = original = indicator2 == null ? null : ProgressWrapper.unwrapAll(indicator2);
        if (!(original instanceof DaemonProgressIndicator)) {
            throw new IllegalStateException("must be run under DaemonProgressIndicator, but got: " + (String)(original == null ? "null" : ": " + original.getClass()) + ": " + original);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 17: 
            case 24: 
            case 30: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 17: 
            case 24: 
            case 30: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 17: 
            case 24: 
            case 30: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/GlobalInspectionContextBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentScope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 32: 
            case 35: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outGlobalTools";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outLocalTools";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outGlobalSimpleTools";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTools";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 31: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 34: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldApplyFix";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentProfile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createOption";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedTools";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTools";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdJobDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 17: 
            case 24: 
            case 30: 
            case 46: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheck";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRerunAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doInspections";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isToCheckMember";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isToCheckFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "launchInspections";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifyInspectionsFinished";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "performInspectionsWithProgress";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runTools";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "initializeTools";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "classifyTool";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "appendJobDescriptor";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "codeCleanup";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "cleanupElements";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "incrementJobDoneAmount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 17: 
            case 24: 
            case 30: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

