/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.services;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.ide.BrowserUtil;
import com.intellij.util.Url;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H$J\u001d\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H$\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH$J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u001b*\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthServiceBase;", "T", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "Lcom/intellij/collaboration/auth/services/OAuthService;", "()V", "currentRequest", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/CompletableFuture;", "getCurrentRequest", "()Ljava/util/concurrent/atomic/AtomicReference;", "acceptCode", "", "code", "", "authorize", "getAuthUrlWithParameters", "Lcom/intellij/util/Url;", "getCredentials", "responseBody", "responseHeaders", "Ljava/net/http/HttpHeaders;", "(Ljava/lang/String;Ljava/net/http/HttpHeaders;)Lcom/intellij/collaboration/auth/credentials/Credentials;", "getTokenUrlWithParameters", "postHttpResponse", "Ljava/net/http/HttpResponse;", "url", "startAuthorization", "", "processCode", "intellij.platform.collaborationTools"})
public abstract class OAuthServiceBase<T extends Credentials>
implements OAuthService<T> {
    @NotNull
    private final AtomicReference<CompletableFuture<T>> currentRequest = new AtomicReference();

    @NotNull
    protected final AtomicReference<CompletableFuture<T>> getCurrentRequest() {
        return this.currentRequest;
    }

    @Override
    @NotNull
    public CompletableFuture<T> authorize() {
        if (!this.currentRequest.compareAndSet(null, new CompletableFuture())) {
            CompletableFuture<T> completableFuture = this.currentRequest.get();
            Intrinsics.checkNotNull(completableFuture);
            return completableFuture;
        }
        CompletableFuture<T> completableFuture = this.currentRequest.get();
        Intrinsics.checkNotNull(completableFuture);
        CompletableFuture<T> request = completableFuture;
        request.whenComplete(new BiConsumer(this){
            final /* synthetic */ OAuthServiceBase this$0;

            public final void accept(T $noName_0, Throwable $noName_1) {
                this.this$0.getCurrentRequest().set(null);
            }
            {
                this.this$0 = oAuthServiceBase;
            }
        });
        this.startAuthorization();
        return request;
    }

    @Override
    public boolean acceptCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        CompletableFuture<T> completableFuture = this.currentRequest.get();
        if (completableFuture == null) {
            return false;
        }
        CompletableFuture<T> request = completableFuture;
        this.processCode(request, code);
        return request.isDone() && !request.isCancelled() && !request.isCompletedExceptionally();
    }

    private final void startAuthorization() {
        String string = this.getAuthUrlWithParameters().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAuthUrlWithParameters().toExternalForm()");
        String authUrl = string;
        BrowserUtil.browse((String)authUrl);
    }

    private final void processCode(CompletableFuture<T> $this$processCode, String code) {
        try {
            String string = this.getTokenUrlWithParameters(code).toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenUrlWithParameters(code).toExternalForm()");
            String tokenUrl = string;
            HttpResponse<String> response = this.postHttpResponse(tokenUrl);
            if (response.statusCode() == 200) {
                String string2 = response.body();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.body()");
                HttpHeaders httpHeaders = response.headers();
                Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"response.headers()");
                T result2 = this.getCredentials(string2, httpHeaders);
                $this$processCode.complete(result2);
            } else {
                CharSequence charSequence;
                CompletableFuture<T> completableFuture = $this$processCode;
                CharSequence charSequence2 = response.body();
                boolean bl = false;
                CharSequence charSequence3 = charSequence2;
                boolean bl2 = false;
                if (charSequence3.length() == 0) {
                    CompletableFuture<T> completableFuture2 = completableFuture;
                    boolean bl3 = false;
                    String string3 = "No token provided";
                    completableFuture = completableFuture2;
                    charSequence = string3;
                } else {
                    charSequence = charSequence2;
                }
                String string4 = (String)charSequence;
                completableFuture.completeExceptionally(new RuntimeException(string4));
            }
        }
        catch (IOException e) {
            $this$processCode.completeExceptionally(e);
        }
    }

    @NotNull
    protected final HttpResponse<String> postHttpResponse(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.noBody()).build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"HttpRequest.newBuilder()\u2026.noBody())\n      .build()");
        HttpRequest request = httpRequest;
        HttpResponse<String> httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"client.send(request, Htt\u2026.BodyHandlers.ofString())");
        return httpResponse;
    }

    @NotNull
    protected abstract Url getAuthUrlWithParameters();

    @NotNull
    protected abstract Url getTokenUrlWithParameters(@NotNull String var1);

    @NotNull
    protected abstract T getCredentials(@NotNull String var1, @NotNull HttpHeaders var2);
}

