/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.StaxFactory;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001aV\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b28\u0010\f\u001a4\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00070\rH\u0080\b\u00f8\u0001\u0000\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"createDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "ioDir", "Ljava/nio/file/Path;", "requestor", "Lcom/intellij/configurationStore/StorageManagerFileWriteRequestor;", "lazyPreloadScheme", "", "bytes", "", "isOldSchemeNaming", "", "consumer", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "Ljavax/xml/stream/XMLStreamReader;", "parser", "preload", "getOrCreateChild", "fileName", "intellij.platform.configurationStore.impl"})
public final class SchemeLoaderKt {
    public static final void lazyPreloadScheme(@NotNull byte[] bytes, boolean isOldSchemeNaming, @NotNull Function2<? super String, ? super XMLStreamReader, Unit> consumer) {
        int $i$f$lazyPreloadScheme = 0;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        byte[] byArray = bytes;
        boolean bl = false;
        InputStream inputStream2 = CharsetToolkit.inputStreamSkippingBOM((InputStream)new ByteArrayInputStream(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"CharsetToolkit.inputStre\u2026gBOM(bytes.inputStream())");
        XMLStreamReader2 reader = StaxFactory.createXmlStreamReader((InputStream)inputStream2);
        consumer.invoke((Object)SchemeLoaderKt.preload(isOldSchemeNaming, (XMLStreamReader)reader), (Object)reader);
    }

    /*
     * WARNING - void declaration
     */
    private static final String preload(boolean isOldSchemeNaming, XMLStreamReader parser) {
        void eventType;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = parser.getEventType();
        Function0<String> $fun$findName$1 = new Function0<String>((Ref.IntRef)eventType, parser){
            final /* synthetic */ Ref.IntRef $eventType;
            final /* synthetic */ XMLStreamReader $parser;

            @Nullable
            public final String invoke() {
                this.$eventType.element = this.$parser.next();
                while (this.$eventType.element != 8) {
                    switch (this.$eventType.element) {
                        case 1: {
                            if (!Intrinsics.areEqual((Object)this.$parser.getLocalName(), (Object)"option") || !Intrinsics.areEqual((Object)this.$parser.getAttributeValue(null, "name"), (Object)"myName")) break;
                            return this.$parser.getAttributeValue(null, "value");
                        }
                    }
                    this.$eventType.element = this.$parser.next();
                }
                return null;
            }
            {
                this.$eventType = intRef;
                this.$parser = xMLStreamReader;
                super(0);
            }
        };
        do {
            switch (eventType.element) {
                case 1: {
                    if (isOldSchemeNaming && !(Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"component") ^ true)) break;
                    if (Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"profile") || isOldSchemeNaming && Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"copyright")) {
                        return $fun$findName$1.invoke();
                    }
                    if (Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"inspections")) {
                        Object object = parser.getAttributeValue(null, "profile_name");
                        if (object == null) {
                            object = $fun$findName$1.invoke();
                        }
                        return object;
                    }
                    if (Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"configuration")) {
                        return parser.getAttributeValue(null, "name");
                    }
                    return null;
                }
            }
            eventType.element = parser.next();
        } while (eventType.element != 8);
        return null;
    }

    @NotNull
    public static final VirtualFile getOrCreateChild(@NotNull VirtualFile $this$getOrCreateChild, @NotNull String fileName, @NotNull StorageManagerFileWriteRequestor requestor) {
        Intrinsics.checkNotNullParameter((Object)$this$getOrCreateChild, (String)"$this$getOrCreateChild");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        VirtualFile virtualFile2 = $this$getOrCreateChild.findChild(fileName);
        if (virtualFile2 == null) {
            Object object;
            boolean $i$f$runAsWriteActionIfNeeded = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isWriteAccessAllowed()) {
                boolean bl = false;
                VirtualFile virtualFile3 = $this$getOrCreateChild.createChildData((Object)requestor, fileName);
                object = virtualFile3;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"createChildData(requestor, fileName)");
            } else {
                boolean $i$f$runWriteAction = false;
                object = ApplicationManager.getApplication().runWriteAction(new Computable($this$getOrCreateChild, requestor, fileName){
                    final /* synthetic */ VirtualFile $this_getOrCreateChild$inlined;
                    final /* synthetic */ StorageManagerFileWriteRequestor $requestor$inlined;
                    final /* synthetic */ String $fileName$inlined;
                    {
                        this.$this_getOrCreateChild$inlined = virtualFile2;
                        this.$requestor$inlined = storageManagerFileWriteRequestor;
                        this.$fileName$inlined = string;
                    }

                    public final T compute() {
                        boolean bl = false;
                        VirtualFile virtualFile2 = this.$this_getOrCreateChild$inlined.createChildData((Object)this.$requestor$inlined, this.$fileName$inlined);
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildData(requestor, fileName)");
                        return (T)virtualFile2;
                    }
                });
            }
            virtualFile2 = object;
        }
        return virtualFile2;
    }

    @NotNull
    public static final VirtualFile createDir(@NotNull Path ioDir, @NotNull StorageManagerFileWriteRequestor requestor) {
        Intrinsics.checkNotNullParameter((Object)ioDir, (String)"ioDir");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        PathKt.createDirectories((Path)ioDir);
        Path parentFile = ioDir.getParent();
        VirtualFile virtualFile2 = parentFile == null ? null : VfsUtil.createDirectoryIfMissing((String)PathKt.getSystemIndependentPath((Path)parentFile));
        if (virtualFile2 == null) {
            throw (Throwable)new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile}));
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"(if (parentFile == null)\u2026.not.found\", parentFile))");
        VirtualFile parentVirtualFile = virtualFile2;
        return SchemeLoaderKt.getOrCreateChild(parentVirtualFile, ((Object)ioDir.getFileName()).toString(), requestor);
    }
}

