/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import javax.swing.JComponent;

public class LightFillLayout
implements LayoutManager2 {
    private final boolean myVertical;

    public LightFillLayout() {
        this(false);
    }

    public LightFillLayout(boolean vertical) {
        this.myVertical = vertical;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints2) {
    }

    @Override
    public float getLayoutAlignmentX(Container target2) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target2) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target2) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target2) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return LightFillLayout.layoutSize(parent, this.myVertical, (Function<? super Component, ? extends Dimension>)((Function)component2 -> component2.getPreferredSize()));
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return LightFillLayout.layoutSize(parent, this.myVertical, (Function<? super Component, ? extends Dimension>)((Function)component2 -> component2.getMinimumSize()));
    }

    private static Dimension layoutSize(Container parent, boolean vertical, Function<? super Component, ? extends Dimension> getSize) {
        int[] extraSize = new int[2];
        JComponent jParent = (JComponent)parent;
        LightFillLayout.getSize(jParent, "left", vertical, extraSize);
        LightFillLayout.getSize(jParent, "right", vertical, extraSize);
        Component toolbar = parent.getComponent(0);
        Dimension toolbarSize = toolbar.isVisible() ? (Dimension)getSize.fun((Object)toolbar) : new Dimension();
        Dimension contentSize = (Dimension)getSize.fun((Object)parent.getComponent(1));
        return new Dimension(Math.max(toolbarSize.width, contentSize.width + extraSize[0]), toolbarSize.height + contentSize.height + extraSize[1]);
    }

    private static void getSize(JComponent jParent, String key, boolean vertical, int[] size2) {
        if (jParent.getClientProperty(key) != null) {
            int n = vertical ? 1 : 0;
            size2[n] = size2[n] + 25;
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.myVertical) {
            LightFillLayout.layoutVContainer(parent);
        } else {
            LightFillLayout.layoutHContainer(parent);
        }
    }

    private static void layoutHContainer(Container parent) {
        JComponent right;
        int leftWidth = 0;
        int rightWidth = 0;
        JComponent jParent = (JComponent)parent;
        JComponent left = (JComponent)jParent.getClientProperty("left");
        if (left != null) {
            leftWidth = 25;
        }
        if ((right = (JComponent)jParent.getClientProperty("right")) != null) {
            rightWidth = 25;
        }
        int extraWidth = leftWidth + rightWidth;
        int width = parent.getWidth() - extraWidth;
        int height = parent.getHeight();
        Component toolbar = parent.getComponent(0);
        Dimension toolbarSize = toolbar.isVisible() ? toolbar.getPreferredSize() : new Dimension();
        toolbar.setBounds(leftWidth, 0, width, toolbarSize.height);
        parent.getComponent(1).setBounds(leftWidth, toolbarSize.height, width, height - toolbarSize.height);
        if (left != null) {
            left.setBounds(0, 0, leftWidth, height);
        }
        if (right != null) {
            right.setBounds(width + leftWidth, 0, rightWidth, height);
        }
    }

    private static void layoutVContainer(Container parent) {
        int bottomHeight = 0;
        JComponent jParent = (JComponent)parent;
        JComponent bottom = (JComponent)jParent.getClientProperty("right");
        if (bottom != null) {
            bottomHeight = 25;
        }
        int width = parent.getWidth();
        int height = parent.getHeight() - bottomHeight;
        Component toolbar = parent.getComponent(0);
        Dimension toolbarSize = toolbar.isVisible() ? toolbar.getPreferredSize() : new Dimension();
        toolbar.setBounds(0, 0, width, toolbarSize.height);
        parent.getComponent(1).setBounds(0, toolbarSize.height, width, height - toolbarSize.height);
        if (bottom != null) {
            bottom.setBounds(0, height, width, bottomHeight);
        }
    }
}

