/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.openapi.application.ApplicationStarterBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffApplicationBase
extends ApplicationStarterBase {
    @NlsSafe
    protected static final String NULL_PATH = "/dev/null";
    protected static final Logger LOG = Logger.getInstance(DiffApplicationBase.class);

    protected DiffApplicationBase(@NotNull @NonNls String commandName2, int ... possibleArgumentsCount) {
        if (commandName2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(0);
        }
        super(commandName2, possibleArgumentsCount);
    }

    @NotNull
    public static List<VirtualFile> findFilesOrThrow(@NotNull List<String> filePaths, @Nullable String currentDirectory) throws Exception {
        if (filePaths == null) {
            DiffApplicationBase.$$$reportNull$$$0(1);
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (String path2 : filePaths) {
            if (NULL_PATH.equals(path2)) {
                files2.add(null);
                continue;
            }
            VirtualFile virtualFile2 = DiffApplicationBase.findFile(path2, currentDirectory);
            if (virtualFile2 == null) {
                throw new Exception(DiffBundle.message((String)"cannot.find.file.error", (Object[])new Object[]{path2}));
            }
            files2.add(virtualFile2);
        }
        DiffApplicationBase.refreshAndEnsureFilesValid(files2);
        ArrayList<VirtualFile> arrayList = files2;
        if (arrayList == null) {
            DiffApplicationBase.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static void refreshAndEnsureFilesValid(@NotNull List<? extends VirtualFile> files2) throws Exception {
        if (files2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(3);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(files2));
        for (VirtualFile virtualFile2 : files2) {
            if (virtualFile2 == null || virtualFile2.isValid()) continue;
            throw new Exception(DiffBundle.message((String)"cannot.find.file.error", (Object[])new Object[]{virtualFile2.getPresentableUrl()}));
        }
    }

    @Nullable
    public static VirtualFile findFile(@NotNull String path2, @Nullable String currentDirectory) {
        if (path2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(4);
        }
        File file2 = DiffApplicationBase.getFile(path2, currentDirectory);
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        if (virtualFile2 == null) {
            LOG.warn(String.format("Can't find file: current directory - %s; path - %s", currentDirectory, path2));
        }
        return virtualFile2;
    }

    @Nullable
    public static VirtualFile findOrCreateFile(@NotNull String path2, @Nullable String currentDirectory) throws IOException {
        boolean wasCreated;
        if (path2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(5);
        }
        File file2 = DiffApplicationBase.getFile(path2, currentDirectory);
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        if (virtualFile2 == null && (wasCreated = file2.createNewFile())) {
            virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        }
        if (virtualFile2 == null) {
            LOG.warn(String.format("Can't create file: current directory - %s; path - %s", currentDirectory, path2));
        }
        return virtualFile2;
    }

    @NotNull
    public static File getFile(@NotNull String path2, @Nullable String currentDirectory) {
        File file2;
        if (path2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(6);
        }
        if (!(file2 = new File(path2)).isAbsolute() && currentDirectory != null) {
            file2 = new File(currentDirectory, path2);
        }
        File file3 = file2;
        if (file3 == null) {
            DiffApplicationBase.$$$reportNull$$$0(7);
        }
        return file3;
    }

    @NotNull
    public static List<VirtualFile> replaceNullsWithEmptyFile(@NotNull List<? extends VirtualFile> contents) {
        if (contents == null) {
            DiffApplicationBase.$$$reportNull$$$0(8);
        }
        List list2 = ContainerUtil.map(contents, file2 -> file2 != null ? file2 : new LightVirtualFile(NULL_PATH, (FileType)PlainTextFileType.INSTANCE, (CharSequence)""));
        if (list2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Nullable
    protected static Project guessProject(@NotNull List<? extends VirtualFile> files2) {
        Project project2;
        if (files2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(10);
        }
        HashSet projects = new HashSet();
        for (VirtualFile virtualFile2 : files2) {
            projects.addAll(ProjectLocator.getInstance().getProjectsForFile(virtualFile2));
        }
        if (projects.isEmpty()) {
            Object[] openProjects = ProjectManager.getInstance().getOpenProjects();
            projects.addAll(ContainerUtil.filter((Object[])openProjects, project -> project.isInitialized() && !project.isDisposed()));
        }
        if (projects.isEmpty()) {
            return null;
        }
        Window recentFocusedWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (recentFocusedWindow instanceof IdeFrame && (project2 = ((IdeFrame)recentFocusedWindow).getProject()) != null && projects.contains(project2)) {
            return project2;
        }
        return (Project)projects.iterator().next();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/applications/DiffApplicationBase";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/applications/DiffApplicationBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesOrThrow";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceNullsWithEmptyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFilesOrThrow";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndEnsureFilesValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceNullsWithEmptyFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "guessProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

