/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.editor;

import com.intellij.diff.editor.DiffRequestProcessorEditorCustomizer;
import com.intellij.diff.editor.DiffVirtualFile;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/diff/editor/DiffRequestProcessorEditor;", "Lcom/intellij/diff/util/FileEditorBase;", "file", "Lcom/intellij/diff/editor/DiffVirtualFile;", "processor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "(Lcom/intellij/diff/editor/DiffVirtualFile;Lcom/intellij/diff/impl/DiffRequestProcessor;)V", "disposed", "", "panel", "Lcom/intellij/diff/editor/DiffRequestProcessorEditor$MyPanel;", "getProcessor", "()Lcom/intellij/diff/impl/DiffRequestProcessor;", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "getPreferredFocusedComponent", "isValid", "selectNotify", "Companion", "MyPanel", "intellij.platform.diff.impl"})
public class DiffRequestProcessorEditor
extends FileEditorBase {
    private boolean disposed;
    private final MyPanel panel;
    private final DiffVirtualFile file;
    @NotNull
    private final DiffRequestProcessor processor;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public JComponent getComponent() {
        return this.panel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.processor.getPreferredFocusedComponent();
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @Override
    public boolean isValid() {
        return !this.disposed && !this.processor.isDisposed();
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.file;
    }

    @NotNull
    public String getName() {
        String string = DiffBundle.message((String)"diff.file.editor.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiffBundle.message(\"diff.file.editor.name\")");
        return string;
    }

    @Override
    public void selectNotify() {
        this.processor.updateRequest();
    }

    @NotNull
    public final DiffRequestProcessor getProcessor() {
        return this.processor;
    }

    public DiffRequestProcessorEditor(@NotNull DiffVirtualFile file2, @NotNull DiffRequestProcessor processor2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
        this.file = file2;
        this.processor = processor2;
        JComponent jComponent = this.processor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"processor.component");
        this.panel = new MyPanel(jComponent);
        this.putUserData(EditorWindow.HIDE_TABS, true);
        DiffRequestProcessorEditorCustomizer.Companion.customize((VirtualFile)this.file, this, this.processor);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DiffRequestProcessorEditor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$setDisposed$p(DiffRequestProcessorEditor $this, boolean bl) {
        $this.disposed = bl;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/diff/editor/DiffRequestProcessorEditor$MyPanel;", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "(Lcom/intellij/diff/editor/DiffRequestProcessorEditor;Ljavax/swing/JComponent;)V", "intellij.platform.diff.impl"})
    private final class MyPanel
    extends JPanel {
        public MyPanel(JComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            super(new BorderLayout());
            this.add((Component)component2, "Center");
            this.addContainerListener(new ContainerAdapter(){

                @Override
                public void componentRemoved(@Nullable ContainerEvent e) {
                    if (DiffRequestProcessorEditor.this.disposed) {
                        return;
                    }
                    LOG.error("DiffRequestProcessor cannot be shown twice, see com.intellij.ide.actions.SplitAction.FORBID_TAB_SPLIT, file: " + DiffRequestProcessorEditor.this.file);
                }
            });
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diff/editor/DiffRequestProcessorEditor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

