/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.TransferableFileEditorStateSupport;
import com.intellij.diff.tools.util.side.TwosideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideBinaryDiffViewer
extends TwosideDiffViewer<BinaryEditorHolder> {
    @NotNull
    private final TransferableFileEditorStateSupport myTransferableStateSupport;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private ComparisonData myComparisonData;

    public TwosideBinaryDiffViewer(@NotNull DiffContext context2, @NotNull DiffRequest request) {
        if (context2 == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(1);
        }
        super(context2, (ContentDiffRequest)request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
        this.myComparisonData = ComparisonData.UNKNOWN;
        this.myStatusPanel = new MyStatusPanel();
        new MyFocusOppositePaneAction().install(this.myPanel);
        this.myContentPanel.setTopAction((AnAction)new MyAcceptSideAction(Side.LEFT));
        this.myContentPanel.setBottomAction((AnAction)new MyAcceptSideAction(Side.RIGHT));
        this.myTransferableStateSupport = new TransferableFileEditorStateSupport(DiffUtil.getDiffSettings(context2), this.getEditorHolders(), (Disposable)this);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myTransferableStateSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myTransferableStateSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group2 = new ArrayList<AnAction>();
        group2.add((AnAction)new MyAcceptSideAction(Side.LEFT));
        group2.add((AnAction)new MyAcceptSideAction(Side.RIGHT));
        group2.add((AnAction)Separator.getInstance());
        group2.add(this.myTransferableStateSupport.createToggleAction());
        group2.addAll(super.createToolbarActions());
        group2.add(ActionManager.getInstance().getAction("Diff.Binary.Settings"));
        return group2;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(2);
        }
        try {
            indicator2.checkCanceled();
            List contents = this.myRequest.getContents();
            if (!(contents.get(0) instanceof FileContent) || !(contents.get(1) instanceof FileContent)) {
                return this.applyNotification(ComparisonData.UNKNOWN);
            }
            VirtualFile file1 = ((FileContent)contents.get(0)).getFile();
            VirtualFile file2 = ((FileContent)contents.get(1)).getFile();
            ComparisonData comparisonData = (ComparisonData)ReadAction.nonBlocking(() -> {
                if (!file1.isValid() || !file2.isValid()) {
                    return ComparisonData.ERROR;
                }
                long length1 = file1.getLength();
                long length2 = file2.getLength();
                try {
                    boolean contentsEquals;
                    if (length1 > 0L && length2 > 0L && length1 != length2) {
                        contentsEquals = false;
                    } else {
                        if (FileUtilRt.isTooLarge((long)length1) || FileUtilRt.isTooLarge((long)length2)) {
                            return new ComparisonData(ThreeState.UNSURE, (NullableComputable<String>)((NullableComputable)() -> DiffBundle.message((String)"error.files.too.large.to.compare.text", (Object[])new Object[0])));
                        }
                        contentsEquals = DiffUtil.compareStreams((ThrowableComputable<? extends InputStream, ? extends IOException>)((ThrowableComputable)() -> DiffUtil.getFileInputStream(file1)), (ThrowableComputable<? extends InputStream, ? extends IOException>)((ThrowableComputable)() -> DiffUtil.getFileInputStream(file2)));
                    }
                    return new ComparisonData(ThreeState.fromBoolean((boolean)contentsEquals), (NullableComputable<String>)((NullableComputable)() -> contentsEquals ? DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]) : null));
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    return ComparisonData.ERROR;
                }
            }).wrapProgress(indicator2).executeSynchronously();
            return this.applyNotification(comparisonData);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return this.applyNotification(ComparisonData.ERROR);
        }
    }

    @NotNull
    private Runnable applyNotification(@NotNull ComparisonData comparisonData) {
        if (comparisonData == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(3);
        }
        Runnable runnable2 = () -> {
            this.clearDiffPresentation();
            this.myComparisonData = comparisonData;
            if (this.myComparisonData.notification.get() != null) {
                this.myPanel.addNotification(DiffNotifications.createNotification((String)this.myComparisonData.notification.get()));
            }
            this.myStatusPanel.update();
        };
        if (runnable2 == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(4);
        }
        return runnable2;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
    }

    @NotNull
    FileEditor getCurrentEditor() {
        FileEditor fileEditor = ((BinaryEditorHolder)this.getCurrentEditorHolder()).getEditor();
        if (fileEditor == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(5);
        }
        return fileEditor;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(6);
        }
        return statusPanel;
    }

    public static boolean canShowRequest(@NotNull DiffContext context2, @NotNull DiffRequest request) {
        if (context2 == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(7);
        }
        if (request == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(8);
        }
        return TwosideDiffViewer.canShowRequest(context2, request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparisonData";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "applyNotification";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyNotification";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ComparisonData {
        public static final ComparisonData UNKNOWN = new ComparisonData(ThreeState.UNSURE, (NullableComputable<String>)((NullableComputable)() -> null));
        public static final ComparisonData ERROR = new ComparisonData(ThreeState.UNSURE, (NullableComputable<String>)((NullableComputable)() -> DiffBundle.message((String)"diff.cant.calculate.diff", (Object[])new Object[0])));
        @NotNull
        public final ThreeState isContentsEqual;
        public final @NotNull NullableComputable<@Nls String> notification;

        private ComparisonData(@NotNull ThreeState isContentsEqual, @NotNull NullableComputable<@Nls String> notification) {
            if (isContentsEqual == null) {
                ComparisonData.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                ComparisonData.$$$reportNull$$$0(1);
            }
            this.isContentsEqual = isContentsEqual;
            this.notification = notification;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "isContentsEqual";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer$ComparisonData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        private MyFocusOppositePaneAction() {
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFocusOppositePaneAction.$$$reportNull$$$0(0);
            }
            TwosideBinaryDiffViewer.this.setCurrentSide(TwosideBinaryDiffViewer.this.getCurrentSide().other());
            DiffUtil.requestFocus(TwosideBinaryDiffViewer.this.getProject(), TwosideBinaryDiffViewer.this.getPreferredFocusedComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer$MyFocusOppositePaneAction", "actionPerformed"));
        }
    }

    private class MyAcceptSideAction
    extends DumbAwareAction {
        @NotNull
        private final Side myBaseSide;

        MyAcceptSideAction(Side baseSide) {
            if (baseSide == null) {
                MyAcceptSideAction.$$$reportNull$$$0(0);
            }
            this.myBaseSide = baseSide;
            this.getTemplatePresentation().setText(DiffBundle.message((String)"copy.content.to.side", (Object[])new Object[]{baseSide.other().getIndex()}));
            this.getTemplatePresentation().setIcon((Icon)baseSide.select((Object)AllIcons.Vcs.Arrow_right, (Object)AllIcons.Vcs.Arrow_left));
            this.setShortcutSet(ActionManager.getInstance().getAction((String)baseSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAcceptSideAction.$$$reportNull$$$0(1);
            }
            VirtualFile baseFile = this.getContentFile(this.myBaseSide);
            VirtualFile targetFile = this.getContentFile(this.myBaseSide.other());
            boolean enabled = baseFile != null && targetFile != null && targetFile.isWritable();
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAcceptSideAction.$$$reportNull$$$0(2);
            }
            VirtualFile baseFile = this.getContentFile(this.myBaseSide);
            VirtualFile targetFile = this.getContentFile(this.myBaseSide.other());
            assert (baseFile != null && targetFile != null);
            try {
                WriteAction.run(() -> targetFile.setBinaryContent(baseFile.contentsToByteArray()));
            }
            catch (IOException err) {
                LOG.warn((Throwable)err);
                Messages.showErrorDialog((Project)TwosideBinaryDiffViewer.this.getProject(), (String)err.getMessage(), (String)DiffBundle.message((String)"can.t.copy.file", (Object[])new Object[0]));
            }
        }

        @Nullable
        private VirtualFile getContentFile(@NotNull Side side) {
            DiffContent content2;
            if (side == null) {
                MyAcceptSideAction.$$$reportNull$$$0(3);
            }
            VirtualFile file2 = (content2 = (DiffContent)side.select(TwosideBinaryDiffViewer.this.myRequest.getContents())) instanceof FileContent ? ((FileContent)content2).getFile() : null;
            return file2 != null && file2.isValid() ? file2 : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseSide";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer$MyAcceptSideAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContentFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (TwosideBinaryDiffViewer.this.myComparisonData.isContentsEqual == ThreeState.UNSURE) {
                return null;
            }
            if (TwosideBinaryDiffViewer.this.myComparisonData.isContentsEqual == ThreeState.YES) {
                return DiffBundle.message((String)"binary.diff.contents.are.identical.message.text", (Object[])new Object[0]);
            }
            return DiffBundle.message((String)"binary.diff.contents.are.different.message.text", (Object[])new Object[0]);
        }
    }
}

