/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SyncScrollSupport {
    private static void doScrollVertically(@NotNull Editor editor, int offset, boolean animated) {
        if (editor == null) {
            SyncScrollSupport.$$$reportNull$$$0(0);
        }
        SyncScrollSupport.doScrollVertically(editor, offset, animated, false, false);
    }

    private static void doScrollVertically(@NotNull Editor editor, int offset, boolean animated, boolean onlyMajorForward, boolean onlyMajorBackward) {
        if (editor == null) {
            SyncScrollSupport.$$$reportNull$$$0(1);
        }
        ScrollingModel model2 = editor.getScrollingModel();
        int currentOffset = model2.getVerticalScrollOffset();
        if ((onlyMajorForward && offset > currentOffset || onlyMajorBackward && offset < currentOffset) && Math.abs(offset - currentOffset) < editor.getLineHeight()) {
            return;
        }
        if (!animated) {
            model2.disableAnimation();
        }
        model2.scrollVertically(offset);
        if (!animated) {
            model2.enableAnimation();
        }
    }

    private static void doScrollHorizontally(@NotNull Editor editor, int offset, boolean animated) {
        if (editor == null) {
            SyncScrollSupport.$$$reportNull$$$0(2);
        }
        ScrollingModel model2 = editor.getScrollingModel();
        if (!animated) {
            model2.disableAnimation();
        }
        model2.scrollHorizontally(offset);
        if (!animated) {
            model2.enableAnimation();
        }
    }

    private static int getHeaderOffset(@NotNull Editor editor) {
        JComponent header2;
        if (editor == null) {
            SyncScrollSupport.$$$reportNull$$$0(3);
        }
        return (header2 = editor.getHeaderComponent()) == null ? 0 : header2.getHeight();
    }

    public static int @NotNull [] getTargetOffsets(@NotNull Editor editor1, @NotNull Editor editor2, int startLine1, int endLine1, int startLine2, int endLine2, int preferredTopShift) {
        if (editor1 == null) {
            SyncScrollSupport.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            SyncScrollSupport.$$$reportNull$$$0(5);
        }
        return SyncScrollSupport.getTargetOffsets(new Editor[]{editor1, editor2}, new int[]{startLine1, startLine2}, new int[]{endLine1, endLine2}, preferredTopShift);
    }

    private static int @NotNull [] getTargetOffsets(Editor @NotNull [] editors2, int[] startLines, int[] endLines, int preferredTopShift) {
        int i2;
        if (editors2 == null) {
            SyncScrollSupport.$$$reportNull$$$0(6);
        }
        int count = editors2.length;
        assert (startLines.length == count);
        assert (endLines.length == count);
        int[] topOffsets = new int[count];
        int[] bottomOffsets = new int[count];
        int[] rangeHeights = new int[count];
        int[] gapLines = new int[count];
        int[] editorHeights = new int[count];
        int[] maximumOffsets = new int[count];
        int[] topShifts = new int[count];
        for (int i3 = 0; i3 < count; ++i3) {
            topOffsets[i3] = editors2[i3].logicalPositionToXY((LogicalPosition)new LogicalPosition((int)startLines[i3], (int)0)).y;
            bottomOffsets[i3] = editors2[i3].logicalPositionToXY((LogicalPosition)new LogicalPosition((int)(endLines[i3] + 1), (int)0)).y;
            rangeHeights[i3] = bottomOffsets[i3] - topOffsets[i3];
            gapLines[i3] = 2 * editors2[i3].getLineHeight();
            editorHeights[i3] = editors2[i3].getScrollingModel().getVisibleArea().height;
            maximumOffsets[i3] = ((EditorEx)editors2[i3]).getScrollPane().getVerticalScrollBar().getMaximum() - editorHeights[i3];
            boolean canShow2 = 2 * gapLines[i3] + rangeHeights[i3] <= editorHeights[i3];
            int shift = preferredTopShift != -1 ? preferredTopShift : editorHeights[i3] / 3;
            topShifts[i3] = canShow2 ? Math.min(editorHeights[i3] - gapLines[i3] - rangeHeights[i3], shift) : gapLines[i3];
        }
        int topShift = ArrayUtil.min((int[])topShifts);
        topShift = Math.min(topShift, ArrayUtil.min((int[])topOffsets));
        int[] offsets2 = new int[count];
        boolean haveEnoughSpace = true;
        for (i2 = 0; i2 < count; ++i2) {
            offsets2[i2] = topOffsets[i2] - topShift;
            haveEnoughSpace &= maximumOffsets[i2] > offsets2[i2];
        }
        if (haveEnoughSpace) {
            if (offsets2 == null) {
                SyncScrollSupport.$$$reportNull$$$0(7);
            }
            return offsets2;
        }
        topShift = 0;
        for (i2 = 0; i2 < count; ++i2) {
            topShift = Math.max(topOffsets[i2] - maximumOffsets[i2], topShift);
        }
        for (i2 = 0; i2 < count; ++i2) {
            offsets2[i2] = topOffsets[i2] - topShift + Math.max(topShift + rangeHeights[i2] + gapLines[i2] - editorHeights[i2], 0);
            offsets2[i2] = Math.min(offsets2[i2], topOffsets[i2] - gapLines[i2]);
        }
        if (offsets2 == null) {
            SyncScrollSupport.$$$reportNull$$$0(8);
        }
        return offsets2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/SyncScrollSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/SyncScrollSupport";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doScrollVertically";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doScrollHorizontally";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderOffset";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTargetOffsets";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Anchor {
        public final int masterStartOffset;
        public final int masterEndOffset;
        public final int slaveStartOffset;
        public final int slaveEndOffset;

        Anchor(int masterStartOffset, int masterEndOffset, int slaveStartOffset, int slaveEndOffset) {
            this.masterStartOffset = masterStartOffset;
            this.masterEndOffset = masterEndOffset;
            this.slaveStartOffset = slaveStartOffset;
            this.slaveEndOffset = slaveEndOffset;
        }
    }

    private static class ScrollHelper
    implements VisibleAreaListener {
        @NotNull
        private final List<? extends Editor> myEditors;
        private final int myMasterIndex;
        private final int mySlaveIndex;
        @NotNull
        private final SyncScrollable myScrollable;
        @NotNull
        private final Side mySide;
        @Nullable
        private Anchor myAnchor;

        ScrollHelper(@NotNull List<? extends Editor> editors2, int masterIndex, int slaveIndex, @NotNull SyncScrollable scrollable, @NotNull Side side) {
            if (editors2 == null) {
                ScrollHelper.$$$reportNull$$$0(0);
            }
            if (scrollable == null) {
                ScrollHelper.$$$reportNull$$$0(1);
            }
            if (side == null) {
                ScrollHelper.$$$reportNull$$$0(2);
            }
            this.myEditors = editors2;
            this.myMasterIndex = masterIndex;
            this.mySlaveIndex = slaveIndex;
            this.myScrollable = scrollable;
            this.mySide = side;
        }

        public void setAnchor(int masterStartOffset, int masterEndOffset, int slaveStartOffset, int slaveEndOffset) {
            this.myAnchor = new Anchor(masterStartOffset, masterEndOffset, slaveStartOffset, slaveEndOffset);
        }

        public void removeAnchor() {
            this.myAnchor = null;
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            if (e == null) {
                ScrollHelper.$$$reportNull$$$0(3);
            }
            if (((FoldingModelImpl)this.getSlave().getFoldingModel()).isInBatchFoldingOperation()) {
                return;
            }
            if (this.getMaster().isDisposed() || this.getSlave().isDisposed()) {
                return;
            }
            Rectangle newRectangle = e.getNewRectangle();
            Rectangle oldRectangle = e.getOldRectangle();
            if (oldRectangle == null) {
                return;
            }
            if (newRectangle.x != oldRectangle.x) {
                this.syncHorizontalScroll(false);
            }
            if (newRectangle.y != oldRectangle.y) {
                this.syncVerticalScroll(false);
            }
        }

        public int getMasterIndex() {
            return this.myMasterIndex;
        }

        public int getSlaveIndex() {
            return this.mySlaveIndex;
        }

        @NotNull
        public Editor getMaster() {
            Editor editor = this.myEditors.get(this.myMasterIndex);
            if (editor == null) {
                ScrollHelper.$$$reportNull$$$0(4);
            }
            return editor;
        }

        @NotNull
        public Editor getSlave() {
            Editor editor = this.myEditors.get(this.mySlaveIndex);
            if (editor == null) {
                ScrollHelper.$$$reportNull$$$0(5);
            }
            return editor;
        }

        private void syncVerticalScroll(boolean animated) {
            int offset;
            Editor master = this.getMaster();
            Editor slave = this.getSlave();
            if (master.getDocument().getTextLength() == 0) {
                return;
            }
            Rectangle viewRect = master.getScrollingModel().getVisibleArea();
            int lineHeight = master.getLineHeight();
            boolean onlyMajorForward = false;
            boolean onlyMajorBackward = false;
            if (this.myAnchor == null) {
                int middleY = viewRect.height / 3;
                int masterOffset = viewRect.y + middleY;
                int masterVisualLine = master.yToVisualLine(masterOffset);
                int convertedVisualLine = this.transferVisualLine(masterVisualLine);
                int slaveOffset = slave.visualLineToY(convertedVisualLine);
                int masterOffsetRaw = master.visualLineToY(masterVisualLine);
                int correction = (masterOffset - masterOffsetRaw) % lineHeight;
                offset = slaveOffset - middleY + correction;
                onlyMajorBackward = correction < lineHeight / 2 && masterVisualLine > 0 && convertedVisualLine == this.transferVisualLine(masterVisualLine - 1);
                onlyMajorForward = correction > lineHeight / 2 && convertedVisualLine == this.transferVisualLine(masterVisualLine + 1);
            } else {
                double progress2 = this.myAnchor.masterStartOffset == this.myAnchor.masterEndOffset || viewRect.y == this.myAnchor.masterEndOffset ? 1.0 : (double)(viewRect.y - this.myAnchor.masterStartOffset) / (double)(this.myAnchor.masterEndOffset - this.myAnchor.masterStartOffset);
                offset = this.myAnchor.slaveStartOffset + (int)((double)(this.myAnchor.slaveEndOffset - this.myAnchor.slaveStartOffset) * progress2);
            }
            int deltaHeaderOffset = SyncScrollSupport.getHeaderOffset(slave) - SyncScrollSupport.getHeaderOffset(master);
            SyncScrollSupport.doScrollVertically(slave, offset + deltaHeaderOffset, animated, onlyMajorForward, onlyMajorBackward);
        }

        private int transferVisualLine(int masterVisualLine) {
            Editor master = this.getMaster();
            Editor slave = this.getSlave();
            int masterCenterLine = master.visualToLogicalPosition((VisualPosition)new VisualPosition((int)masterVisualLine, (int)0)).line;
            Range range2 = this.myScrollable.getRange(this.mySide, masterCenterLine);
            int masterStart = ScrollHelper.logicalToVisualLine(master, range2.start1);
            int masterEnd = range2.start1 == range2.end1 ? masterStart : ScrollHelper.logicalToVisualLine(master, range2.end1);
            int slaveStart = ScrollHelper.logicalToVisualLine(slave, range2.start2);
            int slaveEnd = range2.start2 == range2.end2 ? slaveStart : ScrollHelper.logicalToVisualLine(slave, range2.end2);
            Range visualRange = new Range(masterStart, masterEnd, slaveStart, slaveEnd);
            return BaseSyncScrollable.transferLine(masterVisualLine, visualRange);
        }

        private static int logicalToVisualLine(@NotNull Editor editor, int line) {
            if (editor == null) {
                ScrollHelper.$$$reportNull$$$0(6);
            }
            return editor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)line, (int)0)).line;
        }

        private void syncHorizontalScroll(boolean animated) {
            int offset = this.getMaster().getScrollingModel().getVisibleArea().x;
            SyncScrollSupport.doScrollHorizontally(this.getSlave(), offset, animated);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scrollable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/SyncScrollSupport$ScrollHelper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/SyncScrollSupport$ScrollHelper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMaster";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSlave";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visibleAreaChanged";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "logicalToVisualLine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class SyncScrollSupportBase
    implements Support {
        private int myDuringSyncScrollDepth = 0;

        private SyncScrollSupportBase() {
        }

        public boolean isDuringSyncScroll() {
            return this.myDuringSyncScrollDepth > 0;
        }

        @Override
        public void enterDisableScrollSection() {
            ++this.myDuringSyncScrollDepth;
        }

        @Override
        public void exitDisableScrollSection() {
            --this.myDuringSyncScrollDepth;
            assert (this.myDuringSyncScrollDepth >= 0);
        }

        @NotNull
        protected abstract List<? extends Editor> getEditors();

        @NotNull
        protected abstract List<? extends ScrollHelper> getScrollHelpers();

        protected void doMakeVisible(int masterIndex, int[] startLines, int[] endLines, boolean animate2) {
            List<? extends Editor> editors2 = this.getEditors();
            List<? extends ScrollHelper> helpers = this.getScrollHelpers();
            int count = editors2.size();
            assert (startLines.length == count);
            assert (endLines.length == count);
            int[] offsets2 = SyncScrollSupport.getTargetOffsets(editors2.toArray(Editor.EMPTY_ARRAY), startLines, endLines, -1);
            int[] startOffsets = new int[count];
            for (int i2 = 0; i2 < count; ++i2) {
                startOffsets[i2] = editors2.get((int)i2).getScrollingModel().getVisibleArea().y;
            }
            Editor masterEditor = editors2.get(masterIndex);
            int masterOffset = offsets2[masterIndex];
            int masterStartOffset = startOffsets[masterIndex];
            for (ScrollHelper scrollHelper : helpers) {
                scrollHelper.setAnchor(startOffsets[scrollHelper.getMasterIndex()], offsets2[scrollHelper.getMasterIndex()], startOffsets[scrollHelper.getSlaveIndex()], offsets2[scrollHelper.getSlaveIndex()]);
            }
            SyncScrollSupport.doScrollHorizontally(masterEditor, 0, false);
            SyncScrollSupport.doScrollVertically(masterEditor, masterOffset, animate2);
            masterEditor.getScrollingModel().runActionOnScrollingFinished(() -> {
                for (ScrollHelper helper : helpers) {
                    helper.removeAnchor();
                }
                int masterFinalOffset = masterEditor.getScrollingModel().getVisibleArea().y;
                boolean animateSlaves = animate2 && masterFinalOffset == masterStartOffset;
                for (int i2 = 0; i2 < count; ++i2) {
                    if (i2 == masterIndex) continue;
                    Editor editor = (Editor)editors2.get(i2);
                    int finalOffset = editor.getScrollingModel().getVisibleArea().y;
                    if (finalOffset == offsets2[i2]) continue;
                    this.enterDisableScrollSection();
                    SyncScrollSupport.doScrollVertically(editor, offsets2[i2], animateSlaves);
                    editor.getScrollingModel().runActionOnScrollingFinished(this::exitDisableScrollSection);
                }
            });
        }
    }

    public static class ThreesideSyncScrollSupport
    extends SyncScrollSupportBase {
        @NotNull
        private final List<? extends Editor> myEditors;
        @NotNull
        private final SyncScrollable myScrollable12;
        @NotNull
        private final SyncScrollable myScrollable23;
        @NotNull
        private final ScrollHelper myHelper12;
        @NotNull
        private final ScrollHelper myHelper21;
        @NotNull
        private final ScrollHelper myHelper23;
        @NotNull
        private final ScrollHelper myHelper32;

        public ThreesideSyncScrollSupport(@NotNull List<? extends Editor> editors2, @NotNull SyncScrollable scrollable12, @NotNull SyncScrollable scrollable23) {
            if (editors2 == null) {
                ThreesideSyncScrollSupport.$$$reportNull$$$0(0);
            }
            if (scrollable12 == null) {
                ThreesideSyncScrollSupport.$$$reportNull$$$0(1);
            }
            if (scrollable23 == null) {
                ThreesideSyncScrollSupport.$$$reportNull$$$0(2);
            }
            assert (editors2.size() == 3);
            this.myEditors = editors2;
            this.myScrollable12 = scrollable12;
            this.myScrollable23 = scrollable23;
            this.myHelper12 = this.create(ThreeSide.LEFT, ThreeSide.BASE);
            this.myHelper21 = this.create(ThreeSide.BASE, ThreeSide.LEFT);
            this.myHelper23 = this.create(ThreeSide.BASE, ThreeSide.RIGHT);
            this.myHelper32 = this.create(ThreeSide.RIGHT, ThreeSide.BASE);
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends Editor> list2 = this.myEditors;
            if (list2 == null) {
                ThreesideSyncScrollSupport.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<? extends ScrollHelper> getScrollHelpers() {
            List<ScrollHelper> list2 = Arrays.asList(this.myHelper12, this.myHelper21, this.myHelper23, this.myHelper32);
            if (list2 == null) {
                ThreesideSyncScrollSupport.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        public SyncScrollable getScrollable12() {
            SyncScrollable syncScrollable = this.myScrollable12;
            if (syncScrollable == null) {
                ThreesideSyncScrollSupport.$$$reportNull$$$0(5);
            }
            return syncScrollable;
        }

        @NotNull
        public SyncScrollable getScrollable23() {
            SyncScrollable syncScrollable = this.myScrollable23;
            if (syncScrollable == null) {
                ThreesideSyncScrollSupport.$$$reportNull$$$0(6);
            }
            return syncScrollable;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (this.isDuringSyncScroll()) {
                return;
            }
            this.enterDisableScrollSection();
            try {
                if (e.getEditor() == ThreeSide.LEFT.select(this.myEditors)) {
                    if (this.myScrollable12.isSyncScrollEnabled()) {
                        this.myHelper12.visibleAreaChanged(e);
                        if (this.myScrollable23.isSyncScrollEnabled()) {
                            this.myHelper23.visibleAreaChanged(e);
                        }
                    }
                } else if (e.getEditor() == ThreeSide.BASE.select(this.myEditors)) {
                    if (this.myScrollable12.isSyncScrollEnabled()) {
                        this.myHelper21.visibleAreaChanged(e);
                    }
                    if (this.myScrollable23.isSyncScrollEnabled()) {
                        this.myHelper23.visibleAreaChanged(e);
                    }
                } else if (e.getEditor() == ThreeSide.RIGHT.select(this.myEditors) && this.myScrollable23.isSyncScrollEnabled()) {
                    this.myHelper32.visibleAreaChanged(e);
                    if (this.myScrollable12.isSyncScrollEnabled()) {
                        this.myHelper21.visibleAreaChanged(e);
                    }
                }
            }
            finally {
                this.exitDisableScrollSection();
            }
        }

        public void makeVisible(@NotNull ThreeSide masterSide, int[] startLines, int[] endLines, boolean animate2) {
            if (masterSide == null) {
                ThreesideSyncScrollSupport.$$$reportNull$$$0(7);
            }
            this.doMakeVisible(masterSide.getIndex(), startLines, endLines, animate2);
        }

        @NotNull
        private ScrollHelper create(@NotNull ThreeSide master, @NotNull ThreeSide slave) {
            SyncScrollable scrollable;
            if (master == null) {
                ThreesideSyncScrollSupport.$$$reportNull$$$0(8);
            }
            if (slave == null) {
                ThreesideSyncScrollSupport.$$$reportNull$$$0(9);
            }
            assert (master != slave);
            assert (master == ThreeSide.BASE || slave == ThreeSide.BASE);
            boolean leftSide = master == ThreeSide.LEFT || slave == ThreeSide.LEFT;
            SyncScrollable syncScrollable = scrollable = leftSide ? this.myScrollable12 : this.myScrollable23;
            Side side = leftSide ? Side.fromLeft((master == ThreeSide.LEFT ? 1 : 0) != 0) : Side.fromLeft((master == ThreeSide.BASE ? 1 : 0) != 0);
            return new ScrollHelper(this.myEditors, master.getIndex(), slave.getIndex(), scrollable, side);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scrollable12";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scrollable23";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "masterSide";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "master";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slave";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScrollHelpers";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScrollable12";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScrollable23";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "makeVisible";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TwosideSyncScrollSupport
    extends SyncScrollSupportBase {
        @NotNull
        private final List<? extends Editor> myEditors;
        @NotNull
        private final SyncScrollable myScrollable;
        @NotNull
        private final ScrollHelper myHelper1;
        @NotNull
        private final ScrollHelper myHelper2;

        public TwosideSyncScrollSupport(@NotNull List<? extends Editor> editors2, @NotNull SyncScrollable scrollable) {
            if (editors2 == null) {
                TwosideSyncScrollSupport.$$$reportNull$$$0(0);
            }
            if (scrollable == null) {
                TwosideSyncScrollSupport.$$$reportNull$$$0(1);
            }
            this.myEditors = editors2;
            this.myScrollable = scrollable;
            this.myHelper1 = this.create(Side.LEFT);
            this.myHelper2 = this.create(Side.RIGHT);
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends Editor> list2 = this.myEditors;
            if (list2 == null) {
                TwosideSyncScrollSupport.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<? extends ScrollHelper> getScrollHelpers() {
            List<ScrollHelper> list2 = Arrays.asList(this.myHelper1, this.myHelper2);
            if (list2 == null) {
                TwosideSyncScrollSupport.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @NotNull
        public SyncScrollable getScrollable() {
            SyncScrollable syncScrollable = this.myScrollable;
            if (syncScrollable == null) {
                TwosideSyncScrollSupport.$$$reportNull$$$0(4);
            }
            return syncScrollable;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (!this.myScrollable.isSyncScrollEnabled() || this.isDuringSyncScroll()) {
                return;
            }
            this.enterDisableScrollSection();
            try {
                if (e.getEditor() == Side.LEFT.select(this.myEditors)) {
                    this.myHelper1.visibleAreaChanged(e);
                } else if (e.getEditor() == Side.RIGHT.select(this.myEditors)) {
                    this.myHelper2.visibleAreaChanged(e);
                }
            }
            finally {
                this.exitDisableScrollSection();
            }
        }

        public void makeVisible(@NotNull Side masterSide, int startLine1, int endLine1, int startLine2, int endLine2, boolean animate2) {
            if (masterSide == null) {
                TwosideSyncScrollSupport.$$$reportNull$$$0(5);
            }
            this.doMakeVisible(masterSide.getIndex(), new int[]{startLine1, startLine2}, new int[]{endLine1, endLine2}, animate2);
        }

        @NotNull
        private ScrollHelper create(@NotNull Side side) {
            if (side == null) {
                TwosideSyncScrollSupport.$$$reportNull$$$0(6);
            }
            return new ScrollHelper(this.myEditors, side.getIndex(), side.other().getIndex(), this.myScrollable, side);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scrollable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "masterSide";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScrollHelpers";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScrollable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "makeVisible";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Support {
        public void enterDisableScrollSection();

        public void exitDisableScrollSection();
    }

    public static interface SyncScrollable {
        @RequiresEdt
        public boolean isSyncScrollEnabled();

        @RequiresEdt
        public int transfer(@NotNull Side var1, int var2);

        @NotNull
        @RequiresEdt
        public Range getRange(@NotNull Side var1, int var2);
    }
}

