/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.SiblingNodeIterator;
import com.intellij.dupLocator.treeHash.DuplicatesMatchingVisitor;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.TreeHasherBase;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeSpecificHasherBase
extends NodeSpecificHasher {
    private final TreeHasherBase myTreeHasher;
    private final DuplocatorSettings mySettings;
    private final DuplicatesProfileBase myDuplicatesProfile;
    private final NodeFilter myNodeFilter;
    protected final boolean myForIndexing;

    private boolean isToSkipAsLiteral(PsiElement element2) {
        return this.isLiteral(element2) && !this.myDuplicatesProfile.getDuplocatorState(this.myDuplicatesProfile.getLanguage(element2)).distinguishLiterals();
    }

    public NodeSpecificHasherBase(@NotNull DuplocatorSettings settings2, @NotNull FragmentsCollector callback2, @NotNull DuplicatesProfileBase duplicatesProfile) {
        if (settings2 == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(0);
        }
        if (callback2 == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(1);
        }
        if (duplicatesProfile == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(2);
        }
        this(settings2, callback2, duplicatesProfile, false);
    }

    public NodeSpecificHasherBase(@NotNull DuplocatorSettings settings2, @NotNull FragmentsCollector callback2, @NotNull DuplicatesProfileBase duplicatesProfile, boolean forIndexing) {
        if (settings2 == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(3);
        }
        if (callback2 == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(4);
        }
        if (duplicatesProfile == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(5);
        }
        this.myNodeFilter = new NodeFilter(){

            @Override
            public boolean accepts(PsiElement element2) {
                return DuplocatorUtil.isIgnoredNode(element2) || NodeSpecificHasherBase.this.isToSkipAsLiteral(element2);
            }
        };
        this.myTreeHasher = new TreeHasherBase(callback2, duplicatesProfile, forIndexing ? 0 : -1, forIndexing);
        this.mySettings = settings2;
        this.myDuplicatesProfile = duplicatesProfile;
        this.myForIndexing = forIndexing;
    }

    @NotNull
    public NodeFilter getNodeFilter() {
        NodeFilter nodeFilter = this.myNodeFilter;
        if (nodeFilter == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(6);
        }
        return nodeFilter;
    }

    @Override
    public int getNodeHash(PsiElement node2) {
        if (node2 == null) {
            return 0;
        }
        if (node2 instanceof PsiWhiteSpace || node2 instanceof PsiErrorElement) {
            return 0;
        }
        if (node2 instanceof LeafElement) {
            if (this.isToSkipAsLiteral(node2)) {
                return 0;
            }
            return node2.getText().hashCode();
        }
        return node2.getClass().getName().hashCode();
    }

    private boolean isLiteral(PsiElement node2) {
        if (node2 instanceof LeafElement) {
            IElementType elementType = ((LeafElement)node2).getElementType();
            if (this.myDuplicatesProfile.getLiterals().contains(elementType)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getNodeCost(PsiElement node2) {
        return node2 != null ? this.myDuplicatesProfile.getNodeCost(node2) : 0;
    }

    @Override
    public List<PsiElement> getNodeChildren(PsiElement node2) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        FilteringNodeIterator it = new FilteringNodeIterator(SiblingNodeIterator.create(node2.getFirstChild()), this.myNodeFilter);
        while (it.hasNext()) {
            result2.add(it.current());
            it.advance();
        }
        return result2;
    }

    @Override
    public boolean areNodesEqual(@NotNull PsiElement node1, @NotNull PsiElement node2) {
        if (node1 == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(7);
        }
        if (node2 == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(8);
        }
        return false;
    }

    @Override
    public boolean areTreesEqual(@NotNull PsiElement root1, @NotNull PsiElement root2, int discardCost) {
        if (root1 == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(9);
        }
        if (root2 == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(10);
        }
        if (root1 == root2) {
            return true;
        }
        return new DuplicatesMatchingVisitor(this, this.myNodeFilter, discardCost).match(root1, root2);
    }

    @NotNull
    public DuplicatesProfileBase getDuplicatesProfile() {
        DuplicatesProfileBase duplicatesProfileBase = this.myDuplicatesProfile;
        if (duplicatesProfileBase == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(11);
        }
        return duplicatesProfileBase;
    }

    @Override
    public boolean checkDeep(PsiElement node1, PsiElement node2) {
        return true;
    }

    @Override
    public void visitNode(@NotNull PsiElement node2) {
        FileType fileType;
        if (node2 == null) {
            NodeSpecificHasherBase.$$$reportNull$$$0(12);
        }
        Language language = null;
        if (node2 instanceof PsiFile && (fileType = ((PsiFile)node2).getFileType()) instanceof LanguageFileType) {
            language = ((LanguageFileType)fileType).getLanguage();
        }
        if (language == null) {
            language = node2.getLanguage();
        }
        if ((this.myForIndexing || this.mySettings.SELECTED_PROFILES.contains(language.getDisplayName())) && this.myDuplicatesProfile.isMyLanguage(language)) {
            this.myTreeHasher.hash(node2, this);
        }
    }

    @Override
    public void hashingFinished() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicatesProfile";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeFilter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicatesProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "areNodesEqual";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "areTreesEqual";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

