/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsBranchPopup<Repo extends Repository> {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final AbstractRepositoryManager<Repo> myRepositoryManager;
    @NotNull
    protected final DvcsSyncSettings myVcsSettings;
    @NotNull
    protected final AbstractVcs myVcs;
    @NotNull
    protected final DvcsMultiRootBranchConfig<Repo> myMultiRootBranchConfig;
    @NotNull
    protected final Repo myCurrentRepository;
    @NotNull
    protected final BranchActionGroupPopup myPopup;
    protected final boolean myInSpecificRepository;

    protected DvcsBranchPopup(@NotNull Repo currentRepository, @NotNull AbstractRepositoryManager<Repo> repositoryManager, @NotNull DvcsMultiRootBranchConfig<Repo> multiRootBranchConfig, @NotNull DvcsSyncSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition, @Nullable String dimensionKey, @NotNull DataContext dataContext) {
        if (currentRepository == null) {
            DvcsBranchPopup.$$$reportNull$$$0(0);
        }
        if (repositoryManager == null) {
            DvcsBranchPopup.$$$reportNull$$$0(1);
        }
        if (multiRootBranchConfig == null) {
            DvcsBranchPopup.$$$reportNull$$$0(2);
        }
        if (vcsSettings == null) {
            DvcsBranchPopup.$$$reportNull$$$0(3);
        }
        if (preselectActionCondition == null) {
            DvcsBranchPopup.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            DvcsBranchPopup.$$$reportNull$$$0(5);
        }
        this.myProject = currentRepository.getProject();
        this.myCurrentRepository = currentRepository;
        this.myRepositoryManager = repositoryManager;
        this.myVcs = currentRepository.getVcs();
        this.myVcsSettings = vcsSettings;
        this.myMultiRootBranchConfig = multiRootBranchConfig;
        this.myInSpecificRepository = this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC;
        String title2 = this.myInSpecificRepository ? DvcsBundle.message((String)"branch.popup.vcs.name.branches", (Object[])new Object[]{this.myVcs.getDisplayName()}) : DvcsBundle.message((String)"branch.popup.vcs.name.branches.in.repo", (Object[])new Object[]{this.myVcs.getDisplayName(), DvcsUtil.getShortRepositoryName(currentRepository)});
        this.myPopup = new BranchActionGroupPopup(title2, this.myProject, preselectActionCondition, this.createActions(), dimensionKey, dataContext);
        this.initBranchSyncPolicyIfNotInitialized();
        this.warnThatBranchesDivergedIfNeeded();
        if (this.myRepositoryManager.moreThanOneRoot()) {
            this.myPopup.addToolbarAction((AnAction)new TrackReposSynchronouslyAction(this.myVcsSettings), true);
        }
    }

    @NotNull
    public ListPopup asListPopup() {
        BranchActionGroupPopup branchActionGroupPopup = this.myPopup;
        if (branchActionGroupPopup == null) {
            DvcsBranchPopup.$$$reportNull$$$0(6);
        }
        return branchActionGroupPopup;
    }

    private void initBranchSyncPolicyIfNotInitialized() {
        if (this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.NOT_DECIDED) {
            if (this.myRepositoryManager.shouldProposeSyncControl()) {
                this.notifyAboutSyncedBranches();
                this.myVcsSettings.setSyncSetting(DvcsSyncSettings.Value.SYNC);
            } else {
                this.myVcsSettings.setSyncSetting(DvcsSyncSettings.Value.DONT_SYNC);
            }
        }
    }

    private void notifyAboutSyncedBranches() {
        VcsNotifier.getInstance(this.myProject).notify(VcsNotifier.STANDARD_NOTIFICATION.createNotification(DvcsBundle.message((String)"notification.message.branch.operations.are.executed.on.all.roots", (Object[])new Object[0]), NotificationType.INFORMATION).setDisplayId("vcs.branch.operations.are.executed.on.all.roots").addAction((AnAction)NotificationAction.create((String)DvcsBundle.message((String)"action.NotificationAction.DvcsBranchPopup.text.disable", (Object[])new Object[0]), (event, notification) -> {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, this.myVcs.getDisplayName());
            if (this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC) {
                notification.expire();
            }
        })));
    }

    @NotNull
    private ActionGroup createActions() {
        LightActionGroup popupGroup = new LightActionGroup(false);
        AbstractRepositoryManager<Repo> repositoryManager = this.myRepositoryManager;
        if (repositoryManager.moreThanOneRoot()) {
            if (this.userWantsSyncControl()) {
                this.fillWithCommonRepositoryActions(popupGroup, repositoryManager);
            } else {
                this.fillPopupWithCurrentRepositoryActions(popupGroup, this.createRepositoriesActions());
            }
        } else {
            this.fillPopupWithCurrentRepositoryActions(popupGroup, null);
        }
        popupGroup.addSeparator();
        LightActionGroup lightActionGroup = popupGroup;
        if (lightActionGroup == null) {
            DvcsBranchPopup.$$$reportNull$$$0(7);
        }
        return lightActionGroup;
    }

    protected boolean userWantsSyncControl() {
        return this.myVcsSettings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC;
    }

    protected abstract void fillWithCommonRepositoryActions(@NotNull LightActionGroup var1, @NotNull AbstractRepositoryManager<Repo> var2);

    @NotNull
    protected List<Repo> filterRepositoriesNotOnThisBranch(@NotNull String branch, @NotNull List<? extends Repo> allRepositories) {
        if (branch == null) {
            DvcsBranchPopup.$$$reportNull$$$0(8);
        }
        if (allRepositories == null) {
            DvcsBranchPopup.$$$reportNull$$$0(9);
        }
        List list2 = ContainerUtil.filter(allRepositories, repository -> !branch.equals(repository.getCurrentBranchName()));
        if (list2 == null) {
            DvcsBranchPopup.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private void warnThatBranchesDivergedIfNeeded() {
        if (this.isBranchesDiverged()) {
            this.myPopup.setWarning(DvcsBundle.message((String)"branch.popup.warning.branches.have.diverged", (Object[])new Object[0]));
        }
    }

    private boolean isBranchesDiverged() {
        return this.myRepositoryManager.moreThanOneRoot() && this.myMultiRootBranchConfig.diverged() && this.userWantsSyncControl();
    }

    @NotNull
    protected abstract LightActionGroup createRepositoriesActions();

    protected abstract void fillPopupWithCurrentRepositoryActions(@NotNull LightActionGroup var1, @Nullable LightActionGroup var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiRootBranchConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectActionCondition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/branch/DvcsBranchPopup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/branch/DvcsBranchPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "asListPopup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRepositoriesNotOnThisBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterRepositoriesNotOnThisBranch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrackReposSynchronouslyAction
    extends ToggleAction
    implements DumbAware {
        private final DvcsSyncSettings myVcsSettings;

        TrackReposSynchronouslyAction(@NotNull DvcsSyncSettings vcsSettings) {
            if (vcsSettings == null) {
                TrackReposSynchronouslyAction.$$$reportNull$$$0(0);
            }
            super(DvcsBundle.message((String)"sync.setting", (Object[])new Object[0]), DvcsBundle.message((String)"sync.setting.description", (Object[])new Object[]{VcsBundle.message((String)"vcs.generic.name", (Object[])new Object[0])}), null);
            this.myVcsSettings = vcsSettings;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                TrackReposSynchronouslyAction.$$$reportNull$$$0(1);
            }
            return this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                TrackReposSynchronouslyAction.$$$reportNull$$$0(2);
            }
            this.myVcsSettings.setSyncSetting(state ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsSettings";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dvcs/branch/DvcsBranchPopup$TrackReposSynchronouslyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MyMoreIndex {
        public static final int MAX_NUM = 8;
        public static final int DEFAULT_NUM = 5;
    }
}

