/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRepositoryManager<T extends Repository>
implements RepositoryManager<T>,
Disposable {
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final String myRepoDirName;
    @NotNull
    private final VcsRepositoryManager myGlobalRepositoryManager;

    protected AbstractRepositoryManager(@NotNull AbstractVcs vcs, @NotNull String repoDirName) {
        if (vcs == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(0);
        }
        if (repoDirName == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(1);
        }
        this.myGlobalRepositoryManager = VcsRepositoryManager.getInstance(vcs.getProject());
        this.myVcs = vcs;
        this.myRepoDirName = repoDirName;
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @RequiresBackgroundThread
    public T getRepositoryForRoot(@Nullable VirtualFile virtualFile2) {
        void root;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRoot((VirtualFile)root));
    }

    @Nullable
    public T getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRootQuick(root));
    }

    public void addExternalRepository(@NotNull VirtualFile root, @NotNull T repository) {
        if (root == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(2);
        }
        if (repository == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(3);
        }
        this.myGlobalRepositoryManager.addExternalRepository(root, (Repository)repository);
    }

    public void removeExternalRepository(@NotNull VirtualFile root) {
        if (root == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(4);
        }
        this.myGlobalRepositoryManager.removeExternalRepository(root);
    }

    public boolean isExternal(@NotNull T repository) {
        if (repository == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(5);
        }
        return this.myGlobalRepositoryManager.isExternal((Repository)repository);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @RequiresBackgroundThread
    public T getRepositoryForFile(@NotNull VirtualFile virtualFile2) {
        void file2;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (file2 == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(6);
        }
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile((VirtualFile)file2));
    }

    @Nullable
    public T getRepositoryForFileQuick(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(7);
        }
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFileQuick(file2));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @RequiresBackgroundThread
    public T getRepositoryForFile(@NotNull FilePath filePath) {
        void file2;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (file2 == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(8);
        }
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile((FilePath)file2, false));
    }

    @Nullable
    public T getRepositoryForFileQuick(@NotNull FilePath file2) {
        if (file2 == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(9);
        }
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile(file2, true));
    }

    @NotNull
    protected List<T> getRepositories(Class<T> type) {
        List list2 = ContainerUtil.findAll(this.myGlobalRepositoryManager.getRepositories(), type);
        if (list2 == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public abstract List<T> getRepositories();

    public boolean moreThanOneRoot() {
        return this.getRepositories().size() > 1;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    public void updateRepository(@Nullable VirtualFile virtualFile2) {
        void root;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        T repo = this.getRepositoryForRoot((VirtualFile)root);
        if (repo != null) {
            repo.update();
        }
    }

    public void updateAllRepositories() {
        ContainerUtil.process(this.getRepositories(), repo -> {
            repo.update();
            return true;
        });
    }

    @Nullable
    private T validateAndGetRepository(@Nullable Repository repository) {
        if (repository == null || !this.myVcs.equals((Object)repository.getVcs())) {
            return null;
        }
        return (T)((Repository)ReadAction.compute(() -> {
            VirtualFile root = repository.getRoot();
            if (root.isValid()) {
                VirtualFile vcsDir = root.findChild(this.myRepoDirName);
                return vcsDir != null && vcsDir.exists() ? repository : null;
            }
            return null;
        }));
    }

    @NotNull
    public AbstractVcs getVcs() {
        AbstractVcs abstractVcs = this.myVcs;
        if (abstractVcs == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(11);
        }
        return abstractVcs;
    }

    public boolean shouldProposeSyncControl() {
        return !MultiRootBranches.diverged(this.getRepositories());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoDirName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/repo/AbstractRepositoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/repo/AbstractRepositoryManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addExternalRepository";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeExternalRepository";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExternal";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFile";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFileQuick";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

