/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClonePathProvider {
    private static final ExtensionPointName<ClonePathProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.clonePathProvider");

    @NotNull
    public static String defaultParentDirectoryPath(@NotNull Project project, @NotNull DvcsRememberedInputs rememberedInputs) {
        if (project == null) {
            ClonePathProvider.$$$reportNull$$$0(0);
        }
        if (rememberedInputs == null) {
            ClonePathProvider.$$$reportNull$$$0(1);
        }
        for (ClonePathProvider provider2 : EP_NAME.getExtensionList()) {
            String directoryPath = provider2.getParentDirectoryPath(project, rememberedInputs);
            if (!StringUtil.isNotEmpty((String)directoryPath)) continue;
            String string = directoryPath;
            if (string == null) {
                ClonePathProvider.$$$reportNull$$$0(2);
            }
            return string;
        }
        String parentDirectory = rememberedInputs.getCloneParentDir();
        String string = StringUtil.isEmptyOrSpaces((String)parentDirectory) ? ProjectUtil.getBaseDir() : parentDirectory;
        if (string == null) {
            ClonePathProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String relativeDirectoryPathForVcsUrl(@NotNull Project project, @NotNull String vcsUrl) {
        String string;
        if (project == null) {
            ClonePathProvider.$$$reportNull$$$0(4);
        }
        if (vcsUrl == null) {
            ClonePathProvider.$$$reportNull$$$0(5);
        }
        for (ClonePathProvider provider2 : EP_NAME.getExtensionList()) {
            String directoryPath = provider2.getRelativeDirectoryPathForVcsUrl(project, vcsUrl);
            if (!StringUtil.isNotEmpty((String)directoryPath)) continue;
            String string2 = directoryPath;
            if (string2 == null) {
                ClonePathProvider.$$$reportNull$$$0(6);
            }
            return string2;
        }
        String encoded = PathUtil.getFileName((String)vcsUrl);
        try {
            string = URLUtil.decode((String)encoded);
        }
        catch (Exception e) {
            String string3 = encoded;
            if (string3 == null) {
                ClonePathProvider.$$$reportNull$$$0(8);
            }
            return string3;
        }
        if (string == null) {
            ClonePathProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public abstract String getParentDirectoryPath(@NotNull Project var1, @NotNull DvcsRememberedInputs var2);

    @Nullable
    public abstract String getRelativeDirectoryPathForVcsUrl(@NotNull Project var1, @NotNull String var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rememberedInputs";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/repo/ClonePathProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/repo/ClonePathProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultParentDirectoryPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "relativeDirectoryPathForVcsUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "defaultParentDirectoryPath";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "relativeDirectoryPathForVcsUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

