/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RunManagerConfig {
    public static final int MIN_RECENT_LIMIT = 0;
    public static final int DEFAULT_RECENT_LIMIT = 5;
    private final PropertiesComponent myPropertiesComponent;
    @NonNls
    private static final String RECENTS_LIMIT = "recentsLimit";
    @NonNls
    private static final String RESTART_REQUIRES_CONFIRMATION = "restartRequiresConfirmation";
    @NonNls
    private static final String DELETION_FROM_POPUP_REQUIRES_CONFIRMATION = "deletionFromPopupRequiresConfirmation";
    @NonNls
    private static final String STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION = "stopIncompatibleRequiresConfirmation";
    @NonNls
    private static final String RECENTS_LIMIT_KEY = "temporary.configurations.limit";

    public RunManagerConfig(@NotNull PropertiesComponent propertiesComponent) {
        if (propertiesComponent == null) {
            RunManagerConfig.$$$reportNull$$$0(0);
        }
        this.myPropertiesComponent = propertiesComponent;
    }

    public int getRecentsLimit() {
        return AdvancedSettings.getInt((String)RECENTS_LIMIT_KEY);
    }

    public void setRecentsLimit(int recentsLimit) {
        AdvancedSettings.setInt((String)RECENTS_LIMIT_KEY, (int)Math.max(0, recentsLimit));
    }

    public void migrateToRegistry() {
        String value2 = this.myPropertiesComponent.getValue(RECENTS_LIMIT);
        if (value2 != null) {
            this.setRecentsLimit(Math.max(0, StringUtil.parseInt((String)value2, (int)5)));
            this.myPropertiesComponent.setValue(RECENTS_LIMIT, null);
        }
    }

    public boolean isRestartRequiresConfirmation() {
        return this.myPropertiesComponent.getBoolean(RESTART_REQUIRES_CONFIRMATION, true);
    }

    public void setRestartRequiresConfirmation(boolean restartRequiresConfirmation) {
        this.myPropertiesComponent.setValue(RESTART_REQUIRES_CONFIRMATION, restartRequiresConfirmation, true);
    }

    public boolean isDeletionFromPopupRequiresConfirmation() {
        return this.myPropertiesComponent.getBoolean(DELETION_FROM_POPUP_REQUIRES_CONFIRMATION, true);
    }

    public void setDeletionFromPopupRequiresConfirmation(boolean deletionFromPopupRequiresConfirmation) {
        this.myPropertiesComponent.setValue(DELETION_FROM_POPUP_REQUIRES_CONFIRMATION, deletionFromPopupRequiresConfirmation, true);
    }

    public boolean isStopIncompatibleRequiresConfirmation() {
        return this.myPropertiesComponent.getBoolean(STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION, true);
    }

    public void setStopIncompatibleRequiresConfirmation(boolean stopIncompatibleRequiresConfirmation) {
        this.myPropertiesComponent.setValue(STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION, stopIncompatibleRequiresConfirmation, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesComponent", "com/intellij/execution/RunManagerConfig", "<init>"));
    }
}

