/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.execution.filters.LazyFileHyperlinkInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.io.URLUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlFilter
implements Filter,
DumbAware {
    private final Project myProject;

    public UrlFilter() {
        this(null);
    }

    public UrlFilter(Project project) {
        this.myProject = project;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            UrlFilter.$$$reportNull$$$0(0);
        }
        if (!URLUtil.canContainUrl((String)line)) {
            return null;
        }
        int textStartOffset = entireLength - line.length();
        Pattern pattern = line.contains("file://") ? URLUtil.FILE_URL_PATTERN : URLUtil.URL_PATTERN;
        Matcher m = pattern.matcher(line);
        Filter.ResultItem item = null;
        ArrayList<Filter.ResultItem> items = null;
        while (m.find()) {
            if (item == null) {
                item = new Filter.ResultItem(textStartOffset + m.start(), textStartOffset + m.end(), this.buildHyperlinkInfo(m.group()));
                continue;
            }
            if (items == null) {
                items = new ArrayList<Filter.ResultItem>(2);
                items.add(item);
            }
            items.add(new Filter.ResultItem(textStartOffset + m.start(), textStartOffset + m.end(), this.buildHyperlinkInfo(m.group())));
        }
        return items != null ? new Filter.Result(items) : (item != null ? new Filter.Result(item.getHighlightStartOffset(), item.getHighlightEndOffset(), item.getHyperlinkInfo()) : null);
    }

    @NotNull
    protected HyperlinkInfo buildHyperlinkInfo(@NotNull String url) {
        HyperlinkInfo fileHyperlinkInfo;
        if (url == null) {
            UrlFilter.$$$reportNull$$$0(1);
        }
        return (fileHyperlinkInfo = this.buildFileHyperlinkInfo(url)) != null ? fileHyperlinkInfo : new OpenUrlHyperlinkInfo(url);
    }

    @Nullable
    private HyperlinkInfo buildFileHyperlinkInfo(@NotNull String url) {
        if (url == null) {
            UrlFilter.$$$reportNull$$$0(2);
        }
        if (this.myProject != null && !url.endsWith(".html") && url.startsWith("file://")) {
            int lastValue;
            int documentLine = 0;
            int documentColumn = 0;
            int filePathEndIndex = url.length();
            int lastColonInd = url.lastIndexOf(58);
            if (lastColonInd > "file://".length() && lastColonInd < url.length() - 1 && (lastValue = StringUtil.parseInt((String)url.substring(lastColonInd + 1), (int)Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                int preLastValue;
                documentLine = lastValue - 1;
                filePathEndIndex = lastColonInd;
                int preLastColonInd = url.lastIndexOf(58, lastColonInd - 1);
                if (preLastColonInd > "file://".length() && (preLastValue = StringUtil.parseInt((String)url.substring(preLastColonInd + 1, lastColonInd), (int)Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                    documentLine = preLastValue - 1;
                    documentColumn = lastValue - 1;
                    filePathEndIndex = preLastColonInd;
                }
            }
            String filePath = url.substring("file://".length(), filePathEndIndex);
            return new FileUrlHyperlinkInfo(filePath, documentLine, documentColumn, url);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/filters/UrlFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildHyperlinkInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildFileHyperlinkInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FileUrlHyperlinkInfo
    extends LazyFileHyperlinkInfo
    implements HyperlinkWithPopupMenuInfo {
        @NotNull
        private final String myUrl;

        FileUrlHyperlinkInfo(String filePath, int documentLine, @NotNull int documentColumn, String url) {
            if (filePath == null) {
                FileUrlHyperlinkInfo.$$$reportNull$$$0(0);
            }
            if (url == null) {
                FileUrlHyperlinkInfo.$$$reportNull$$$0(1);
            }
            super(UrlFilter.this.myProject, filePath, documentLine, documentColumn);
            this.myUrl = url;
        }

        public void navigate(@NotNull Project project) {
            VirtualFile file2;
            if (project == null) {
                FileUrlHyperlinkInfo.$$$reportNull$$$0(2);
            }
            if ((file2 = this.getVirtualFile()) == null || !file2.isValid()) {
                Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"message.cannot.find.file.0", (Object[])new Object[]{StringUtil.trimMiddle((String)this.myUrl, (int)150)}), (String)IdeBundle.message((String)"title.cannot.open.file", (Object[])new Object[0]));
                return;
            }
            super.navigate(project);
        }

        @Override
        @Nullable
        public ActionGroup getPopupMenuGroup(@NotNull MouseEvent event) {
            if (event == null) {
                FileUrlHyperlinkInfo.$$$reportNull$$$0(3);
            }
            return new OpenUrlHyperlinkInfo(this.myUrl).getPopupMenuGroup(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/filters/UrlFilter$FileUrlHyperlinkInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "navigate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPopupMenuGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UrlFilterProvider
    implements ConsoleFilterProviderEx {
        public Filter @NotNull [] getDefaultFilters(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
            if (project == null) {
                UrlFilterProvider.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                UrlFilterProvider.$$$reportNull$$$0(1);
            }
            Filter[] filterArray = new Filter[]{new UrlFilter(project)};
            if (filterArray == null) {
                UrlFilterProvider.$$$reportNull$$$0(2);
            }
            return filterArray;
        }

        public Filter @NotNull [] getDefaultFilters(@NotNull Project project) {
            if (project == null) {
                UrlFilterProvider.$$$reportNull$$$0(3);
            }
            Filter[] filterArray = this.getDefaultFilters(project, GlobalSearchScope.allScope((Project)project));
            if (filterArray == null) {
                UrlFilterProvider.$$$reportNull$$$0(4);
            }
            return filterArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/filters/UrlFilter$UrlFilterProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/filters/UrlFilter$UrlFilterProvider";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultFilters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultFilters";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

