/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.VirtualConfigurationType;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class BaseExecuteBeforeRunDialog<T extends BeforeRunTask<?>>
extends DialogWrapper {
    private static final Object TEMPLATE_ROOT = new Object();
    private final Project myProject;
    private DefaultMutableTreeNode myRoot;

    public BaseExecuteBeforeRunDialog(Project project) {
        super(project, true);
        this.myProject = project;
    }

    protected void init() {
        super.init();
        this.setTitle(ExecutionBundle.message((String)"execute.before.run.debug.dialog.title", (Object[])new Object[]{this.getTargetDisplayString()}));
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myRoot = this.buildNodes();
        final Tree tree = new Tree((TreeNode)this.myRoot);
        final MyTreeCellRenderer cellRenderer = new MyTreeCellRenderer();
        tree.setCellRenderer((TreeCellRenderer)cellRenderer);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row2 = tree.getRowForLocation(e.getX(), e.getY());
                if (row2 >= 0) {
                    Rectangle rowBounds = tree.getRowBounds(row2);
                    cellRenderer.setBounds(rowBounds);
                    Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                    checkBounds.setLocation(rowBounds.getLocation());
                    if (checkBounds.contains(e.getPoint())) {
                        BaseExecuteBeforeRunDialog.toggleNode((JTree)tree, (DefaultMutableTreeNode)tree.getPathForRow(row2).getLastPathComponent());
                        e.consume();
                        tree.setSelectionRow(row2);
                    }
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TreePath treePath = tree.getLeadSelectionPath();
                    DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    BaseExecuteBeforeRunDialog.toggleNode((JTree)tree, node2);
                    e.consume();
                }
            }
        });
        BaseExecuteBeforeRunDialog.expandChecked(tree);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)400, (int)400));
        panel2.add((Component)scrollPane, "Center");
        return panel2;
    }

    private static void expandChecked(Tree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        Enumeration<? extends TreeNode> factories2 = root.children();
        ArrayList<TreeNode[]> toExpand = new ArrayList<TreeNode[]>();
        block0: while (factories2.hasMoreElements()) {
            DefaultMutableTreeNode factoryNode = (DefaultMutableTreeNode)factories2.nextElement();
            Enumeration<TreeNode> enumeration = factoryNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)enumeration.nextElement();
                Descriptor config2 = (Descriptor)node2.getUserObject();
                if (!config2.isChecked()) continue;
                toExpand.add(factoryNode.getPath());
                continue block0;
            }
        }
        for (Object[] objectArray : toExpand) {
            tree.expandPath(new TreePath(objectArray));
        }
    }

    private static void toggleNode(JTree tree, DefaultMutableTreeNode node2) {
        Descriptor descriptor2;
        descriptor2.setChecked(!(descriptor2 = (Descriptor)node2.getUserObject()).isChecked());
        if (descriptor2 instanceof GroupConfigurationDescriptor) {
            TreeUtil.treeNodeTraverser((TreeNode)node2).forEach(child2 -> ((Descriptor)((DefaultMutableTreeNode)child2).getUserObject()).setChecked(descriptor2.isChecked()));
        } else if (descriptor2 instanceof ConfigurationDescriptor) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node2.getParent();
            GroupConfigurationDescriptor groupConfigurationDescriptor = (GroupConfigurationDescriptor)parent.getUserObject();
            ThreeStateCheckBox.State state = BaseExecuteBeforeRunDialog.getStateFromChildren(parent);
            groupConfigurationDescriptor.setChecked(state == ThreeStateCheckBox.State.SELECTED);
        }
        tree.repaint();
    }

    @NotNull
    private DefaultMutableTreeNode buildNodes() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new Descriptor());
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(this.myProject);
        for (Map.Entry<ConfigurationType, Map<String, List<RunnerAndConfigurationSettings>>> entry2 : runManager.getConfigurationsGroupedByTypeAndFolder(false).entrySet()) {
            ConfigurationType type = entry2.getKey();
            Icon icon2 = type.getIcon();
            boolean selectedAll = true;
            GroupConfigurationDescriptor groupConfigurationDescriptor = new GroupConfigurationDescriptor(type, icon2);
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(groupConfigurationDescriptor);
            root.add(typeNode);
            Set addedNames = CollectionFactory.createSmallMemoryFootprintSet();
            for (List<RunnerAndConfigurationSettings> list2 : entry2.getValue().values()) {
                for (RunnerAndConfigurationSettings configuration2 : list2) {
                    String configurationName = configuration2.getName();
                    if (!addedNames.add(configurationName)) continue;
                    boolean assigned = this.isConfigurationAssigned(configuration2.getConfiguration());
                    selectedAll = selectedAll && assigned;
                    typeNode.add(new DefaultMutableTreeNode(new ConfigurationDescriptor(configuration2.getConfiguration(), assigned)));
                }
                groupConfigurationDescriptor.setChecked(selectedAll);
            }
        }
        this.buildTemplatesNode(root);
        DefaultMutableTreeNode defaultMutableTreeNode = root;
        if (defaultMutableTreeNode == null) {
            BaseExecuteBeforeRunDialog.$$$reportNull$$$0(0);
        }
        return defaultMutableTreeNode;
    }

    private void buildTemplatesNode(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(TEMPLATE_ROOT);
        root.add(node2);
        for (ConfigurationType type : ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()) {
            if (type instanceof VirtualConfigurationType) continue;
            Icon icon2 = type.getIcon();
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(new ConfigurationTypeDescriptor(type, icon2, this.isConfigurationAssigned(type)));
            node2.add(typeNode);
        }
    }

    private boolean isConfigurationAssigned(ConfigurationType type) {
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        for (ConfigurationFactory factory2 : type.getConfigurationFactories()) {
            RunnerAndConfigurationSettingsImpl settings2 = ((RunManagerImpl)runManager).getConfigurationTemplate(factory2);
            if (!this.isConfigurationAssigned(settings2.getConfiguration())) continue;
            return true;
        }
        return false;
    }

    private boolean isConfigurationAssigned(RunConfiguration configuration2) {
        for (BeforeRunTask task2 : RunManagerEx.getInstanceEx(this.myProject).getBeforeRunTasks(configuration2, this.getTaskId())) {
            if (!this.isRunning(task2)) continue;
            return true;
        }
        return false;
    }

    protected void doOKAction() {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(this.myProject);
        Enumeration<TreeNode> nodes = this.myRoot.depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)nodes.nextElement();
            Object object = node2.getUserObject();
            if (!(object instanceof Descriptor)) continue;
            Descriptor descriptor2 = (Descriptor)object;
            boolean isChecked = descriptor2.isChecked();
            if (descriptor2 instanceof ConfigurationTypeDescriptor) {
                ConfigurationTypeDescriptor typeDesc = (ConfigurationTypeDescriptor)descriptor2;
                for (ConfigurationFactory factory2 : typeDesc.getConfigurationType().getConfigurationFactories()) {
                    RunnerAndConfigurationSettingsImpl settings2 = runManager.getConfigurationTemplate(factory2);
                    this.update(settings2.getConfiguration(), isChecked, runManager);
                }
                continue;
            }
            if (!(descriptor2 instanceof ConfigurationDescriptor)) continue;
            ConfigurationDescriptor configDesc = (ConfigurationDescriptor)descriptor2;
            this.update(configDesc.getConfiguration(), isChecked, runManager);
        }
        RunManagerImpl.getInstanceImpl(this.myProject).fireBeforeRunTasksUpdated();
        this.close(0);
    }

    protected abstract String getTargetDisplayString();

    protected abstract Key<T> getTaskId();

    protected abstract boolean isRunning(T var1);

    private void update(RunConfiguration config2, boolean enabled, RunManagerImpl runManager) {
        SmartList tasks = RunManagerImplKt.doGetBeforeRunTasks(config2);
        BeforeRunTaskProvider provider2 = BeforeRunTaskProvider.getProvider((Project)this.myProject, this.getTaskId());
        if (provider2 == null) {
            return;
        }
        BeforeRunTask task2 = Objects.requireNonNull(provider2.createTask(config2));
        this.update(task2);
        task2.setEnabled(true);
        if (enabled) {
            if (!tasks.contains(task2)) {
                tasks = new SmartList(tasks);
                tasks.add(task2);
            }
        } else if (tasks.contains(task2)) {
            tasks = new SmartList(tasks);
            tasks.remove(task2);
        }
        runManager.setBeforeRunTasks(config2, (List<? extends BeforeRunTask<?>>)tasks);
    }

    protected abstract void update(@NotNull T var1);

    protected abstract void clear(T var1);

    private static ThreeStateCheckBox.State getStateFromChildren(DefaultMutableTreeNode node2) {
        boolean allEnabled = true;
        boolean anyEnabled = false;
        Enumeration<TreeNode> children2 = node2.children();
        while (children2.hasMoreElements()) {
            if (anyEnabled && !allEnabled) {
                return ThreeStateCheckBox.State.DONT_CARE;
            }
            DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)children2.nextElement();
            ConfigurationDescriptor descriptor2 = (ConfigurationDescriptor)child2.getUserObject();
            allEnabled = allEnabled && descriptor2.isChecked();
            anyEnabled = anyEnabled || descriptor2.isChecked();
        }
        if (allEnabled) {
            return ThreeStateCheckBox.State.SELECTED;
        }
        if (anyEnabled) {
            return ThreeStateCheckBox.State.DONT_CARE;
        }
        return ThreeStateCheckBox.State.NOT_SELECTED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/BaseExecuteBeforeRunDialog", "buildNodes"));
    }

    private static final class MyTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final JLabel myLabel;
        public final ThreeStateCheckBox myCheckbox = new ThreeStateCheckBox();

        MyTreeCellRenderer() {
            super(new BorderLayout());
            this.myLabel = new JLabel();
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)this.myLabel, "Center");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)value2;
            Object object = node2.getUserObject();
            this.myCheckbox.setBackground(UIUtil.getTreeBackground());
            this.setBackground(UIUtil.getTreeBackground((boolean)selected2, (boolean)true));
            Color foreground = UIUtil.getTreeForeground((boolean)selected2, (boolean)true);
            this.setForeground(foreground);
            this.myCheckbox.setForeground(foreground);
            this.myLabel.setForeground(foreground);
            if (object == TEMPLATE_ROOT) {
                this.myCheckbox.setVisible(false);
                this.myLabel.setIcon(AllIcons.General.Settings);
                this.myLabel.setText(ExecutionBundle.message((String)"run.configuration.edit.default.configuration.settings.text", (Object[])new Object[0]));
                return this;
            }
            Descriptor descriptor2 = (Descriptor)object;
            this.myCheckbox.setVisible(true);
            this.myCheckbox.setSelected(descriptor2.isChecked());
            this.myCheckbox.setEnabled(true);
            if (descriptor2 instanceof ConfigurationTypeDescriptor) {
                ConfigurationTypeDescriptor configurationTypeDescriptor = (ConfigurationTypeDescriptor)descriptor2;
                this.myLabel.setFont(tree.getFont());
                this.myLabel.setText(configurationTypeDescriptor.getConfigurationType().getDisplayName());
                this.myLabel.setIcon(configurationTypeDescriptor.getIcon());
            } else if (descriptor2 instanceof GroupConfigurationDescriptor) {
                GroupConfigurationDescriptor groupConfigurationDescriptor = (GroupConfigurationDescriptor)descriptor2;
                this.myLabel.setIcon(groupConfigurationDescriptor.getIcon());
                this.myLabel.setText(groupConfigurationDescriptor.getConfigurationType().getDisplayName());
                this.myLabel.setFont(tree.getFont());
                this.myCheckbox.setState(BaseExecuteBeforeRunDialog.getStateFromChildren(node2));
            } else if (descriptor2 instanceof ConfigurationDescriptor) {
                ConfigurationDescriptor configurationTypeDescriptor = (ConfigurationDescriptor)descriptor2;
                this.myLabel.setFont(tree.getFont());
                this.myLabel.setText(configurationTypeDescriptor.getName());
                this.myLabel.setIcon(null);
                if (((GroupConfigurationDescriptor)((DefaultMutableTreeNode)node2.getParent()).getUserObject()).isChecked()) {
                    this.myCheckbox.setSelected(true);
                }
            }
            return this;
        }
    }

    private static final class ConfigurationDescriptor
    extends Descriptor {
        private final RunConfiguration myConfiguration;

        ConfigurationDescriptor(RunConfiguration configuration2, boolean isChecked) {
            this.myConfiguration = configuration2;
            this.setChecked(isChecked);
        }

        public ConfigurationType getConfigurationFactory() {
            return this.myConfiguration.getType();
        }

        @NlsSafe
        public String getName() {
            return this.myConfiguration.getName();
        }

        public RunConfiguration getConfiguration() {
            return this.myConfiguration;
        }
    }

    private static final class GroupConfigurationDescriptor
    extends Descriptor {
        private final ConfigurationType myConfigurationType;
        private final Icon myIcon;

        private GroupConfigurationDescriptor(ConfigurationType type, Icon icon2) {
            this.myConfigurationType = type;
            this.myIcon = icon2;
        }

        private ConfigurationType getConfigurationType() {
            return this.myConfigurationType;
        }

        private Icon getIcon() {
            return this.myIcon;
        }
    }

    private static final class ConfigurationTypeDescriptor
    extends Descriptor {
        private final ConfigurationType myConfigurationType;
        private final Icon myIcon;

        ConfigurationTypeDescriptor(ConfigurationType type, Icon icon2, boolean isChecked) {
            this.myConfigurationType = type;
            this.myIcon = icon2;
            this.setChecked(isChecked);
        }

        public ConfigurationType getConfigurationType() {
            return this.myConfigurationType;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private static class Descriptor {
        private boolean myChecked;

        private Descriptor() {
        }

        public final boolean isChecked() {
            return this.myChecked;
        }

        public final void setChecked(boolean checked) {
            this.myChecked = checked;
        }
    }
}

