/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.actions;

import com.intellij.execution.ui.actions.BaseViewAction;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.content.Content;

public final class MinimizeViewAction
extends BaseViewAction {
    protected void update(AnActionEvent e, ViewContext context2, Content[] content2) {
        this.setEnabled(e, MinimizeViewAction.isEnabled(context2, content2, e.getPlace()));
        e.getPresentation().setIcon(AllIcons.Actions.MoveToButton);
    }

    protected void actionPerformed(AnActionEvent e, ViewContext context2, Content[] content2) {
        for (Content each : content2) {
            context2.findCellFor(each).minimize(each);
        }
    }

    public static boolean isEnabled(ViewContext context2, Content[] content2, String place) {
        if (!context2.isMinimizeActionEnabled() || content2.length == 0) {
            return false;
        }
        if ("debuggerTabToolbar".equals(place) || "debuggerTabPopup".equals(place)) {
            Tab tab = MinimizeViewAction.getTabFor((ViewContext)context2, (Content[])content2);
            if (tab == null) {
                return false;
            }
            return !tab.isDefault() && content2.length == 1;
        }
        return MinimizeViewAction.getTabFor((ViewContext)context2, (Content[])content2) != null;
    }
}

