/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FindAllAction
extends AnAction
implements ShortcutProvider,
DumbAware {
    public FindAllAction() {
        super(IdeBundle.messagePointer((String)"show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.messagePointer((String)"show.in.find.window.button.description", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FindAllAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        EditorSearchSession search2 = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
        e.getPresentation().setIcon(FindAllAction.getIcon(project));
        e.getPresentation().setEnabled(editor != null && project != null && search2 != null && !project.isDisposed() && search2.hasMatches() && PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FindAllAction.$$$reportNull$$$0(1);
        }
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        EditorSearchSession search2 = (EditorSearchSession)e.getRequiredData(EditorSearchSession.SESSION_KEY);
        if (project.isDisposed()) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return;
        }
        FindModel oldModel = FindManager.getInstance((Project)project).getFindInFileModel();
        FindModel newModel = oldModel.clone();
        String text2 = search2.getTextInField();
        if (StringUtil.isEmpty((String)text2)) {
            return;
        }
        newModel.setStringToFind(text2);
        FindUtil.findAllAndShow(project, file2, newModel);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        AnAction findUsages2 = ActionManager.getInstance().getAction("FindUsages");
        return findUsages2 != null ? findUsages2.getShortcutSet() : null;
    }

    @NotNull
    private static Icon getIcon(@Nullable Project project) {
        ToolWindowManager toolWindowManager;
        ToolWindowManager toolWindowManager2 = toolWindowManager = project != null ? ToolWindowManager.getInstance((Project)project) : null;
        if (toolWindowManager != null) {
            Icon icon2 = toolWindowManager.getLocationIcon("Find", AllIcons.General.Pin_tab);
            if (icon2 == null) {
                FindAllAction.$$$reportNull$$$0(2);
            }
            return icon2;
        }
        Icon icon3 = AllIcons.General.Pin_tab;
        if (icon3 == null) {
            FindAllAction.$$$reportNull$$$0(3);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/FindAllAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/FindAllAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

