/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.PingEDT;
import com.intellij.find.actions.ResolverKt;
import com.intellij.find.actions.ShowTargetUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesParameters;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.find.actions.TargetVariant;
import com.intellij.find.actions.UsageListCellRenderer;
import com.intellij.find.actions.UsageVariantHandler;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesHandlerUi;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.ShowUsageViewSettings;
import com.intellij.usages.ShowUsagesSettings;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearchPresentation;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ShowUsagesAction
extends AnAction
implements PopupAction,
HintManagerImpl.ActionToIgnore {
    public static final String ID = "ShowUsages";
    private static final String DIMENSION_SERVICE_KEY = "ShowUsagesActions.dimensionServiceKey";
    private static int ourPopupDelayTimeout = 300;

    public ShowUsagesAction() {
        this.setInjectedContext(true);
    }

    public static int getUsagesPageSize() {
        return Math.max(1, AdvancedSettings.getInt((String)"ide.usages.page.size"));
    }

    public void update(@NotNull AnActionEvent e) {
        Object[] usageTargets;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(0);
        }
        FindUsagesInFileAction.updateFindUsagesAction(e);
        if (e.getPresentation().isEnabled() && (usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY)) != null && !(ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget)) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ShowUsagesActionState state = ShowUsagesAction.getState(project);
        Runnable continuation = state.continuation;
        if (continuation != null) {
            state.continuation = null;
            ShowUsagesAction.hideHints();
            continuation.run();
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.usages");
        DataContext dataContext = e.getDataContext();
        ShowUsagesAction.showUsages(project, dataContext, ResolverKt.allTargets(dataContext));
    }

    @ApiStatus.Internal
    public static void showUsages(@NotNull Project project, @NotNull DataContext dataContext, @NotNull @NotNull List<? extends @NotNull TargetVariant> targetVariants) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            ShowUsagesAction.$$$reportNull$$$0(3);
        }
        if (targetVariants == null) {
            ShowUsagesAction.$$$reportNull$$$0(4);
        }
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        SearchScope searchScope2 = FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName());
        SlowOperations.allowSlowOperations(() -> ResolverKt.findShowUsages(project, dataContext, targetVariants, FindBundle.message("show.usages.ambiguous.title", new Object[0]), ShowUsagesAction.createVariantHandler(project, editor, popupPosition, searchScope2)));
    }

    @NotNull
    private static UsageVariantHandler createVariantHandler(final @NotNull Project project, final @Nullable Editor editor, final @NotNull RelativePoint popupPosition, final @NotNull SearchScope searchScope2) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(5);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(6);
        }
        if (searchScope2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(7);
        }
        return new UsageVariantHandler(){

            @Override
            public void handleTarget(@NotNull SearchTarget target2) {
                if (target2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowTargetUsagesActionHandler.showUsages(project, searchScope2, target2, ShowUsagesParameters.initial(project, editor, popupPosition));
            }

            @Override
            public void handlePsi(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ShowUsagesAction.startFindUsages(element2, popupPosition, editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleTarget";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePsi";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @ApiStatus.Internal
    public static void showUsages(@NotNull Project project, @NotNull DataContext dataContext, @NotNull RelativePoint popupPosition, @NotNull SearchTarget target2) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(8);
        }
        if (dataContext == null) {
            ShowUsagesAction.$$$reportNull$$$0(9);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(10);
        }
        if (target2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(11);
        }
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        SearchScope searchScope2 = FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName());
        ShowTargetUsagesActionHandler.showUsages(project, searchScope2, target2, ShowUsagesParameters.initial(project, editor, popupPosition));
    }

    private static void hideHints() {
        HintManager.getInstance().hideHints(2, false, false);
    }

    public static void startFindUsages(@NotNull PsiElement element2, @NotNull RelativePoint popupPosition, @Nullable Editor editor) {
        Project project;
        FindUsagesManager findUsagesManager;
        FindUsagesHandler handler2;
        if (element2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(12);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(13);
        }
        if ((handler2 = (findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)(project = element2.getProject()))).getFindUsagesManager()).getFindUsagesHandler(element2, FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS)) == null) {
            return;
        }
        FindUsagesOptions options2 = handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        ShowUsagesAction.showElementUsages(ShowUsagesParameters.initial(project, editor, popupPosition), ShowUsagesAction.createActionHandler(handler2, options2));
    }

    private static void rulesChanged(@NotNull UsageViewImpl usageView, @NotNull PingEDT pingEDT, JBPopup popup2) {
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(14);
        }
        if (pingEDT == null) {
            ShowUsagesAction.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                usageView.waitForUpdateRequestsCompletion();
                if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                    pingEDT.ping();
                }
            }
        }));
    }

    @NotNull
    private static ShowUsagesActionHandler createActionHandler(final @NotNull FindUsagesHandlerBase handler2, final @NotNull FindUsagesOptions options2) {
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(16);
        }
        if (options2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(17);
        }
        final PsiElement[] primaryElements = handler2.getPrimaryElements();
        final PsiElement[] secondaryElements = handler2.getSecondaryElements();
        return new ShowUsagesActionHandler(){

            @Override
            public boolean isValid() {
                return handler2.getPsiElement().isValid();
            }

            @Override
            @NotNull
            public UsageSearchPresentation getPresentation() {
                return new UsageSearchPresentation(){

                    @Nls
                    @NotNull
                    public String getSearchString() {
                        ItemPresentation itemPresentation;
                        PsiElement element2 = handler2.getPsiElement();
                        HtmlBuilder builder2 = new HtmlBuilder();
                        builder2.append(StringUtil.capitalize((String)UsageViewUtil.getType(element2))).nbsp().append((HtmlChunk)HtmlChunk.text((String)UsageViewUtil.getLongName(element2)).bold());
                        if (element2 instanceof NavigationItem && (itemPresentation = ((NavigationItem)element2).getPresentation()) != null && StringUtil.isNotEmpty((String)itemPresentation.getLocationString())) {
                            builder2.nbsp().append((HtmlChunk)HtmlChunk.text((String)itemPresentation.getLocationString()).wrapWith("font").attr("color", "#" + ColorUtil.toHex((Color)SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor())));
                        }
                        String string = builder2.toString();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    @Nls
                    @NotNull
                    public String getSearchOptions() {
                        String string = options2.generateUsagesString();
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/find/actions/ShowUsagesAction$2$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getSearchString";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getSearchOptions";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }

            @Override
            @NotNull
            public UsageSearcher createUsageSearcher() {
                UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(handler2, primaryElements, secondaryElements, options2);
                if (usageSearcher == null) {
                    2.$$$reportNull$$$0(0);
                }
                return usageSearcher;
            }

            @Override
            @NotNull
            public SearchScope getSelectedScope() {
                SearchScope searchScope2 = options2.searchScope;
                if (searchScope2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return searchScope2;
            }

            @NotNull
            public GlobalSearchScope getMaximalScope() {
                GlobalSearchScope globalSearchScope = FindUsagesManager.getMaximalScope(handler2);
                if (globalSearchScope == null) {
                    2.$$$reportNull$$$0(2);
                }
                return globalSearchScope;
            }

            @Override
            public ShowUsagesActionHandler showDialog() {
                FindUsagesOptions newOptions = ShowUsagesAction.showDialog(handler2);
                if (newOptions == null) {
                    return null;
                }
                return ShowUsagesAction.createActionHandler(handler2, newOptions);
            }

            @Override
            public void findUsages() {
                Project project = handler2.getProject();
                FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
                findUsagesManager.findUsages(handler2.getPrimaryElements(), handler2.getSecondaryElements(), handler2, options2, FindSettings.getInstance().isSkipResultsWithOneUsage());
            }

            @Override
            @NotNull
            public ShowUsagesActionHandler withScope(@NotNull SearchScope searchScope2) {
                if (searchScope2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                FindUsagesOptions newOptions = options2.clone();
                newOptions.searchScope = searchScope2;
                ShowUsagesActionHandler showUsagesActionHandler = ShowUsagesAction.createActionHandler(handler2, newOptions);
                if (showUsagesActionHandler == null) {
                    2.$$$reportNull$$$0(4);
                }
                return showUsagesActionHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createUsageSearcher";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedScope";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMaximalScope";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$2";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "withScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "withScope";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    static void showElementUsages(final @NotNull ShowUsagesParameters parameters2, final @NotNull ShowUsagesActionHandler actionHandler2) {
        PsiReference reference2;
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(18);
        }
        if (actionHandler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = parameters2.project;
        Editor editor = parameters2.editor;
        UsageViewImpl usageView = ShowUsagesAction.createUsageView(project);
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor)) != null) {
            UsageInfo2UsageAdapter origin = new UsageInfo2UsageAdapter(new UsageInfo(reference2));
            usageView.setOriginUsage((Usage)origin);
        }
        SearchScope searchScope2 = actionHandler2.getSelectedScope();
        AtomicInteger outOfScopeUsages = new AtomicInteger();
        AtomicBoolean manuallyResized = new AtomicBoolean();
        ShowUsagesTable table = new ShowUsagesTable(new ShowUsagesTableCellRenderer(usageView, outOfScopeUsages, searchScope2), (UsageView)usageView);
        AsyncProcessIcon processIcon = new AsyncProcessIcon("xxx");
        TitlePanel statusPanel = new TitlePanel();
        statusPanel.add((Component)processIcon, (Object)"East");
        ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, new ArrayList());
        ArrayList usages = new ArrayList();
        LinkedHashSet visibleUsages = new LinkedHashSet();
        table.setTableModel((List<UsageNode>)new SmartList((Object)new StringNode(UsageViewBundle.message((String)"progress.searching", (Object[])new Object[0]))));
        Runnable itemChosenCallback = table.prepareTable(ShowUsagesAction.showMoreUsagesRunnable(parameters2, actionHandler2), ShowUsagesAction.showUsagesInMaximalScopeRunnable(parameters2, actionHandler2));
        AbstractPopup popup2 = ShowUsagesAction.createUsagePopup(usageView, (JTable)((Object)table), itemChosenCallback, statusPanel, parameters2, actionHandler2);
        popup2.addResizeListener(() -> manuallyResized.set(true), popup2);
        ProgressIndicatorBase indicator2 = new ProgressIndicatorBase();
        if (!popup2.isDisposed()) {
            Disposer.register((Disposable)popup2, (Disposable)usageView);
            Disposer.register((Disposable)popup2, () -> ((ProgressIndicator)indicator2).cancel());
            EdtScheduledExecutorService.getInstance().schedule(() -> {
                if (!usageView.isDisposed()) {
                    ShowUsagesAction.showPopupIfNeedTo(popup2, parameters2.popupPosition);
                }
            }, (long)ourPopupDelayTimeout, TimeUnit.MILLISECONDS);
        }
        UsageNode USAGES_OUTSIDE_SCOPE_NODE = new UsageNode(null, table.USAGES_OUTSIDE_SCOPE_SEPARATOR);
        UsageNode MORE_USAGES_SEPARATOR_NODE = new UsageNode(null, table.MORE_USAGES_SEPARATOR);
        PingEDT pingEDT = new PingEDT("Rebuild popup in EDT", () -> popup2.isDisposed(), 100, () -> {
            boolean hasOutsideScopeUsages;
            ArrayList copy2;
            if (popup2.isDisposed()) {
                return;
            }
            ArrayList<UsageNode> nodes = new ArrayList<UsageNode>(usages.size());
            List list2 = usages;
            synchronized (list2) {
                if (!(popup2.isVisible() || !usages.isEmpty() && ShowUsagesAction.showPopupIfNeedTo(popup2, parameters2.popupPosition))) {
                    return;
                }
                ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, nodes);
                copy2 = new ArrayList(usages);
            }
            boolean shouldShowMoreSeparator = copy2.contains(table.MORE_USAGES_SEPARATOR);
            if (shouldShowMoreSeparator) {
                nodes.add(MORE_USAGES_SEPARATOR_NODE);
            }
            if ((hasOutsideScopeUsages = copy2.contains(table.USAGES_OUTSIDE_SCOPE_SEPARATOR)) && !shouldShowMoreSeparator) {
                nodes.add(USAGES_OUTSIDE_SCOPE_NODE);
            }
            ArrayList<UsageNode> data2 = new ArrayList<UsageNode>(nodes);
            int filteredOutCount = ShowUsagesAction.getFilteredOutNodeCount(copy2, usageView);
            if (filteredOutCount != 0) {
                DefaultActionGroup filteringActions = popup2.getUserData(DefaultActionGroup.class);
                if (filteringActions == null) {
                    return;
                }
                final List unselectedActions = Arrays.stream(filteringActions.getChildren(null)).filter(action2 -> action2 instanceof ToggleAction).map(action2 -> (ToggleAction)action2).filter(ta -> !ta.isSelected(ShowUsagesAction.fakeEvent(ta))).filter(ta -> !StringUtil.isEmpty((String)ta.getTemplatePresentation().getText())).collect(Collectors.toList());
                data2.add(new FilteredOutUsagesNode(table.USAGES_FILTERED_OUT_SEPARATOR, UsageViewBundle.message((String)"usages.were.filtered.out", (Object[])new Object[]{filteredOutCount}), UsageViewBundle.message((String)"usages.were.filtered.out.tooltip", (Object[])new Object[0])){

                    @Override
                    public void onSelected() {
                        ShowUsagesAction.toggleFilters(unselectedActions);
                        ShowUsagesAction.showElementUsages(parameters2, actionHandler2);
                    }
                });
            }
            data2.sort(new UsageNodeComparator(table));
            boolean hasMore = shouldShowMoreSeparator || hasOutsideScopeUsages;
            int totalCount = copy2.size();
            int visibleCount = totalCount - filteredOutCount;
            statusPanel.setText(ShowUsagesAction.getStatusString(!processIcon.isDisposed(), hasMore, visibleCount, totalCount));
            ShowUsagesAction.rebuildTable(usageView, data2, table, popup2, parameters2.popupPosition, parameters2.minWidth, manuallyResized);
        });
        MessageBusConnection messageBusConnection2 = project.getMessageBus().connect((Disposable)usageView);
        messageBusConnection2.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, () -> ShowUsagesAction.rulesChanged(usageView, pingEDT, popup2));
        Processor collect2 = usage -> {
            if (!UsageViewManagerImpl.isInScope((Usage)usage, (SearchScope)searchScope2)) {
                if (outOfScopeUsages.getAndIncrement() == 0) {
                    visibleUsages.add(USAGES_OUTSIDE_SCOPE_NODE.getUsage());
                    usages.add(table.USAGES_OUTSIDE_SCOPE_SEPARATOR);
                }
                return true;
            }
            List list2 = usages;
            synchronized (list2) {
                if (visibleUsages.size() >= parameters2.maxUsages) {
                    return false;
                }
                UsageNode nodes = (UsageNode)ReadAction.compute(() -> usageView.doAppendUsage(usage));
                usages.add(usage);
                if (nodes != null) {
                    visibleUsages.add(nodes.getUsage());
                    boolean continueSearch = true;
                    if (visibleUsages.size() == parameters2.maxUsages) {
                        visibleUsages.add(MORE_USAGES_SEPARATOR_NODE.getUsage());
                        usages.add(table.MORE_USAGES_SEPARATOR);
                        continueSearch = false;
                    }
                    pingEDT.ping();
                    return continueSearch;
                }
            }
            return true;
        };
        UsageSearcher usageSearcher = actionHandler2.createUsageSearcher();
        FindUsagesManager.startProcessUsages(indicator2, project, usageSearcher, (Processor<? super Usage>)collect2, () -> ApplicationManager.getApplication().invokeLater(() -> {
            Disposer.dispose((Disposable)processIcon);
            Container parent = processIcon.getParent();
            if (parent != null) {
                parent.remove((Component)processIcon);
                parent.repaint();
            }
            pingEDT.ping();
            List list2 = usages;
            synchronized (list2) {
                if (visibleUsages.isEmpty()) {
                    if (usages.isEmpty()) {
                        String hint = UsageViewBundle.message((String)"no.usages.found.in", (Object[])new Object[]{searchScope2.getDisplayName()});
                        ShowUsagesAction.hint(false, hint, parameters2, actionHandler2);
                        ShowUsagesAction.cancel(popup2);
                    }
                } else if (visibleUsages.size() == 1) {
                    if (usages.size() == 1) {
                        Usage usage = (Usage)visibleUsages.iterator().next();
                        if (usage == table.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                            String hint = UsageViewManagerImpl.outOfScopeMessage((int)outOfScopeUsages.get(), (SearchScope)searchScope2);
                            ShowUsagesAction.hint(true, hint, parameters2, actionHandler2);
                        } else {
                            String hint = UsageViewBundle.message((String)"show.usages.only.usage", (Object[])new Object[]{searchScope2.getDisplayName()});
                            ShowUsagesAction.navigateAndHint(usage, hint, parameters2, actionHandler2);
                        }
                        ShowUsagesAction.cancel(popup2);
                    } else {
                        assert (usages.size() > 1) : usages;
                        Usage visibleUsage = (Usage)visibleUsages.iterator().next();
                        if (ShowUsagesAction.areAllUsagesInOneLine(visibleUsage, usages)) {
                            String hint = UsageViewBundle.message((String)"all.usages.are.in.this.line", (Object[])new Object[]{usages.size(), searchScope2.getDisplayName()});
                            ShowUsagesAction.navigateAndHint(visibleUsage, hint, parameters2, actionHandler2);
                            ShowUsagesAction.cancel(popup2);
                        }
                    }
                }
            }
        }, project.getDisposed()));
    }

    private static void toggleFilters(@NotNull List<? extends ToggleAction> unselectedActions) {
        if (unselectedActions == null) {
            ShowUsagesAction.$$$reportNull$$$0(20);
        }
        for (ToggleAction toggleAction : unselectedActions) {
            toggleAction.actionPerformed(ShowUsagesAction.fakeEvent(toggleAction));
        }
    }

    @NotNull
    private static AnActionEvent fakeEvent(@NotNull ToggleAction action2) {
        if (action2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(21);
        }
        return new AnActionEvent(null, DataContext.EMPTY_CONTEXT, "", action2.getTemplatePresentation(), ActionManager.getInstance(), 0);
    }

    @NotNull
    private static UsageViewImpl createUsageView(@NotNull Project project) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(22);
        }
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        usageViewPresentation.setDetachedMode(true);
        return new UsageViewImpl(project, usageViewPresentation, UsageTarget.EMPTY_ARRAY, null){

            @NotNull
            public UsageViewSettings getUsageViewSettings() {
                ShowUsageViewSettings showUsageViewSettings = ShowUsagesSettings.getInstance().getState();
                if (showUsageViewSettings == null) {
                    4.$$$reportNull$$$0(0);
                }
                return showUsageViewSettings;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$4", "getUsageViewSettings"));
            }
        };
    }

    private static boolean showPopupIfNeedTo(@NotNull JBPopup popup2, @NotNull RelativePoint popupPosition) {
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(23);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(24);
        }
        if (!popup2.isDisposed() && !popup2.isVisible()) {
            popup2.show(popupPosition);
            return true;
        }
        return false;
    }

    @NotNull
    private static JComponent createHintComponent(@NotNull @NlsContexts.HintText String secondInvocationTitle, boolean isWarning, @NotNull JComponent button4) {
        if (secondInvocationTitle == null) {
            ShowUsagesAction.$$$reportNull$$$0(25);
        }
        if (button4 == null) {
            ShowUsagesAction.$$$reportNull$$$0(26);
        }
        JComponent label2 = HintUtil.createInformationLabel(secondInvocationTitle);
        if (isWarning) {
            label2.setBackground(MessageType.WARNING.getPopupBackground());
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        button4.setBackground(label2.getBackground());
        panel2.setBackground(label2.getBackground());
        label2.setOpaque(false);
        label2.setBorder(null);
        panel2.setBorder(HintUtil.createHintBorder());
        panel2.add((Component)label2, "Center");
        panel2.add((Component)button4, "East");
        JPanel jPanel2 = panel2;
        if (jPanel2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(27);
        }
        return jPanel2;
    }

    @NotNull
    private static InplaceButton createSettingsButton(@NotNull Project project, @NotNull Runnable cancelAction, @NotNull Runnable showDialogAndFindUsagesRunnable) {
        KeyboardShortcut shortcut;
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(28);
        }
        if (cancelAction == null) {
            ShowUsagesAction.$$$reportNull$$$0(29);
        }
        if (showDialogAndFindUsagesRunnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(30);
        }
        String tooltip2 = (shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut()) == null ? FindBundle.message("show.usages.settings.tooltip", new Object[0]) : FindBundle.message("show.usages.settings.tooltip.shortcut", KeymapUtil.getShortcutText((Shortcut)shortcut));
        return new InplaceButton(tooltip2, AllIcons.General.Settings, __ -> {
            ApplicationManager.getApplication().invokeLater(showDialogAndFindUsagesRunnable, project.getDisposed());
            cancelAction.run();
        });
    }

    @Nullable
    private static FindUsagesOptions showDialog(@NotNull FindUsagesHandlerBase handler2) {
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(31);
        }
        UIEventLogger.ShowUsagesPopupShowSettings.log(handler2.getProject());
        AbstractFindUsagesDialog dialog2 = handler2 instanceof FindUsagesHandlerUi ? ((FindUsagesHandlerUi)((Object)handler2)).getFindUsagesDialog(false, false, false) : FindUsagesHandler.createDefaultFindUsagesDialog(false, false, false, handler2);
        if (dialog2.showAndGet()) {
            dialog2.calcFindUsagesOptions();
            return handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        }
        return null;
    }

    @NotNull
    private static AbstractPopup createUsagePopup(@NotNull UsageViewImpl usageView, @NotNull JTable table, @NotNull Runnable itemChoseCallback, final @NotNull TitlePanel statusPanel, final @NotNull ShowUsagesParameters parameters2, final @NotNull ShowUsagesActionHandler actionHandler2) {
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(32);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(33);
        }
        if (itemChoseCallback == null) {
            ShowUsagesAction.$$$reportNull$$$0(34);
        }
        if (statusPanel == null) {
            ShowUsagesAction.$$$reportNull$$$0(35);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(36);
        }
        if (actionHandler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(37);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = parameters2.project;
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(table);
        String title2 = actionHandler2.getPresentation().getSearchString();
        builder2.setTitle(XmlStringUtil.wrapInHtml((CharSequence)("<body><nobr>" + title2 + "</nobr></body>"))).setAdText(ShowUsagesActionHandler.getSecondInvocationHint(actionHandler2)).setMovable(true).setResizable(true).setItemChoosenCallback(itemChoseCallback).setCancelKeyEnabled(true).setDimensionServiceKey(DIMENSION_SERVICE_KEY);
        final AtomicReference<AbstractPopup> popupRef = new AtomicReference<AbstractPopup>();
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel((JBPopup)popupRef.get());
                    ShowUsagesAction.showDialogAndRestart(parameters2, actionHandler2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$5", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        if ((shortcut = ShowUsagesAction.getShowUsagesShortcut()) != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel((JBPopup)popupRef.get());
                    ShowUsagesAction.showUsagesInMaximalScope(parameters2, actionHandler2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$6", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        ActiveComponent statusComponent = new ActiveComponent(){

            public void setActive(boolean active) {
                statusPanel.setActive(active);
            }

            @NotNull
            public JComponent getComponent() {
                TitlePanel titlePanel = statusPanel;
                if (titlePanel == null) {
                    7.$$$reportNull$$$0(0);
                }
                return titlePanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$7", "getComponent"));
            }
        };
        DefaultActionGroup pinGroup = new DefaultActionGroup();
        ActiveComponent pin = ShowUsagesAction.createPinButton(project, popupRef, pinGroup, table, actionHandler2::findUsages);
        builder2.setCommandButton((ActiveComponent)new CompositeActiveComponent(statusComponent, pin));
        DefaultActionGroup filteringGroup = new DefaultActionGroup();
        usageView.addFilteringActions(filteringGroup);
        filteringGroup.add(ActionManager.getInstance().getAction("UsageGrouping.FileStructure"));
        JPanel northPanel = new JPanel(new GridBagLayout());
        GridBag gc = new GridBag().nextLine();
        ActionToolbar actionToolbar = ShowUsagesAction.createActionToolbar(table, filteringGroup);
        JComponent toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setOpaque(false);
        northPanel.add((Component)toolbarComponent, gc.next());
        ScopeChooserCombo scopeChooserCombo = new ScopeChooserCombo(project, false, false, actionHandler2.getSelectedScope().getDisplayName());
        ComboBox<ScopeDescriptor> scopeComboBox = scopeChooserCombo.getComboBox();
        scopeComboBox.setMinimumAndPreferredWidth(JBUIScale.scale((int)200));
        scopeComboBox.addItemListener(event -> {
            SearchScope scope2;
            if (event.getStateChange() == 1 && (scope2 = scopeChooserCombo.getSelectedScope()) != null) {
                ShowUsagesAction.cancel((JBPopup)popupRef.get());
                ShowUsagesAction.showElementUsages(parameters2, actionHandler2.withScope(scope2));
            }
        });
        scopeComboBox.putClientProperty((Object)"JComboBox.isBorderless", (Object)Boolean.TRUE);
        scopeChooserCombo.setButtonVisible(false);
        northPanel.add((Component)((Object)scopeChooserCombo), gc.next());
        northPanel.add((Component)new Box.Filler((Dimension)JBUI.size((int)10, (int)0), (Dimension)JBUI.size((int)10, (int)0), (Dimension)JBUI.size((int)Short.MAX_VALUE, (int)0)), gc.next().weightx(1.0).fillCellHorizontally());
        DefaultActionGroup settingsGroup = new DefaultActionGroup(new AnAction[]{new SettingsAction(project, () -> ShowUsagesAction.cancel((JBPopup)popupRef.get()), ShowUsagesAction.showDialogAndRestartRunnable(parameters2, actionHandler2))});
        actionToolbar = ShowUsagesAction.createActionToolbar(table, settingsGroup);
        toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setOpaque(false);
        JLabel optionsLabel = new JLabel(actionHandler2.getPresentation().getSearchOptions());
        northPanel.add((Component)optionsLabel, gc.next());
        northPanel.add((Component)toolbarComponent, gc.next());
        builder2.setNorthComponent((JComponent)northPanel);
        PopupUpdateProcessor processor2 = new PopupUpdateProcessor(usageView.getProject()){

            public void updatePopup(Object lookupItemObject) {
            }
        };
        builder2.addListener((JBPopupListener)processor2);
        popupRef.set((AbstractPopup)builder2.createPopup());
        JComponent content2 = popupRef.get().getContent();
        Disposer.register((Disposable)popupRef.get(), (Disposable)scopeChooserCombo);
        CaptionPanel caption = popupRef.get().getTitle();
        if (caption instanceof TitlePanel) {
            TitlePanel titlePanel = (TitlePanel)caption;
            titlePanel.getLabel().setHorizontalAlignment(2);
            titlePanel.obeyPreferredWidth(WindowStateService.getInstance().getSize(DIMENSION_SERVICE_KEY) == null);
        }
        parameters2.minWidth.set(-1);
        for (AnAction action2 : filteringGroup.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        for (AnAction action2 : pinGroup.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        popupRef.get().setUserData(Collections.singletonList(filteringGroup));
        AbstractPopup abstractPopup = popupRef.get();
        if (abstractPopup == null) {
            ShowUsagesAction.$$$reportNull$$$0(38);
        }
        return abstractPopup;
    }

    @NotNull
    private static ActionToolbar createActionToolbar(@NotNull JTable table, @NotNull DefaultActionGroup group2) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(39);
        }
        if (group2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(40);
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ShowUsagesPopupToolbar", (ActionGroup)group2, true);
        actionToolbar.setTargetComponent((JComponent)table);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        ActionToolbar actionToolbar2 = actionToolbar;
        if (actionToolbar2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(41);
        }
        return actionToolbar2;
    }

    @NotNull
    private static ActiveComponent createPinButton(@NotNull Project project, final @NotNull AtomicReference<AbstractPopup> popupRef, @NotNull DefaultActionGroup pinGroup, @NotNull JTable table, final @NotNull Runnable findUsagesRunnable) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(42);
        }
        if (popupRef == null) {
            ShowUsagesAction.$$$reportNull$$$0(43);
        }
        if (pinGroup == null) {
            ShowUsagesAction.$$$reportNull$$$0(44);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(45);
        }
        if (findUsagesRunnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(46);
        }
        Icon icon2 = ToolWindowManager.getInstance((Project)project).getLocationIcon("Find", AllIcons.General.Pin_tab);
        AnAction pinAction = new AnAction(IdeBundle.messagePointer((String)"show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.messagePointer((String)"show.in.find.window.button.pin.description", (Object[])new Object[0]), icon2){
            {
                super(arg0, arg1, arg2);
                AnAction action2 = ActionManager.getInstance().getAction("FindUsages");
                this.setShortcutSet(action2.getShortcutSet());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                ShowUsagesAction.hideHints();
                ShowUsagesAction.cancel((JBPopup)popupRef.get());
                findUsagesRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$9", "actionPerformed"));
            }
        };
        pinGroup.add(pinAction);
        ActionToolbar pinToolbar = ShowUsagesAction.createActionToolbar(table, pinGroup);
        final JComponent pinToolBar = pinToolbar.getComponent();
        pinToolBar.setBorder(null);
        pinToolBar.setOpaque(false);
        return new ActiveComponent.Adapter(){

            @NotNull
            public JComponent getComponent() {
                JComponent jComponent = pinToolBar;
                if (jComponent == null) {
                    10.$$$reportNull$$$0(0);
                }
                return jComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$10", "getComponent"));
            }
        };
    }

    private static void cancel(@Nullable JBPopup popup2) {
        if (popup2 != null) {
            popup2.cancel();
        }
    }

    @Nls
    @NotNull
    private static String getStatusString(boolean findUsagesInProgress, boolean hasMore, int visibleCount, int totalCount) {
        if (findUsagesInProgress || hasMore) {
            String string = UsageViewBundle.message((String)"showing.0.usages", (Object[])new Object[]{visibleCount - (hasMore ? 1 : 0)});
            if (string == null) {
                ShowUsagesAction.$$$reportNull$$$0(47);
            }
            return string;
        }
        if (visibleCount != totalCount) {
            String string = UsageViewBundle.message((String)"showing.0.of.1.usages", (Object[])new Object[]{visibleCount, totalCount});
            if (string == null) {
                ShowUsagesAction.$$$reportNull$$$0(48);
            }
            return string;
        }
        String string = UsageViewBundle.message((String)"found.0.usages", (Object[])new Object[]{totalCount});
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(49);
        }
        return string;
    }

    @Nls
    @NotNull
    private static String suggestSecondInvocation(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String text2, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String hint) {
        if (text2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(50);
        }
        HtmlBuilder builder2 = new HtmlBuilder().append(text2);
        if (hint != null) {
            builder2.br().append((HtmlChunk)HtmlChunk.text((String)hint).wrapWith("small"));
        }
        String string = builder2.wrapWithHtmlBody().toString();
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(51);
        }
        return string;
    }

    @Nullable
    static KeyboardShortcut getShowUsagesShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(ID);
    }

    private static int getFilteredOutNodeCount(@NotNull List<? extends Usage> usages, @NotNull UsageViewImpl usageView) {
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(52);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(53);
        }
        return (int)usages.stream().filter(usage -> !usageView.isVisible(usage)).count();
    }

    private static int getUsageOffset(@NotNull Usage usage) {
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(54);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return -1;
        }
        PsiElement element2 = ((UsageInfo2UsageAdapter)usage).getElement();
        if (element2 == null) {
            return -1;
        }
        return element2.getTextRange().getStartOffset();
    }

    private static boolean areAllUsagesInOneLine(@NotNull Usage visibleUsage, @NotNull List<? extends Usage> usages) {
        Editor editor;
        if (visibleUsage == null) {
            ShowUsagesAction.$$$reportNull$$$0(55);
        }
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(56);
        }
        if ((editor = ShowUsagesAction.getEditorFor(visibleUsage)) == null) {
            return false;
        }
        int offset = ShowUsagesAction.getUsageOffset(visibleUsage);
        if (offset == -1) {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        for (Usage usage : usages) {
            Editor otherEditor = ShowUsagesAction.getEditorFor(usage);
            if (otherEditor != editor) {
                return false;
            }
            int otherOffset = ShowUsagesAction.getUsageOffset(usage);
            if (otherOffset == -1) {
                return false;
            }
            int otherLine = otherEditor.getDocument().getLineNumber(otherOffset);
            if (otherLine == lineNumber) continue;
            return false;
        }
        return true;
    }

    private static int calcMaxWidth(@NotNull JTable table) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(57);
        }
        int colsNum = table.getColumnModel().getColumnCount();
        int totalWidth = 0;
        for (int col = 0; col < colsNum - 1; ++col) {
            TableColumn column2 = table.getColumnModel().getColumn(col);
            int preferred = column2.getPreferredWidth();
            int width = Math.max(preferred, ShowUsagesAction.columnMaxWidth(table, col));
            totalWidth += width;
            column2.setMinWidth(width);
            column2.setMaxWidth(width);
            column2.setWidth(width);
            column2.setPreferredWidth(width);
        }
        return totalWidth += ShowUsagesAction.columnMaxWidth(table, colsNum - 1);
    }

    private static int columnMaxWidth(@NotNull JTable table, int col) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(58);
        }
        TableColumn column2 = table.getColumnModel().getColumn(col);
        int width = 0;
        for (int row2 = 0; row2 < table.getRowCount(); ++row2) {
            Component component2 = table.prepareRenderer(column2.getCellRenderer(), row2, col);
            int rendererWidth = component2.getPreferredSize().width;
            width = Math.max(width, rendererWidth + table.getIntercellSpacing().width);
        }
        return width;
    }

    private static void rebuildTable(@NotNull UsageViewImpl usageView, @NotNull List<UsageNode> data2, @NotNull ShowUsagesTable table, @Nullable AbstractPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, @NotNull AtomicBoolean manuallyResized) {
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(59);
        }
        if (data2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(60);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(61);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(62);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(63);
        }
        if (manuallyResized == null) {
            ShowUsagesAction.$$$reportNull$$$0(64);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ShowUsagesTable.MyModel tableModel = table.setTableModel(data2);
        List existingData = tableModel.getItems();
        int row2 = table.getSelectedRow();
        int newSelection = ShowUsagesAction.updateModel(tableModel, existingData, data2, row2 == -1 ? 0 : row2);
        if (newSelection < 0 || newSelection >= tableModel.getRowCount()) {
            ScrollingUtil.ensureSelectionExists((JTable)((Object)table));
            newSelection = table.getSelectedRow();
        } else {
            Object valueInTopRow;
            if (newSelection == 0 && table.getModel().getRowCount() > 1 && (valueInTopRow = table.getModel().getValueAt(0, 0)) instanceof UsageNode && usageView.isOriginUsage(((UsageNode)valueInTopRow).getUsage())) {
                ++newSelection;
            }
            table.getSelectionModel().setSelectionInterval(newSelection, newSelection);
        }
        ScrollingUtil.ensureIndexIsVisible((JTable)((Object)table), (int)newSelection, (int)0);
        if (popup2 != null) {
            if (manuallyResized.get()) {
                ShowUsagesAction.calcMaxWidth((JTable)((Object)table));
            } else {
                ShowUsagesAction.setPopupSize((JTable)((Object)table), popup2, popupPosition, minWidth, data2);
            }
        }
    }

    private static int updateModel(@NotNull ShowUsagesTable.MyModel tableModel, @NotNull List<? extends UsageNode> listOld, @NotNull List<? extends UsageNode> listNew, int oldSelection) {
        if (tableModel == null) {
            ShowUsagesAction.$$$reportNull$$$0(65);
        }
        if (listOld == null) {
            ShowUsagesAction.$$$reportNull$$$0(66);
        }
        if (listNew == null) {
            ShowUsagesAction.$$$reportNull$$$0(67);
        }
        UsageNode[] oa = listOld.toArray(new UsageNode[0]);
        UsageNode[] na = listNew.toArray(new UsageNode[0]);
        List<ModelDiff.Cmd> cmds = ModelDiff.createDiffCmds(tableModel, oa, na);
        int selection = oldSelection;
        if (cmds != null) {
            for (ModelDiff.Cmd cmd : cmds) {
                selection = cmd.translateSelection(selection);
                cmd.apply();
            }
        }
        return selection;
    }

    private static void setPopupSize(@NotNull JTable table, @NotNull AbstractPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, @NotNull List<? extends UsageNode> data2) {
        Dimension savedSize;
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(68);
        }
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(69);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(70);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(71);
        }
        if (data2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(72);
        }
        if (ShowUsagesAction.isCodeWithMeClientInstance(popup2)) {
            return;
        }
        Dimension d = popup2.getSize();
        Insets contentInsets = popup2.getContent().getInsets();
        d.width -= contentInsets.left + contentInsets.right;
        Component toolbarComponent = ((BorderLayout)popup2.getContent().getLayout()).getLayoutComponent("North");
        Object toolbarSize = toolbarComponent != null ? toolbarComponent.getPreferredSize() : JBUI.emptySize();
        Dimension headerSize = popup2.getHeaderPreferredSize();
        int width = Math.max(d.width, ShowUsagesAction.calcMaxWidth(table));
        width = Math.max(Math.max(headerSize.width, width), toolbarSize.width);
        width = Math.max(minWidth.get(), width);
        int delta = minWidth.get() == -1 ? 0 : width - minWidth.get();
        int newWidth = Math.max(width, d.width + delta);
        minWidth.set(newWidth);
        int minHeight = headerSize.height + toolbarSize.height;
        Rectangle rectangle = ShowUsagesAction.getPreferredBounds(table, popupPosition.getScreenPoint(), newWidth, minHeight, data2.size());
        table.setSize(rectangle.width, rectangle.height - minHeight);
        if (!data2.isEmpty()) {
            ScrollingUtil.ensureSelectionExists((JTable)table);
        }
        if ((savedSize = WindowStateService.getInstance().getSize(DIMENSION_SERVICE_KEY)) != null) {
            rectangle.width = Math.min(savedSize.width, rectangle.width);
        }
        popup2.setSize(rectangle.getSize());
    }

    private static boolean isCodeWithMeClientInstance(@NotNull JBPopup popup2) {
        JComponent content2;
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(73);
        }
        return (content2 = popup2.getContent()).getClientProperty("THIN_CLIENT") != null;
    }

    @NotNull
    private static Rectangle getPreferredBounds(@NotNull JTable table, @NotNull Point point, int width, int minHeight, int modelRows) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(74);
        }
        if (point == null) {
            ShowUsagesAction.$$$reportNull$$$0(75);
        }
        boolean addExtraSpace = Registry.is((String)"ide.preferred.scrollable.viewport.extra.space");
        int visibleRows = Math.min(30, modelRows);
        int rowHeight = table.getRowHeight();
        int space = addExtraSpace && visibleRows < modelRows ? rowHeight / 2 : 0;
        int height = visibleRows * rowHeight + minHeight + space;
        Rectangle bounds2 = new Rectangle(point.x, point.y, width, height);
        ScreenUtil.fitToScreen((Rectangle)bounds2);
        if (bounds2.height != height) {
            bounds2.height = Math.max(1, (bounds2.height - (minHeight += addExtraSpace && space == 0 ? rowHeight / 2 : space)) / rowHeight) * rowHeight + minHeight;
        }
        Rectangle rectangle = bounds2;
        if (rectangle == null) {
            ShowUsagesAction.$$$reportNull$$$0(76);
        }
        return rectangle;
    }

    private static void addUsageNodes(@NotNull GroupNode root, @NotNull UsageViewImpl usageView, @NotNull List<? super UsageNode> outNodes) {
        if (root == null) {
            ShowUsagesAction.$$$reportNull$$$0(77);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(78);
        }
        if (outNodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(79);
        }
        for (UsageNode node2 : root.getUsageNodes()) {
            Usage usage = node2.getUsage();
            if (!usageView.isVisible(usage)) continue;
            node2.setParent((MutableTreeNode)root);
            outNodes.add((UsageNode)node2);
        }
        for (GroupNode groupNode : root.getSubGroups()) {
            groupNode.setParent((MutableTreeNode)root);
            ShowUsagesAction.addUsageNodes(groupNode, usageView, outNodes);
        }
    }

    private static void navigateAndHint(@NotNull Usage usage, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String hint, @NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler2) {
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(80);
        }
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(81);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(82);
        }
        if (actionHandler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(83);
        }
        usage.navigate(true);
        Editor newEditor = ShowUsagesAction.getEditorFor(usage);
        if (newEditor == null) {
            return;
        }
        ShowUsagesAction.hint(false, hint, parameters2.withEditor(newEditor), actionHandler2);
    }

    private static void hint(boolean isWarning, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String hint, @NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler2) {
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(84);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(85);
        }
        if (actionHandler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(86);
        }
        Project project = parameters2.project;
        Editor editor = parameters2.editor;
        Runnable runnable2 = () -> {
            if (!actionHandler2.isValid()) {
                return;
            }
            JComponent label2 = ShowUsagesAction.createHintComponent(ShowUsagesAction.suggestSecondInvocation(hint, ShowUsagesActionHandler.getSecondInvocationHint(actionHandler2)), isWarning, (JComponent)ShowUsagesAction.createSettingsButton(project, ShowUsagesAction::hideHints, ShowUsagesAction.showDialogAndRestartRunnable(parameters2, actionHandler2)));
            ShowUsagesActionState state = ShowUsagesAction.getState(project);
            state.continuation = ShowUsagesAction.showUsagesInMaximalScopeRunnable(parameters2, actionHandler2);
            Runnable clearContinuation = () -> {
                state.continuation = null;
            };
            UIUtil.runWhenHidden((Component)label2, (Runnable)clearContinuation);
            if (editor == null || editor.isDisposed() || !editor.getComponent().isShowing()) {
                int flags = 42;
                HintManager.getInstance().showHint(label2, parameters2.popupPosition, flags, 0, clearContinuation);
            } else {
                HintManager.getInstance().showInformationHint(editor, label2);
            }
        };
        if (editor == null) {
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(runnable2));
        } else {
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> editor.getScrollingModel().runActionOnScrollingFinished(() -> IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> AsyncEditorLoader.performWhenLoaded(editor, runnable2))));
        }
    }

    @Nullable
    private static Editor getEditorFor(@NotNull Usage usage) {
        FileEditorLocation location;
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(87);
        }
        FileEditor newFileEditor = (location = usage.getLocation()) == null ? null : location.getEditor();
        return newFileEditor instanceof TextEditor ? ((TextEditor)newFileEditor).getEditor() : null;
    }

    @NotNull
    private static Runnable showMoreUsagesRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler2) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(88);
        }
        if (actionHandler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(89);
        }
        Runnable runnable2 = () -> ShowUsagesAction.showElementUsages(parameters2.moreUsages(), actionHandler2);
        if (runnable2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(90);
        }
        return runnable2;
    }

    @NotNull
    private static Runnable showUsagesInMaximalScopeRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler2) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(91);
        }
        if (actionHandler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(92);
        }
        Runnable runnable2 = () -> ShowUsagesAction.showUsagesInMaximalScope(parameters2, actionHandler2);
        if (runnable2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(93);
        }
        return runnable2;
    }

    private static void showUsagesInMaximalScope(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler2) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(94);
        }
        if (actionHandler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(95);
        }
        ShowUsagesAction.showElementUsages(parameters2, actionHandler2.withScope(actionHandler2.getMaximalScope()));
    }

    @NotNull
    private static Runnable showDialogAndRestartRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler2) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(96);
        }
        if (actionHandler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(97);
        }
        Runnable runnable2 = () -> ShowUsagesAction.showDialogAndRestart(parameters2, actionHandler2);
        if (runnable2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(98);
        }
        return runnable2;
    }

    private static void showDialogAndRestart(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler2) {
        ShowUsagesActionHandler newActionHandler;
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(99);
        }
        if (actionHandler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(100);
        }
        if ((newActionHandler = actionHandler2.showDialog()) != null) {
            ShowUsagesAction.showElementUsages(parameters2, newActionHandler);
        }
    }

    @NotNull
    private static ShowUsagesActionState getState(@NotNull Project project) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(101);
        }
        ShowUsagesActionState showUsagesActionState = (ShowUsagesActionState)project.getService(ShowUsagesActionState.class);
        if (showUsagesActionState == null) {
            ShowUsagesAction.$$$reportNull$$$0(102);
        }
        return showUsagesActionState;
    }

    @TestOnly
    public static void setPopupDelayTimeout(int timeout) {
        ourPopupDelayTimeout = timeout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 38: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 76: 
            case 90: 
            case 93: 
            case 98: 
            case 102: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 38: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 76: 
            case 90: 
            case 93: 
            case 98: 
            case 102: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 22: 
            case 28: 
            case 42: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetVariants";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 24: 
            case 62: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupPosition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 32: 
            case 53: 
            case 59: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pingEDT";
                break;
            }
            case 16: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 18: 
            case 36: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 19: 
            case 37: 
            case 83: 
            case 86: 
            case 89: 
            case 92: 
            case 95: 
            case 97: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHandler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unselectedActions";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 23: 
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondInvocationTitle";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 27: 
            case 38: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 76: 
            case 90: 
            case 93: 
            case 98: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelAction";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showDialogAndFindUsagesRunnable";
                break;
            }
            case 33: 
            case 39: 
            case 45: 
            case 57: 
            case 58: 
            case 61: 
            case 68: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemChoseCallback";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusPanel";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupRef";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pinGroup";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findUsagesRunnable";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 54: 
            case 80: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleUsage";
                break;
            }
            case 60: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 63: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minWidth";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manuallyResized";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOld";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listNew";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outNodes";
                break;
            }
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createHintComponent";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsagePopup";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusString";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSecondInvocation";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredBounds";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "showMoreUsagesRunnable";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "showUsagesInMaximalScopeRunnable";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "showDialogAndRestartRunnable";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showUsages";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createVariantHandler";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startFindUsages";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rulesChanged";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createActionHandler";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showElementUsages";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toggleFilters";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fakeEvent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createUsageView";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showPopupIfNeedTo";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createHintComponent";
                break;
            }
            case 27: 
            case 38: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 76: 
            case 90: 
            case 93: 
            case 98: 
            case 102: {
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsButton";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createUsagePopup";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createPinButton";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "suggestSecondInvocation";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredOutNodeCount";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getUsageOffset";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "areAllUsagesInOneLine";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "calcMaxWidth";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "columnMaxWidth";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "rebuildTable";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "setPopupSize";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isCodeWithMeClientInstance";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredBounds";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addUsageNodes";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "navigateAndHint";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "hint";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFor";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "showMoreUsagesRunnable";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "showUsagesInMaximalScopeRunnable";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "showUsagesInMaximalScope";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndRestartRunnable";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndRestart";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 38: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 76: 
            case 90: 
            case 93: 
            case 98: 
            case 102: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Service
    private static final class ShowUsagesActionState {
        Runnable continuation;

        private ShowUsagesActionState() {
        }
    }

    static abstract class FilteredOutUsagesNode
    extends UsageNode {
        @Nls
        @NotNull
        private final String myString;
        @Nls
        @NotNull
        private final String myToolTip;

        private FilteredOutUsagesNode(@NotNull Usage fakeUsage, @Nls @NotNull String string, @Nls @NotNull String toolTip) {
            if (fakeUsage == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(0);
            }
            if (string == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(1);
            }
            if (toolTip == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(2);
            }
            super(null, fakeUsage);
            this.myString = string;
            this.myToolTip = toolTip;
        }

        @Nls
        @NotNull
        String getString() {
            String string = this.myString;
            if (string == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls
        @NotNull
        String getTooltip() {
            String string = this.myToolTip;
            if (string == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(4);
            }
            return string;
        }

        public String toString() {
            return this.myString;
        }

        public abstract void onSelected();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fakeUsage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolTip";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$FilteredOutUsagesNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$FilteredOutUsagesNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SettingsAction
    extends DumbAwareAction
    implements CustomComponentAction {
        private final Project project;
        private final Runnable cancelAction;
        private final Runnable showDialogAction;

        private SettingsAction(@NotNull Project project, @NotNull Runnable cancelAction, @NotNull Runnable showDialogAction) {
            if (project == null) {
                SettingsAction.$$$reportNull$$$0(0);
            }
            if (cancelAction == null) {
                SettingsAction.$$$reportNull$$$0(1);
            }
            if (showDialogAction == null) {
                SettingsAction.$$$reportNull$$$0(2);
            }
            super(FindBundle.message("show.usages.settings.tooltip", new Object[0]), null, AllIcons.General.GearPlain);
            this.project = project;
            this.cancelAction = cancelAction;
            this.showDialogAction = showDialogAction;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SettingsAction.$$$reportNull$$$0(3);
            }
            ApplicationManager.getApplication().invokeLater(this.showDialogAction, this.project.getDisposed());
            this.cancelAction.run();
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                SettingsAction.$$$reportNull$$$0(4);
            }
            if (place == null) {
                SettingsAction.$$$reportNull$$$0(5);
            }
            return new ActionButton((AnAction)this, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

                @Override
                @Nullable
                protected String getShortcutText() {
                    KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
                    return shortcut != null ? KeymapUtil.getShortcutText((Shortcut)shortcut) : null;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cancelAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "showDialogAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$SettingsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCustomComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class StringNode
    extends UsageNode {
        @Nls
        @NotNull
        private final String myString;

        private StringNode(@Nls @NotNull String string) {
            if (string == null) {
                StringNode.$$$reportNull$$$0(0);
            }
            super(null, (Usage)NullUsage.INSTANCE);
            this.myString = string;
        }

        @Nls
        @NotNull
        String getString() {
            String string = this.myString;
            if (string == null) {
                StringNode.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return this.myString;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$StringNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$StringNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class UsageNodeComparator
    implements Comparator<UsageNode> {
        private final ShowUsagesTable myTable;

        private UsageNodeComparator(@NotNull ShowUsagesTable table) {
            if (table == null) {
                UsageNodeComparator.$$$reportNull$$$0(0);
            }
            this.myTable = table;
        }

        @Override
        public int compare(UsageNode c1, UsageNode c2) {
            VirtualFile v2;
            String name2;
            int weight2;
            int weight1;
            if (c1 instanceof StringNode || c2 instanceof StringNode) {
                if (c1 instanceof StringNode && c2 instanceof StringNode) {
                    return Comparing.compare((Comparable)((Object)c1.toString()), (Comparable)((Object)c2.toString()));
                }
                return c1 instanceof StringNode ? 1 : -1;
            }
            Usage o1 = c1.getUsage();
            Usage o2 = c2.getUsage();
            int n = o1 == this.myTable.USAGES_FILTERED_OUT_SEPARATOR ? 3 : (o1 == this.myTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight1 = o1 == this.myTable.MORE_USAGES_SEPARATOR ? 1 : 0));
            int n2 = o2 == this.myTable.USAGES_FILTERED_OUT_SEPARATOR ? 3 : (o2 == this.myTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight2 = o2 == this.myTable.MORE_USAGES_SEPARATOR ? 1 : 0));
            if (weight1 != weight2) {
                return weight1 - weight2;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            VirtualFile v1 = UsageListCellRenderer.getVirtualFile(o1);
            String name1 = v1 == null ? null : v1.getName();
            int i2 = Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)(name2 = (v2 = UsageListCellRenderer.getVirtualFile(o2)) == null ? null : v2.getName())));
            if (i2 != 0) {
                return i2;
            }
            if (Comparing.equal((Object)v1, (Object)v2)) {
                FileEditorLocation loc1 = o1.getLocation();
                FileEditorLocation loc2 = o2.getLocation();
                return Comparing.compare((Comparable)loc1, (Comparable)loc2);
            }
            String path1 = v1 == null ? null : v1.getPath();
            String path2 = v2 == null ? null : v2.getPath();
            return Comparing.compare((Comparable)((Object)path1), (Comparable)((Object)path2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction$UsageNodeComparator", "<init>"));
        }
    }
}

