/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.TableCell;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.speedSearch.FilteringTableModel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class RevisionsList {
    public static final int RECENT_PERIOD = 12;
    private final JBTable table = new JBTable();
    private volatile Set<Long> filteredRevisions;

    public RevisionsList(SelectionListener l) {
        this.setModel(new MyModel(Collections.emptyList(), Collections.emptyMap()));
        this.table.setTableHeader(null);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.getColumnModel().setColumnMargin(0);
        this.table.resetDefaultFocusTraversalKeys();
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new MyCellRenderer(this.table));
        this.table.getEmptyText().setText(VcsBundle.message((String)"history.empty", (Object[])new Object[0]));
        this.addSelectionListener(l);
        MyCellRenderer.MyCopyProvider copyProvider2 = new MyCellRenderer.MyCopyProvider(this.table);
        DataManager.registerDataProvider((JComponent)this.table, dataId -> {
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return copyProvider2;
            }
            return null;
        });
    }

    public JComponent getComponent() {
        return this.table;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public void moveSelection(boolean fwd) {
        int index2 = this.table.getSelectionModel().getLeadSelectionIndex();
        int count = this.table.getRowCount();
        int newIdx = (count + index2 + (fwd ? 1 : -1)) % count;
        this.table.getSelectionModel().setSelectionInterval(newIdx, newIdx);
    }

    private void addSelectionListener(final SelectionListener listener2) {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private final SelectionListener mySelectionListener;
            {
                this.mySelectionListener = listener2;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = RevisionsList.this.table.getSelectionModel();
                int selectedRow1 = sm.getMinSelectionIndex();
                int selectedRow2 = sm.getMaxSelectionIndex();
                FilteringTableModel<?> model2 = RevisionsList.this.getFilteringModel();
                int origRow1 = model2.getOriginalIndex(selectedRow1);
                int origRow2 = model2.getOriginalIndex(selectedRow2);
                this.mySelectionListener.revisionsSelected(origRow1, origRow2);
            }
        });
    }

    public void updateData(HistoryDialogModel model2) {
        HashSet<Long> sel = new HashSet<Long>();
        TableModel tm = this.table.getModel();
        for (int i2 : this.table.getSelectedRows()) {
            if (i2 >= tm.getRowCount()) continue;
            sel.add(((RevisionItem)tm.getValueAt((int)i2, (int)0)).revision.getChangeSetId());
        }
        List<RevisionItem> newRevs = model2.getRevisions();
        Date today = new Date();
        HashMap<RevisionItem, Period> periods = new HashMap<RevisionItem, Period>();
        for (int i2 = 0; i2 < newRevs.size(); ++i2) {
            boolean recent;
            RevisionItem each = newRevs.get(i2);
            boolean bl = recent = today.getTime() - each.revision.getTimestamp() < 43200000L;
            if (recent) {
                if (i2 != 0) continue;
                periods.put(each, Period.RECENT);
                continue;
            }
            periods.put(each, periods.isEmpty() ? Period.OLD : Period.OLDER);
            break;
        }
        this.setModel(new MyModel(newRevs, periods));
        FilteringTableModel<?> fm = this.getFilteringModel();
        for (int i3 = 0; i3 < fm.getRowCount(); ++i3) {
            RevisionItem r = (RevisionItem)fm.getValueAt(i3, 0);
            if (!sel.contains(r.revision.getChangeSetId())) continue;
            this.table.getSelectionModel().addSelectionInterval(i3, i3);
        }
        if (this.table.getSelectionModel().isSelectionEmpty()) {
            this.table.getSelectionModel().addSelectionInterval(0, 0);
        }
    }

    private void setModel(MyModel newModel) {
        FilteringTableModel fModel = new FilteringTableModel((TableModel)newModel, RevisionItem.class);
        this.table.setModel((TableModel)fModel);
        fModel.setFilter(this::filterRevision);
    }

    private boolean filterRevision(RevisionItem r) {
        if (this.filteredRevisions == null) {
            return true;
        }
        return this.filteredRevisions.contains(r.revision.getChangeSetId());
    }

    public void setFilteredRevisions(Set<Long> filtered2) {
        this.filteredRevisions = filtered2;
        List<Object> sel = this.storeSelection();
        this.getFilteringModel().refilter();
        this.restoreSelection(sel);
    }

    private void restoreSelection(List<Object> sel) {
        ListSelectionModel sm = this.table.getSelectionModel();
        sm.clearSelection();
        for (Object o : sel) {
            int idx = -1;
            int e = this.table.getModel().getRowCount();
            for (int i2 = 0; i2 < e; ++i2) {
                if (this.table.getModel().getValueAt(i2, 0) != o) continue;
                idx = i2;
                break;
            }
            sm.addSelectionInterval(idx, idx);
        }
        if (sm.isSelectionEmpty() && this.table.getRowCount() > 0) {
            sm.setSelectionInterval(0, 0);
        }
        sm.setValueIsAdjusting(false);
    }

    @NotNull
    private List<Object> storeSelection() {
        ListSelectionModel sm = this.table.getSelectionModel();
        sm.setValueIsAdjusting(true);
        ArrayList<Object> sel = new ArrayList<Object>();
        for (int index2 : sm.getSelectedIndices()) {
            sel.add(this.table.getModel().getValueAt(index2, 0));
        }
        ArrayList<Object> arrayList = sel;
        if (arrayList == null) {
            RevisionsList.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private FilteringTableModel<?> getFilteringModel() {
        return (FilteringTableModel)this.table.getModel();
    }

    private static MyModel getMyModel(JTable table) {
        return (MyModel)((FilteringTableModel)table.getModel()).getOriginalModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/ui/views/RevisionsList", "storeSelection"));
    }

    public static class MyCellRenderer
    implements TableCellRenderer {
        private static final Color USER_LABEL_COLOR = new JBColor(new Color(230, 230, 250), new Color(89, 96, 74));
        private static final Insets BORDER_INSETS = new Insets(2, 5, 2, 5);
        private final DefaultTableCellRenderer myTemplate = new DefaultTableCellRenderer();
        private final MyWrapperPanel myWrapperPanel = new MyWrapperPanel();
        private final JPanel myItemPanel = new JPanel();
        private final MyBorder myBorder = new MyBorder(BORDER_INSETS);
        private final SeparatorWithText myPeriodLabel = new SeparatorWithText();
        private final JBLabel myDateLabel = new JBLabel();
        private final JBLabel myFilesCountLabel = new JBLabel();
        private final JBLabel myTitleLabel = new JBLabel();
        private final JPanel myLabelPanel = new JPanel();
        private final MyLabelContainer myLabelContainer = new MyLabelContainer();
        private final JBLabel myLabelLabel = new JBLabel();
        private final ExpandableItemsHandler<TableCell> myToolTipHandler;

        public MyCellRenderer(JBTable table) {
            this.myToolTipHandler = table.getExpandableItemsHandler();
            JPanel headersPanel = new JPanel(new BorderLayout());
            headersPanel.setOpaque(false);
            headersPanel.add((Component)this.myPeriodLabel, "North");
            headersPanel.add((Component)this.myLabelPanel, "Center");
            this.myLabelContainer.add((Component)this.myLabelLabel);
            this.myLabelPanel.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(Container parent) {
                    Dimension size2 = myLabelContainer.getPreferredSize();
                    JBInsets.addTo((Dimension)size2, (Insets)parent.getInsets());
                    return size2;
                }

                public void layoutContainer(Container parent) {
                    Insets i2 = parent.getInsets();
                    int pw = parent.getWidth() - i2.left - i2.right;
                    Dimension pref = myLabelContainer.getPreferredSize();
                    int w = Math.min(pw, pref.width);
                    int h = pref.height;
                    int x = i2.left + pw - w;
                    int y = i2.top;
                    myLabelContainer.setBounds(x, y, w, h);
                }
            });
            this.myLabelPanel.setOpaque(false);
            this.myLabelPanel.add(this.myLabelContainer);
            final JPanel layoutPanel = new JPanel(new BorderLayout());
            layoutPanel.setOpaque(false);
            layoutPanel.add((Component)headersPanel, "North");
            layoutPanel.add((Component)this.myItemPanel, "Center");
            this.myWrapperPanel.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(Container parent) {
                    return layoutPanel.getPreferredSize();
                }

                public void layoutContainer(Container parent) {
                    Dimension size2 = parent.getSize();
                    Insets i2 = parent.getInsets();
                    Dimension pref = layoutPanel.getPreferredSize();
                    layoutPanel.setBounds(i2.left, i2.top, size2.width - i2.left - i2.right, pref.height);
                }
            });
            this.myWrapperPanel.add(layoutPanel);
            this.myItemPanel.setBorder(this.myBorder);
            this.myItemPanel.setLayout(new BorderLayout());
            JPanel north = new JPanel(new BorderLayout());
            north.setOpaque(false);
            north.add((Component)this.myDateLabel, "West");
            north.add((Component)this.myFilesCountLabel, "East");
            JPanel south = new JPanel(new BorderLayout());
            south.add((Component)this.myTitleLabel, "Center");
            south.setOpaque(false);
            this.myItemPanel.add((Component)north, "North");
            this.myItemPanel.add((Component)south, "South");
            this.myLabelLabel.setBorder((Border)new EmptyBorder(0, 5, 1, 5));
            this.myLabelPanel.setBorder(new MyBorder(new Insets(4, 20, 3, 1)));
            this.myWrapperPanel.setOpaque(false);
            this.myItemPanel.setOpaque(true);
            this.myWrapperPanel.setBackground(table.getBackground());
            this.myDateLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
            this.myFilesCountLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
            this.myLabelLabel.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
            this.myTitleLabel.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            if (value2 == null) {
                return this.myWrapperPanel;
            }
            RevisionItem r = (RevisionItem)value2;
            LabelsAndColor labelsAndColor = MyCellRenderer.getLabelsAndColor(r);
            Period p = RevisionsList.getMyModel(table).getPeriod(r);
            if (p == null) {
                this.myPeriodLabel.setVisible(false);
            } else {
                this.myPeriodLabel.setVisible(true);
                this.myPeriodLabel.setCaption(p.getDisplayString());
            }
            this.myBorder.set(row2 == table.getModel().getRowCount() - 1);
            this.myDateLabel.setText(MyCellRenderer.ensureString(DateFormatUtil.formatDateTime((long)r.revision.getTimestamp())));
            this.myFilesCountLabel.setText(MyCellRenderer.ensureString(labelsAndColor.filesCount));
            this.myTitleLabel.setFont(this.myTitleLabel.getFont().deriveFont(labelsAndColor.isNamed ? 1 : 0));
            this.myTitleLabel.setText(MyCellRenderer.ensureString(labelsAndColor.title));
            JComponent orig = (JComponent)this.myTemplate.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column2);
            if (labelsAndColor.label == null) {
                this.myLabelPanel.setVisible(false);
            } else {
                this.myLabelPanel.setVisible(true);
                this.myLabelLabel.setBackground((Color)labelsAndColor.label.second);
                this.myLabelContainer.set((Color)labelsAndColor.label.second);
                this.myLabelLabel.setText(MyCellRenderer.ensureString((String)labelsAndColor.label.first));
            }
            Color fg = orig.getForeground();
            Color bg = isSelected && !table.isFocusOwner() ? UIUtil.getListUnfocusedSelectionBackground() : orig.getBackground();
            this.myDateLabel.setForeground(isSelected ? fg : JBColor.GRAY);
            this.myFilesCountLabel.setForeground(this.myDateLabel.getForeground());
            this.myTitleLabel.setForeground(isSelected || labelsAndColor.isNamed ? fg : JBColor.DARK_GRAY);
            this.myItemPanel.setBackground(bg);
            this.myWrapperPanel.doLayout();
            int height = this.myWrapperPanel.getPreferredSize().height;
            if (table.getRowHeight(row2) != height && height > 0) {
                table.setRowHeight(row2, height);
            }
            return this.myWrapperPanel;
        }

        @NlsContexts.Label
        private static String ensureString(@NlsContexts.Label String s) {
            return StringUtil.isEmpty((String)s) ? " " : s;
        }

        private static LabelsAndColor getLabelsAndColor(RevisionItem item) {
            boolean named;
            Revision r = item.revision;
            Pair<List<String>, Integer> affected = r.getAffectedFileNames();
            Object title2 = r.getChangeSetName();
            boolean bl = named = title2 != null;
            if (title2 == null) {
                title2 = StringUtil.join((Collection)((Collection)affected.first), (String)", ");
                if (((List)affected.first).size() < (Integer)affected.second) {
                    title2 = (String)title2 + "...";
                }
            }
            String filesCount = StringUtil.pluralize((String)LocalHistoryBundle.message("revisions.table.filesCount", affected.second), (int)((Integer)affected.second));
            Pair label2 = null;
            if (!item.labels.isEmpty()) {
                Revision first = item.labels.getFirst();
                label2 = Pair.create((Object)first.getLabel(), (Object)(first.getLabelColor() == -1 ? USER_LABEL_COLOR : new Color(first.getLabelColor())));
            }
            return new LabelsAndColor(named, (String)title2, filesCount, label2);
        }

        private static final class MyCopyProvider
        implements CopyProvider {
            @NotNull
            private final JBTable myTable;

            private MyCopyProvider(@NotNull JBTable table) {
                if (table == null) {
                    MyCopyProvider.$$$reportNull$$$0(0);
                }
                this.myTable = table;
            }

            public void performCopy(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    MyCopyProvider.$$$reportNull$$$0(1);
                }
                TableModel model2 = this.myTable.getModel();
                StringBuilder sb = new StringBuilder();
                for (int row2 : this.myTable.getSelectedRows()) {
                    RevisionItem r = (RevisionItem)model2.getValueAt(row2, 0);
                    LabelsAndColor labelsAndColor = MyCellRenderer.getLabelsAndColor(r);
                    String time = DateFormatUtil.formatDateTime((long)r.revision.getTimestamp());
                    String title2 = labelsAndColor.title;
                    String filesCount = labelsAndColor.filesCount;
                    if (sb.length() != 0) {
                        sb.append("\n");
                    }
                    sb.append(time).append(", ").append(filesCount).append(": ").append(title2);
                }
                CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(sb));
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    MyCopyProvider.$$$reportNull$$$0(2);
                }
                return this.myTable.getSelectedRowCount() > 0;
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    MyCopyProvider.$$$reportNull$$$0(3);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/history/integration/ui/views/RevisionsList$MyCellRenderer$MyCopyProvider";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performCopy";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyEnabled";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyVisible";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static final class MyLabelContainer
        extends JPanel {
            private MyLabelContainer() {
                super(new BorderLayout());
            }

            public void set(Color c) {
                this.setBackground(c);
            }

            @Override
            public Dimension getMinimumSize() {
                return super.getMinimumSize();
            }

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(this.getBackground());
                g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.getHeight() - 2, this.getHeight() - 2);
                g2d.setColor(this.getBackground().darker());
                g2d.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getHeight() - 2, this.getHeight() - 2);
                g2d.dispose();
            }
        }

        private static final class MyBorder
        extends EmptyBorder {
            private boolean isLast;

            private MyBorder(Insets insets) {
                super(insets);
            }

            public void set(boolean isLast) {
                this.isLast = isLast;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(JBColor.border());
                g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f}, 1.0f));
                g2d.drawLine(x, y, x + width, y);
                if (this.isLast) {
                    g2d.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
                g2d.dispose();
            }
        }

        private static final class LabelsAndColor {
            final boolean isNamed;
            final @NlsContexts.Label String title;
            final @NlsContexts.Label String filesCount;
            final Pair<@NlsContexts.Label String, Color> label;

            private LabelsAndColor(boolean isNamed, @NlsContexts.Label String title2, @NlsContexts.Label String filesCount, Pair<@NlsContexts.Label String, Color> label2) {
                this.isNamed = isNamed;
                this.title = title2;
                this.filesCount = filesCount;
                this.label = label2;
            }
        }

        private class MyWrapperPanel
        extends JPanel {
            private MyWrapperPanel() {
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleMyWrapperPanel();
                }
                return this.accessibleContext;
            }

            protected class AccessibleMyWrapperPanel
            extends JPanel.AccessibleJPanel {
                protected AccessibleMyWrapperPanel() {
                    super(MyWrapperPanel.this);
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.LABEL;
                }

                @Override
                public String getAccessibleName() {
                    if (MyCellRenderer.this.myPeriodLabel.isVisible()) {
                        return AccessibleContextUtil.getCombinedName((String)", ", (Component[])new Component[]{MyCellRenderer.this.myPeriodLabel, MyCellRenderer.this.myTitleLabel, MyCellRenderer.this.myFilesCountLabel, MyCellRenderer.this.myDateLabel});
                    }
                    return AccessibleContextUtil.getCombinedName((String)", ", (Component[])new Component[]{MyCellRenderer.this.myTitleLabel, MyCellRenderer.this.myFilesCountLabel, MyCellRenderer.this.myDateLabel});
                }
            }
        }
    }

    public static class MyModel
    extends AbstractTableModel {
        private final List<? extends RevisionItem> myRevisions;
        private final Map<RevisionItem, Period> myPeriods;

        public MyModel(List<? extends RevisionItem> revisions, Map<RevisionItem, Period> periods) {
            this.myRevisions = revisions;
            this.myPeriods = periods;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.myRevisions.size();
        }

        @Override
        public RevisionItem getValueAt(int rowIndex, int columnIndex) {
            return this.myRevisions.get(rowIndex);
        }

        public Period getPeriod(RevisionItem r) {
            return this.myPeriods.get(r);
        }
    }

    private static enum Period {
        RECENT(LocalHistoryBundle.message("revisions.table.period.recent", 12)),
        OLDER(LocalHistoryBundle.message("revisions.table.period.older", new Object[0])),
        OLD(LocalHistoryBundle.message("revisions.table.period.old", new Object[0]));

        private final @NlsContexts.Label String myDisplayString;

        private Period(String displayString) {
            this.myDisplayString = displayString;
        }

        @NlsContexts.Label
        public String getDisplayString() {
            return this.myDisplayString;
        }
    }

    public static interface SelectionListener {
        public void revisionsSelected(int var1, int var2);
    }
}

