/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public final class ActiveWindowsWatcher {
    private static final LinkedHashSet<Window> activatedWindows = new LinkedHashSet();

    public static boolean isTheCurrentWindowOnTheActivatedList(Window w) {
        ActiveWindowsWatcher.updateActivatedWindowSet();
        return activatedWindows.contains(w);
    }

    public static void addActiveWindow(Window window) {
        activatedWindows.add(window);
        ActiveWindowsWatcher.updateActivatedWindowSet();
    }

    public static void updateActivatedWindowSet() {
        Iterator iter2 = activatedWindows.iterator();
        while (iter2.hasNext()) {
            Window window = (Window)iter2.next();
            if (!(!window.isFocusableWindow() || !window.isVisible() || ComponentUtil.isMinimized((Window)window) || AppUIUtil.isInFullscreen(window) || window instanceof Frame && ((Frame)window).isUndecorated() || window instanceof Dialog && ((Dialog)window).isUndecorated()) && (window instanceof Dialog || window instanceof Frame)) continue;
            iter2.remove();
        }
    }

    public static Window nextWindowAfter(@NotNull Window w) {
        Window[] windows;
        if (w == null) {
            ActiveWindowsWatcher.$$$reportNull$$$0(0);
        }
        if (w.equals((windows = ActiveWindowsWatcher.getWindows(w))[windows.length - 1])) {
            return windows[0];
        }
        for (int i2 = windows.length - 2; i2 >= 0; --i2) {
            if (!w.equals(windows[i2])) continue;
            return windows[i2 + 1];
        }
        throw new IllegalArgumentException("The window after " + w.getName() + " has not been found");
    }

    public static Window nextWindowBefore(@NotNull Window w) {
        if (w == null) {
            ActiveWindowsWatcher.$$$reportNull$$$0(1);
        }
        assert (activatedWindows.contains(w));
        Window[] windows = ActiveWindowsWatcher.getWindows(w);
        if (w.equals(windows[0])) {
            return windows[windows.length - 1];
        }
        for (int i2 = 1; i2 < windows.length; ++i2) {
            if (!w.equals(windows[i2])) continue;
            return windows[i2 - 1];
        }
        throw new IllegalArgumentException("The window after " + w.getName() + " has not been found");
    }

    @NotNull
    private static Window[] getWindows(@NotNull Window w) {
        if (w == null) {
            ActiveWindowsWatcher.$$$reportNull$$$0(2);
        }
        if (SystemInfo.isMac && SystemInfo.isJetBrainsJvm && activatedWindows.size() > 1) {
            Window[] windowArray = (Window[])activatedWindows.stream().filter(window -> window == w || Foundation.invoke((ID)MacUtil.getWindowFromJavaWindow((Window)window), (String)"isOnActiveSpace", (Object[])new Object[0]).booleanValue()).toArray(Window[]::new);
            if (windowArray == null) {
                ActiveWindowsWatcher.$$$reportNull$$$0(3);
            }
            return windowArray;
        }
        Window[] windowArray = activatedWindows.toArray(new Window[0]);
        if (windowArray == null) {
            ActiveWindowsWatcher.$$$reportNull$$$0(4);
        }
        return windowArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ActiveWindowsWatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ActiveWindowsWatcher";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nextWindowAfter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "nextWindowBefore";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWindows";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

