/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.RecentProjectsManagerBaseKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0010\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tH\u0002\u001a\b\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u001a\b\u0010\u000f\u001a\u00020\u0004H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "convertToSystemIndependentPaths", "", "list", "", "", "getLastProjectFrameInfoFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "isUseProjectFrameAsSplash", "", "readProjectName", "path", "updateSystemDockMenu", "intellij.platform.ide.impl"})
public final class RecentProjectsManagerBaseKt {
    private static final Logger LOG;

    private static final boolean isUseProjectFrameAsSplash() {
        return Registry.is((String)"ide.project.frame.as.splash");
    }

    private static final String readProjectName(String path2) {
        Path file2;
        if (!RecentProjectsManagerBase.Companion.isFileSystemPath(path2)) {
            return path2;
        }
        Path path3 = file2 = Path.of(path2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"file");
        if (!PathKt.isDirectory((Path)path3)) {
            String string = FileUtilRt.getNameWithoutExtension((String)((Object)file2.getFileName()).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtilRt.getNameWithou\u2026file.fileName.toString())");
            return string;
        }
        Path projectDir = file2.resolve(".idea");
        String string = JpsPathUtil.readProjectName((Path)projectDir);
        if (string == null) {
            String string2 = JpsPathUtil.getDefaultProjectName((Path)projectDir);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JpsPathUtil.getDefaultProjectName(projectDir)");
        }
        return string;
    }

    private static final Path getLastProjectFrameInfoFile() {
        return PathManagerEx.getAppSystemDir().resolve("lastProjectFrameInfo");
    }

    private static final void convertToSystemIndependentPaths(List<String> list2) {
        list2.replaceAll(convertToSystemIndependentPaths.1.INSTANCE);
    }

    private static final void updateSystemDockMenu() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isHeadlessEnvironment()) {
            SystemDock.updateMenu();
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RecentProjectsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$updateSystemDockMenu() {
        RecentProjectsManagerBaseKt.updateSystemDockMenu();
    }

    public static final /* synthetic */ boolean access$isUseProjectFrameAsSplash() {
        return RecentProjectsManagerBaseKt.isUseProjectFrameAsSplash();
    }

    public static final /* synthetic */ Path access$getLastProjectFrameInfoFile() {
        return RecentProjectsManagerBaseKt.getLastProjectFrameInfoFile();
    }

    public static final /* synthetic */ void access$convertToSystemIndependentPaths(List list2) {
        RecentProjectsManagerBaseKt.convertToSystemIndependentPaths(list2);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$readProjectName(String path2) {
        return RecentProjectsManagerBaseKt.readProjectName(path2);
    }
}

