/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipsUtilityExperiment;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TipsOfTheDayUsagesCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ui.tips", 8);
    public static final EventId NEXT_TIP = GROUP.registerEvent("next.tip");
    public static final EventId PREVIOUS_TIP = GROUP.registerEvent("previous.tip");
    private static final EventId1<DialogType> DIALOG_SHOWN = GROUP.registerEvent("dialog.shown", (EventField)EventFields.Enum((String)"type", DialogType.class));
    private static final EventId2<Boolean, Boolean> DIALOG_CLOSED = GROUP.registerEvent("dialog.closed", (EventField)EventFields.Boolean((String)"keep_showing_before"), (EventField)EventFields.Boolean((String)"keep_showing_after"));
    private static final StringEventField ALGORITHM_FIELD = EventFields.String((String)"algorithm", Arrays.asList("TOP", "MATRIX_ALS", "MATRIX_BPR", "PROB", "WIDE", "CODIS", "RANDOM", "WEIGHTS_LIN_REG", "default_shuffle", "unknown", "ONE_TIP_SUMMER2020", "RANDOM_SUMMER2020", TipsUtilityExperiment.BY_TIP_UTILITY.toString(), TipsUtilityExperiment.BY_TIP_UTILITY_IGNORE_USED.toString()));
    private static final EventId3<String, String, String> TIP_SHOWN = GROUP.registerEvent("tip.shown", (EventField)EventFields.StringValidatedByCustomRule((String)"filename", (String)"tip_info"), (EventField)ALGORITHM_FIELD, (EventField)EventFields.Version);
    private static final EventId2<String, Long> TIP_PERFORMED = GROUP.registerEvent("tip.performed", (EventField)EventFields.StringValidatedByCustomRule((String)"filename", (String)"tip_info"), (EventField)EventFields.Long((String)"time_passed"));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void triggerTipShown(@NotNull TipAndTrickBean tip, @NotNull String algorithm, @Nullable String version2) {
        if (tip == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(0);
        }
        if (algorithm == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(1);
        }
        TIP_SHOWN.log((Object)tip.fileName, (Object)algorithm, (Object)version2);
    }

    public static void triggerDialogShown(@NotNull DialogType type) {
        if (type == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(2);
        }
        DIALOG_SHOWN.log((Object)type);
    }

    public static void triggerDialogClosed(boolean showOnStartupBefore) {
        DIALOG_CLOSED.log((Object)showOnStartupBefore, (Object)GeneralSettings.getInstance().isShowTipsOnStartup());
    }

    public static void triggerTipUsed(@NotNull String tipFilename, long timePassed) {
        if (tipFilename == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(3);
        }
        TIP_PERFORMED.log((Object)tipFilename, (Object)timePassed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tip";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "algorithm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tipFilename";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/TipsOfTheDayUsagesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerTipShown";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerDialogShown";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerTipUsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TipInfoValidationRule
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "tip_info".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            TipAndTrickBean tip;
            PluginInfo info2;
            if (data2 == null) {
                TipInfoValidationRule.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                TipInfoValidationRule.$$$reportNull$$$0(1);
            }
            if ((info2 = (PluginInfo)context2.getPayload(PLUGIN_INFO)) != null) {
                ValidationResultType validationResultType = info2.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    TipInfoValidationRule.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            Object filename = context2.eventData.get("filename");
            if (filename instanceof String && (tip = TipAndTrickBean.findByFileName((String)filename)) != null) {
                PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)tip.getPluginDescriptor());
                context2.setPayload(PLUGIN_INFO, (Object)pluginInfo);
                ValidationResultType validationResultType = pluginInfo.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    TipInfoValidationRule.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                TipInfoValidationRule.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/TipsOfTheDayUsagesCollector$TipInfoValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/TipsOfTheDayUsagesCollector$TipInfoValidationRule";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum DialogType {
        automatically,
        manually;

    }
}

