/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.GeneralModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class CreateTemplateInPackageAction<T extends PsiElement>
extends CreateFromTemplateAction<T> {
    private final Set<? extends JpsModuleSourceRootType<?>> mySourceRootTypes;

    protected CreateTemplateInPackageAction(String text2, String description2, Icon icon2, Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        this(() -> text2, () -> description2, icon2, rootTypes);
    }

    protected CreateTemplateInPackageAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon2, Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (dynamicText == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(1);
        }
        super(dynamicText, dynamicDescription, icon2);
        this.mySourceRootTypes = rootTypes;
    }

    @Override
    @Nullable
    protected T createFile(String name, String templateName, PsiDirectory dir) {
        return this.checkOrCreate(name, dir, templateName);
    }

    @Nullable
    protected abstract PsiElement getNavigationElement(@NotNull T var1);

    @Override
    protected void postProcess(@NotNull T createdElement, String templateName, Map<String, String> customProperties2) {
        Editor editor;
        if (createdElement == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(2);
        }
        super.postProcess(createdElement, templateName, customProperties2);
        PsiElement element2 = this.getNavigationElement(createdElement);
        if (element2 != null && (editor = PsiEditorUtil.findEditor((PsiElement)element2)) != null) {
            editor.getCaretModel().moveToOffset(element2.getTextOffset());
        }
    }

    @Override
    protected boolean isAvailable(DataContext dataContext) {
        return CreateTemplateInPackageAction.isAvailable(dataContext, this.mySourceRootTypes, this::checkPackageExists);
    }

    @Override
    @Nullable
    protected PsiDirectory adjustDirectory(@NotNull PsiDirectory directory) {
        ProjectFileIndex index2;
        if (directory == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(3);
        }
        if (!(index2 = ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex()).isUnderSourceRootOfType(directory.getVirtualFile(), this.mySourceRootTypes)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
            if (module == null) {
                return null;
            }
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            ContentEntry contentEntry = (ContentEntry)ContainerUtil.find((Object[])modifiableModel.getContentEntries(), entry2 -> entry2.getFile() != null && VfsUtilCore.isAncestor((VirtualFile)entry2.getFile(), (VirtualFile)directory.getVirtualFile(), (boolean)false));
            if (contentEntry == null) {
                return null;
            }
            try {
                VirtualFile src = (VirtualFile)WriteAction.compute(() -> VfsUtil.createDirectoryIfMissing((VirtualFile)contentEntry.getFile(), (String)"src"));
                contentEntry.addSourceFolder(src, false);
                WriteAction.run(() -> modifiableModel.commit());
                return PsiManager.getInstance((Project)module.getProject()).findDirectory(src);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return directory;
    }

    public static boolean isAvailable(DataContext dataContext, Set<? extends JpsModuleSourceRootType<?>> sourceRootTypes, Predicate<? super PsiDirectory> checkPackageExists) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null || view.getDirectories().length == 0) {
            return false;
        }
        if (sourceRootTypes == null) {
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), sourceRootTypes) && checkPackageExists.test((PsiDirectory)dir)) {
                return true;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)dir);
            if (module == null || !ModuleType.is((Module)module, (ModuleType)GeneralModuleType.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean checkPackageExists(PsiDirectory var1);

    @Nullable
    private T checkOrCreate(String newName2, PsiDirectory directory, String templateName) throws IncorrectOperationException {
        PsiDirectory dir = directory;
        String className = this.removeExtension(templateName, newName2);
        if (className.contains(".")) {
            String[] names2 = className.split("\\.");
            for (int i2 = 0; i2 < names2.length - 1; ++i2) {
                dir = CreateFileAction.findOrCreateSubdirectory(dir, names2[i2]);
            }
            className = names2[names2.length - 1];
        }
        DumbService service = DumbService.getInstance((Project)dir.getProject());
        PsiDirectory finalDir = dir;
        String finalClassName = className;
        return (T)((PsiElement)service.computeWithAlternativeResolveEnabled(() -> this.doCreate(finalDir, finalClassName, templateName)));
    }

    protected String removeExtension(String templateName, String className) {
        String extension2 = StringUtil.getShortName((String)templateName);
        if (StringUtil.isNotEmpty((String)extension2)) {
            className = StringUtil.trimEnd((String)className, (String)("." + extension2));
        }
        return className;
    }

    @Nullable
    protected abstract T doCreate(PsiDirectory var1, String var2, String var3) throws IncorrectOperationException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CreateTemplateInPackageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcess";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

