/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Composite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    private static final Logger LOG = Logger.getInstance(ShowSettingsUtilImpl.class);

    @NotNull
    public static DialogWrapper getDialog(@Nullable Project project, @NotNull List<? extends ConfigurableGroup> groups2, @Nullable Configurable toSelect2) {
        if (groups2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(0);
        }
        DialogWrapper dialogWrapper2 = SettingsDialogFactory.getInstance().create(ProjectUtil.currentOrDefaultProject((Project)project), ShowSettingsUtilImpl.filterEmptyGroups(groups2), toSelect2, null);
        if (dialogWrapper2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(1);
        }
        return dialogWrapper2;
    }

    public static ConfigurableGroup @NotNull [] getConfigurableGroups(@Nullable Project project, boolean withIdeSettings) {
        ConfigurableGroup group2 = ConfigurableExtensionPointUtil.getConfigurableGroup(project, withIdeSettings);
        ConfigurableGroup[] configurableGroupArray = new ConfigurableGroup[]{group2};
        if (configurableGroupArray == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(2);
        }
        return configurableGroupArray;
    }

    @NotNull
    public static List<Configurable> getConfigurables(@Nullable Project project, boolean withIdeSettings) {
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        for (Configurable configurable2 : ConfigurableExtensionPointUtil.getConfigurables(withIdeSettings ? project : ProjectUtil.currentOrDefaultProject((Project)project), withIdeSettings)) {
            list2.add(configurable2);
            if (!(configurable2 instanceof Configurable.Composite)) continue;
            ShowSettingsUtilImpl.collect(list2, ((Configurable.Composite)configurable2).getConfigurables());
        }
        ArrayList<Configurable> arrayList = list2;
        if (arrayList == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void collect(@NotNull List<? super Configurable> list2, Configurable @NotNull [] configurables) {
        if (list2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(4);
        }
        if (configurables == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(5);
        }
        for (Configurable configurable2 : configurables) {
            list2.add((Configurable)configurable2);
            if (!(configurable2 instanceof Configurable.Composite)) continue;
            ShowSettingsUtilImpl.collect(list2, ((Configurable.Composite)configurable2).getConfigurables());
        }
    }

    public void showSettingsDialog(@NotNull Project project, ConfigurableGroup ... groups2) {
        if (project == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(6);
        }
        if (groups2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(7);
        }
        try {
            ShowSettingsUtilImpl.getDialog(project, Arrays.asList(groups2), null).show();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public <T extends Configurable> void showSettingsDialog(@Nullable Project project, @NotNull Class<T> configurableClass) {
        if (configurableClass == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(8);
        }
        this.showSettingsDialog(project, configurableClass, null);
    }

    public <T extends Configurable> void showSettingsDialog(@Nullable Project project, @NotNull Class<T> configurableClass, @Nullable Consumer<? super T> additionalConfiguration) {
        if (configurableClass == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(9);
        }
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        this.showSettingsDialog(project, (? super Configurable it) -> ConfigurableWrapper.cast(configurableClass, (UnnamedConfigurable)it) != null, (? super Configurable it) -> {
            if (additionalConfiguration != null) {
                Configurable toConfigure = (Configurable)ConfigurableWrapper.cast(configurableClass, (UnnamedConfigurable)it);
                assert (toConfigure != null) : "Wrong configurable found: " + it.getClass();
                additionalConfiguration.accept(toConfigure);
            }
        });
    }

    public void showSettingsDialog(@Nullable Project project, final @NotNull Predicate<? super Configurable> predicate2, @Nullable Consumer<? super Configurable> additionalConfiguration) {
        if (predicate2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(10);
        }
        ConfigurableGroup[] groups2 = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        Configurable config2 = new ConfigurableVisitor(){

            @Override
            protected boolean accept(@NotNull Configurable configurable2) {
                if (configurable2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return predicate2.test(configurable2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl$1", "accept"));
            }
        }.find(groups2);
        assert (config2 != null) : "Cannot find configurable for specified predicate";
        if (additionalConfiguration != null) {
            additionalConfiguration.accept((Configurable)config2);
        }
        ShowSettingsUtilImpl.getDialog(project, Arrays.asList(groups2), config2).show();
    }

    public void showSettingsDialog(@Nullable Project project, @NotNull String nameToSelect) {
        ConfigurableGroup group2;
        if (nameToSelect == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(11);
        }
        List<Object> groups2 = (group2 = ConfigurableExtensionPointUtil.getConfigurableGroup(project, true)).getConfigurables().length == 0 ? Collections.emptyList() : Collections.singletonList(group2);
        ShowSettingsUtilImpl.getDialog(project, groups2, ShowSettingsUtilImpl.findPreselectedByDisplayName(nameToSelect, groups2)).show();
    }

    @Nullable
    private static Configurable findPreselectedByDisplayName(@NotNull String preselectedConfigurableDisplayName, @NotNull List<? extends ConfigurableGroup> groups2) {
        if (preselectedConfigurableDisplayName == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(12);
        }
        if (groups2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(13);
        }
        for (ConfigurableGroup configurableGroup : groups2) {
            for (Configurable configurable2 : SearchUtil.expandGroup(configurableGroup)) {
                if (!preselectedConfigurableDisplayName.equals(configurable2.getDisplayName())) continue;
                return configurable2;
            }
        }
        return null;
    }

    public static void showSettingsDialog(@Nullable Project project, @Nullable String idToSelect, String filter) {
        ConfigurableGroup group2 = ConfigurableExtensionPointUtil.getConfigurableGroup(project, true);
        if (group2.getConfigurables().length == 0) {
            group2 = null;
        }
        Configurable configurableToSelect = idToSelect == null ? null : ConfigurableVisitor.findById(idToSelect, Collections.singletonList(group2));
        SettingsDialogFactory.getInstance().create(ProjectUtil.currentOrDefaultProject((Project)project), Collections.singletonList(group2), configurableToSelect, filter).show();
    }

    public void showSettingsDialog(@NotNull Project project, @Nullable Configurable toSelect2) {
        if (project == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(14);
        }
        List<ConfigurableGroup> groups2 = Collections.singletonList(ConfigurableExtensionPointUtil.getConfigurableGroup(project, true));
        ShowSettingsUtilImpl.getDialog(project, groups2, toSelect2).show();
    }

    @NotNull
    private static List<ConfigurableGroup> filterEmptyGroups(@NotNull List<? extends ConfigurableGroup> group2) {
        if (group2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(15);
        }
        ArrayList<ConfigurableGroup> groups2 = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup configurableGroup : group2) {
            if (configurableGroup.getConfigurables().length <= 0) continue;
            groups2.add(configurableGroup);
        }
        ArrayList<ConfigurableGroup> arrayList = groups2;
        if (arrayList == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public boolean editConfigurable(Project project, @NotNull Configurable configurable2) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(17);
        }
        return this.editConfigurable(project, ShowSettingsUtilImpl.createDimensionKey(configurable2), configurable2);
    }

    public boolean editConfigurable(Project project, @NotNull String dimensionServiceKey, @NotNull Configurable configurable2) {
        if (dimensionServiceKey == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(18);
        }
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(19);
        }
        return this.editConfigurable(project, dimensionServiceKey, configurable2, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    private static boolean isWorthToShowApplyButton(@NotNull Configurable configurable2) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(20);
        }
        return configurable2 instanceof Place.Navigator || configurable2 instanceof Composite || configurable2 instanceof TabbedConfigurable;
    }

    public boolean editConfigurable(Project project, @NotNull String dimensionServiceKey, @NotNull Configurable configurable2, boolean showApplyButton) {
        if (dimensionServiceKey == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(21);
        }
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(22);
        }
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable2, dimensionServiceKey, null, showApplyButton);
    }

    public boolean editConfigurable(Project project, @NotNull Configurable configurable2, Runnable advancedInitialization) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(23);
        }
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable2) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(24);
        }
        return this.editConfigurable(parent, configurable2, null);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull String displayName) {
        if (displayName == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(25);
        }
        return this.editConfigurable(parent, displayName, (Runnable)null);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull String displayName, @Nullable Runnable advancedInitialization) {
        ConfigurableGroup group2;
        List<Object> groups2;
        Configurable configurable2;
        if (displayName == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(26);
        }
        if ((configurable2 = ShowSettingsUtilImpl.findPreselectedByDisplayName(displayName, groups2 = (group2 = ConfigurableExtensionPointUtil.getConfigurableGroup(null, true)).getConfigurables().length == 0 ? Collections.emptyList() : Collections.singletonList(group2))) == null) {
            LOG.error("Cannot find configurable for name [" + displayName + "]");
            return false;
        }
        return this.editConfigurable(parent, configurable2, advancedInitialization);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable2, @Nullable Runnable advancedInitialization) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(27);
        }
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    private static boolean editConfigurable(@Nullable Component parent, @Nullable Project project, @NotNull Configurable configurable2, @NotNull String dimensionKey, final @Nullable Runnable advancedInitialization, boolean showApplyButton) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(28);
        }
        if (dimensionKey == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(29);
        }
        DialogWrapper editor = parent == null ? SettingsDialogFactory.getInstance().create(project, dimensionKey, configurable2, showApplyButton, false) : SettingsDialogFactory.getInstance().create(parent, dimensionKey, configurable2, showApplyButton, false);
        if (advancedInitialization != null) {
            new UiNotifyConnector.Once((Component)editor.getContentPane(), new Activatable(){

                public void showNotify() {
                    advancedInitialization.run();
                }
            });
        }
        return editor.showAndGet();
    }

    @NotNull
    public static String createDimensionKey(@NotNull Configurable configurable2) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(30);
        }
        String string = "#" + configurable2.getDisplayName().replace('\n', '_').replace(' ', '_');
        if (string == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(31);
        }
        return string;
    }

    public boolean editConfigurable(Component parent, @NotNull String dimensionServiceKey, @NotNull Configurable configurable2) {
        if (dimensionServiceKey == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(32);
        }
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(33);
        }
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable2, dimensionServiceKey, null, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ShowSettingsUtilImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToSelect";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectedConfigurableDisplayName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 18: 
            case 21: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimensionServiceKey";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimensionKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ShowSettingsUtilImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableGroups";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurables";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyGroups";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createDimensionKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDialog";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 31: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showSettingsDialog";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findPreselectedByDisplayName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyGroups";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "editConfigurable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isWorthToShowApplyButton";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createDimensionKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

