/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class GroupedResultsSearcher
implements SESearcher {
    private static final Logger LOG = Logger.getInstance(GroupedResultsSearcher.class);
    @NotNull
    private final SESearcher.Listener myListener;
    @NotNull
    private final Executor myNotificationExecutor;
    @NotNull
    private final SEResultsEqualityProvider myEqualityProvider;

    GroupedResultsSearcher(@NotNull SESearcher.Listener listener2, @NotNull Executor notificationExecutor, @NotNull Collection<? extends SEResultsEqualityProvider> equalityProviders) {
        if (listener2 == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(0);
        }
        if (notificationExecutor == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(1);
        }
        if (equalityProviders == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(2);
        }
        this.myListener = listener2;
        this.myNotificationExecutor = notificationExecutor;
        this.myEqualityProvider = SEResultsEqualityProvider.composite(equalityProviders);
    }

    @Override
    public ProgressIndicator search(@NotNull Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, @NotNull String pattern) {
        ProgressIndicatorBase indicator2;
        FullSearchResultsAccumulator accumulator;
        if (contributorsAndLimits == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(4);
        }
        LOG.debug("Search started for pattern [", new Object[]{pattern, "]"});
        Collection<Object> contributors = contributorsAndLimits.keySet();
        if (pattern.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            contributors = Collections.emptySet();
        }
        if (!(contributors = ContainerUtil.filter(contributors, contributor -> !contributor.filterControlSymbols(pattern).isEmpty() || contributor.isEmptyPatternSupported())).isEmpty()) {
            CountDownLatch latch = new CountDownLatch(contributors.size());
            ProgressIndicatorWithCancelListener indicatorWithCancelListener = new ProgressIndicatorWithCancelListener();
            accumulator = new FullSearchResultsAccumulator((Map<? extends SearchEverywhereContributor<?>, Integer>)contributorsAndLimits, this.myEqualityProvider, this.myListener, this.myNotificationExecutor, (ProgressIndicator)indicatorWithCancelListener);
            for (SearchEverywhereContributor searchEverywhereContributor : contributors) {
                Runnable task2 = GroupedResultsSearcher.createSearchTask(pattern, accumulator, indicatorWithCancelListener, searchEverywhereContributor, () -> latch.countDown());
                ApplicationManager.getApplication().executeOnPooledThread(task2);
            }
            Runnable finisherTask = GroupedResultsSearcher.createFinisherTask(latch, accumulator, indicatorWithCancelListener);
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(finisherTask);
            indicatorWithCancelListener.setCancelCallback(() -> {
                accumulator.stop();
                finisherFeature.cancel(true);
            });
            ProgressIndicatorWithCancelListener indicator3 = indicatorWithCancelListener;
        } else {
            indicator2 = new ProgressIndicatorBase();
            accumulator = new FullSearchResultsAccumulator((Map<? extends SearchEverywhereContributor<?>, Integer>)contributorsAndLimits, this.myEqualityProvider, this.myListener, this.myNotificationExecutor, (ProgressIndicator)indicator2);
        }
        indicator2.start();
        if (contributors.isEmpty()) {
            indicator2.stop();
            accumulator.searchFinished();
        }
        return indicator2;
    }

    @Override
    public ProgressIndicator findMoreItems(@NotNull Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, @NotNull Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, @NotNull String pattern) {
        if (alreadyFound == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(5);
        }
        if (contributorsAndLimits == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(7);
        }
        if (contributorsAndLimits.size() > 1) {
            throw new IllegalArgumentException("Multiple contributors are not allowed for grouped list");
        }
        Map.Entry entry2 = (Map.Entry)contributorsAndLimits.entrySet().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Empty contributors map is not allowed"));
        SearchEverywhereContributor contributor = (SearchEverywhereContributor)entry2.getKey();
        int newLimit = (Integer)entry2.getValue();
        ProgressIndicatorBase indicator2 = new ProgressIndicatorBase();
        ShowMoreResultsAccumulator accumulator = new ShowMoreResultsAccumulator(alreadyFound, this.myEqualityProvider, contributor, newLimit, this.myListener, this.myNotificationExecutor, indicator2);
        indicator2.start();
        Runnable task2 = GroupedResultsSearcher.createSearchTask(pattern, accumulator, indicator2, contributor, () -> indicator2.stop());
        ApplicationManager.getApplication().executeOnPooledThread(task2);
        return indicator2;
    }

    @NotNull
    private static Runnable createSearchTask(String pattern, ResultsAccumulator accumulator, ProgressIndicator indicator2, SearchEverywhereContributor<?> contributor, Runnable finalCallback) {
        ContributorSearchTask task2 = new ContributorSearchTask(contributor, pattern, accumulator, indicator2, finalCallback);
        Runnable runnable2 = ConcurrencyUtil.underThreadNameRunnable((String)("SE-SearchTask-" + contributor.getSearchProviderId()), task2);
        if (runnable2 == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(8);
        }
        return runnable2;
    }

    private static Runnable createFinisherTask(CountDownLatch latch, FullSearchResultsAccumulator accumulator, ProgressIndicator indicator2) {
        return ConcurrencyUtil.underThreadNameRunnable((String)"SE-FinisherTask", () -> {
            try {
                latch.await();
                if (!indicator2.isCanceled()) {
                    accumulator.searchFinished();
                }
                indicator2.stop();
            }
            catch (InterruptedException e) {
                LOG.debug("Finisher interrupted before search process is finished");
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityProviders";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorsAndLimits";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyFound";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/GroupedResultsSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/GroupedResultsSearcher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMoreItems";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProgressIndicatorWithCancelListener
    extends ProgressIndicatorBase {
        private volatile Runnable cancelCallback = () -> {};

        private ProgressIndicatorWithCancelListener() {
        }

        private void setCancelCallback(Runnable cancelCallback) {
            this.cancelCallback = cancelCallback;
        }

        @Override
        protected void onRunningChange() {
            if (this.isCanceled()) {
                this.cancelCallback.run();
            }
        }
    }

    private static class FullSearchResultsAccumulator
    extends ResultsAccumulator {
        private final Map<? extends SearchEverywhereContributor<?>, Integer> sectionsLimits;
        private final Map<? extends SearchEverywhereContributor<?>, Condition> conditionsMap;
        private final Map<SearchEverywhereContributor<?>, Boolean> hasMoreMap = new ConcurrentHashMap();
        private final Set<SearchEverywhereContributor<?>> finishedContributorsSet = ContainerUtil.newConcurrentSet();
        private final Lock lock = new ReentrantLock();
        private volatile boolean mySearchFinished = false;

        FullSearchResultsAccumulator(Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, SEResultsEqualityProvider equalityProvider, SESearcher.Listener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            super(contributorsAndLimits.entrySet().stream().collect(Collectors.toMap(entry2 -> (SearchEverywhereContributor)entry2.getKey(), entry2 -> new ArrayList((Integer)entry2.getValue()))), equalityProvider, listener2, notificationExecutor, progressIndicator);
            this.sectionsLimits = contributorsAndLimits;
            this.conditionsMap = contributorsAndLimits.keySet().stream().collect(Collectors.toMap(Function.identity(), c -> this.lock.newCondition()));
        }

        @Override
        public void setContributorHasMore(SearchEverywhereContributor<?> contributor, boolean hasMore) {
            this.hasMoreMap.put(contributor, hasMore);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addElement(Object element2, SearchEverywhereContributor<?> contributor, int priority, ProgressIndicator indicator2) throws InterruptedException {
            SearchEverywhereFoundElementInfo newElementInfo = new SearchEverywhereFoundElementInfo(element2, priority, contributor);
            Condition condition2 = this.conditionsMap.get(contributor);
            Collection section = (Collection)this.sections.get(contributor);
            int limit = this.sectionsLimits.get(contributor);
            this.lock.lock();
            try {
                while (section.size() >= limit && !this.mySearchFinished) {
                    indicator2.checkCanceled();
                    condition2.await(100L, TimeUnit.MILLISECONDS);
                }
                if (this.mySearchFinished) {
                    boolean bl = false;
                    return bl;
                }
                List alreadyFoundItems = this.sections.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                SEResultsEqualityProvider.SEEqualElementsActionType type = this.myEqualityProvider.compareItems(newElementInfo, alreadyFoundItems);
                if (type == SEResultsEqualityProvider.SEEqualElementsActionType.Skip.INSTANCE) {
                    LOG.debug(String.format("Element %s for contributor %s was skipped", element2.toString(), contributor.getSearchProviderId()));
                    boolean bl = true;
                    return bl;
                }
                section.add(newElementInfo);
                this.runInNotificationExecutor(() -> this.myListener.elementsAdded(Collections.singletonList(newElementInfo)));
                List<SearchEverywhereFoundElementInfo> toRemove2 = type instanceof SEResultsEqualityProvider.SEEqualElementsActionType.Replace ? ((SEResultsEqualityProvider.SEEqualElementsActionType.Replace)type).getToBeReplaced() : Collections.emptyList();
                toRemove2.forEach(info2 -> {
                    Collection list2 = (Collection)this.sections.get(info2.getContributor());
                    Condition listCondition = this.conditionsMap.get(info2.getContributor());
                    list2.remove(info2);
                    LOG.debug(String.format("Element %s for contributor %s is removed", info2.getElement().toString(), info2.getContributor().getSearchProviderId()));
                    listCondition.signal();
                });
                this.runInNotificationExecutor(() -> this.myListener.elementsRemoved(toRemove2));
                if (section.size() >= limit) {
                    this.stopSearchIfNeeded();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void contributorFinished(SearchEverywhereContributor<?> contributor) {
            this.lock.lock();
            try {
                this.finishedContributorsSet.add(contributor);
                this.stopSearchIfNeeded();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void searchFinished() {
            this.runInNotificationExecutor(() -> this.myListener.searchFinished(this.hasMoreMap));
        }

        public void stop() {
            this.lock.lock();
            try {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void stopSearchIfNeeded() {
            if (this.sections.keySet().stream().allMatch(contributor -> this.isContributorFinished((SearchEverywhereContributor<?>)contributor))) {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
        }

        private boolean isContributorFinished(SearchEverywhereContributor<?> contributor) {
            if (this.finishedContributorsSet.contains(contributor)) {
                return true;
            }
            return ((Collection)this.sections.get(contributor)).size() >= this.sectionsLimits.get(contributor);
        }
    }

    private static class ShowMoreResultsAccumulator
    extends ResultsAccumulator {
        private final SearchEverywhereContributor<?> myExpandedContributor;
        private final int myNewLimit;
        private volatile boolean hasMore;

        ShowMoreResultsAccumulator(Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, SEResultsEqualityProvider equalityProvider, SearchEverywhereContributor<?> contributor, int newLimit, SESearcher.Listener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            super(new ConcurrentHashMap(alreadyFound), equalityProvider, listener2, notificationExecutor, progressIndicator);
            this.myExpandedContributor = contributor;
            this.myNewLimit = newLimit;
        }

        @Override
        public boolean addElement(Object element2, SearchEverywhereContributor<?> contributor, int priority, ProgressIndicator indicator2) {
            assert (contributor == this.myExpandedContributor);
            Collection section = (Collection)this.sections.get(contributor);
            SearchEverywhereFoundElementInfo newElementInfo = new SearchEverywhereFoundElementInfo(element2, priority, contributor);
            if (section.size() >= this.myNewLimit) {
                return false;
            }
            List alreadyFoundItems = this.sections.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            SEResultsEqualityProvider.SEEqualElementsActionType action2 = this.myEqualityProvider.compareItems(newElementInfo, alreadyFoundItems);
            if (action2 == SEResultsEqualityProvider.SEEqualElementsActionType.Skip.INSTANCE) {
                LOG.debug(String.format("Element %s for contributor %s was skipped", element2.toString(), contributor.getSearchProviderId()));
                return true;
            }
            section.add(newElementInfo);
            this.runInNotificationExecutor(() -> this.myListener.elementsAdded(Collections.singletonList(newElementInfo)));
            List<SearchEverywhereFoundElementInfo> toRemove2 = action2 instanceof SEResultsEqualityProvider.SEEqualElementsActionType.Replace ? ((SEResultsEqualityProvider.SEEqualElementsActionType.Replace)action2).getToBeReplaced() : Collections.emptyList();
            toRemove2.forEach(info2 -> {
                Collection list2 = (Collection)this.sections.get(info2.getContributor());
                if (list2 != null) {
                    list2.remove(info2);
                    LOG.debug(String.format("Element %s for contributor %s is removed", info2.getElement().toString(), info2.getContributor().getSearchProviderId()));
                }
            });
            this.runInNotificationExecutor(() -> this.myListener.elementsRemoved(toRemove2));
            return true;
        }

        @Override
        public void setContributorHasMore(SearchEverywhereContributor<?> contributor, boolean hasMore) {
            assert (contributor == this.myExpandedContributor);
            this.hasMore = hasMore;
        }

        @Override
        public void contributorFinished(SearchEverywhereContributor<?> contributor) {
            this.runInNotificationExecutor(() -> this.myListener.searchFinished(Collections.singletonMap(contributor, this.hasMore)));
        }
    }

    private static abstract class ResultsAccumulator {
        protected final Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> sections;
        protected final SESearcher.Listener myListener;
        protected final Executor myNotificationExecutor;
        protected final SEResultsEqualityProvider myEqualityProvider;
        protected final ProgressIndicator myProgressIndicator;

        ResultsAccumulator(Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> sections2, SEResultsEqualityProvider equalityProvider, SESearcher.Listener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            this.sections = sections2;
            this.myEqualityProvider = equalityProvider;
            this.myListener = listener2;
            this.myNotificationExecutor = notificationExecutor;
            this.myProgressIndicator = progressIndicator;
        }

        protected void runInNotificationExecutor(Runnable runnable2) {
            this.myNotificationExecutor.execute(() -> {
                if (!this.myProgressIndicator.isCanceled()) {
                    runnable2.run();
                }
            });
        }

        public abstract boolean addElement(Object var1, SearchEverywhereContributor<?> var2, int var3, ProgressIndicator var4) throws InterruptedException;

        public abstract void contributorFinished(SearchEverywhereContributor<?> var1);

        public abstract void setContributorHasMore(SearchEverywhereContributor<?> var1, boolean var2);
    }

    private static final class ContributorSearchTask<Item>
    implements Runnable {
        private final ResultsAccumulator myAccumulator;
        private final Runnable finishCallback;
        private final SearchEverywhereContributor<Item> myContributor;
        private final String myPattern;
        private final ProgressIndicator myIndicator;

        private ContributorSearchTask(SearchEverywhereContributor<Item> contributor, String pattern, ResultsAccumulator accumulator, ProgressIndicator indicator2, Runnable callback2) {
            this.myContributor = contributor;
            this.myPattern = pattern;
            this.myAccumulator = accumulator;
            this.myIndicator = indicator2;
            this.finishCallback = callback2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("Search task started for contributor ", new Object[]{this.myContributor});
            try {
                SensitiveProgressWrapper wrapperIndicator;
                boolean repeat2;
                do {
                    wrapperIndicator = new SensitiveProgressWrapper(this.myIndicator);
                    try {
                        if (this.myContributor instanceof WeightedSearchEverywhereContributor) {
                            ((WeightedSearchEverywhereContributor)this.myContributor).fetchWeightedElements(this.myPattern, (ProgressIndicator)wrapperIndicator, descriptor2 -> this.processFoundItem(descriptor2.getItem(), descriptor2.getWeight(), wrapperIndicator));
                            continue;
                        }
                        this.myContributor.fetchElements(this.myPattern, (ProgressIndicator)wrapperIndicator, element2 -> {
                            int priority = this.myContributor.getElementPriority(Objects.requireNonNull(element2), this.myPattern);
                            return this.processFoundItem(element2, priority, wrapperIndicator);
                        });
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                } while (repeat2 = !this.myIndicator.isCanceled() && wrapperIndicator.isCanceled());
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                this.myAccumulator.contributorFinished(this.myContributor);
            }
            finally {
                this.finishCallback.run();
            }
            LOG.debug("Search task finished for contributor ", new Object[]{this.myContributor});
        }

        private boolean processFoundItem(Item element2, int priority, ProgressIndicator wrapperIndicator) {
            try {
                if (element2 == null) {
                    LOG.debug("Skip null element");
                    return true;
                }
                boolean added2 = this.myAccumulator.addElement(element2, this.myContributor, priority, wrapperIndicator);
                if (!added2) {
                    this.myAccumulator.setContributorHasMore(this.myContributor, true);
                }
                return added2;
            }
            catch (InterruptedException e) {
                LOG.warn("Search task was interrupted");
                return false;
            }
        }
    }
}

