/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.actions.searcheverywhere.ActionSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.RunConfigurationsSEContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorValidationRule;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereTabDescriptor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.actions.searcheverywhere.TopHitSEContributor;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchEverywhereManagerImpl
implements SearchEverywhereManager {
    public static final String ALL_CONTRIBUTORS_GROUP_ID = "SearchEverywhereContributor.All";
    public static final String LOCATION_SETTINGS_KEY = "search.everywhere.popup";
    public static final DataKey<Boolean> IS_SELECT_SEARCH_TEXT = DataKey.create("search.everywhere.is.select.search.text");
    private final Map<String, String> myTabsShortcutsMap;
    private final Project myProject;
    private JBPopup myBalloon;
    private SearchEverywhereUI mySearchEverywhereUI;
    private Dimension myBalloonFullSize;
    private final SearchHistoryList myHistoryList = new SearchHistoryList();
    private final Map<String, Object> myPrevSelections = new HashMap<String, Object>();
    private HistoryIterator myHistoryIterator;
    private boolean myEverywhere;

    public SearchEverywhereManagerImpl() {
        this.myProject = null;
        this.myTabsShortcutsMap = Collections.emptyMap();
    }

    public SearchEverywhereManagerImpl(Project project) {
        this.myProject = project;
        this.myTabsShortcutsMap = SearchEverywhereManagerImpl.createShortcutsMap();
    }

    @Override
    public void show(@NotNull String tabID, @Nullable String searchText, @NotNull AnActionEvent initEvent) {
        if (tabID == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(0);
        }
        if (initEvent == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.isShown()) {
            throw new IllegalStateException("Method should cannot be called when popup is shown");
        }
        Project project = initEvent.getProject();
        Component contextComponent = (Component)initEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Map<SearchEverywhereContributor<?>, SearchEverywhereTabDescriptor> contributors = this.createContributors(initEvent, project, contextComponent);
        SearchEverywhereContributorValidationRule.updateContributorsMap(contributors.keySet());
        this.mySearchEverywhereUI = this.createView(this.myProject, contributors);
        contributors.keySet().forEach(c -> Disposer.register((Disposable)this.mySearchEverywhereUI, (Disposable)c));
        this.mySearchEverywhereUI.switchToTab(tabID);
        this.myHistoryIterator = this.myHistoryList.getIterator(tabID);
        boolean suppressHistory = SystemProperties.getBooleanProperty((String)"idea.searchEverywhere.noHistory", (boolean)false);
        boolean bl = suppressHistory = suppressHistory || ALL_CONTRIBUTORS_GROUP_ID.equals(tabID) && Registry.is((String)"search.everywhere.disable.history.for.all");
        if (searchText == null && !suppressHistory) {
            searchText = this.myHistoryIterator.prev();
        }
        this.myBalloon = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this.mySearchEverywhereUI), (JComponent)this.mySearchEverywhereUI.getSearchField()).setProject(this.myProject).setModalContext(false).setCancelOnClickOutside(true).setRequestFocus(true).setCancelKeyEnabled(false).setCancelCallback(() -> {
            this.saveSearchText();
            SearchEverywhereUsageTriggerCollector.DIALOG_CLOSED.log(this.myProject);
            return true;
        }).addUserData((Object)"SIMPLE_WINDOW").setResizable(true).setMovable(true).setDimensionServiceKey(project, LOCATION_SETTINGS_KEY, true).setLocateWithinScreenBounds(false).createPopup();
        Disposer.register((Disposable)this.myBalloon, (Disposable)this.mySearchEverywhereUI);
        OpenInRightSplitAction.Companion.overrideDoubleClickWithOneClick(this.myBalloon.getContent());
        if (project != null) {
            Disposer.register((Disposable)project, (Disposable)this.myBalloon);
        }
        Dimension size2 = this.mySearchEverywhereUI.getMinimumSize();
        JBInsets.addTo((Dimension)size2, (Insets)this.myBalloon.getContent().getInsets());
        this.myBalloon.setMinimumSize(size2);
        Project dataHolder = this.myProject != null ? project : ApplicationManager.getApplication();
        ConcurrentHashMap<ClientId, JBPopup> map2 = (ConcurrentHashMap<ClientId, JBPopup>)dataHolder.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP);
        if (map2 == null) {
            map2 = new ConcurrentHashMap<ClientId, JBPopup>();
            dataHolder.putUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP, map2);
        }
        map2.put(ClientId.getCurrent(), this.myBalloon);
        if (searchText != null && !searchText.isEmpty()) {
            this.mySearchEverywhereUI.getSearchField().setText(searchText);
            if (!Boolean.FALSE.equals(initEvent.getData(IS_SELECT_SEARCH_TEXT))) {
                this.mySearchEverywhereUI.getSearchField().selectAll();
            }
        }
        Disposer.register((Disposable)this.myBalloon, () -> this.lambda$show$2((UserDataHolder)dataHolder));
        this.myBalloonFullSize = this.getStateService().getSize(LOCATION_SETTINGS_KEY);
        if (this.mySearchEverywhereUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            Dimension prefSize = this.mySearchEverywhereUI.getPreferredSize();
            this.myBalloon.setSize(prefSize);
        }
        this.calcPositionAndShow(initEvent, project, this.myBalloon);
    }

    private WindowStateService getStateService() {
        return this.myProject != null ? WindowStateService.getInstance((Project)this.myProject) : WindowStateService.getInstance();
    }

    private Map<SearchEverywhereContributor<?>, SearchEverywhereTabDescriptor> createContributors(@NotNull AnActionEvent initEvent, Project project, Component contextComponent) {
        if (initEvent == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ActionSearchEverywhereContributor.Factory factory2 = new ActionSearchEverywhereContributor.Factory();
            return Collections.singletonMap(factory2.createContributor(initEvent), SearchEverywhereTabDescriptor.IDE);
        }
        HashMap res2 = new HashMap();
        res2.put(new TopHitSEContributor(project, contextComponent, s -> this.mySearchEverywhereUI.getSearchField().setText((String)s)), SearchEverywhereTabDescriptor.IDE);
        res2.put(PSIPresentationBgRendererWrapper.wrapIfNecessary(new RecentFilesSEContributor(initEvent)), SearchEverywhereTabDescriptor.PROJECT);
        res2.put(new RunConfigurationsSEContributor(project, contextComponent, () -> this.mySearchEverywhereUI.getSearchField().getText()), SearchEverywhereTabDescriptor.IDE);
        for (SearchEverywhereContributorFactory factory3 : SearchEverywhereContributor.EP_NAME.getExtensionList()) {
            SearchEverywhereContributor contributor = factory3.createContributor(initEvent);
            SearchEverywhereTabDescriptor tab = factory3.getTab();
            res2.put(contributor, tab);
        }
        return res2;
    }

    private void calcPositionAndShow(@NotNull AnActionEvent initEvent, Project project, JBPopup balloon2) {
        Window window;
        Component parent;
        if (initEvent == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(3);
        }
        if (initEvent.getPlace().equals("NewToolbar")) {
            Component component2 = (Component)initEvent.getInputEvent().getSource();
            balloon2.setLocation(component2.getLocationOnScreen());
            ((AbstractPopup)balloon2).show(component2, 0, 0, true);
            return;
        }
        Point savedLocation = this.getStateService().getLocation(LOCATION_SETTINGS_KEY);
        if (savedLocation == null && this.mySearchEverywhereUI.getViewType() == BigPopupUI.ViewType.SHORT && (parent = UIUtil.findUltimateParent((Component)(window = project != null ? WindowManager.getInstance().suggestParentWindow(project) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()))) != null) {
            JComponent content2 = balloon2.getContent();
            Dimension balloonSize = content2.getPreferredSize();
            Point screenPoint = new Point((parent.getSize().width - balloonSize.width) / 2, parent.getHeight() / 4 - balloonSize.height / 2);
            SwingUtilities.convertPointToScreen(screenPoint, parent);
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Point)screenPoint);
            Insets insets = content2.getInsets();
            int bottomEdge = screenPoint.y + this.mySearchEverywhereUI.getExpandedSize().height + insets.bottom + insets.top;
            int shift = bottomEdge - (int)screenRectangle.getMaxY();
            if (shift > 0) {
                screenPoint.y = Integer.max(screenPoint.y - shift, screenRectangle.y);
            }
            RelativePoint showPoint = new RelativePoint(screenPoint);
            balloon2.show(showPoint);
            return;
        }
        if (project != null) {
            balloon2.showCenteredInCurrentWindow(project);
        } else {
            balloon2.showInFocusCenter();
        }
    }

    @Override
    public boolean isShown() {
        return this.mySearchEverywhereUI != null && this.myBalloon != null && !this.myBalloon.isDisposed();
    }

    @Override
    @NotNull
    public String getSelectedTabID() {
        this.checkIsShown();
        String string = this.mySearchEverywhereUI.getSelectedTabID();
        if (string == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setSelectedTabID(@NotNull String contributorID) {
        if (contributorID == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(5);
        }
        this.checkIsShown();
        if (!contributorID.equals(this.getSelectedTabID())) {
            this.mySearchEverywhereUI.switchToTab(contributorID);
        }
    }

    @Override
    public void toggleEverywhereFilter() {
        this.checkIsShown();
        this.mySearchEverywhereUI.toggleEverywhereFilter();
    }

    @Override
    public boolean isEverywhere() {
        return this.myEverywhere;
    }

    public void setEverywhere(boolean everywhere) {
        this.myEverywhere = everywhere;
    }

    private SearchEverywhereUI createView(Project project, Map<SearchEverywhereContributor<?>, SearchEverywhereTabDescriptor> contributors) {
        if (LightEdit.owns((Project)project)) {
            contributors = ContainerUtil.filter(contributors, contributor -> contributor instanceof LightEditCompatible);
        }
        SearchEverywhereUI view = new SearchEverywhereUI(project, contributors, this.myTabsShortcutsMap::get);
        view.setSearchFinishedHandler(() -> {
            if (this.isShown()) {
                this.myBalloon.cancel();
            }
        });
        view.addViewTypeListener(viewType -> {
            if (!this.isShown()) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myBalloon == null || this.myBalloon.isDisposed()) {
                    return;
                }
                Dimension minSize = view.getMinimumSize();
                JBInsets.addTo((Dimension)minSize, (Insets)this.myBalloon.getContent().getInsets());
                this.myBalloon.setMinimumSize(minSize);
                if (viewType == BigPopupUI.ViewType.SHORT) {
                    this.myBalloonFullSize = this.myBalloon.getSize();
                    JBInsets.removeFrom((Dimension)this.myBalloonFullSize, (Insets)this.myBalloon.getContent().getInsets());
                    this.myBalloon.pack(false, true);
                } else {
                    if (this.myBalloonFullSize == null) {
                        this.myBalloonFullSize = view.getPreferredSize();
                        JBInsets.addTo((Dimension)this.myBalloonFullSize, (Insets)this.myBalloon.getContent().getInsets());
                    }
                    this.myBalloonFullSize.height = Integer.max(this.myBalloonFullSize.height, minSize.height);
                    this.myBalloonFullSize.width = Integer.max(this.myBalloonFullSize.width, minSize.width);
                    this.myBalloon.setSize(this.myBalloonFullSize);
                }
            });
        });
        DumbAwareAction.create(__ -> this.showHistoryItem(true)).registerCustomShortcutSet((ShortcutSet)SearchTextField.SHOW_HISTORY_SHORTCUT, (JComponent)((Object)view));
        DumbAwareAction.create(__ -> this.showHistoryItem(false)).registerCustomShortcutSet((ShortcutSet)SearchTextField.ALT_SHOW_HISTORY_SHORTCUT, (JComponent)((Object)view));
        return view;
    }

    private void checkIsShown() {
        if (!this.isShown()) {
            throw new IllegalStateException("Method should be called only when search popup is shown");
        }
    }

    private void saveSearchText() {
        if (!this.isShown()) {
            return;
        }
        this.updateHistoryIterator();
        String searchText = this.mySearchEverywhereUI.getSearchField().getText();
        if (!searchText.isEmpty()) {
            this.myHistoryList.saveText(searchText, this.mySearchEverywhereUI.getSelectedTabID());
        }
        this.myPrevSelections.put(this.mySearchEverywhereUI.getSelectedTabID(), this.mySearchEverywhereUI.getSelectionIdentity());
    }

    @Nullable
    public Object getPrevSelection(String contributorID) {
        return this.myPrevSelections.remove(contributorID);
    }

    private void saveSize() {
        if (this.mySearchEverywhereUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            this.getStateService().putSize(LOCATION_SETTINGS_KEY, this.myBalloonFullSize);
        }
    }

    private void showHistoryItem(boolean next) {
        if (!this.isShown()) {
            return;
        }
        this.updateHistoryIterator();
        JTextField searchField = this.mySearchEverywhereUI.getSearchField();
        searchField.setText(next ? this.myHistoryIterator.next() : this.myHistoryIterator.prev());
        searchField.selectAll();
    }

    private void updateHistoryIterator() {
        if (!this.isShown()) {
            return;
        }
        String selectedContributorID = this.mySearchEverywhereUI.getSelectedTabID();
        if (this.myHistoryIterator == null || !this.myHistoryIterator.getContributorID().equals(selectedContributorID)) {
            this.myHistoryIterator = this.myHistoryList.getIterator(selectedContributorID);
        }
    }

    private static Map<String, String> createShortcutsMap() {
        HashMap<String, String> res2 = new HashMap<String, String>();
        res2.put(ALL_CONTRIBUTORS_GROUP_ID, "Double Shift");
        SearchEverywhereManagerImpl.addShortcut(res2, "ClassSearchEverywhereContributor", "GotoClass");
        SearchEverywhereManagerImpl.addShortcut(res2, "FileSearchEverywhereContributor", "GotoFile");
        SearchEverywhereManagerImpl.addShortcut(res2, "SymbolSearchEverywhereContributor", "GotoSymbol");
        SearchEverywhereManagerImpl.addShortcut(res2, "ActionSearchEverywhereContributor", "GotoAction");
        return res2;
    }

    private static void addShortcut(Map<String, String> map2, String contributorID, String actionID) {
        KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut(actionID);
        if (shortcut != null) {
            map2.put(contributorID, KeymapUtil.getShortcutText((Shortcut)shortcut));
        }
    }

    private /* synthetic */ void lambda$show$2(UserDataHolder dataHolder) {
        this.saveSize();
        Objects.requireNonNull((ConcurrentHashMap)dataHolder.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP)).remove(ClientId.getCurrent());
        this.mySearchEverywhereUI = null;
        this.myBalloon = null;
        this.myBalloonFullSize = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabID";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initEvent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTabID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createContributors";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcPositionAndShow";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedTabID";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HistoryIterator {
        private final String contributorID;
        private final List<String> list;
        private int index;

        HistoryIterator(String id2, List<String> list2) {
            this.contributorID = id2;
            this.list = list2;
            this.index = -1;
        }

        public String getContributorID() {
            return this.contributorID;
        }

        public String next() {
            if (this.list.isEmpty()) {
                return "";
            }
            ++this.index;
            if (this.index >= this.list.size()) {
                this.index = 0;
            }
            return this.list.get(this.index);
        }

        public String prev() {
            if (this.list.isEmpty()) {
                return "";
            }
            --this.index;
            if (this.index < 0) {
                this.index = this.list.size() - 1;
            }
            return this.list.get(this.index);
        }
    }

    private static class SearchHistoryList {
        private static final int HISTORY_LIMIT = 50;
        private final List<HistoryItem> historyList = new ArrayList<HistoryItem>();
        private static final Collector<String, List<String>, List<String>> distinctCollector = Collector.of(() -> new ArrayList(), (lst, str) -> {
            lst.remove(str);
            lst.add(str);
        }, (lst1, lst2) -> {
            lst1.removeAll((Collection<?>)lst2);
            lst1.addAll(lst2);
            return lst1;
        }, new Collector.Characteristics[0]);

        private SearchHistoryList() {
        }

        public HistoryIterator getIterator(String contributorID) {
            List<String> list2 = this.getHistoryForContributor(contributorID);
            return new HistoryIterator(contributorID, list2);
        }

        public void saveText(@NotNull String text2, @NotNull String contributorID) {
            if (text2 == null) {
                SearchHistoryList.$$$reportNull$$$0(0);
            }
            if (contributorID == null) {
                SearchHistoryList.$$$reportNull$$$0(1);
            }
            this.historyList.stream().filter(item -> text2.equals(item.getSearchText()) && contributorID.equals(item.getContributorID())).findFirst().ifPresent(this.historyList::remove);
            this.historyList.add(new HistoryItem(text2, contributorID));
            List<String> list2 = this.filteredHistory(item -> item.getContributorID().equals(contributorID));
            if (list2.size() > 50) {
                this.historyList.stream().filter(item -> item.getContributorID().equals(contributorID)).findFirst().ifPresent(this.historyList::remove);
            }
        }

        private List<String> getHistoryForContributor(String contributorID) {
            if (SearchEverywhereManagerImpl.ALL_CONTRIBUTORS_GROUP_ID.equals(contributorID)) {
                List<String> res2 = this.filteredHistory(item -> true);
                int size2 = res2.size();
                return size2 > 50 ? res2.subList(size2 - 50, size2) : res2;
            }
            return this.filteredHistory(item -> item.getContributorID().equals(contributorID));
        }

        @NotNull
        private List<String> filteredHistory(Predicate<? super HistoryItem> predicate2) {
            List<String> list2 = this.historyList.stream().filter(predicate2).map(item -> item.getSearchText()).collect(distinctCollector);
            if (list2 == null) {
                SearchHistoryList.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributorID";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl$SearchHistoryList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl$SearchHistoryList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filteredHistory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "saveText";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class HistoryItem {
            private final String searchText;
            private final String contributorID;

            HistoryItem(String searchText, String contributorID) {
                this.searchText = searchText;
                this.contributorID = contributorID;
            }

            public String getSearchText() {
                return this.searchText;
            }

            public String getContributorID() {
                return this.contributorID;
            }
        }
    }
}

