/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.accessibility.TextFieldWithListAccessibleContext;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.GroupedListFactory;
import com.intellij.ide.actions.searcheverywhere.GroupedResultsSearcher;
import com.intellij.ide.actions.searcheverywhere.MixedListFactory;
import com.intellij.ide.actions.searcheverywhere.MixedResultsSearcher;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.SEListSelectionTracker;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SEResultsListFactory;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereHeader;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManagerImpl;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereTabDescriptor;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.ide.actions.searcheverywhere.SearchRestartReason;
import com.intellij.ide.actions.searcheverywhere.ThrottlingListenerWrapper;
import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereMlSessionService;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchFieldStatisticsCollector;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RowIcon;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SearchEverywhereUI
extends BigPopupUI
implements DataProvider,
QuickSearchComponent {
    public static final String SEARCH_EVERYWHERE_SEARCH_FILED_KEY = "search-everywhere-textfield";
    public static final int SINGLE_CONTRIBUTOR_ELEMENTS_LIMIT = 30;
    public static final int MULTIPLE_CONTRIBUTORS_ELEMENTS_LIMIT = 15;
    public static final int THROTTLING_TIMEOUT = 100;
    private final SEResultsListFactory myListFactory;
    private SearchListModel myListModel;
    private final SearchEverywhereHeader myHeader;
    private String myNotFoundString;
    private final SESearcher mySearcher;
    private final ThrottlingListenerWrapper myBufferedListener;
    private ProgressIndicator mySearchProgressIndicator;
    private final SEListSelectionTracker mySelectionTracker;
    private final SearchFieldTypingListener mySearchTypingListener;
    private final HintHelper myHintHelper;
    private static final long REBUILD_LIST_DELAY = 100L;
    private final Alarm rebuildListAlarm;
    private final ListCellRenderer<Object> myCommandRenderer;
    private final SearchListener mySearchListener;
    private final SearchEverywhereContributor<Object> myStubCommandContributor;

    public SearchEverywhereUI(@Nullable Project project, Map<SearchEverywhereContributor<?>, SearchEverywhereTabDescriptor> contributors) {
        this(project, contributors, s -> null);
    }

    public SearchEverywhereUI(@Nullable Project project, Map<SearchEverywhereContributor<?>, SearchEverywhereTabDescriptor> contributors, @NotNull Function<? super String, String> shortcutSupplier) {
        if (shortcutSupplier == null) {
            SearchEverywhereUI.$$$reportNull$$$0(0);
        }
        super(project);
        this.rebuildListAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myCommandRenderer = new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList<?> list2, Object value2, int index2, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                this.setPaintFocusBorder(false);
                this.setIcon(EmptyIcon.ICON_16);
                this.setFont(list2.getFont());
                SearchEverywhereCommandInfo command = (SearchEverywhereCommandInfo)value2;
                this.append(command.getCommandWithPrefix() + " ", new SimpleTextAttributes(0, list2.getForeground()));
                this.append(command.getDefinition(), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                this.setBackground(UIUtil.getListBackground((boolean)selected2, (boolean)hasFocus));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$7", "customizeCellRenderer"));
            }
        };
        this.mySearchListener = new SearchListener();
        this.myStubCommandContributor = new SearchEverywhereContributor<Object>(){

            @NotNull
            public String getSearchProviderId() {
                return "CommandsContributor";
            }

            @NotNull
            public String getGroupName() {
                String string = IdeBundle.message((String)"searcheverywhere.commands.tab.name", (Object[])new Object[0]);
                if (string == null) {
                    8.$$$reportNull$$$0(0);
                }
                return string;
            }

            public int getSortWeight() {
                return 10;
            }

            public boolean showInFindResults() {
                return false;
            }

            public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super Object> consumer) {
                if (pattern == null) {
                    8.$$$reportNull$$$0(1);
                }
                if (progressIndicator == null) {
                    8.$$$reportNull$$$0(2);
                }
                if (consumer == null) {
                    8.$$$reportNull$$$0(3);
                }
            }

            public boolean processSelectedItem(@NotNull Object selected2, int modifiers, @NotNull String searchText) {
                if (selected2 == null) {
                    8.$$$reportNull$$$0(4);
                }
                if (searchText == null) {
                    8.$$$reportNull$$$0(5);
                }
                SearchEverywhereUI.this.mySearchField.setText(((SearchEverywhereCommandInfo)selected2).getCommandWithPrefix() + " ");
                SearchEverywhereUsageTriggerCollector.COMMAND_COMPLETED.log(SearchEverywhereUI.this.myProject, new EventPair[0]);
                return false;
            }

            @NotNull
            public ListCellRenderer<? super Object> getElementsRenderer() {
                ListCellRenderer<Object> listCellRenderer2 = SearchEverywhereUI.this.myCommandRenderer;
                if (listCellRenderer2 == null) {
                    8.$$$reportNull$$$0(6);
                }
                return listCellRenderer2;
            }

            @Nullable
            public Object getDataForItem(@NotNull Object element2, @NotNull String dataId) {
                if (element2 == null) {
                    8.$$$reportNull$$$0(7);
                }
                if (dataId == null) {
                    8.$$$reportNull$$$0(8);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$8";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "progressIndicator";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selected";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchText";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getGroupName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$8";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElementsRenderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "fetchElements";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "processSelectedItem";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "getDataForItem";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myListFactory = Experiments.getInstance().isFeatureEnabled("search.everywhere.mixed.results") ? new MixedListFactory() : new GroupedListFactory();
        List<SEResultsEqualityProvider> equalityProviders = SEResultsEqualityProvider.getProviders();
        this.myBufferedListener = new ThrottlingListenerWrapper(100, this.mySearchListener, Runnable::run);
        this.mySearcher = Experiments.getInstance().isFeatureEnabled("search.everywhere.mixed.results") ? new MixedResultsSearcher(this.myBufferedListener, run2 -> ApplicationManager.getApplication().invokeLater(run2), equalityProviders) : new GroupedResultsSearcher(this.myBufferedListener, run2 -> ApplicationManager.getApplication().invokeLater(run2), equalityProviders);
        Runnable scopeChangedCallback = () -> {
            this.updateSearchFieldAdvertisement();
            this.scheduleRebuildList(SearchRestartReason.SCOPE_CHANGED);
        };
        this.myHeader = new SearchEverywhereHeader(project, contributors, scopeChangedCallback, shortcutSupplier, (AnAction)(project == null ? null : new ShowInFindToolWindowAction()), this);
        this.init();
        this.initSearchActions();
        this.myResultsList.setSelectionMode(2);
        this.myResultsList.addListSelectionListener(e -> {
            boolean multiSelection;
            int[] selectedIndices = this.myResultsList.getSelectedIndices();
            if (selectedIndices.length > 1 && !(multiSelection = Arrays.stream(selectedIndices).allMatch(i2 -> {
                SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i2);
                return contributor != null && contributor.isMultiSelectionSupported();
            }))) {
                int index2 = this.myResultsList.getLeadSelectionIndex();
                this.myResultsList.setSelectedIndex(index2);
            }
        });
        this.mySelectionTracker = new SEListSelectionTracker(this.myResultsList, this.myListModel);
        this.myResultsList.addListSelectionListener((ListSelectionListener)this.mySelectionTracker);
        this.mySearchTypingListener = new SearchFieldTypingListener();
        this.mySearchField.addKeyListener((KeyListener)this.mySearchTypingListener);
        this.myHintHelper = new HintHelper(this.mySearchField);
        SearchEverywhereMlSessionService.getInstance().onSessionStarted(this.myProject);
        Disposer.register((Disposable)this, (Disposable)SearchFieldStatisticsCollector.createAndStart((JTextField)this.mySearchField, this.myProject));
    }

    @Override
    @NotNull
    protected ListCellRenderer<Object> createCellRenderer() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ListCellRenderer<Object> listCellRenderer2 = (list2, value2, index2, isSelected, cellHasFocus) -> new JPanel();
            if (listCellRenderer2 == null) {
                SearchEverywhereUI.$$$reportNull$$$0(1);
            }
            return listCellRenderer2;
        }
        ListCellRenderer<Object> listCellRenderer3 = this.myListFactory.createListRenderer(this.myListModel, this.myHeader);
        if (listCellRenderer3 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(2);
        }
        return listCellRenderer3;
    }

    @Override
    @NotNull
    public JBList<Object> createList() {
        this.myListModel = this.myListFactory.createModel();
        this.addListDataListener(this.myListModel);
        JBList<Object> jBList = this.myListFactory.createList(this.myListModel);
        if (jBList == null) {
            SearchEverywhereUI.$$$reportNull$$$0(3);
        }
        return jBList;
    }

    public void toggleEverywhereFilter() {
        this.myHeader.toggleEverywhere();
    }

    public void switchToTab(@NotNull String tabID) {
        if (tabID == null) {
            SearchEverywhereUI.$$$reportNull$$$0(4);
        }
        SearchEverywhereHeader.SETab selectedTab = this.myHeader.getTabs().stream().filter(tab -> tab.getID().equals(tabID)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("There is no such tab - %s", tabID)));
        this.switchToTab(selectedTab);
    }

    private void switchToTab(SearchEverywhereHeader.SETab tab) {
        boolean prevTabIsSingleContributor = this.myHeader.getSelectedTab().isSingleContributor();
        this.myHeader.switchToTab(tab);
        boolean nextTabIsSingleContributor = this.myHeader.getSelectedTab().isSingleContributor();
        this.updateSearchFieldAdvertisement();
        if (prevTabIsSingleContributor != nextTabIsSingleContributor) {
            this.myResultsList.setCellRenderer(this.myResultsList.getCellRenderer());
        }
    }

    private void updateSearchFieldAdvertisement() {
        if (this.mySearchField == null) {
            return;
        }
        List<SearchEverywhereContributor<?>> contributors = this.myHeader.getSelectedTab().getContributors();
        String advertisementText = this.getWarning(contributors);
        if (advertisementText != null) {
            this.myHintHelper.setWarning(advertisementText);
            return;
        }
        advertisementText = SearchEverywhereUI.getAdvertisement(contributors);
        this.myHintHelper.setHint(advertisementText);
    }

    @Nls
    @Nullable
    private String getWarning(List<SearchEverywhereContributor<?>> contributors) {
        boolean containsPSIContributors;
        if (this.myProject != null && DumbService.isDumb((Project)this.myProject) && (containsPSIContributors = contributors.stream().anyMatch(c -> c instanceof AbstractGotoSEContributor))) {
            return IdeBundle.message((String)"dumb.mode.results.might.be.incomplete", (Object[])new Object[0]);
        }
        return null;
    }

    @Nls
    @Nullable
    private static String getAdvertisement(List<SearchEverywhereContributor<?>> contributors) {
        boolean commandsSupported = contributors.stream().anyMatch(contributor -> !contributor.getSupportedCommands().isEmpty());
        if (commandsSupported) {
            return IdeBundle.message((String)"searcheverywhere.textfield.hint", (Object[])new Object[]{SearchTopHitProvider.getTopHitAccelerator()});
        }
        List advertisements = contributors.stream().map(c -> c.getAdvertisement()).filter(Objects::nonNull).collect(Collectors.toList());
        return advertisements.isEmpty() ? null : (String)advertisements.get(new Random().nextInt(advertisements.size()));
    }

    public String getSelectedTabID() {
        return this.myHeader.getSelectedTab().getID();
    }

    @Nullable
    public Object getSelectionIdentity() {
        Object value2 = this.myResultsList.getSelectedValue();
        return value2 == null ? null : Integer.valueOf(Objects.hashCode(value2));
    }

    public void dispose() {
        this.stopSearching();
        this.myListModel.clear();
        SearchEverywhereMlSessionService.getInstance().onDialogClose();
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            SearchEverywhereUI.$$$reportNull$$$0(5);
        }
        IntStream indicesStream = Arrays.stream(this.myResultsList.getSelectedIndices()).filter(i2 -> !this.myListModel.isMoreElement(i2));
        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
            return this.getSearchPattern();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            List elements = indicesStream.mapToObj(i2 -> {
                SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i2);
                Object item = this.myListModel.getElementAt(i2);
                Object psi = contributor.getDataForItem(item, CommonDataKeys.PSI_ELEMENT.getName());
                return (PsiElement)psi;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return PsiUtilCore.toPsiElementArray(elements);
        }
        return indicesStream.mapToObj(i2 -> {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i2);
            Object item = this.myListModel.getElementAt(i2);
            return contributor.getDataForItem(item, dataId);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void registerHint(@NotNull JBPopup h) {
        if (h == null) {
            SearchEverywhereUI.$$$reportNull$$$0(6);
        }
        if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
            this.myHint.cancel();
        }
        this.myHint = h;
    }

    public void unregisterHint() {
        this.myHint = null;
    }

    private void hideHint() {
        if (this.myHint != null && this.myHint.isVisible()) {
            this.myHint.cancel();
        }
    }

    private void updateHint(Object element2) {
        if (this.myHint == null || !this.myHint.isVisible()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element2);
        }
    }

    @Override
    @NotNull
    protected JPanel createSettingsPanel() {
        JPanel jPanel2 = this.myHeader.getToolbarPanel();
        if (jPanel2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(7);
        }
        return jPanel2;
    }

    @Override
    @NotNull
    @NlsContexts.PopupAdvertisement
    protected String[] getInitialHints() {
        String[] stringArray = new String[]{IdeBundle.message((String)"searcheverywhere.open.in.split.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"OpenInRightSplit")}), IdeBundle.message((String)"searcheverywhere.open.in.new.window.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"EditSourceInNewWindow")}), IdeBundle.message((String)"searcheverywhere.history.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.ALT_SHOW_HISTORY_KEYSTROKE), KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.SHOW_HISTORY_KEYSTROKE)})};
        if (stringArray == null) {
            SearchEverywhereUI.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @Override
    @Nls
    protected String getAccessibleName() {
        return IdeBundle.message((String)"searcheverywhere.accessible.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected ExtendableTextField createSearchField() {
        BigPopupUI.SearchField res2 = new BigPopupUI.SearchField(){

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new TextFieldWithListAccessibleContext((JTextComponent)((Object)this), SearchEverywhereUI.this.myResultsList.getAccessibleContext());
                }
                return this.accessibleContext;
            }
        };
        ExtendableTextComponent.Extension leftExt = new ExtendableTextComponent.Extension(){

            public Icon getIcon(boolean hovered2) {
                return AllIcons.Actions.Search;
            }

            public boolean isIconBeforeText() {
                return true;
            }

            public int getIconGap() {
                return JBUIScale.scale((int)10);
            }
        };
        res2.addExtension(leftExt);
        res2.putClientProperty(SEARCH_EVERYWHERE_SEARCH_FILED_KEY, true);
        res2.setLayout(new BorderLayout());
        BigPopupUI.SearchField searchField = res2;
        if (searchField == null) {
            SearchEverywhereUI.$$$reportNull$$$0(9);
        }
        return searchField;
    }

    @Override
    protected void installScrollingActions() {
        ScrollingUtil.installMoveUpAction((JList)this.myResultsList, (JComponent)this.getSearchField());
        ScrollingUtil.installMoveDownAction((JList)this.myResultsList, (JComponent)this.getSearchField());
    }

    @Override
    @NotNull
    protected JPanel createTopLeftPanel() {
        JPanel jPanel2 = this.myHeader.getTabsPanel();
        if (jPanel2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(10);
        }
        return jPanel2;
    }

    private void scheduleRebuildList(SearchRestartReason reason) {
        if (!this.rebuildListAlarm.isDisposed() && this.rebuildListAlarm.getActiveRequestCount() == 0) {
            this.rebuildListAlarm.addRequest(() -> this.rebuildList(reason), 100L);
        }
    }

    private void rebuildList(SearchRestartReason reason) {
        String typedCommand;
        List<SearchEverywhereCommandInfo> commands;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.stopSearching();
        this.myResultsList.setEmptyText(IdeBundle.message((String)"label.choosebyname.searching", (Object[])new Object[0]));
        String rawPattern = this.getSearchPattern();
        this.updateViewType(rawPattern.isEmpty() ? BigPopupUI.ViewType.SHORT : BigPopupUI.ViewType.FULL);
        String namePattern = this.myHeader.getSelectedTab().isSingleContributor() ? this.myHeader.getSelectedTab().getContributors().get(0).filterControlSymbols(rawPattern) : rawPattern;
        MinusculeMatcher matcher = NameUtil.buildMatcherWithFallback((String)("*" + rawPattern), (String)("*" + namePattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        MatcherHolder.associateMatcher((JComponent)this.myResultsList, (Matcher)matcher);
        HashMap contributorsMap = new HashMap();
        List contributors = this.myHeader.getSelectedTab().getContributors();
        int limit = contributors.size() > 1 ? 15 : 30;
        contributors.forEach(c -> contributorsMap.put(c, limit));
        if (this.myProject != null) {
            contributors = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(contributorsMap.keySet());
            if (contributors.isEmpty() && DumbService.isDumb((Project)this.myProject)) {
                this.myResultsList.setEmptyText(IdeBundle.message((String)"searcheverywhere.indexing.mode.not.supported", (Object[])new Object[]{this.myHeader.getSelectedTab().getText(), ApplicationNamesInfo.getInstance().getFullProductName()}));
                this.myListModel.clear();
                return;
            }
            if (contributors.size() != contributorsMap.size()) {
                this.myResultsList.setEmptyText(IdeBundle.message((String)"searcheverywhere.indexing.incomplete.results", (Object[])new Object[]{this.myHeader.getSelectedTab().getText(), ApplicationNamesInfo.getInstance().getFullProductName()}));
            }
        }
        String tabId = this.myHeader.getSelectedTab().getID();
        SearchEverywhereMlSessionService.getInstance().onSearchRestart(this.myProject, tabId, reason, this.mySearchTypingListener.mySymbolKeysTyped, this.mySearchTypingListener.myBackspacesTyped, this.mySearchField.getText().length(), (Function0<? extends List<? extends SearchEverywhereFoundElementInfo>>)((Function0)() -> this.myListModel.getFoundElementsInfo()));
        this.myListModel.expireResults();
        contributors.forEach(contributor -> this.myListModel.setHasMore((SearchEverywhereContributor<?>)contributor, false));
        String commandPrefix = SearchTopHitProvider.getTopHitAccelerator();
        if (rawPattern.startsWith(commandPrefix) && !(commands = SearchEverywhereUI.getCommandsForCompletion(contributors, typedCommand = rawPattern.split(" ")[0].substring(commandPrefix.length()))).isEmpty()) {
            if (rawPattern.contains(" ")) {
                contributorsMap.keySet().retainAll(commands.stream().map(SearchEverywhereCommandInfo::getContributor).collect(Collectors.toSet()));
            } else {
                this.myListModel.clear();
                List lst = ContainerUtil.map(commands, command -> new SearchEverywhereFoundElementInfo(command, 0, this.myStubCommandContributor));
                this.myListModel.addElements(lst);
                ScrollingUtil.ensureSelectionExists((JList)this.myResultsList);
            }
        }
        this.myHintHelper.setSearchInProgress(StringUtil.isNotEmpty((String)this.getSearchPattern()));
        this.mySearchProgressIndicator = this.mySearcher.search(contributorsMap, rawPattern);
    }

    private void initSearchActions() {
        MouseAdapter listMouseListener = new MouseAdapter(){
            private int currentDescriptionIndex = -1;

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchEverywhereUI.this.onMouseClicked(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int index2 = SearchEverywhereUI.this.myResultsList.locationToIndex(e.getPoint());
                this.indexChanged(index2);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                int index2 = SearchEverywhereUI.this.myResultsList.getSelectedIndex();
                this.indexChanged(index2);
            }

            private void indexChanged(int index2) {
                if (index2 != this.currentDescriptionIndex) {
                    this.currentDescriptionIndex = index2;
                    SearchEverywhereUI.this.showDescriptionForIndex(index2);
                }
            }
        };
        this.myResultsList.addMouseMotionListener((MouseMotionListener)listMouseListener);
        this.myResultsList.addMouseListener((MouseListener)listMouseListener);
        ScrollingUtil.redirectExpandSelection((JList)this.myResultsList, (JComponent)this.mySearchField);
        Consumer nextTabAction = e -> {
            this.myHeader.switchToNextTab();
            this.triggerTabSwitched((AnActionEvent)e);
        };
        Consumer prevTabAction = e -> {
            this.myHeader.switchToPrevTab();
            this.triggerTabSwitched((AnActionEvent)e);
        };
        this.registerAction("SearchEverywhere.CompleteCommand", () -> new CompleteCommandAction());
        this.registerAction("SearchEverywhere.NextTab", (Consumer<? super AnActionEvent>)nextTabAction);
        this.registerAction("SearchEverywhere.PrevTab", (Consumer<? super AnActionEvent>)prevTabAction);
        this.registerAction("NextTab", (Consumer<? super AnActionEvent>)nextTabAction);
        this.registerAction("PreviousTab", (Consumer<? super AnActionEvent>)prevTabAction);
        this.registerAction("Switcher", (Consumer<? super AnActionEvent>)((Consumer)e -> {
            if (e.getInputEvent().isShiftDown()) {
                this.myHeader.switchToPrevTab();
            } else {
                this.myHeader.switchToNextTab();
            }
            this.triggerTabSwitched((AnActionEvent)e);
        }));
        this.registerAction("SearchEverywhere.NavigateToNextGroup", (Consumer<? super AnActionEvent>)((Consumer)e -> {
            this.scrollList(true);
            SearchEverywhereUsageTriggerCollector.GROUP_NAVIGATE.log(this.myProject, e);
        }));
        this.registerAction("SearchEverywhere.NavigateToPrevGroup", (Consumer<? super AnActionEvent>)((Consumer)e -> {
            this.scrollList(false);
            SearchEverywhereUsageTriggerCollector.GROUP_NAVIGATE.log(this.myProject, e);
        }));
        this.registerSelectItemAction();
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction.create(__ -> this.sendStatisticsAndClose()).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)((Object)this));
        this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                String newSearchString = SearchEverywhereUI.this.getSearchPattern();
                if (SearchEverywhereUI.this.myNotFoundString != null) {
                    boolean newPatternContainsPrevious;
                    boolean bl = newPatternContainsPrevious = SearchEverywhereUI.this.myNotFoundString.length() > 1 && newSearchString.contains(SearchEverywhereUI.this.myNotFoundString);
                    if (SearchEverywhereUI.this.myHeader.canSetEverywhere() && SearchEverywhereUI.this.myHeader.isEverywhere() && !newPatternContainsPrevious) {
                        SearchEverywhereUI.this.myNotFoundString = null;
                        SearchEverywhereUI.this.myHeader.autoSetEverywhere(false);
                        return;
                    }
                }
                SearchEverywhereUI.this.scheduleRebuildList(SearchRestartReason.TEXT_CHANGED);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$4", "textChanged"));
            }
        });
        this.myResultsList.addListSelectionListener(e -> {
            Object selectedValue = this.myResultsList.getSelectedValue();
            if (selectedValue != null && this.myHint != null && this.myHint.isVisible()) {
                this.updateHint(selectedValue);
            }
            this.showDescriptionForIndex(this.myResultsList.getSelectedIndex());
        });
        MessageBusConnection busConnection = this.myProject != null ? this.myProject.getMessageBus().connect((Disposable)this) : ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        busConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    SearchEverywhereUI.this.updateSearchFieldAdvertisement();
                    SearchEverywhereUI.this.scheduleRebuildList(SearchRestartReason.EXIT_DUMB_MODE);
                });
            }
        });
        (this.myProject == null ? busConnection : ApplicationManager.getApplication().getMessageBus().connect((Disposable)this)).subscribe(ProgressWindow.TOPIC, pw -> Disposer.register((Disposable)pw, () -> this.myResultsList.repaint()));
        this.mySearchField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component oppositeComponent = e.getOppositeComponent();
                if (!SearchEverywhereUI.this.isHintComponent(oppositeComponent) && !UIUtil.haveCommonOwner((Component)((Object)SearchEverywhereUI.this), (Component)oppositeComponent)) {
                    SearchEverywhereUI.this.sendStatisticsAndClose();
                }
            }
        });
    }

    private void showDescriptionForIndex(int index2) {
        if (index2 < 0 || this.myListModel.isMoreElement(index2)) {
            return;
        }
        if (Registry.is((String)"search.everywhere.show.weights")) {
            @NlsSafe String weight2 = Integer.toString(this.myListModel.getWeightAt(index2));
            ActionMenu.showDescriptionInStatusBar(true, (Component)this.myResultsList, weight2);
            return;
        }
        SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(index2);
        Object data2 = contributor.getDataForItem(this.myListModel.getElementAt(index2), SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.getName());
        if (data2 instanceof String) {
            ActionMenu.showDescriptionInStatusBar(true, (Component)this.myResultsList, (String)data2);
        }
    }

    private void registerAction(String actionID, Supplier<? extends AnAction> actionSupplier) {
        Optional.ofNullable(ActionManager.getInstance().getAction(actionID)).map(a -> a.getShortcutSet()).ifPresent(shortcuts -> ((AnAction)actionSupplier.get()).registerCustomShortcutSet(shortcuts, (JComponent)((Object)this), (Disposable)this));
    }

    private void registerAction(String actionID, Consumer<? super AnActionEvent> action2) {
        this.registerAction(actionID, () -> DumbAwareAction.create((Consumer)action2));
    }

    private void registerSelectItemAction() {
        int[] allowedModifiers = new int[]{0, 1, 2, 4, 8};
        ShortcutSet selectShortcuts = ActionManager.getInstance().getAction("SearchEverywhere.SelectItem").getShortcutSet();
        Collection keyboardShortcuts = Arrays.stream(selectShortcuts.getShortcuts()).filter(shortcut -> shortcut instanceof KeyboardShortcut).map(shortcut -> (KeyboardShortcut)shortcut).collect(Collectors.toList());
        for (int modifiers : allowedModifiers) {
            ArrayList<KeyboardShortcut> newShortcuts = new ArrayList<KeyboardShortcut>();
            for (KeyboardShortcut shortcut2 : keyboardShortcuts) {
                KeyStroke originalStroke;
                boolean hasSecondStroke = shortcut2.getSecondKeyStroke() != null;
                KeyStroke keyStroke = originalStroke = hasSecondStroke ? shortcut2.getSecondKeyStroke() : shortcut2.getFirstKeyStroke();
                if ((originalStroke.getModifiers() & modifiers) != 0) continue;
                KeyStroke newStroke = KeyStroke.getKeyStroke(originalStroke.getKeyCode(), originalStroke.getModifiers() | modifiers);
                newShortcuts.add(hasSecondStroke ? new KeyboardShortcut(shortcut2.getFirstKeyStroke(), newStroke) : new KeyboardShortcut(newStroke, null));
            }
            if (newShortcuts.isEmpty()) continue;
            CustomShortcutSet newShortcutSet = new CustomShortcutSet(newShortcuts.toArray(Shortcut.EMPTY_ARRAY));
            DumbAwareAction.create(event -> {
                int[] indices = this.myResultsList.getSelectedIndices();
                this.elementsSelected(indices, modifiers);
            }).registerCustomShortcutSet((ShortcutSet)newShortcutSet, (JComponent)((Object)this), (Disposable)this);
        }
    }

    private void triggerTabSwitched(AnActionEvent e) {
        String id2 = this.myHeader.getSelectedTab().getReportableID();
        SearchEverywhereUsageTriggerCollector.TAB_SWITCHED.log(this.myProject, new EventPair[]{SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ID_FIELD.with((Object)id2), EventFields.InputEventByAnAction.with((Object)e)});
    }

    private void scrollList(boolean down) {
        int currentIndex = this.myResultsList.getSelectedIndex();
        int newIndex = this.myListModel.getIndexToScroll(currentIndex, down);
        if (newIndex != currentIndex) {
            this.myResultsList.setSelectedIndex(newIndex);
            ScrollingUtil.ensureIndexIsVisible((JList)this.myResultsList, (int)newIndex, (int)0);
        }
    }

    private Optional<SearchEverywhereCommandInfo> getSelectedCommand(String typedCommand) {
        int index2 = this.myResultsList.getSelectedIndex();
        if (index2 < 0) {
            return Optional.empty();
        }
        SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(index2);
        if (contributor != this.myStubCommandContributor) {
            return Optional.empty();
        }
        SearchEverywhereCommandInfo selectedCommand = (SearchEverywhereCommandInfo)this.myListModel.getElementAt(index2);
        return selectedCommand.getCommand().contains(typedCommand) ? Optional.of(selectedCommand) : Optional.empty();
    }

    @NotNull
    private static List<SearchEverywhereCommandInfo> getCommandsForCompletion(Collection<? extends SearchEverywhereContributor<?>> contributors, String enteredCommandPart) {
        Comparator cmdComparator = (cmd1, cmd2) -> {
            String cmdName1 = cmd1.getCommand();
            String cmdName2 = cmd2.getCommand();
            if (!enteredCommandPart.isEmpty()) {
                if (cmdName1.startsWith(enteredCommandPart) && !cmdName2.startsWith(enteredCommandPart)) {
                    return -1;
                }
                if (!cmdName1.startsWith(enteredCommandPart) && cmdName2.startsWith(enteredCommandPart)) {
                    return 1;
                }
            }
            return String.CASE_INSENSITIVE_ORDER.compare(cmdName1, cmd2.getCommand());
        };
        List<SearchEverywhereCommandInfo> list2 = contributors.stream().flatMap(contributor -> contributor.getSupportedCommands().stream()).filter(command -> command.getCommand().contains(enteredCommandPart)).sorted(cmdComparator).collect(Collectors.toList());
        if (list2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private void onMouseClicked(@NotNull MouseEvent e) {
        boolean multiSelectMode;
        if (e == null) {
            SearchEverywhereUI.$$$reportNull$$$0(12);
        }
        boolean bl = multiSelectMode = e.isShiftDown() || UIUtil.isControlKeyDown((MouseEvent)e);
        if (e.getButton() == 1 && !multiSelectMode) {
            e.consume();
            int i2 = this.myResultsList.locationToIndex(e.getPoint());
            if (i2 > -1) {
                this.myResultsList.setSelectedIndex(i2);
                this.elementsSelected(new int[]{i2}, e.getModifiers());
            }
        }
    }

    private boolean isHintComponent(Component component2) {
        if (this.myHint != null && !this.myHint.isDisposed() && component2 != null) {
            return SwingUtilities.isDescendingFrom(component2, this.myHint.getContent());
        }
        return false;
    }

    private void elementsSelected(int[] indexes, int modifiers) {
        if (indexes.length == 1 && this.myListModel.isMoreElement(indexes[0])) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(indexes[0]);
            this.showMoreElements(contributor);
            return;
        }
        indexes = Arrays.stream(indexes).filter(i2 -> !this.myListModel.isMoreElement(i2)).toArray();
        String searchText = this.getSearchPattern();
        if (searchText.startsWith(SearchTopHitProvider.getTopHitAccelerator()) && searchText.contains(" ")) {
            SearchEverywhereUsageTriggerCollector.COMMAND_USED.log(this.myProject);
        }
        boolean closePopup = false;
        for (int i3 : indexes) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i3);
            Object value2 = this.myListModel.getElementAt(i3);
            String selectedTabContributorID = this.myHeader.getSelectedTab().getReportableID();
            String reportableContributorID = SearchEverywhereUsageTriggerCollector.getReportableContributorID(contributor);
            ArrayList<EventPair> data2 = new ArrayList<EventPair>();
            data2.add(SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ID_FIELD.with((Object)reportableContributorID));
            if (selectedTabContributorID != null) {
                data2.add(SearchEverywhereUsageTriggerCollector.CURRENT_TAB_FIELD.with((Object)selectedTabContributorID));
            }
            data2.add(SearchEverywhereUsageTriggerCollector.SELECTED_ITEM_NUMBER.with((Object)i3));
            if (value2 instanceof PsiElement) {
                data2.add(EventFields.Language.with((Object)((PsiElement)value2).getLanguage()));
            }
            SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ITEM_SELECTED.log(this.myProject, data2);
            closePopup |= contributor.processSelectedItem(value2, modifiers, searchText);
        }
        SearchEverywhereMlSessionService.getInstance().onItemSelected(this.myProject, indexes, closePopup, (Function0<? extends List<? extends SearchEverywhereFoundElementInfo>>)((Function0)() -> this.myListModel.getFoundElementsInfo()));
        if (closePopup) {
            this.closePopup();
        } else {
            ApplicationManager.getApplication().invokeLater(() -> this.myResultsList.repaint());
        }
    }

    private void showMoreElements(SearchEverywhereContributor contributor) {
        SearchEverywhereUsageTriggerCollector.MORE_ITEM_SELECTED.log(this.myProject);
        if (contributor != null) {
            this.myListModel.setHasMore(contributor, false);
        } else {
            this.myListModel.clearMoreItems();
        }
        Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> found = this.myListModel.getFoundElementsMap();
        int additionalItemsCount = this.myHeader.getSelectedTab().isSingleContributor() ? 30 : 15;
        Stream<Object> stream = found.entrySet().stream();
        stream = contributor != null ? stream.filter(entry2 -> entry2.getKey() == contributor) : stream.filter(entry2 -> this.myListModel.hasMoreElements((SearchEverywhereContributor)entry2.getKey()));
        Map<SearchEverywhereContributor, Integer> contributorsAndLimits = stream.collect(Collectors.toMap(entry2 -> (SearchEverywhereContributor)entry2.getKey(), entry2 -> ((Collection)entry2.getValue()).size() + additionalItemsCount));
        this.myHintHelper.setSearchInProgress(StringUtil.isNotEmpty((String)this.getSearchPattern()));
        this.mySearchProgressIndicator = this.mySearcher.findMoreItems(found, contributorsAndLimits, this.getSearchPattern());
    }

    private void stopSearching() {
        if (this.mySearchProgressIndicator != null && !this.mySearchProgressIndicator.isCanceled()) {
            this.mySearchProgressIndicator.cancel();
        }
        if (this.myBufferedListener != null) {
            this.myBufferedListener.clearBuffer();
        }
    }

    private void sendStatisticsAndClose() {
        if (this.isShowing()) {
            SearchEverywhereMlSessionService.getInstance().onSearchFinished(this.myProject, (Function0<? extends List<? extends SearchEverywhereFoundElementInfo>>)((Function0)() -> this.myListModel.getFoundElementsInfo()));
        }
        this.closePopup();
    }

    private void closePopup() {
        ActionMenu.showDescriptionInStatusBar(true, (Component)this.myResultsList, null);
        this.stopSearching();
        this.searchFinishedHandler.run();
    }

    @TestOnly
    public Future<List<Object>> findElementsForPattern(String pattern) {
        this.clearResults();
        CompletableFuture<List<Object>> future2 = new CompletableFuture<List<Object>>();
        this.mySearchListener.setTestCallback((Consumer<? super List<Object>>)((Consumer)list2 -> {
            future2.complete((List<Object>)list2);
            this.mySearchListener.setTestCallback(null);
        }));
        this.mySearchField.setText(pattern);
        return future2;
    }

    @TestOnly
    public void clearResults() {
        this.myListModel.clear();
        this.mySearchField.setText("");
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private String getNotFoundText() {
        SearchEverywhereHeader.SETab selectedTab = this.myHeader.getSelectedTab();
        if (!selectedTab.isSingleContributor()) {
            return IdeBundle.message((String)"searcheverywhere.nothing.found.for.all.anywhere", (Object[])new Object[0]);
        }
        String groupName = selectedTab.getContributors().get(0).getFullGroupName();
        return IdeBundle.message((String)"searcheverywhere.nothing.found.for.contributor.anywhere", (Object[])new Object[]{groupName.toLowerCase(Locale.ROOT)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSupplier";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabID";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCellRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialHints";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchField";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopLeftPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandsForCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "switchToTab";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerHint";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onMouseClicked";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HintHelper {
        private final ExtendableTextField myTextField;
        private final TextIcon myHintTextIcon = new TextIcon("", JBUI.CurrentTheme.BigPopup.searchFieldGrayForeground(), Gray.TRANSPARENT, 0);
        private final RowIcon myWarnIcon = new RowIcon(2, RowIcon.Alignment.BOTTOM);
        private final ExtendableTextComponent.Extension myHintExtension = HintHelper.createExtension(this.myHintTextIcon);
        private final ExtendableTextComponent.Extension mySearchProcessExtension = HintHelper.createExtension((Icon)AnimatedIcon.Default.INSTANCE);
        private final ExtendableTextComponent.Extension myWarningExtension;

        private HintHelper(ExtendableTextField field) {
            this.myTextField = field;
            this.myHintTextIcon.setFont(this.myTextField.getFont());
            this.myHintTextIcon.setFontTransform(FontInfo.getFontRenderContext((Component)this.myTextField).getTransform());
            this.myWarnIcon.setIcon(AllIcons.General.Warning, 0);
            this.myWarnIcon.setIcon(this.myHintTextIcon, 1);
            this.myWarningExtension = HintHelper.createExtension(this.myWarnIcon);
        }

        public void setHint(String hintText) {
            this.myTextField.removeExtension(this.myHintExtension);
            this.myTextField.removeExtension(this.myWarningExtension);
            if (StringUtil.isNotEmpty((String)hintText)) {
                this.myHintTextIcon.setText(hintText);
                this.addExtensionAsLast(this.myHintExtension);
            }
        }

        public void setWarning(String warnText) {
            this.myTextField.removeExtension(this.myHintExtension);
            this.myTextField.removeExtension(this.myWarningExtension);
            if (StringUtil.isNotEmpty((String)warnText)) {
                this.myHintTextIcon.setText(warnText);
                this.myWarnIcon.setIcon(this.myHintTextIcon, 1);
                this.addExtensionAsLast(this.myWarningExtension);
            }
        }

        public void setSearchInProgress(boolean inProgress) {
            this.myTextField.removeExtension(this.mySearchProcessExtension);
            if (inProgress) {
                this.myTextField.addExtension(this.mySearchProcessExtension);
            }
        }

        private void addExtensionAsLast(ExtendableTextComponent.Extension ext) {
            ArrayList<ExtendableTextComponent.Extension> extensions2 = new ArrayList<ExtendableTextComponent.Extension>(this.myTextField.getExtensions());
            extensions2.add(0, ext);
            this.myTextField.setExtensions(extensions2);
        }

        @NotNull
        private static ExtendableTextComponent.Extension createExtension(final Icon icon2) {
            return new ExtendableTextComponent.Extension(){

                public Icon getIcon(boolean hovered2) {
                    return icon2;
                }
            };
        }
    }

    private static class SearchFieldTypingListener
    extends KeyAdapter {
        private int mySymbolKeysTyped;
        private int myBackspacesTyped;

        private SearchFieldTypingListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            ++this.mySymbolKeysTyped;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 8 || code == 127) {
                ++this.myBackspacesTyped;
            }
        }
    }

    private class SearchListener
    implements SESearcher.Listener {
        @Nullable
        private Consumer<? super List<Object>> testCallback;

        private SearchListener() {
        }

        @Override
        public void elementsAdded(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
            Object prevSelection;
            if (list2 == null) {
                SearchListener.$$$reportNull$$$0(0);
            }
            boolean wasEmpty = SearchEverywhereUI.this.myListModel.getSize() == 0;
            SearchEverywhereUI.this.mySelectionTracker.lock();
            SearchEverywhereUI.this.myListModel.addElements(list2);
            SearchEverywhereUI.this.mySelectionTracker.unlock();
            SearchEverywhereUI.this.mySelectionTracker.restoreSelection();
            if (wasEmpty && SearchEverywhereUI.this.myListModel.getSize() > 0 && (prevSelection = ((SearchEverywhereManagerImpl)SearchEverywhereManager.getInstance(SearchEverywhereUI.this.myProject)).getPrevSelection(SearchEverywhereUI.this.getSelectedTabID())) instanceof Integer) {
                for (Object item : SearchEverywhereUI.this.myListModel.getItems()) {
                    if (Objects.hashCode(item) != (Integer)prevSelection) continue;
                    SearchEverywhereUI.this.myResultsList.setSelectedValue(item, true);
                    break;
                }
            }
        }

        @Override
        public void elementsRemoved(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
            if (list2 == null) {
                SearchListener.$$$reportNull$$$0(1);
            }
            list2.forEach(info2 -> SearchEverywhereUI.this.myListModel.removeElement(info2.getElement(), info2.getContributor()));
        }

        @Override
        public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
            if (hasMoreContributors == null) {
                SearchListener.$$$reportNull$$$0(2);
            }
            String pattern = SearchEverywhereUI.this.getSearchPattern();
            pattern = pattern.replaceAll("^" + SearchTopHitProvider.getTopHitAccelerator() + "\\S+\\s*", "");
            if (SearchEverywhereUI.this.myResultsList.isEmpty() || SearchEverywhereUI.this.myListModel.isResultsExpired()) {
                if (SearchEverywhereUI.this.myHeader.canSetEverywhere() && !SearchEverywhereUI.this.myHeader.isEverywhere() && !pattern.isEmpty()) {
                    SearchEverywhereUI.this.myHeader.autoSetEverywhere(true);
                    SearchEverywhereUI.this.myNotFoundString = pattern;
                    return;
                }
                SearchEverywhereUI.this.hideHint();
                if (SearchEverywhereUI.this.myListModel.isResultsExpired()) {
                    SearchEverywhereUI.this.myListModel.clear();
                }
            }
            this.updateEmptyText(pattern);
            hasMoreContributors.forEach(SearchEverywhereUI.this.myListModel::setHasMore);
            SearchEverywhereUI.this.mySelectionTracker.resetSelectionIfNeeded();
            SearchEverywhereUI.this.myHintHelper.setSearchInProgress(false);
            if (this.testCallback != null) {
                this.testCallback.consume(SearchEverywhereUI.this.myListModel.getItems());
            }
        }

        private void updateEmptyText(String pattern) {
            FindInProjectManager manager2;
            boolean anyActionAllowed;
            StatusText emptyStatus = SearchEverywhereUI.this.myResultsList.getEmptyText();
            emptyStatus.clear();
            if (pattern.isEmpty()) {
                return;
            }
            emptyStatus.appendLine(SearchEverywhereUI.this.getNotFoundText());
            boolean showFindInFilesAction = SearchEverywhereUI.this.myHeader.getSelectedTab().getContributors().stream().anyMatch(contributor -> contributor.showInFindResults());
            boolean showResetScope = SearchEverywhereUI.this.myHeader.canResetScope();
            boolean showResetFilter = SearchEverywhereUI.this.myHeader.getSelectedTab().canClearFilter();
            boolean bl = anyActionAllowed = showFindInFilesAction || showResetScope || showResetFilter;
            if (anyActionAllowed) {
                emptyStatus.appendText(".").appendLine("").appendLine("");
            }
            AtomicBoolean firstPartAdded = new AtomicBoolean();
            AtomicInteger actionsPrinted = new AtomicInteger(0);
            if (showResetScope) {
                ActionListener resetScopeListener = e -> SearchEverywhereUI.this.myHeader.resetScope();
                emptyStatus.appendText(IdeBundle.message((String)"searcheverywhere.try.to.reset.scope", (Object[])new Object[0]));
                emptyStatus.appendText(" " + StringUtil.toLowerCase((String)EverythingGlobalScope.getNameText()), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, resetScopeListener);
                firstPartAdded.set(true);
                actionsPrinted.incrementAndGet();
            }
            if (showResetFilter) {
                ActionListener clearFiltersAction = e -> {
                    SearchEverywhereUI.this.myHeader.getSelectedTab().clearFilter();
                    SearchEverywhereUI.this.scheduleRebuildList(SearchRestartReason.TAB_CHANGED);
                };
                if (firstPartAdded.get()) {
                    emptyStatus.appendText(", ");
                }
                String resetFilterMessage = IdeBundle.message((String)"searcheverywhere.reset.filters", (Object[])new Object[0]);
                emptyStatus.appendText(firstPartAdded.get() ? Strings.toLowerCase((String)resetFilterMessage) : resetFilterMessage, SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, clearFiltersAction);
                firstPartAdded.set(true);
                if (actionsPrinted.incrementAndGet() >= 2) {
                    emptyStatus.appendLine("");
                    actionsPrinted.set(0);
                }
            }
            if (showFindInFilesAction && SearchEverywhereUI.this.myProject != null && (manager2 = FindInProjectManager.getInstance(SearchEverywhereUI.this.myProject)) != null && manager2.isEnabled()) {
                DataContext context2 = DataManager.getInstance().getDataContext((Component)((Object)SearchEverywhereUI.this));
                ActionListener findInFilesAction = e -> manager2.findInProject(context2, null);
                emptyStatus.appendText((String)(firstPartAdded.get() ? " " + IdeBundle.message((String)"searcheverywhere.use.optional", (Object[])new Object[0]) : IdeBundle.message((String)"searcheverywhere.use.main", (Object[])new Object[0])) + " ");
                emptyStatus.appendText(IdeBundle.message((String)"searcheverywhere.try.to.find.in.files", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, findInFilesAction);
                String findInFilesShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"FindInPath");
                if (!StringUtil.isEmpty((String)findInFilesShortcut)) {
                    emptyStatus.appendText(" (" + findInFilesShortcut + ")");
                }
                if (actionsPrinted.incrementAndGet() >= 2) {
                    emptyStatus.appendLine("");
                    actionsPrinted.set(0);
                }
                emptyStatus.appendText(" " + IdeBundle.message((String)"searcheverywhere.to.perform.fulltext.search", (Object[])new Object[0]));
            }
            if (anyActionAllowed) {
                emptyStatus.appendText(".");
            }
        }

        @TestOnly
        void setTestCallback(@Nullable Consumer<? super List<Object>> callback2) {
            this.testCallback = callback2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasMoreContributors";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$SearchListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementsAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementsRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "searchFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CompleteCommandAction
    extends DumbAwareAction {
        private CompleteCommandAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CompleteCommandAction.$$$reportNull$$$0(0);
            }
            if (this.completeCommand()) {
                SearchEverywhereUsageTriggerCollector.COMMAND_COMPLETED.log(SearchEverywhereUI.this.myProject, new EventPair[]{EventFields.InputEventByAnAction.with((Object)e)});
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CompleteCommandAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.getCompleteCommand() != null);
        }

        private boolean completeCommand() {
            SearchEverywhereCommandInfo suggestedCommand = this.getCompleteCommand();
            if (suggestedCommand != null) {
                SearchEverywhereUI.this.mySearchField.setText(suggestedCommand.getCommandWithPrefix() + " ");
                return true;
            }
            return false;
        }

        private SearchEverywhereCommandInfo getCompleteCommand() {
            String commandPrefix;
            String pattern = SearchEverywhereUI.this.getSearchPattern();
            if (pattern.startsWith(commandPrefix = SearchTopHitProvider.getTopHitAccelerator()) && !pattern.contains(" ")) {
                String typedCommand = pattern.substring(commandPrefix.length());
                return SearchEverywhereUI.this.getSelectedCommand(typedCommand).orElseGet(() -> {
                    List<SearchEverywhereCommandInfo> completions = SearchEverywhereUI.getCommandsForCompletion(SearchEverywhereUI.this.myHeader.getSelectedTab().getContributors(), typedCommand);
                    return completions.isEmpty() ? null : completions.get(0);
                });
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$CompleteCommandAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowInFindToolWindowAction
    extends DumbAwareAction {
        ShowInFindToolWindowAction() {
            super(IdeBundle.messagePointer((String)"show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.messagePointer((String)"show.in.find.window.button.description", (Object[])new Object[0]), AllIcons.General.Pin_tab);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInFindToolWindowAction.$$$reportNull$$$0(0);
            }
            SearchEverywhereUI.this.stopSearching();
            List contributors = SearchEverywhereUI.this.myHeader.getSelectedTab().getContributors();
            contributors = ContainerUtil.filter(contributors, SearchEverywhereContributor::showInFindResults);
            if (contributors.isEmpty()) {
                return;
            }
            final String searchText = SearchEverywhereUI.this.getSearchPattern();
            String contributorsString = contributors.stream().map(SearchEverywhereContributor::getGroupName).collect(Collectors.joining(", "));
            final UsageViewPresentation presentation2 = new UsageViewPresentation();
            String tabCaptionText = IdeBundle.message((String)"searcheverywhere.found.matches.title", (Object[])new Object[]{searchText, contributorsString});
            presentation2.setCodeUsagesString(tabCaptionText);
            presentation2.setTargetsNodeText(IdeBundle.message((String)"searcheverywhere.found.targets.title", (Object[])new Object[]{searchText, contributorsString}));
            presentation2.setTabName(tabCaptionText);
            presentation2.setTabText(tabCaptionText);
            final LinkedHashSet<Usage> usages = new LinkedHashSet<Usage>();
            final LinkedHashSet targets2 = new LinkedHashSet();
            final Collection cached = contributors.stream().flatMap(contributor -> SearchEverywhereUI.this.myListModel.getFoundItems((SearchEverywhereContributor)contributor).stream()).collect(Collectors.toSet());
            this.fillUsages(cached, usages, targets2);
            final List contributorsForAdditionalSearch = ContainerUtil.filter((Collection)contributors, contributor -> SearchEverywhereUI.this.myListModel.hasMoreElements((SearchEverywhereContributor<?>)contributor));
            if (!contributorsForAdditionalSearch.isEmpty()) {
                ProgressManager.getInstance().run((Task)new Task.Modal(SearchEverywhereUI.this.myProject, tabCaptionText, true){
                    private final ProgressIndicator progressIndicator;
                    {
                        super(arg0, arg1, arg2);
                        this.progressIndicator = new ProgressIndicatorBase();
                    }

                    public void run(@NotNull ProgressIndicator indicator2) {
                        if (indicator2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.progressIndicator.start();
                        TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.createFor(this.progressIndicator);
                        ArrayList<Object> foundElements = new ArrayList<Object>();
                        int alreadyFoundCount = cached.size();
                        for (SearchEverywhereContributor contributor : contributorsForAdditionalSearch) {
                            if (this.progressIndicator.isCanceled()) break;
                            try {
                                this.fetch(contributor, foundElements, alreadyFoundCount, tooManyUsagesStatus);
                            }
                            catch (ProcessCanceledException processCanceledException) {}
                        }
                        ShowInFindToolWindowAction.this.fillUsages(foundElements, usages, targets2);
                    }

                    <Item> void fetch(SearchEverywhereContributor<Item> contributor, Collection<Object> foundElements, int alreadyFoundCount, TooManyUsagesStatus tooManyUsagesStatus) {
                        contributor.fetchElements(searchText, this.progressIndicator, o -> {
                            if (this.progressIndicator.isCanceled()) {
                                return false;
                            }
                            if (cached.contains(o)) {
                                return true;
                            }
                            foundElements.add(o);
                            tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                            if (foundElements.size() + alreadyFoundCount >= 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                                UsageViewManagerImpl.showTooManyUsagesWarningLater((Project)this.getProject(), (TooManyUsagesStatus)tooManyUsagesStatus, (ProgressIndicator)this.progressIndicator, null);
                                return !this.progressIndicator.isCanceled();
                            }
                            return true;
                        });
                    }

                    public void onCancel() {
                        this.progressIndicator.cancel();
                    }

                    public void onSuccess() {
                        ShowInFindToolWindowAction.this.showInFindWindow(targets2, usages, presentation2);
                    }

                    public void onThrowable(@NotNull Throwable error2) {
                        if (error2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        super.onThrowable(error2);
                        this.progressIndicator.cancel();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowInFindToolWindowAction$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onThrowable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                this.showInFindWindow(targets2, usages, presentation2);
            }
            SearchEverywhereUI.this.sendStatisticsAndClose();
        }

        private void fillUsages(Collection<Object> foundElements, Collection<? super Usage> usages, Collection<? super PsiElement> targets2) {
            ReadAction.run(() -> foundElements.stream().map(o -> this.toPsi(o)).filter(Objects::nonNull).forEach(element2 -> {
                if (element2.getTextRange() != null) {
                    UsageInfo usageInfo = new UsageInfo(element2);
                    usages.add((Usage)new UsageInfo2UsageAdapter(usageInfo));
                } else {
                    targets2.add((PsiElement)element2);
                }
            }));
        }

        private PsiElement toPsi(Object o) {
            if (o instanceof PsiElement) {
                return (PsiElement)o;
            }
            if (o instanceof PSIPresentationBgRendererWrapper.PsiItemWithPresentation) {
                return ((PSIPresentationBgRendererWrapper.PsiItemWithPresentation)((Object)o)).getItem();
            }
            return null;
        }

        private void showInFindWindow(Collection<? extends PsiElement> targets2, Collection<Usage> usages, UsageViewPresentation presentation2) {
            UsageTarget[] targetsArray = targets2.isEmpty() ? UsageTarget.EMPTY_ARRAY : PsiElement2UsageTargetAdapter.convert(PsiUtilCore.toPsiElementArray(targets2));
            Usage[] usagesArray = usages.toArray(Usage.EMPTY_ARRAY);
            UsageViewManager.getInstance((Project)SearchEverywhereUI.this.myProject).showUsages(targetsArray, usagesArray, presentation2);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInFindToolWindowAction.$$$reportNull$$$0(1);
            }
            if (SearchEverywhereUI.this.myProject == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            SearchEverywhereHeader.SETab selectedTab = SearchEverywhereUI.this.myHeader != null ? SearchEverywhereUI.this.myHeader.getSelectedTab() : null;
            boolean enabled = selectedTab == null || selectedTab.getContributors().stream().anyMatch(c -> c.showInFindResults());
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setIcon(ToolWindowManager.getInstance((Project)SearchEverywhereUI.this.myProject).getLocationIcon("Find", AllIcons.General.Pin_tab));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowInFindToolWindowAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

