/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.tokens;

import com.intellij.ide.highlighter.custom.tokens.PrefixedTokenParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.CustomHighlighterTokenType;

public final class HexNumberParser
extends PrefixedTokenParser {
    private HexNumberParser(String prefix2) {
        super(prefix2, CustomHighlighterTokenType.NUMBER);
    }

    @Override
    protected int getTokenEnd(int position) {
        while (position < this.myEndOffset && StringUtil.isHexDigit((char)this.myBuffer.charAt(position))) {
            ++position;
        }
        return position;
    }

    public static HexNumberParser create(String prefix2) {
        if (prefix2 == null) {
            return null;
        }
        String trimmedPrefix = prefix2.trim();
        if (trimmedPrefix.length() > 0) {
            return new HexNumberParser(prefix2);
        }
        return null;
    }
}

