/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PatchProjectUtil {
    private PatchProjectUtil() {
    }

    public static void patchProject(Project project) {
        Map<Pattern, Set<Pattern>> excludePatterns = PatchProjectUtil.loadPatterns("idea.exclude.patterns");
        Map<Pattern, Set<Pattern>> includePatterns = PatchProjectUtil.loadPatterns("idea.include.patterns");
        if (excludePatterns.isEmpty() && includePatterns.isEmpty()) {
            return;
        }
        PatchProjectUtil.patchProject(project, excludePatterns, includePatterns);
    }

    @VisibleForTesting
    public static void patchProject(Project project, final Map<Pattern, Set<Pattern>> excludePatterns, final Map<Pattern, Set<Pattern>> includePatterns) {
        ModifiableModuleModel modulesModel = ModuleManager.getInstance((Project)project).getModifiableModel();
        Module[] modules2 = modulesModel.getModules();
        ModifiableRootModel[] models = new ModifiableRootModel[modules2.length];
        for (int i2 = 0; i2 < modules2.length; ++i2) {
            ContentEntry[] contentEntries;
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)modules2[i2]);
            models[i2] = rootManager.getModifiableModel();
            final String moduleName = modules2[i2].getName();
            for (final ContentEntry contentEntry : contentEntries = models[i2].getContentEntries()) {
                final VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot == null) continue;
                final HashSet included = new HashSet();
                VfsUtilCore.visitChildrenRecursively((VirtualFile)contentRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                    @NotNull
                    public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile fileOrDir) {
                        Set dirPatterns;
                        if (fileOrDir == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        String relativeName = VfsUtilCore.getRelativePath((VirtualFile)fileOrDir, (VirtualFile)contentRoot, (char)'/');
                        for (Pattern module : excludePatterns.keySet()) {
                            if (module != null && !module.matcher(moduleName).matches()) continue;
                            dirPatterns = (Set)excludePatterns.get(module);
                            for (Pattern pattern : dirPatterns) {
                                if (!pattern.matcher(relativeName).matches()) continue;
                                contentEntry.addExcludeFolder(fileOrDir);
                                VirtualFileVisitor.Result result2 = relativeName.isEmpty() ? CONTINUE : SKIP_CHILDREN;
                                if (result2 == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return result2;
                            }
                        }
                        if (includePatterns.isEmpty()) {
                            VirtualFileVisitor.Result result3 = CONTINUE;
                            if (result3 == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return result3;
                        }
                        for (Pattern module : includePatterns.keySet()) {
                            if (module != null && !module.matcher(moduleName).matches()) continue;
                            dirPatterns = (Set)includePatterns.get(module);
                            for (Pattern pattern : dirPatterns) {
                                if (!pattern.matcher(relativeName).matches()) continue;
                                included.add(fileOrDir);
                                VirtualFileVisitor.Result result4 = CONTINUE;
                                if (result4 == null) {
                                    1.$$$reportNull$$$0(3);
                                }
                                return result4;
                            }
                        }
                        VirtualFileVisitor.Result result5 = CONTINUE;
                        if (result5 == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return result5;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "fileOrDir";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/impl/PatchProjectUtil$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/impl/PatchProjectUtil$1";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "visitFileEx";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "visitFileEx";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
                PatchProjectUtil.processIncluded(contentEntry, included);
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> ModifiableModelCommitter.multiCommit(models, modulesModel));
    }

    public static void processIncluded(ContentEntry contentEntry, Set<? extends VirtualFile> included) {
        if (included.isEmpty()) {
            return;
        }
        HashSet<VirtualFile> parents2 = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile2 : included) {
            if (Comparing.equal((Object)virtualFile2, (Object)contentEntry.getFile())) {
                return;
            }
            VirtualFile parent = virtualFile2.getParent();
            if (parent == null || parents2.contains(parent)) continue;
            parents2.add(parent);
            for (VirtualFile toExclude : parent.getChildren()) {
                boolean toExcludeSibling = true;
                for (VirtualFile virtualFile3 : included) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)toExclude, (VirtualFile)virtualFile3, (boolean)false)) continue;
                    toExcludeSibling = false;
                    break;
                }
                if (!toExcludeSibling) continue;
                contentEntry.addExcludeFolder(toExclude);
            }
        }
        PatchProjectUtil.processIncluded(contentEntry, parents2);
    }

    public static Map<Pattern, Set<Pattern>> loadPatterns(@NonNls String propertyKey) {
        HashMap<Pattern, Set<Pattern>> result2 = new HashMap<Pattern, Set<Pattern>>();
        String patterns = System.getProperty(propertyKey);
        if (patterns != null) {
            String[] pathPatterns2;
            for (String excludedPattern : pathPatterns2 = patterns.split(";")) {
                String module = null;
                int idx = 0;
                if (excludedPattern.startsWith("[")) {
                    idx = excludedPattern.indexOf("]") + 1;
                    module = excludedPattern.substring(1, idx - 1);
                }
                Pattern modulePattern = module != null ? Pattern.compile(StringUtil.replace(module, (String)"*", (String)".*")) : null;
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)excludedPattern.substring(idx)));
                HashSet<Pattern> dirPatterns = (HashSet<Pattern>)result2.get(modulePattern);
                if (dirPatterns == null) {
                    dirPatterns = new HashSet<Pattern>();
                    result2.put(modulePattern, dirPatterns);
                }
                dirPatterns.add(pattern);
            }
        }
        return result2;
    }
}

